/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.player.attachment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KTypeProjection;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Registry;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.Cbf;
import xyz.xenondevs.cbf.serializer.BinarySerializer;
import xyz.xenondevs.cbf.serializer.BinarySerializerKt;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.initialize.DisableFun;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.network.event.PacketHandler;
import xyz.xenondevs.nova.network.event.PacketListener;
import xyz.xenondevs.nova.network.event.PacketListenerKt;
import xyz.xenondevs.nova.network.event.clientbound.ClientboundSetPassengersPacketEvent;
import xyz.xenondevs.nova.registry.NovaRegistries;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.NamespacedUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.world.player.attachment.Attachment;
import xyz.xenondevs.nova.world.player.attachment.AttachmentManagerKt;
import xyz.xenondevs.nova.world.player.attachment.AttachmentType;

@InternalInit(stage=InternalInitStage.POST_WORLD)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0003J\b\u0010\u0011\u001a\u00020\u0010H\u0003J5\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\t\"\u000e\b\u0001\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00130\b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u0002H\u0014\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00072\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\bJ\u001a\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00072\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\bJ\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0003J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001fH\u0003J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020!H\u0003J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020#H\u0003J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020%H\u0003J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020'H\u0003J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u001e\u0010)\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007H\u0002Rr\u0010\u0005\u001af\u0012\u0004\u0012\u00020\u0007\u0012(\u0012&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0006j\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t`\n0\u0006j2\u0012\u0004\u0012\u00020\u0007\u0012(\u0012&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0006j\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t`\n`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u000b\u001a>\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e0\u0006j\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lxyz/xenondevs/nova/world/player/attachment/AttachmentManager;", "Lorg/bukkit/event/Listener;", "Lxyz/xenondevs/nova/network/event/PacketListener;", "<init>", "()V", "activeAttachments", "Ljava/util/HashMap;", "Lorg/bukkit/entity/Player;", "Lxyz/xenondevs/nova/world/player/attachment/AttachmentType;", "Lxyz/xenondevs/nova/world/player/attachment/Attachment;", "Lkotlin/collections/HashMap;", "inactiveAttachments", "Ljava/util/HashSet;", "Lnet/kyori/adventure/key/Key;", "Lkotlin/collections/HashSet;", "init", "", "disable", "addAttachment", "A", "T", "player", "type", "(Lorg/bukkit/entity/Player;Lxyz/xenondevs/nova/world/player/attachment/AttachmentType;)Lxyz/xenondevs/nova/world/player/attachment/Attachment;", "hasAttachment", "", "removeAttachment", "handlePlayerJoin", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "handlePlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "handleDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "handleRespawn", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "handleTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "handlePassengersSet", "Lxyz/xenondevs/nova/network/event/clientbound/ClientboundSetPassengersPacketEvent;", "deactivateAttachments", "activateAttachments", "attachmentIds", "", "loadAttachments", "saveAttachments", "saveAndRemoveAttachments", "nova"})
@SourceDebugExtension(value={"SMAP\nAttachmentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentManager.kt\nxyz/xenondevs/nova/world/player/attachment/AttachmentManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 CbfDataType.kt\nxyz/xenondevs/nova/serialization/persistentdata/CbfDataTypeKt\n+ 7 CosmicBinaryFormat.kt\nxyz/xenondevs/cbf/Cbf\n*L\n1#1,176:1\n1869#2,2:177\n1869#2,2:179\n1869#2,2:189\n295#2,2:191\n1563#2:193\n1634#2,3:194\n1869#2,2:206\n1374#2:231\n1460#2,5:232\n1869#2,2:237\n1#3:181\n1#3:209\n382#4,7:182\n382#4,7:197\n382#4,7:213\n216#5,2:204\n216#5,2:220\n216#5,2:229\n38#6:208\n16#6,2:222\n19#6,3:226\n147#7,2:210\n247#7:212\n193#7:224\n247#7:225\n*S KotlinDebug\n*F\n+ 1 AttachmentManager.kt\nxyz/xenondevs/nova/world/player/attachment/AttachmentManager\n*L\n46#1:177,2\n52#1:179,2\n113#1:189,2\n118#1:191,2\n119#1:193\n119#1:194,3\n140#1:206,2\n47#1:231\n47#1:232,5\n47#1:237,2\n150#1:209\n58#1:182,7\n124#1:197,7\n154#1:213,7\n125#1:204,2\n163#1:220,2\n173#1:229,2\n150#1:208\n166#1:222,2\n166#1:226,3\n150#1:210,2\n150#1:212\n166#1:224\n166#1:225\n*E\n"})
public final class AttachmentManager
implements Listener,
PacketListener {
    @NotNull
    public static final AttachmentManager INSTANCE = new AttachmentManager();
    @NotNull
    private static final HashMap<Player, HashMap<AttachmentType<?>, Attachment>> activeAttachments = new HashMap();
    @NotNull
    private static final HashMap<Player, HashSet<Key>> inactiveAttachments = new HashMap();

    private AttachmentManager() {
    }

    @InitFun
    private final void init() {
        EventUtilsKt.registerEvents(this);
        PacketListenerKt.registerPacketListener(this);
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player p0 = (Player)element$iv;
            boolean bl = false;
            this.loadAttachments(p0);
        }
        SchedulerUtilsKt.runTaskTimer(0L, 1L, (Function0<Unit>)((Function0)AttachmentManager::init$lambda$0));
    }

    @DisableFun
    private final void disable() {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            INSTANCE.saveAndRemoveAttachments(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <A extends Attachment, T extends AttachmentType<A>> A addAttachment(@NotNull Player player, @NotNull T type) {
        HashMap attachmentsMap;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (!(!player.isDead())) {
            boolean $i$a$-check-AttachmentManager$addAttachment$22 = false;
            String $i$a$-check-AttachmentManager$addAttachment$22 = "Attachments cannot be added to dead players";
            throw new IllegalStateException($i$a$-check-AttachmentManager$addAttachment$22.toString());
        }
        Map $i$a$-check-AttachmentManager$addAttachment$22 = activeAttachments;
        Player key$iv = player;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if (((Map)(attachmentsMap = (HashMap)object)).containsKey(type)) {
            Object v = attachmentsMap.get(type);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type A of xyz.xenondevs.nova.world.player.attachment.AttachmentManager.addAttachment");
            return (A)((Attachment)v);
        }
        Attachment attachment = (Attachment)type.getConstructor().invoke((Object)player);
        ((Map)attachmentsMap).put(type, attachment);
        return (A)attachment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasAttachment(@NotNull Player player, @NotNull AttachmentType<?> type) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        HashMap<AttachmentType<?>, Attachment> hashMap = activeAttachments.get(player);
        if (hashMap != null ? ((Map)hashMap).containsKey(type) : false) return true;
        HashSet<Key> hashSet = inactiveAttachments.get(player);
        if (hashSet == null) return false;
        boolean bl = hashSet.contains(type.getId());
        if (!bl) return false;
        return true;
    }

    public final void removeAttachment(@NotNull Player player, @NotNull AttachmentType<?> type) {
        block3: {
            Attachment attachment;
            HashMap<AttachmentType<?>, Attachment> activeAttachmentsMap;
            HashSet<Key> inactiveAttachmentsMap;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            HashSet<Key> hashSet = inactiveAttachmentsMap = inactiveAttachments.get(player);
            if (hashSet != null) {
                hashSet.remove(type.getId());
            }
            if (inactiveAttachmentsMap != null && inactiveAttachmentsMap.isEmpty()) {
                ((Map)inactiveAttachments).remove(player);
            }
            HashMap<AttachmentType<?>, Attachment> hashMap = activeAttachmentsMap = activeAttachments.get(player);
            Attachment attachment2 = attachment = hashMap != null ? hashMap.remove(type) : null;
            if (activeAttachmentsMap != null && activeAttachmentsMap.isEmpty()) {
                ((Map)activeAttachments).remove(player);
            }
            Attachment attachment3 = attachment;
            if (attachment3 == null) break block3;
            attachment3.despawn();
        }
    }

    @EventHandler
    private final void handlePlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.loadAttachments(player);
    }

    @EventHandler
    private final void handlePlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.saveAndRemoveAttachments(player);
    }

    @EventHandler
    private final void handleDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        this.deactivateAttachments(player);
    }

    @EventHandler
    private final void handleRespawn(PlayerRespawnEvent event) {
        SchedulerUtilsKt.runTaskLater(1L, (Function0<Unit>)((Function0)() -> AttachmentManager.handleRespawn$lambda$0(event)));
    }

    @EventHandler
    private final void handleTeleport(PlayerTeleportEvent event) {
        block1: {
            HashMap<AttachmentType<?>, Attachment> hashMap = activeAttachments.get(event.getPlayer());
            if (hashMap == null || (hashMap = hashMap.values()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)((Object)hashMap);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Attachment p0 = (Attachment)element$iv;
                boolean bl = false;
                p0.handleTeleport();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @PacketHandler
    private final void handlePassengersSet(ClientboundSetPassengersPacketEvent event) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object v2;
        Iterable $this$firstOrNull$iv;
        block3: {
            Set<Map.Entry<Player, HashMap<AttachmentType<?>, Attachment>>> set = activeAttachments.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry);
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                Player player = (Player)k;
                if (!(player.getEntityId() == event.getVehicle())) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        Map.Entry entry = v2;
        if (entry == null) {
            return;
        }
        Collection collection2 = ((HashMap)entry.getValue()).values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        Collection attachments = collection2;
        int[] nArray = event.getPassengers();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"<get-passengers>(...)");
        Iterable iterable = attachments;
        int[] nArray2 = nArray;
        ClientboundSetPassengersPacketEvent clientboundSetPassengersPacketEvent = event;
        boolean $i$f$map = false;
        $this$firstOrNull$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Attachment bl = (Attachment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(p0.getPassengerId());
        }
        collection = (List)destination$iv$iv;
        clientboundSetPassengersPacketEvent.setPassengers(ArraysKt.plus((int[])nArray2, (Collection)collection));
    }

    /*
     * WARNING - void declaration
     */
    private final void deactivateAttachments(Player player) {
        Object object;
        void $this$getOrPut$iv;
        HashMap<AttachmentType<?>, Attachment> hashMap = activeAttachments.get(player);
        if (hashMap == null) {
            return;
        }
        HashMap<AttachmentType<?>, Attachment> attachmentsMap = hashMap;
        Map map2 = inactiveAttachments;
        Player key$iv = player;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashSet answer$iv = new HashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        HashSet inactive = (HashSet)object;
        Map $this$forEach$iv = attachmentsMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            AttachmentType type = (AttachmentType)entry.getKey();
            Attachment attachment = (Attachment)entry.getValue();
            ((Collection)inactive).add(type.getId());
            attachment.despawn();
        }
        ((Map)activeAttachments).remove(player);
    }

    private final void activateAttachments(Player player) {
        HashSet<Key> hashSet = inactiveAttachments.get(player);
        if (hashSet == null) {
            return;
        }
        HashSet<Key> attachmentIds = hashSet;
        this.activateAttachments(player, (Set<? extends Key>)attachmentIds);
        ((Map)inactiveAttachments).remove(player);
    }

    private final void activateAttachments(Player player, Set<? extends Key> attachmentIds) {
        Iterable $this$forEach$iv = attachmentIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Key it = (Key)element$iv;
            boolean bl = false;
            AttachmentType type = (AttachmentType)NMSUtilsKt.getValue((Registry)NovaRegistries.ATTACHMENT_TYPE, it);
            if (type != null) {
                INSTANCE.addAttachment(player, type);
                continue;
            }
            NovaBootstrapperKt.getLOGGER().error("Unknown attachment type " + it + " on player " + player.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadAttachments(Player player) {
        Object object;
        void $this$get$iv;
        PersistentDataContainer persistentDataContainer = player.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue((Object)persistentDataContainer, (String)"getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        Key key$iv = (Key)AttachmentManagerKt.access$getATTACHMENTS_KEY$p();
        boolean $i$f$get = false;
        byte[] byArray = (byte[])$this$get$iv.get(NamespacedUtilsKt.toNamespacedKey(key$iv), PersistentDataType.BYTE_ARRAY);
        if (byArray != null) {
            void $this$iv$iv;
            byte[] byArray2 = byArray;
            Cbf cbf = Cbf.INSTANCE;
            byte[] p0$iv = byArray2;
            boolean $i$f$get$read = false;
            boolean bl = false;
            Cbf cbf2 = cbf;
            byte[] bytes$iv$iv = p0$iv;
            boolean strict$iv$iv = true;
            boolean $i$f$read = false;
            void this_$iv$iv$iv = $this$iv$iv;
            boolean $i$f$getSerializer = false;
            object = BinarySerializerKt.read((BinarySerializer)this_$iv$iv$iv.getSerializer(Reflection.typeOf(HashSet.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Key.class)))), (byte[])bytes$iv$iv, (boolean)strict$iv$iv);
        } else {
            object = null;
        }
        HashSet hashSet = (HashSet)object;
        if (hashSet == null) {
            return;
        }
        HashSet attachmentIds = hashSet;
        if (player.isDead()) {
            Object object2;
            void $this$getOrPut$iv;
            Map map2 = inactiveAttachments;
            Player key$iv2 = player;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv2);
            if (value$iv == null) {
                boolean bl = false;
                HashSet answer$iv = new HashSet();
                $this$getOrPut$iv.put(key$iv2, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            CollectionsKt.addAll((Collection)((Collection)object2), (Iterable)attachmentIds);
        } else {
            this.activateAttachments(player, attachmentIds);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveAttachments(Player player) {
        Cbf element$iv;
        Map $this$forEach$iv;
        PersistentDataContainer persistentDataContainer = player.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue((Object)persistentDataContainer, (String)"getPersistentDataContainer(...)");
        PersistentDataContainer dataContainer = persistentDataContainer;
        HashSet attachmentIds = new HashSet();
        HashMap<AttachmentType<?>, Attachment> hashMap = activeAttachments.get(player);
        if (hashMap != null) {
            $this$forEach$iv = hashMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Cbf it = element$iv = iterator.next();
                boolean bl = false;
                ((Collection)attachmentIds).add(((AttachmentType)it.getKey()).getId());
            }
        }
        HashSet<Key> hashSet = inactiveAttachments.get(player);
        if (hashSet != null) {
            HashSet<Key> it = hashSet;
            boolean bl = false;
            CollectionsKt.addAll((Collection)attachmentIds, (Iterable)it);
        }
        if (!((Collection)attachmentIds).isEmpty()) {
            void key$iv;
            void $this$set$iv;
            void this_$iv$iv;
            PersistentDataContainer persistentDataContainer2 = dataContainer;
            $this$forEach$iv = (Key)AttachmentManagerKt.access$getATTACHMENTS_KEY$p();
            HashSet obj$iv = attachmentIds;
            boolean $i$f$set = false;
            element$iv = Cbf.INSTANCE;
            HashSet value$iv$iv = obj$iv;
            boolean $i$f$write = false;
            void this_$iv$iv$iv = this_$iv$iv;
            boolean $i$f$getSerializer = false;
            $this$set$iv.set(NamespacedUtilsKt.toNamespacedKey((Key)key$iv), PersistentDataType.BYTE_ARRAY, (Object)BinarySerializerKt.write((BinarySerializer)this_$iv$iv$iv.getSerializer(Reflection.typeOf(HashSet.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Key.class)))), value$iv$iv));
        } else {
            dataContainer.remove(AttachmentManagerKt.access$getATTACHMENTS_KEY$p());
        }
    }

    private final void saveAndRemoveAttachments(Player player) {
        this.saveAttachments(player);
        HashMap<AttachmentType<?>, Attachment> hashMap = activeAttachments.remove(player);
        if (hashMap != null) {
            Map $this$forEach$iv = hashMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                ((Attachment)it.getValue()).despawn();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit init$lambda$0() {
        void $this$flatMapTo$iv$iv;
        Collection<HashMap<AttachmentType<?>, Attachment>> collection = activeAttachments.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map p0 = (Map)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = p0.values();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Attachment p0 = (Attachment)element$iv;
            boolean bl = false;
            p0.handleTick();
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleRespawn$lambda$0(PlayerRespawnEvent $event) {
        Player player = $event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        if (player2.isOnline() && !player2.isDead()) {
            Player player3 = $event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getPlayer(...)");
            INSTANCE.activateAttachments(player3);
        }
        return Unit.INSTANCE;
    }
}

