/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.block.sound;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.logic.sound.SoundEngine;
import xyz.xenondevs.nova.world.block.sound.SoundGroup;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin {
    LivingEntityMixin() {
    }

    @Overwrite
    protected void playBlockFallSound() {
        LivingEntity entity = (LivingEntity)this;
        if (entity.isSilent()) {
            return;
        }
        int x = Mth.floor((double)entity.getX());
        int y = Mth.floor((double)(entity.getY() - (double)0.2f));
        int z = Mth.floor((double)entity.getZ());
        BlockPos novaPos = new BlockPos((World)entity.level().getWorld(), x, y, z);
        Block block = novaPos.getBlock();
        if (block.getType().isAir()) {
            return;
        }
        SoundGroup soundGroup = BlockUtilsKt.getNovaSoundGroup(block);
        if (soundGroup == null) {
            return;
        }
        String newSound = soundGroup.getFallSound();
        String oldSound = MaterialUtilsKt.getSoundGroup(block.getType()).getFallSound().getKey().value();
        SoundEngine.broadcast((Entity)entity, oldSound, newSound, soundGroup.getFallVolume(), soundGroup.getFallPitch());
    }
}

