/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.registry.injectwrapperblock;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import xyz.xenondevs.nova.registry.NovaRegistries;

@Mixin(value={RegistryFileCodec.class})
abstract class RegistryFileCodecMixin {
    RegistryFileCodecMixin() {
    }

    @Redirect(method={"decode"}, at=@At(value="INVOKE", target="Lnet/minecraft/resources/RegistryOps;getter(Lnet/minecraft/resources/ResourceKey;)Ljava/util/Optional;"))
    private Optional<? extends HolderGetter<?>> getter(RegistryOps<?> ops, ResourceKey<? extends Registry<?>> key) {
        if (key != Registries.BLOCK) {
            return ops.getter(key);
        }
        final HolderGetter getter = (HolderGetter)ops.getter(Registries.BLOCK).orElseThrow();
        HolderGetter<Block> injectGetter = new HolderGetter<Block>(){

            @NotNull
            public Optional<Holder.Reference<Block>> get(@NotNull ResourceKey<Block> key) {
                Optional vanilla = getter.get(key);
                if (vanilla.isPresent()) {
                    return vanilla;
                }
                return NovaRegistries.WRAPPER_BLOCK.get(key.location());
            }

            @NotNull
            public Optional<HolderSet.Named<Block>> get(@NotNull TagKey<Block> tag) {
                return getter.get(tag);
            }
        };
        return Optional.of(injectGetter);
    }
}

