/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.font.provider.bitmap;

import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.resources.builder.font.provider.bitmap.GlyphGrid;
import xyz.xenondevs.nova.util.data.ImageUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u000e\u0010\b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/RasterGlyphGrid;", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "", "gridWidth", "", "gridHeight", "glyphWidth", "glyphHeight", "raster", "<init>", "(IIII[I)V", "getGridWidth", "()I", "getGridHeight", "getGlyphWidth", "getGlyphHeight", "glyphSize", "get", "x", "y", "toImage", "Ljava/awt/image/BufferedImage;", "nova"})
@SourceDebugExtension(value={"SMAP\nGlyphGrid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlyphGrid.kt\nxyz/xenondevs/nova/resources/builder/font/provider/bitmap/RasterGlyphGrid\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1#2:246\n*E\n"})
public final class RasterGlyphGrid
implements GlyphGrid<int[]> {
    private final int gridWidth;
    private final int gridHeight;
    private final int glyphWidth;
    private final int glyphHeight;
    @NotNull
    private int[] raster;
    private final int glyphSize;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RasterGlyphGrid(int gridWidth, int gridHeight, int glyphWidth, int glyphHeight, @NotNull int[] raster) {
        Intrinsics.checkNotNullParameter((Object)raster, (String)"raster");
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.glyphWidth = glyphWidth;
        this.glyphHeight = glyphHeight;
        this.raster = raster;
        this.glyphSize = this.getGlyphWidth() * this.getGlyphHeight();
        if (!(this.raster.length == this.getGridWidth() * this.getGlyphWidth() * this.getGridHeight() * this.getGlyphHeight())) {
            boolean $i$a$-require-RasterGlyphGrid$32 = false;
            String $i$a$-require-RasterGlyphGrid$32 = "Raster size does not match other parameters";
            throw new IllegalArgumentException($i$a$-require-RasterGlyphGrid$32.toString());
        }
        int n = this.getGlyphWidth();
        boolean bl = 0 <= n ? n < 257 : false;
        if (bl) {
            boolean bl2;
            n = this.getGlyphHeight();
            if (0 <= n) {
                if (n < 257) {
                    return;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return;
            }
        }
        boolean bl3 = false;
        if (bl3) return;
        boolean bl4 = false;
        String string = "Max glyph size is 256x256 (got " + this.getGlyphWidth() + " x " + this.getGlyphHeight() + ")";
        throw new IllegalArgumentException(string.toString());
    }

    @Override
    public int getGridWidth() {
        return this.gridWidth;
    }

    @Override
    public int getGridHeight() {
        return this.gridHeight;
    }

    @Override
    public int getGlyphWidth() {
        return this.glyphWidth;
    }

    @Override
    public int getGlyphHeight() {
        return this.glyphHeight;
    }

    @Override
    @NotNull
    public int[] get(int x, int y) {
        block4: {
            block3: {
                boolean bl = 0 <= x ? x <= this.getGridWidth() : false;
                if (!bl) break block3;
                if (0 <= y ? y <= this.getGridHeight() : false) break block4;
            }
            throw new IndexOutOfBoundsException("Coordinates (" + x + ", " + y + ") are out of bounds for grid (" + this.getGridWidth() + " x " + this.getGridHeight() + ")");
        }
        int i2 = y * this.glyphSize;
        return ArraysKt.copyOfRange((int[])this.raster, (int)i2, (int)(i2 + this.glyphSize));
    }

    @Override
    @NotNull
    public BufferedImage toImage() {
        return ImageUtils.createImageFromArgbRaster(this.getGridWidth() * this.getGlyphWidth(), this.raster);
    }
}

