/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ.\u0010\r\u001a\u0012\u0012\u000e\u0012\f0\u0005\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\"\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005\u00a8\u0006\u001a"}, d2={"Lxyz/xenondevs/nova/util/LocationUtils;", "", "<init>", "()V", "getTopBlockBetween", "Lorg/bukkit/Location;", "world", "Lorg/bukkit/World;", "x", "", "z", "maxY", "minY", "getStraightLine", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "base", "axis", "Lorg/bukkit/Axis;", "range", "Lkotlin/ranges/IntRange;", "sort", "Lkotlin/Pair;", "first", "second", "nova"})
@SourceDebugExtension(value={"SMAP\nLocationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationUtils.kt\nxyz/xenondevs/nova/util/LocationUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,444:1\n1563#2:445\n1634#2,2:446\n1636#2:449\n1#3:448\n*S KotlinDebug\n*F\n+ 1 LocationUtils.kt\nxyz/xenondevs/nova/util/LocationUtils\n*L\n429#1:445\n429#1:446,2\n429#1:449\n*E\n"})
public final class LocationUtils {
    @NotNull
    public static final LocationUtils INSTANCE = new LocationUtils();

    private LocationUtils() {
    }

    @Nullable
    public final Location getTopBlockBetween(@NotNull World world, int x, int z, int maxY, int minY) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Location location = LocationUtilsKt.Location$default(world, x, 0, z, null, null, 48, null);
        int y = maxY;
        if (minY <= y) {
            while (true) {
                location.setY((double)y);
                Material material = location.getBlock().getType();
                Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
                if (!MaterialUtilsKt.isTraversable(material)) {
                    return location;
                }
                if (y == minY) break;
                --y;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Location> getStraightLine(@NotNull Location base, @NotNull Axis axis, @NotNull IntRange range) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Iterable $this$map$iv = (Iterable)range;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Location location;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Location $this$getStraightLine_u24lambda_u240_u240 = location = base.clone();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)$this$getStraightLine_u24lambda_u240_u240);
            LocationUtilsKt.setCoordinate($this$getStraightLine_u24lambda_u240_u240, axis, (double)it);
            collection.add(location);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Pair<Location, Location> sort(@NotNull Location first, @NotNull Location second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Preconditions.checkArgument((boolean)Intrinsics.areEqual((Object)first.getWorld(), (Object)second.getWorld()));
        double minX = Math.min(first.getX(), second.getX());
        double minY = Math.min(first.getY(), second.getY());
        double minZ = Math.min(first.getZ(), second.getZ());
        double maxX = Math.max(first.getX(), second.getX());
        double maxY = Math.max(first.getY(), second.getY());
        double maxZ = Math.max(first.getZ(), second.getZ());
        return TuplesKt.to((Object)new Location(first.getWorld(), minX, minY, minZ), (Object)new Location(second.getWorld(), maxX, maxY, maxZ));
    }
}

