/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util.concurrent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lxyz/xenondevs/nova/util/concurrent/Latch;", "", "<init>", "()V", "semaphore", "Ljava/util/concurrent/Semaphore;", "close", "", "open", "await", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "isClosed", "toggle", "toString", "", "nova"})
public final class Latch {
    @NotNull
    private final Semaphore semaphore = new Semaphore(1);

    public final void close() {
        this.semaphore.acquire();
    }

    public final void open() {
        this.semaphore.release();
    }

    public final void await() {
        this.semaphore.acquire();
        this.semaphore.release();
    }

    public final boolean await(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (this.semaphore.tryAcquire(timeout, unit)) {
            this.semaphore.release();
            return true;
        }
        return false;
    }

    public final boolean isClosed() {
        return this.semaphore.availablePermits() == 0;
    }

    public final void toggle() {
        if (this.isClosed()) {
            this.open();
        } else {
            this.close();
        }
    }

    @NotNull
    public String toString() {
        return "Latch(closed=" + this.isClosed() + ")";
    }
}

