/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util.item;

import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.bukkit.GameMode;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.util.EntityUtilsKt;
import xyz.xenondevs.nova.util.MathUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.behavior.Breakable;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.format.WorldDataManager;
import xyz.xenondevs.nova.world.item.NovaItem;
import xyz.xenondevs.nova.world.item.tool.ToolCategory;
import xyz.xenondevs.nova.world.item.tool.ToolTier;
import xyz.xenondevs.nova.world.item.tool.VanillaToolCategories;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ'\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\u000eJd\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u000b2\b\b\u0002\u0010\u0018\u001a\u00020\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u0005J\u001a\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001cH\u0002J\u0018\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#2\u0006\u0010%\u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0014H\u0002\u00a8\u0006("}, d2={"Lxyz/xenondevs/nova/util/item/ToolUtils;", "", "<init>", "()V", "isCorrectToolForDrops", "", "block", "Lorg/bukkit/block/Block;", "tool", "Lorg/bukkit/inventory/ItemStack;", "calculateDamage", "", "player", "Lorg/bukkit/entity/Player;", "calculateDamage$nova", "hardness", "correctForDrops", "speed", "efficiency", "hasteLevel", "", "fatigueLevel", "blockBreakSpeed", "submergedMiningSpeed", "isOnGround", "isUnderWater", "getDestroySpeed", "findMatchingToolComponentRules", "", "Lnet/minecraft/world/item/component/Tool$Rule;", "component", "Lnet/minecraft/world/item/component/Tool;", "categories", "Lxyz/xenondevs/nova/world/item/tool/ToolCategory;", "findSimilarTagForToolCategory", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/block/Block;", "category", "getFatigueMultiplier", "level", "nova"})
@SourceDebugExtension(value={"SMAP\nToolUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolUtils.kt\nxyz/xenondevs/nova/util/item/ToolUtils\n+ 2 NovaBlock.kt\nxyz/xenondevs/nova/world/block/NovaBlock\n+ 3 NovaItem.kt\nxyz/xenondevs/nova/world/item/NovaItem\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n107#2:198\n107#2:205\n180#3:199\n204#3:200\n204#3:201\n1761#4,3:202\n1625#4:207\n1869#4:208\n1870#4:210\n1626#4:211\n865#4,2:212\n1#5:206\n1#5:209\n*S KotlinDebug\n*F\n+ 1 ToolUtils.kt\nxyz/xenondevs/nova/util/item/ToolUtils\n*L\n43#1:198\n151#1:205\n51#1:199\n69#1:200\n139#1:201\n144#1:202,3\n168#1:207\n168#1:208\n168#1:210\n168#1:211\n169#1:212,2\n168#1:209\n*E\n"})
public final class ToolUtils {
    @NotNull
    public static final ToolUtils INSTANCE = new ToolUtils();

    private ToolUtils() {
    }

    public final boolean isCorrectToolForDrops(@NotNull org.bukkit.block.Block block, @Nullable ItemStack tool) {
        boolean bl;
        ItemStack itemStack;
        Tool toolComponent;
        NovaBlock this_$iv;
        NovaBlock novaBlock;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        NovaBlockState novaBlockState = WorldDataManager.INSTANCE.getBlockState(BlockPosKt.getPos(block));
        NovaBlock novaBlock2 = novaBlock = novaBlockState != null ? novaBlockState.getBlock() : null;
        if (novaBlock != null) {
            this_$iv = novaBlock;
            boolean $i$f$getBehaviorOrNull = false;
            Breakable breakable = (Breakable)this_$iv.getBehaviorOrNull(Reflection.getOrCreateKotlinClass(Breakable.class));
            if (breakable == null) {
                return false;
            }
            boolean requiresToolForDrops = breakable.getRequiresToolForDrops();
            if (!requiresToolForDrops) {
                return true;
            }
        } else if (!((CraftBlock)block).getNMS().requiresCorrectToolForDrops()) {
            return true;
        }
        Tool tool2 = toolComponent = (itemStack = tool) != null && (itemStack = NMSUtilsKt.unwrap(itemStack)) != null ? (Tool)itemStack.get(DataComponents.TOOL) : null;
        Object object = tool;
        if (object != null && (object = ItemUtilsKt.getNovaItem(object)) != null) {
            this_$iv = object;
            boolean $i$f$hasBehavior = false;
            bl = ((NovaItem)((Object)this_$iv)).hasBehavior(Reflection.getOrCreateKotlinClass(xyz.xenondevs.nova.world.item.behavior.Tool.class));
        } else {
            bl = false;
        }
        if (!bl && toolComponent != null && novaBlock == null) {
            return toolComponent.isCorrectForDrops(NMSUtilsKt.getNmsState(block));
        }
        return ToolCategory.Companion.hasCorrectToolCategory(block, tool) && ToolTier.Companion.isCorrectLevel(block, tool);
    }

    /*
     * Unable to fully structure code
     */
    public final double calculateDamage$nova(@NotNull Player player, @NotNull org.bukkit.block.Block block, @Nullable ItemStack tool) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        switch (WhenMappings.$EnumSwitchMapping$0[player.getGameMode().ordinal()]) {
            case 1: {
                v0 = tool;
                if (v0 == null || (v0 = ItemUtilsKt.getNovaItem((ItemStack)v0)) == null) ** GOTO lbl-1000
                this_$iv = v0;
                $i$f$getBehaviorOrNull = false;
                v0 = (xyz.xenondevs.nova.world.item.behavior.Tool)this_$iv.getBehaviorOrNull(Reflection.getOrCreateKotlinClass(xyz.xenondevs.nova.world.item.behavior.Tool.class));
                if (v0 != null) {
                    v1 = v0.getCanBreakBlocksInCreative();
                } else lbl-1000:
                // 2 sources

                {
                    v1 = (v2 = tool) != null && (v2 = (io.papermc.paper.datacomponent.item.Tool)v2.getData(DataComponentTypes.TOOL)) != null ? v2.canDestroyBlocksInCreative() : true;
                }
                canBreakBlocks = v1;
                return canBreakBlocks != false ? 1.0 : 0.0;
            }
            case 2: {
                if (tool == null || (canBreakBlocks = NMSUtilsKt.unwrap(tool)) == null || (var7_8 = (AdventureModePredicate)canBreakBlocks.get(DataComponents.CAN_BREAK)) == null) break;
                v3 = block.getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getWorld(...)");
                var7_8.test(new BlockInWorld((LevelReader)NMSUtilsKt.getServerLevel(v3), BlockPosKt.getPos(block).getNmsPos(), false));
                break;
            }
            case 3: {
                return 0.0;
            }
        }
        v4 = BlockUtilsKt.getHardness(block);
        v5 = this.isCorrectToolForDrops(block, tool);
        v6 = this.getDestroySpeed(block, tool);
        v7 = player.getAttribute(Attribute.MINING_EFFICIENCY);
        v8 = v7 != null ? v7.getValue() : 0.0;
        v9 = player.getPotionEffect(PotionEffectType.HASTE);
        v10 = v9 != null ? v9.getAmplifier() + 1 : 0;
        v11 = player.getPotionEffect(PotionEffectType.MINING_FATIGUE);
        v12 = v11 != null ? v11.getAmplifier() + 1 : 0;
        v13 = player.getAttribute(Attribute.BLOCK_BREAK_SPEED);
        v14 = v13 != null ? v13.getValue() : 1.0;
        v15 = player.getAttribute(Attribute.SUBMERGED_MINING_SPEED);
        v16 = v15 != null ? v15.getValue() : 0.2;
        v17 = player.isOnGround();
        if (!EntityUtilsKt.getEyeInWater((Entity)player)) ** GOTO lbl-1000
        v18 = player.getInventory().getHelmet();
        if (!(v18 != null ? v18.containsEnchantment(Enchantment.AQUA_AFFINITY) : false)) {
            v19 = true;
        } else lbl-1000:
        // 2 sources

        {
            v19 = false;
        }
        damage = this.calculateDamage(v4, v5, v6, v8, v10, v12, v14, v16, v17, v19);
        v20 = tool;
        v21 = novaItem = v20 != null ? ItemUtilsKt.getNovaItem(v20) : null;
        if (novaItem != null) {
            damage = novaItem.modifyBlockDamage$nova(player, tool, block, damage);
        }
        return damage;
    }

    public final double calculateDamage(double hardness, boolean correctForDrops, double speed, double efficiency, int hasteLevel, int fatigueLevel, double blockBreakSpeed, double submergedMiningSpeed, boolean isOnGround, boolean isUnderWater) {
        if (hardness < 0.0) {
            return 0.0;
        }
        if (hardness == 0.0) {
            return 1.0;
        }
        double speedMultiplier = speed;
        if (speedMultiplier > 1.0) {
            speedMultiplier += efficiency;
        }
        speedMultiplier *= (double)hasteLevel * 0.2 + 1.0;
        speedMultiplier *= this.getFatigueMultiplier(fatigueLevel);
        speedMultiplier *= blockBreakSpeed;
        if (isUnderWater) {
            speedMultiplier *= submergedMiningSpeed;
        }
        if (!isOnGround) {
            speedMultiplier /= 5.0;
        }
        return MathUtilsKt.roundToDecimalPlaces(speedMultiplier / hardness / (correctForDrops ? 30.0 : 100.0), 3);
    }

    public static /* synthetic */ double calculateDamage$default(ToolUtils toolUtils, double d, boolean bl, double d2, double d3, int n, int n2, double d4, double d5, boolean bl2, boolean bl3, int n3, Object object) {
        if ((n3 & 8) != 0) {
            d3 = 0.0;
        }
        if ((n3 & 0x10) != 0) {
            n = 0;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            d4 = 1.0;
        }
        if ((n3 & 0x80) != 0) {
            d5 = 0.2;
        }
        if ((n3 & 0x100) != 0) {
            bl2 = true;
        }
        if ((n3 & 0x200) != 0) {
            bl3 = false;
        }
        return toolUtils.calculateDamage(d, bl, d2, d3, n, n2, d4, d5, bl2, bl3);
    }

    private final double getDestroySpeed(org.bukkit.block.Block block, ItemStack tool) {
        xyz.xenondevs.nova.world.item.behavior.Tool toolBehavior;
        if (tool == null) {
            return 1.0;
        }
        Tool toolComponent = (Tool)NMSUtilsKt.unwrap(tool).get(DataComponents.TOOL);
        NovaItem novaItem = ItemUtilsKt.getNovaItem(tool);
        if (novaItem != null) {
            NovaItem this_$iv = novaItem;
            boolean $i$f$getBehaviorOrNull = false;
            v1 = (xyz.xenondevs.nova.world.item.behavior.Tool)this_$iv.getBehaviorOrNull(Reflection.getOrCreateKotlinClass(xyz.xenondevs.nova.world.item.behavior.Tool.class));
        } else {
            v1 = toolBehavior = null;
        }
        if (toolBehavior != null) {
            boolean bl;
            block15: {
                Set<ToolCategory> itemCategories = toolBehavior.getCategories();
                blockCategories = ToolCategory.Companion.ofBlock(block);
                Iterable $this$any$iv = itemCategories;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ToolCategory it = (ToolCategory)element$iv;
                        boolean bl2 = false;
                        if (!blockCategories.contains(it)) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return toolBehavior.getBreakSpeed();
            }
        } else if (toolComponent != null) {
            NovaBlock novaBlock = BlockUtilsKt.getNovaBlock(block);
            if (novaBlock != null) {
                Float f;
                Iterator iterator;
                NovaBlock this_$iv = novaBlock;
                boolean $i$f$getBehaviorOrNull = false;
                Object object = (Breakable)this_$iv.getBehaviorOrNull(Reflection.getOrCreateKotlinClass(Breakable.class));
                if (object == null || (object = object.getToolCategories()) == null) {
                    object = SetsKt.emptySet();
                }
                if (!(iterator = ((Iterable)this.findMatchingToolComponentRules(toolComponent, (Set<? extends ToolCategory>)(blockCategories = object))).iterator()).hasNext()) {
                    f = null;
                } else {
                    Tool.Rule it = (Tool.Rule)iterator.next();
                    boolean bl = false;
                    Float f2 = it.speed().orElse(Float.valueOf(1.0f));
                    Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"orElse(...)");
                    float f3 = ((Number)f2).floatValue();
                    while (iterator.hasNext()) {
                        Tool.Rule it2 = (Tool.Rule)iterator.next();
                        $i$a$-maxOfOrNull-ToolUtils$getDestroySpeed$2 = false;
                        Float f4 = it2.speed().orElse(Float.valueOf(1.0f));
                        Intrinsics.checkNotNullExpressionValue((Object)f4, (String)"orElse(...)");
                        float f5 = ((Number)f4).floatValue();
                        f3 = Math.max(f3, f5);
                    }
                    f = Float.valueOf(f3);
                }
                Float f6 = f;
                return f6 != null ? (double)f6.floatValue() : 1.0;
            }
            return toolComponent.getMiningSpeed(NMSUtilsKt.getNmsState(block));
        }
        return 1.0;
    }

    /*
     * Unable to fully structure code
     */
    private final Set<Tool.Rule> findMatchingToolComponentRules(Tool component, Set<? extends ToolCategory> categories) {
        var4_3 = categories;
        destination$iv = new HashSet<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        $i$f$forEach = false;
        var9_9 = $this$forEach$iv$iv.iterator();
        while (var9_9.hasNext()) {
            element$iv = element$iv$iv = var9_9.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv = false;
            p0 = (ToolCategory)element$iv;
            $i$a$-mapNotNullTo-ToolUtils$findMatchingToolComponentRules$tags$1 = false;
            if (this.findSimilarTagForToolCategory(p0) == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv = false;
            destination$iv.add(it$iv);
        }
        tags = (HashSet)destination$iv;
        v0 = component.rules();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"rules(...)");
        $this$mapNotNullTo$iv = v0;
        destination$iv = new HashSet<E>();
        $i$f$filterTo = false;
        for (T element$iv : $this$filterTo$iv) {
            it = (Tool.Rule)element$iv;
            $i$a$-filterTo-ToolUtils$findMatchingToolComponentRules$1 = false;
            if (!(it.blocks() instanceof HolderSet.Named)) ** GOTO lbl-1000
            v1 = it.blocks();
            Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type net.minecraft.core.HolderSet.Named<net.minecraft.world.level.block.Block>");
            if (tags.contains(((HolderSet.Named)v1).key())) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    private final TagKey<Block> findSimilarTagForToolCategory(ToolCategory category) {
        ToolCategory toolCategory = category;
        return Intrinsics.areEqual((Object)toolCategory, (Object)VanillaToolCategories.INSTANCE.getAXE()) ? BlockTags.MINEABLE_WITH_AXE : (Intrinsics.areEqual((Object)toolCategory, (Object)VanillaToolCategories.INSTANCE.getHOE()) ? BlockTags.MINEABLE_WITH_HOE : (Intrinsics.areEqual((Object)toolCategory, (Object)VanillaToolCategories.INSTANCE.getPICKAXE()) ? BlockTags.MINEABLE_WITH_PICKAXE : (Intrinsics.areEqual((Object)toolCategory, (Object)VanillaToolCategories.INSTANCE.getSHEARS()) ? BlockTags.LEAVES : (Intrinsics.areEqual((Object)toolCategory, (Object)VanillaToolCategories.INSTANCE.getSHOVEL()) ? BlockTags.MINEABLE_WITH_SHOVEL : null))));
    }

    private final double getFatigueMultiplier(int level) {
        return switch (level) {
            case 0 -> 1.0;
            case 1 -> 0.3;
            case 2 -> 0.09;
            case 3 -> 0.0027;
            default -> 8.1E-4;
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GameMode.values().length];
            try {
                nArray[GameMode.CREATIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameMode.ADVENTURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameMode.SPECTATOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

