/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.behavior;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.ContextIntention;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.util.BlockUtils;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.DefaultBlocks;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.behavior.BlockBehavior;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.state.property.DefaultBlockStateProperties;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011H\u0016\u00a8\u0006\u001b"}, d2={"Lxyz/xenondevs/nova/world/block/behavior/LeavesBehavior;", "Lxyz/xenondevs/nova/world/block/behavior/BlockBehavior;", "<init>", "()V", "ticksRandomly", "", "state", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "handleRandomTick", "", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "handleScheduledTick", "getDrops", "", "Lorg/bukkit/inventory/ItemStack;", "ctx", "Lxyz/xenondevs/nova/context/Context;", "Lxyz/xenondevs/nova/context/intention/DefaultContextIntentions$BlockBreak;", "updateShape", "neighborPos", "getDistanceAt", "", "(Lxyz/xenondevs/nova/world/BlockPos;)Ljava/lang/Integer;", "calculateDistance", "pickBlockCreative", "Lxyz/xenondevs/nova/context/intention/DefaultContextIntentions$BlockInteract;", "nova"})
@SourceDebugExtension(value={"SMAP\nLeavesBehavior.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeavesBehavior.kt\nxyz/xenondevs/nova/world/block/behavior/LeavesBehavior\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1563#2:128\n1634#2,3:129\n*S KotlinDebug\n*F\n+ 1 LeavesBehavior.kt\nxyz/xenondevs/nova/world/block/behavior/LeavesBehavior\n*L\n72#1:128\n72#1:129,3\n*E\n"})
public final class LeavesBehavior
implements BlockBehavior {
    @NotNull
    public static final LeavesBehavior INSTANCE = new LeavesBehavior();

    private LeavesBehavior() {
    }

    @Override
    public boolean ticksRandomly(@NotNull NovaBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return (Boolean)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getLEAVES_PERSISTENT$nova()) == false && ((Number)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getLEAVES_DISTANCE$nova())).intValue() == 7;
    }

    @Override
    public void handleRandomTick(@NotNull BlockPos pos, @NotNull NovaBlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!((Boolean)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getLEAVES_PERSISTENT$nova())).booleanValue() && ((Number)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getLEAVES_DISTANCE$nova())).intValue() >= 7) {
            LeavesDecayEvent event = new LeavesDecayEvent(pos.getBlock());
            EventUtilsKt.callEvent((Event)event);
            if (event.isCancelled() || !Intrinsics.areEqual((Object)WorldDataManager.INSTANCE.getBlockState(pos), (Object)state)) {
                return;
            }
            Context<ContextIntention> ctx = Context.Companion.intention((ContextIntention)DefaultContextIntentions.BlockBreak.INSTANCE).param(DefaultContextParamTypes.INSTANCE.getBLOCK_POS(), pos).param(DefaultContextParamTypes.INSTANCE.getBLOCK_STATE_NOVA(), state).param(DefaultContextParamTypes.INSTANCE.getBLOCK_BREAK_EFFECTS(), false).build();
            BlockUtils.INSTANCE.breakBlockNaturally(ctx);
        }
    }

    @Override
    public void handleScheduledTick(@NotNull BlockPos pos, @NotNull NovaBlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        NovaBlockState newState = state.with(DefaultBlockStateProperties.INSTANCE.getLEAVES_DISTANCE$nova(), this.calculateDistance(pos));
        if (Intrinsics.areEqual((Object)state, (Object)newState)) {
            return;
        }
        WorldDataManager.INSTANCE.setBlockState(pos, state.with(DefaultBlockStateProperties.INSTANCE.getLEAVES_DISTANCE$nova(), this.calculateDistance(pos)));
        BlockUtils.INSTANCE.broadcastBlockUpdate$nova(pos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull Context<DefaultContextIntentions.BlockBreak> ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        if (!ctx.get(DefaultContextParamTypes.INSTANCE.getBLOCK_DROPS()).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        BlockState nmsState = pos.getNmsBlockState();
        LootParams params = new LootParams.Builder(NMSUtilsKt.getServerLevel(pos.getWorld())).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)((Vec3i)pos.getNmsPos()))).withParameter(LootContextParams.TOOL, (Object)NMSUtilsKt.unwrap(ctx.get(DefaultContextParamTypes.INSTANCE.getTOOL_ITEM_STACK()))).withParameter(LootContextParams.BLOCK_STATE, (Object)nmsState).create(LootContextParamSets.BLOCK);
        LootTable lootTable = NMSUtilsKt.getMINECRAFT_SERVER().reloadableRegistries().getLootTable((ResourceKey)nmsState.getBlock().getLootTable().get());
        ObjectArrayList objectArrayList = lootTable.getRandomItems(params);
        Intrinsics.checkNotNullExpressionValue((Object)objectArrayList, (String)"getRandomItems(...)");
        Iterable $this$map$iv = (Iterable)objectArrayList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            net.minecraft.world.item.ItemStack itemStack = (net.minecraft.world.item.ItemStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asBukkitMirror());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public NovaBlockState updateShape(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull BlockPos neighborPos) {
        block5: {
            ServerLevel level;
            block4: {
                Integer distance;
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
                level = NMSUtilsKt.getServerLevel(pos.getWorld());
                if (((Boolean)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getWATERLOGGED())).booleanValue()) {
                    level.scheduleTick(pos.getNmsPos(), (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
                }
                Integer n = distance = this.getDistanceAt(neighborPos);
                int n2 = 1;
                if (n == null || n != n2) break block4;
                Integer n3 = distance;
                if (n3 != null && ((Number)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getLEAVES_DISTANCE$nova())).intValue() == n3.intValue()) break block5;
            }
            level.scheduleTick(pos.getNmsPos(), pos.getNmsBlockState().getBlock(), 1);
        }
        return state;
    }

    @Nullable
    public final Integer getDistanceAt(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        NovaBlockState novaBlockState = WorldDataManager.INSTANCE.getBlockState(pos);
        if (novaBlockState == null) {
            return Tag.LOGS.isTagged((Keyed)pos.getBlock().getType()) ? Integer.valueOf(0) : null;
        }
        NovaBlockState state = novaBlockState;
        return (Integer)state.get(DefaultBlockStateProperties.INSTANCE.getLEAVES_DISTANCE$nova());
    }

    public final int calculateDistance(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int distance = 7;
        for (BlockFace face : LocationUtilsKt.getCUBE_FACES()) {
            BlockPos neighborPos = BlockPos.advance$default(pos, face, 0, 2, null);
            Integer n = this.getDistanceAt(neighborPos);
            if (n == null) {
                continue;
            }
            int dist = n;
            distance = Math.min(distance, dist + 1);
        }
        return distance;
    }

    @Override
    @Nullable
    public ItemStack pickBlockCreative(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull Context<DefaultContextIntentions.BlockInteract> ctx) {
        Material material;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        NovaBlock novaBlock = state.getBlock();
        if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getOAK_LEAVES())) {
            material = Material.OAK_LEAVES;
        } else if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getSPRUCE_LEAVES())) {
            material = Material.SPRUCE_LEAVES;
        } else if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getBIRCH_LEAVES())) {
            material = Material.BIRCH_LEAVES;
        } else if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getJUNGLE_LEAVES())) {
            material = Material.JUNGLE_LEAVES;
        } else if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getACACIA_LEAVES())) {
            material = Material.ACACIA_LEAVES;
        } else if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getDARK_OAK_LEAVES())) {
            material = Material.DARK_OAK_LEAVES;
        } else if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getMANGROVE_LEAVES())) {
            material = Material.MANGROVE_LEAVES;
        } else if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getCHERRY_LEAVES())) {
            material = Material.CHERRY_LEAVES;
        } else if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getAZALEA_LEAVES())) {
            material = Material.AZALEA_LEAVES;
        } else if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getFLOWERING_AZALEA_LEAVES())) {
            material = Material.FLOWERING_AZALEA_LEAVES;
        } else if (Intrinsics.areEqual((Object)novaBlock, (Object)DefaultBlocks.INSTANCE.getPALE_OAK_LEAVES())) {
            material = Material.PALE_OAK_LEAVES;
        } else {
            throw new UnsupportedOperationException("Unknown leaves block type: " + state.getBlock());
        }
        Material type = material;
        return ItemStack.of((Material)type);
    }
}

