/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.behavior;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.util.BlockUtils;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.behavior.BlockBehavior;
import xyz.xenondevs.nova.world.block.behavior.Bucketable;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.state.model.BlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.DisplayEntityBlockModelProvider;
import xyz.xenondevs.nova.world.block.state.property.DefaultBlockStateProperties;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.FluidType;
import xyz.xenondevs.nova.world.player.EventlessHandSwingingKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lxyz/xenondevs/nova/world/block/behavior/Waterloggable;", "Lxyz/xenondevs/nova/world/block/behavior/BlockBehavior;", "<init>", "()V", "handleInteract", "", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "state", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "ctx", "Lxyz/xenondevs/nova/context/Context;", "Lxyz/xenondevs/nova/context/intention/DefaultContextIntentions$BlockInteract;", "handleNeighborChanged", "", "nova"})
public final class Waterloggable
implements BlockBehavior {
    @NotNull
    public static final Waterloggable INSTANCE = new Waterloggable();

    private Waterloggable() {
    }

    @Override
    public boolean handleInteract(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull Context<DefaultContextIntentions.BlockInteract> ctx) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        Player player = ctx.get(DefaultContextParamTypes.INSTANCE.getSOURCE_PLAYER());
        if (player == null) {
            return false;
        }
        Player player2 = player;
        if (player2.isSneaking()) {
            return false;
        }
        EquipmentSlot equipmentSlot = ctx.get(DefaultContextParamTypes.INSTANCE.getINTERACTION_HAND());
        if (equipmentSlot == null) {
            return false;
        }
        EquipmentSlot hand = equipmentSlot;
        ItemStack itemStack = player2.getInventory().getItem(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack itemStack2 = itemStack;
        boolean isWaterlogged = (Boolean)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getWATERLOGGED());
        if (!isWaterlogged && itemStack2.getType() == Material.WATER_BUCKET) {
            BlockUtils.INSTANCE.updateBlockState(pos, state.with(DefaultBlockStateProperties.INSTANCE.getWATERLOGGED(), true));
            if (player2.getGameMode() != GameMode.CREATIVE) {
                Bucketable.INSTANCE.emptyBucketInHand$nova(player2, hand);
            }
            Sound sound = Sound.ITEM_BUCKET_EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)sound, (String)"ITEM_BUCKET_EMPTY");
            pos.playSound(sound, 1.0f, 1.0f);
            EventlessHandSwingingKt.swingHandEventless(player2, hand);
            return true;
        }
        if (isWaterlogged && itemStack2.getType() == Material.BUCKET) {
            BlockUtils.INSTANCE.updateBlockState(pos, state.with(DefaultBlockStateProperties.INSTANCE.getWATERLOGGED(), false));
            if (player2.getGameMode() != GameMode.CREATIVE) {
                Bucketable.INSTANCE.fillBucketInHand$nova(player2, hand, FluidType.WATER);
            }
            Sound sound = Sound.ITEM_BUCKET_FILL;
            Intrinsics.checkNotNullExpressionValue((Object)sound, (String)"ITEM_BUCKET_FILL");
            pos.playSound(sound, 1.0f, 1.0f);
            EventlessHandSwingingKt.swingHandEventless(player2, hand);
            return true;
        }
        return false;
    }

    @Override
    public void handleNeighborChanged(@NotNull BlockPos pos, @NotNull NovaBlockState state) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            BlockModelProvider blockModelProvider = state.getModelProvider$nova();
            DisplayEntityBlockModelProvider displayEntityBlockModelProvider = blockModelProvider instanceof DisplayEntityBlockModelProvider ? (DisplayEntityBlockModelProvider)blockModelProvider : null;
            if (displayEntityBlockModelProvider == null) break block0;
            displayEntityBlockModelProvider.updateWaterlogEntity(pos);
        }
    }
}

