/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.hitbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.network.event.PacketHandler;
import xyz.xenondevs.nova.network.event.PacketListener;
import xyz.xenondevs.nova.network.event.PacketListenerKt;
import xyz.xenondevs.nova.network.event.serverbound.ServerboundInteractPacketEvent;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.hitbox.Hitbox;
import xyz.xenondevs.nova.world.block.hitbox.PhysicalHitbox;
import xyz.xenondevs.nova.world.block.hitbox.VirtualHitbox;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeInteraction;
import xyz.xenondevs.nova.world.player.WrappedPlayerInteractEvent;
import xyz.xenondevs.nova.world.region.Region;
import xyz.xenondevs.nova.world.region.VisualRegion;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u001d\u0010 \u001a\u00020\u001b2\u000e\u0010\u001e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030!H\u0000\u00a2\u0006\u0002\b\"J\u001d\u0010#\u001a\u00020\u001b2\u000e\u0010\u001e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030!H\u0000\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0003J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0003J$\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u000201\u0018\u0001002\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u0017R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013 \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lxyz/xenondevs/nova/world/block/hitbox/HitboxManager;", "Lorg/bukkit/event/Listener;", "Lxyz/xenondevs/nova/network/event/PacketListener;", "<init>", "()V", "physicalHitboxes", "Ljava/util/HashMap;", "Lxyz/xenondevs/nova/world/block/hitbox/PhysicalHitbox;", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeInteraction;", "physicalHitboxesById", "", "virtualHitboxes", "Ljava/util/HashSet;", "Lxyz/xenondevs/nova/world/block/hitbox/VirtualHitbox;", "virtualHitboxesByBlock", "Lxyz/xenondevs/nova/world/BlockPos;", "Ljava/util/ArrayList;", "visualizers", "", "Lorg/bukkit/entity/Player;", "kotlin.jvm.PlatformType", "", "toggleVisualizer", "", "player", "toggleVisualizer$nova", "showVirtualHitboxes", "", "hideVirtualHitboxes", "showVirtualHitbox", "hitbox", "hideVirtualHitbox", "registerHitbox", "Lxyz/xenondevs/nova/world/block/hitbox/Hitbox;", "registerHitbox$nova", "removeHitbox", "removeHitbox$nova", "addPhysicalHitbox", "removePhysicalHitbox", "addVirtualHitbox", "removeVirtualHitbox", "handleEntityInteractPacket", "event", "Lxyz/xenondevs/nova/network/event/serverbound/ServerboundInteractPacketEvent;", "handleInteract", "wrappedEvent", "Lxyz/xenondevs/nova/world/player/WrappedPlayerInteractEvent;", "rayTraceHitboxes", "Lkotlin/Pair;", "Lorg/joml/Vector3f;", "isLeftClick", "nova"})
@SourceDebugExtension(value={"SMAP\nHitboxManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitboxManager.kt\nxyz/xenondevs/nova/world/block/hitbox/HitboxManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,249:1\n1869#2,2:250\n1869#2,2:252\n1869#2,2:261\n1869#2,2:263\n1869#2,2:265\n1869#2,2:267\n1869#2,2:269\n1869#2,2:271\n382#3,7:254\n*S KotlinDebug\n*F\n+ 1 HitboxManager.kt\nxyz/xenondevs/nova/world/block/hitbox/HitboxManager\n*L\n70#1:250,2\n73#1:252,2\n112#1:261,2\n118#1:263,2\n174#1:265,2\n137#1:267,2\n140#1:269,2\n213#1:271,2\n111#1:254,7\n*E\n"})
public final class HitboxManager
implements Listener,
PacketListener {
    @NotNull
    public static final HitboxManager INSTANCE = new HitboxManager();
    @NotNull
    private static final HashMap<PhysicalHitbox, FakeInteraction> physicalHitboxes = new HashMap();
    @NotNull
    private static final HashMap<Integer, PhysicalHitbox> physicalHitboxesById = new HashMap();
    @NotNull
    private static final HashSet<VirtualHitbox> virtualHitboxes = new HashSet();
    @NotNull
    private static final HashMap<BlockPos, ArrayList<VirtualHitbox>> virtualHitboxesByBlock = new HashMap();
    private static final Set<Player> visualizers = Collections.newSetFromMap(new WeakHashMap());

    private HitboxManager() {
    }

    public final boolean toggleVisualizer$nova(@NotNull Player player) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (visualizers.contains(player)) {
            Set<Player> set = visualizers;
            Intrinsics.checkNotNullExpressionValue(set, (String)"visualizers");
            ((Collection)set).remove(player);
            this.hideVirtualHitboxes(player);
            bl = false;
        } else {
            Set<Player> set = visualizers;
            Intrinsics.checkNotNullExpressionValue(set, (String)"visualizers");
            ((Collection)set).add(player);
            this.showVirtualHitboxes(player);
            bl = true;
        }
        return bl;
    }

    private final void showVirtualHitboxes(Player player) {
        Iterable $this$forEach$iv = virtualHitboxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualHitbox it = (VirtualHitbox)element$iv;
            boolean bl = false;
            INSTANCE.showVirtualHitbox(it, player);
        }
    }

    private final void hideVirtualHitboxes(Player player) {
        Iterable $this$forEach$iv = virtualHitboxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualHitbox it = (VirtualHitbox)element$iv;
            boolean bl = false;
            INSTANCE.hideVirtualHitbox(it, player);
        }
    }

    private final void showVirtualHitbox(VirtualHitbox hitbox, Player player) {
        UUID uUID = hitbox.getUuid$nova();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        VisualRegion.INSTANCE.showRegion(player, uUID, new Region(LocationUtilsKt.toLocation(hitbox.getFrom(), hitbox.getWorld()), LocationUtilsKt.toLocation(hitbox.getTo(), hitbox.getWorld())));
    }

    private final void hideVirtualHitbox(VirtualHitbox hitbox, Player player) {
        UUID uUID = hitbox.getUuid$nova();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        VisualRegion.INSTANCE.hideRegion(player, uUID);
    }

    public final void registerHitbox$nova(@NotNull Hitbox<?, ?> hitbox) {
        Intrinsics.checkNotNullParameter(hitbox, (String)"hitbox");
        Hitbox<?, ?> hitbox2 = hitbox;
        if (hitbox2 instanceof PhysicalHitbox) {
            this.addPhysicalHitbox((PhysicalHitbox)hitbox);
        } else if (hitbox2 instanceof VirtualHitbox) {
            this.addVirtualHitbox((VirtualHitbox)hitbox);
        }
    }

    public final void removeHitbox$nova(@NotNull Hitbox<?, ?> hitbox) {
        Intrinsics.checkNotNullParameter(hitbox, (String)"hitbox");
        Hitbox<?, ?> hitbox2 = hitbox;
        if (hitbox2 instanceof PhysicalHitbox) {
            this.removePhysicalHitbox((PhysicalHitbox)hitbox);
        } else if (hitbox2 instanceof VirtualHitbox) {
            this.removeVirtualHitbox((VirtualHitbox)hitbox);
        }
    }

    private final void addPhysicalHitbox(PhysicalHitbox hitbox) {
        FakeInteraction fakeInteraction = hitbox.createInteractionEntity$nova();
        Map map2 = physicalHitboxes;
        Pair pair = TuplesKt.to((Object)hitbox, (Object)fakeInteraction);
        map2.put(pair.getFirst(), pair.getSecond());
        map2 = physicalHitboxesById;
        pair = TuplesKt.to((Object)fakeInteraction.getEntityId(), (Object)hitbox);
        map2.put(pair.getFirst(), pair.getSecond());
    }

    private final void removePhysicalHitbox(PhysicalHitbox hitbox) {
        FakeInteraction fakeInteraction = physicalHitboxes.remove(hitbox);
        if (fakeInteraction == null) {
            return;
        }
        FakeInteraction fakeInteraction2 = fakeInteraction;
        fakeInteraction2.remove();
        ((Map)physicalHitboxesById).remove(fakeInteraction2.getEntityId());
    }

    /*
     * WARNING - void declaration
     */
    private final void addVirtualHitbox(VirtualHitbox hitbox) {
        for (BlockPos blockPos : hitbox.getBlocks$nova()) {
            Object object;
            void $this$getOrPut$iv;
            ((Collection)virtualHitboxes).add(hitbox);
            Map map2 = virtualHitboxesByBlock;
            BlockPos key$iv = blockPos;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ArrayList answer$iv = new ArrayList(1);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(hitbox);
            Set<Player> set = visualizers;
            Intrinsics.checkNotNullExpressionValue(set, (String)"visualizers");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                INSTANCE.showVirtualHitbox(hitbox, it);
            }
        }
    }

    private final void removeVirtualHitbox(VirtualHitbox hitbox) {
        ((Collection)virtualHitboxes).remove(hitbox);
        Set<Player> set = visualizers;
        Intrinsics.checkNotNullExpressionValue(set, (String)"visualizers");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            INSTANCE.hideVirtualHitbox(hitbox, it);
        }
        for (BlockPos blockPos : hitbox.getBlocks$nova()) {
            ArrayList<VirtualHitbox> hitboxes;
            if (virtualHitboxesByBlock.get(blockPos) == null) continue;
            if (hitboxes.size() > 1) {
                ((Collection)hitboxes).remove(hitbox);
                continue;
            }
            ((Map)virtualHitboxesByBlock).remove(blockPos);
        }
    }

    @PacketHandler
    private final void handleEntityInteractPacket(ServerboundInteractPacketEvent event) {
        PhysicalHitbox physicalHitbox = physicalHitboxesById.get(event.getEntityId());
        if (physicalHitbox == null) {
            return;
        }
        PhysicalHitbox hitbox = physicalHitbox;
        event.setCancelled(true);
        SchedulerUtilsKt.runTask((Function0<Unit>)((Function0)() -> HitboxManager.handleEntityInteractPacket$lambda$0(event, hitbox)));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private final void handleInteract(WrappedPlayerInteractEvent wrappedEvent) {
        if (wrappedEvent.getActionPerformed()) {
            return;
        }
        PlayerInteractEvent event = wrappedEvent.getEvent();
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Action action = event.getAction();
        Intrinsics.checkNotNullExpressionValue((Object)action, (String)"getAction(...)");
        Action action2 = action;
        if (action2 != Action.PHYSICAL) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            Player player2 = player;
            Pair<VirtualHitbox, Vector3f> hitboxResult = this.rayTraceHitboxes(player2, event.getAction().isLeftClick());
            if (hitboxResult != null) {
                List<Object> handlers;
                event.setCancelled(true);
                wrappedEvent.setActionPerformed(true);
                Pair<VirtualHitbox, Vector3f> pair = hitboxResult;
                VirtualHitbox hitbox = (VirtualHitbox)pair.component1();
                Vector3f relHitLoc = (Vector3f)pair.component2();
                Vector3f vector3f = hitbox.getBaseCenter().add((Vector3fc)relHitLoc, new Vector3f());
                Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"add(...)");
                BlockPos clickedBlockPos = BlockPosKt.getPos(LocationUtilsKt.toLocation((Vector3fc)vector3f, player2.getLocation().getWorld()));
                List<Object> list = handlers = action2.isLeftClick() ? hitbox.getLeftClickHandlers() : hitbox.getRightClickHandlers();
                if (ProtectionManager.INSTANCE.canUseBlock(player2, event.getItem(), clickedBlockPos)) {
                    Iterable $this$forEach$iv = handlers;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Function2 it = (Function2)element$iv;
                        boolean bl = false;
                        it.invoke((Object)player2, (Object)relHitLoc);
                    }
                }
            }
        }
    }

    @Nullable
    public final Pair<VirtualHitbox, Vector3f> rayTraceHitboxes(@NotNull Player player, boolean isLeftClick) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Location location = player.getEyeLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getEyeLocation(...)");
        Vec3 origin = LocationUtilsKt.toVec3(location);
        Vector3f originF = origin.toVector3f();
        Vector3f directionF = player.getEyeLocation().getDirection().toVector3f().normalize();
        AttributeInstance attributeInstance = player.getAttribute(Attribute.BLOCK_INTERACTION_RANGE);
        Intrinsics.checkNotNull((Object)attributeInstance);
        float interactionRange = (float)attributeInstance.getValue();
        Vector3f vector3f = new Vector3f((Vector3fc)originF).add((Vector3fc)directionF.mul(interactionRange, new Vector3f()));
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"add(...)");
        Vec3 dest = LocationUtilsKt.toVec3((Vector3fc)vector3f);
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        World world2 = world;
        ServerLevel level = NMSUtilsKt.getServerLevel(world2);
        ClipContext ctx = new ClipContext(origin, dest, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty());
        Ref.ObjectRef hitbox = new Ref.ObjectRef();
        Ref.ObjectRef relHitLoc = new Ref.ObjectRef();
        BlockGetter.traverseBlocks((Vec3)origin, (Vec3)dest, (Object)ctx, (arg_0, arg_1) -> HitboxManager.rayTraceHitboxes$lambda$0(world2, level, ctx, origin, dest, originF, player, isLeftClick, directionF, interactionRange, hitbox, relHitLoc, arg_0, arg_1), HitboxManager::rayTraceHitboxes$lambda$1);
        if (hitbox.element != null && relHitLoc.element != null) {
            return TuplesKt.to((Object)hitbox.element, (Object)relHitLoc.element);
        }
        return null;
    }

    private static final Unit handleEntityInteractPacket$lambda$0(ServerboundInteractPacketEvent $event, PhysicalHitbox $hitbox) {
        block3: {
            ServerboundInteractPacket.Action action;
            Player player;
            block2: {
                player = $event.getPlayer();
                action = $event.getAction();
                if (!Intrinsics.areEqual((Object)action, (Object)ServerboundInteractPacket.ATTACK_ACTION)) break block2;
                Iterable $this$forEach$iv = $hitbox.getLeftClickHandlers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl = false;
                    it.invoke((Object)player);
                }
                break block3;
            }
            if (!(action instanceof ServerboundInteractPacket.InteractionAtLocationAction)) break block3;
            Vector3f location = ((ServerboundInteractPacket.InteractionAtLocationAction)action).location.toVector3f();
            Iterable $this$forEach$iv = $hitbox.getRightClickHandlers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function2 it = (Function2)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)location);
                it.invoke((Object)player, (Object)location);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit rayTraceHitboxes$lambda$0(World $world, ServerLevel $level, ClipContext $ctx, Vec3 $origin, Vec3 $dest, Vector3f $originF, Player $player, boolean $isLeftClick, Vector3f $directionF, float $interactionRange, Ref.ObjectRef $hitbox, Ref.ObjectRef $relHitLoc, ClipContext clipContext, net.minecraft.core.BlockPos pos) {
        boolean done;
        block3: {
            Vector3f vector3f;
            Intrinsics.checkNotNull((Object)pos);
            BlockPos novaPos = NMSUtilsKt.toNovaPos(pos, $world);
            BlockState blockState = $level.getBlockState(pos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            BlockState blockState2 = blockState;
            VoxelShape voxelShape = $ctx.getBlockShape(blockState2, (BlockGetter)$level, pos);
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"getBlockShape(...)");
            VoxelShape blockShape = voxelShape;
            BlockHitResult blockHitResult = $level.clipWithInteractionOverride($origin, $dest, pos, blockShape, blockState2);
            if (blockHitResult != null) {
                BlockHitResult it = blockHitResult;
                boolean bl = false;
                vector3f = it.getType() != HitResult.Type.MISS ? it.getLocation().toVector3f() : null;
            } else {
                vector3f = null;
            }
            Vector3f blockHitLoc = vector3f;
            done = false;
            done = blockHitLoc != null;
            float distance = 0.0f;
            Vector3f vector3f2 = blockHitLoc;
            distance = vector3f2 != null ? vector3f2.distance((Vector3fc)$originF) : Float.MAX_VALUE;
            ArrayList<VirtualHitbox> arrayList = virtualHitboxesByBlock.get(novaPos);
            if (arrayList == null) break block3;
            Iterable $this$forEach$iv = arrayList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                float t;
                List<Object> handlers;
                VirtualHitbox candidate = (VirtualHitbox)element$iv;
                boolean bl = false;
                Function2<Player, Boolean, Boolean> function2 = candidate.getQualifier$nova();
                if (function2 != null ? !((Boolean)function2.invoke((Object)$player, (Object)$isLeftClick)).booleanValue() : false) continue;
                List<Object> list = handlers = $isLeftClick ? candidate.getLeftClickHandlers() : candidate.getRightClickHandlers();
                if (handlers.isEmpty()) continue;
                Vector2f boxHitResult = new Vector2f();
                if (!Intersectionf.intersectRayAab((Vector3fc)((Vector3fc)$originF), (Vector3fc)((Vector3fc)$directionF), (Vector3fc)candidate.getFrom(), (Vector3fc)candidate.getTo(), (Vector2f)boxHitResult) || !((t = boxHitResult.x) < distance) || !(t < $interactionRange)) continue;
                $hitbox.element = candidate;
                distance = t;
                done = true;
                $relHitLoc.element = new Vector3f().add((Vector3fc)$originF).add((Vector3fc)new Vector3f((Vector3fc)$directionF).mul(distance)).sub(((VirtualHitbox)$hitbox.element).getBaseCenter());
            }
        }
        return done ? Unit.INSTANCE : null;
    }

    private static final Unit rayTraceHitboxes$lambda$1(ClipContext it) {
        return Unit.INSTANCE;
    }

    static {
        PacketListenerKt.registerPacketListener(INSTANCE);
        EventUtilsKt.registerEvents(INSTANCE);
    }
}

