/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.resources.lookup.ResourceLookups;
import xyz.xenondevs.nova.serialization.kotlinx.NovaBlockStateSerializer;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.behavior.BlockBehavior;
import xyz.xenondevs.nova.world.block.state.model.BlockModelProvider;
import xyz.xenondevs.nova.world.block.state.property.BlockStateProperty;
import xyz.xenondevs.nova.world.block.state.property.PropertiesTree;
import xyz.xenondevs.nova.world.block.state.property.ScopedBlockStateProperty;

@Serializable(with=NovaBlockStateSerializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 02\u00020\u0001:\u00010B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010%\u001a\u0004\u0018\u0001H&\"\b\b\u0000\u0010&*\u00020\u00012\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0\u0010H\u0086\u0002\u00a2\u0006\u0002\u0010(J#\u0010)\u001a\u0002H&\"\b\b\u0000\u0010&*\u00020\u00012\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0\u0010\u00a2\u0006\u0002\u0010(J+\u0010*\u001a\u00020\u0000\"\b\b\u0000\u0010&*\u00020\u00012\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0\u00102\u0006\u0010\u0016\u001a\u0002H&\u00a2\u0006\u0002\u0010+J\u001e\u0010*\u001a\u00020\u00002\u0016\u0010,\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00010\u0007J\u0012\u0010-\u001a\u00020\u00002\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u0010J\b\u0010.\u001a\u00020/H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001b\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R.\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u00172\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0017@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8PX\u0090\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010!\u001a\u00020\"X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00061"}, d2={"Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "", "block", "Lxyz/xenondevs/nova/world/block/NovaBlock;", "path", "", "scopedValues", "", "Lxyz/xenondevs/nova/world/block/state/property/ScopedBlockStateProperty;", "<init>", "(Lxyz/xenondevs/nova/world/block/NovaBlock;[ILjava/util/Map;)V", "getBlock", "()Lxyz/xenondevs/nova/world/block/NovaBlock;", "getScopedValues$nova", "()Ljava/util/Map;", "values", "Lxyz/xenondevs/nova/world/block/state/property/BlockStateProperty;", "getValues", "properties", "", "getProperties", "()Ljava/util/Set;", "value", "Lxyz/xenondevs/nova/world/block/state/property/PropertiesTree;", "tree", "getTree$nova", "()Lxyz/xenondevs/nova/world/block/state/property/PropertiesTree;", "modelProvider", "Lxyz/xenondevs/nova/world/block/state/model/BlockModelProvider;", "getModelProvider$nova", "()Lxyz/xenondevs/nova/world/block/state/model/BlockModelProvider;", "modelProvider$delegate", "Lkotlin/Lazy;", "ticksRandomly", "", "getTicksRandomly$nova", "()Z", "get", "T", "property", "(Lxyz/xenondevs/nova/world/block/state/property/BlockStateProperty;)Ljava/lang/Object;", "getOrThrow", "with", "(Lxyz/xenondevs/nova/world/block/state/property/BlockStateProperty;Ljava/lang/Object;)Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "propertyValues", "cycle", "toString", "", "Companion", "nova"})
@SourceDebugExtension(value={"SMAP\nNovaBlockState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NovaBlockState.kt\nxyz/xenondevs/nova/world/block/state/NovaBlockState\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n424#2:117\n1252#3,4:118\n1803#3,3:122\n*S KotlinDebug\n*F\n+ 1 NovaBlockState.kt\nxyz/xenondevs/nova/world/block/state/NovaBlockState\n*L\n25#1:117\n25#1:118,4\n38#1:122,3\n*E\n"})
public class NovaBlockState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NovaBlock block;
    @NotNull
    private final int[] path;
    @NotNull
    private final Map<ScopedBlockStateProperty<?>, Object> scopedValues;
    @NotNull
    private final Map<BlockStateProperty<?>, Object> values;
    @Nullable
    private PropertiesTree<NovaBlockState> tree;
    @NotNull
    private final Lazy modelProvider$delegate;
    private final boolean ticksRandomly;

    /*
     * WARNING - void declaration
     */
    public NovaBlockState(@NotNull NovaBlock block, @NotNull int[] path, @NotNull Map<ScopedBlockStateProperty<?>, ? extends Object> scopedValues) {
        void $this$fold$iv;
        void initial$iv;
        void $this$associateByTo$iv$iv;
        void destination$iv22;
        Iterable $this$mapKeysTo$iv;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(scopedValues, (String)"scopedValues");
        this.block = block;
        this.path = path;
        Map<ScopedBlockStateProperty<?>, Object> map2 = this.scopedValues = scopedValues;
        Map map3 = new HashMap();
        NovaBlockState novaBlockState = this;
        boolean $i$f$mapKeysTo = false;
        Iterable iterable = $this$mapKeysTo$iv.entrySet();
        void destination$iv$iv = destination$iv22;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            void var18_25 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            BlockStateProperty blockStateProperty = ((ScopedBlockStateProperty)it.getKey()).getProperty();
            it = var18_25;
            boolean bl2 = false;
            Object v = it$iv.getValue();
            it.put(blockStateProperty, v);
        }
        novaBlockState.values = destination$iv$iv;
        this.modelProvider$delegate = LazyKt.lazy(() -> NovaBlockState.modelProvider_delegate$lambda$0(this));
        $this$mapKeysTo$iv = this.block.getBehaviors();
        boolean destination$iv22 = false;
        novaBlockState = this;
        boolean $i$f$fold = false;
        boolean accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void behavior;
            BlockBehavior blockBehavior = (BlockBehavior)element$iv;
            void acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc != false || behavior.ticksRandomly(this);
        }
        void var18_26 = accumulator$iv;
        novaBlockState.ticksRandomly = var18_26;
    }

    @NotNull
    public final NovaBlock getBlock() {
        return this.block;
    }

    @NotNull
    public final Map<ScopedBlockStateProperty<?>, Object> getScopedValues$nova() {
        return this.scopedValues;
    }

    @NotNull
    public final Map<BlockStateProperty<?>, Object> getValues() {
        return this.values;
    }

    @NotNull
    public final Set<BlockStateProperty<?>> getProperties() {
        return this.values.keySet();
    }

    @Nullable
    public final PropertiesTree<NovaBlockState> getTree$nova() {
        return this.tree;
    }

    @NotNull
    public BlockModelProvider getModelProvider$nova() {
        Lazy lazy = this.modelProvider$delegate;
        return (BlockModelProvider)lazy.getValue();
    }

    public final boolean getTicksRandomly$nova() {
        return this.ticksRandomly;
    }

    @Nullable
    public final <T> T get(@NotNull BlockStateProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return (T)this.values.get(property);
    }

    @NotNull
    public final <T> T getOrThrow(@NotNull BlockStateProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        T t = this.get(property);
        if (t == null) {
            throw new IllegalStateException(this.block + " does not have property " + property);
        }
        return t;
    }

    @NotNull
    public final <T> NovaBlockState with(@NotNull BlockStateProperty<T> property, @NotNull T value) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        PropertiesTree<NovaBlockState> propertiesTree = this.tree;
        if (propertiesTree == null) {
            throw new IllegalStateException("Block state has no properties tree");
        }
        PropertiesTree<NovaBlockState> tree = propertiesTree;
        IndexedValue<ScopedBlockStateProperty<T>> indexedValue = tree.find(property);
        int nodeIdx = indexedValue.component1();
        ScopedBlockStateProperty scopedProperty = (ScopedBlockStateProperty)indexedValue.component2();
        return tree.get(this.path, nodeIdx, scopedProperty.valueToId(value));
    }

    @NotNull
    public final NovaBlockState with(@NotNull Map<BlockStateProperty<?>, ? extends Object> propertyValues) {
        Intrinsics.checkNotNullParameter(propertyValues, (String)"propertyValues");
        if (propertyValues.isEmpty()) {
            return this;
        }
        PropertiesTree<NovaBlockState> propertiesTree = this.tree;
        if (propertiesTree == null) {
            throw new IllegalStateException("Block state has no properties tree");
        }
        PropertiesTree<NovaBlockState> tree = propertiesTree;
        return tree.get(propertyValues);
    }

    @NotNull
    public final NovaBlockState cycle(@NotNull BlockStateProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        PropertiesTree<NovaBlockState> propertiesTree = this.tree;
        if (propertiesTree == null) {
            throw new IllegalStateException("Block state has no properties tree");
        }
        PropertiesTree<NovaBlockState> tree = propertiesTree;
        IndexedValue<ScopedBlockStateProperty<?>> indexedValue = tree.find(property);
        int depth = indexedValue.component1();
        ScopedBlockStateProperty scopedProperty = (ScopedBlockStateProperty)indexedValue.component2();
        int valueId = (this.path[depth] + 1) % scopedProperty.getValues().size();
        return tree.get(this.path, depth, valueId);
    }

    @NotNull
    public String toString() {
        String propertiesStr = CollectionsKt.joinToString$default((Iterable)this.scopedValues.entrySet(), null, null, null, (int)0, null, NovaBlockState::toString$lambda$0, (int)31, null);
        return this.block + "[" + propertiesStr + "]";
    }

    private static final BlockModelProvider modelProvider_delegate$lambda$0(NovaBlockState this$0) {
        BlockModelProvider blockModelProvider = ResourceLookups.INSTANCE.getBLOCK_MODEL().get(this$0);
        Intrinsics.checkNotNull((Object)blockModelProvider);
        return blockModelProvider;
    }

    private static final CharSequence toString$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ScopedBlockStateProperty property = (ScopedBlockStateProperty)entry.getKey();
        Object value = entry.getValue();
        Intrinsics.checkNotNull((Object)property, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.world.block.state.property.ScopedBlockStateProperty<kotlin.Any>");
        String valStr = property.valueToString(value);
        return property + "=" + valStr;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0005H\u0000\u00a2\u0006\u0002\b\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a8\u0006\u000e"}, d2={"Lxyz/xenondevs/nova/world/block/state/NovaBlockState$Companion;", "", "<init>", "()V", "createBlockStates", "", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "block", "Lxyz/xenondevs/nova/world/block/NovaBlock;", "properties", "Lxyz/xenondevs/nova/world/block/state/property/ScopedBlockStateProperty;", "createBlockStates$nova", "serializer", "Lkotlinx/serialization/KSerializer;", "nova"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<NovaBlockState> createBlockStates$nova(@NotNull NovaBlock block, @NotNull List<? extends ScopedBlockStateProperty<?>> properties) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            if (!((Collection)properties).isEmpty()) {
                PropertiesTree tree = new PropertiesTree(properties, (arg_0, arg_1) -> Companion.createBlockStates$lambda$0(block, arg_0, arg_1));
                for (NovaBlockState blockState : tree.getElements()) {
                    blockState.tree = tree;
                }
                return tree.getElements();
            }
            return CollectionsKt.listOf((Object)new NovaBlockState(block, new int[0], MapsKt.emptyMap()));
        }

        @NotNull
        public final KSerializer<NovaBlockState> serializer() {
            return NovaBlockStateSerializer.INSTANCE;
        }

        private static final NovaBlockState createBlockStates$lambda$0(NovaBlock $block, int[] path, Map values) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            return new NovaBlockState($block, path, values);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

