/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.state.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import net.minecraft.world.level.biome.Biome;
import org.bukkit.Fluid;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.behavior.Waterloggable;
import xyz.xenondevs.nova.world.block.migrator.BlockMigrator;
import xyz.xenondevs.nova.world.block.state.model.BlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.BlockUpdateMethod;
import xyz.xenondevs.nova.world.block.state.model.DisplayEntityBlockModelData;
import xyz.xenondevs.nova.world.block.state.model.DisplayEntityBlockModelData$;
import xyz.xenondevs.nova.world.block.state.model.DisplayEntityBlockModelProvider$;
import xyz.xenondevs.nova.world.block.state.property.DefaultBlockStateProperties;
import xyz.xenondevs.nova.world.fakeentity.FakeEntity;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeItemDisplay;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ItemDisplayMetadata;
import xyz.xenondevs.nova.world.item.DefaultBlockOverlays;

@Serializable
@SerialName(value="entity_backed")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 (2\u00020\u0001:\u0002()B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J%\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0002\b'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006*"}, d2={"Lxyz/xenondevs/nova/world/block/state/model/DisplayEntityBlockModelProvider;", "Lxyz/xenondevs/nova/world/block/state/model/BlockModelProvider;", "info", "Lxyz/xenondevs/nova/world/block/state/model/DisplayEntityBlockModelData;", "<init>", "(Lxyz/xenondevs/nova/world/block/state/model/DisplayEntityBlockModelData;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILxyz/xenondevs/nova/world/block/state/model/DisplayEntityBlockModelData;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getInfo", "()Lxyz/xenondevs/nova/world/block/state/model/DisplayEntityBlockModelData;", "set", "", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "method", "Lxyz/xenondevs/nova/world/block/state/model/BlockUpdateMethod;", "placeHitbox", "load", "remove", "unload", "replace", "updateWaterlogEntity", "hasWaterlogEntity", "", "setWaterlogMetadata", "data", "Lxyz/xenondevs/nova/world/fakeentity/metadata/impl/ItemDisplayMetadata;", "setMetadata", "model", "Lxyz/xenondevs/nova/world/block/state/model/DisplayEntityBlockModelData$Model;", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$nova", "Companion", "$serializer", "nova"})
@SourceDebugExtension(value={"SMAP\nDisplayEntityModelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayEntityModelProvider.kt\nxyz/xenondevs/nova/world/block/state/model/DisplayEntityBlockModelProvider\n+ 2 NMSUtils.kt\nxyz/xenondevs/nova/util/NMSUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 NovaBlock.kt\nxyz/xenondevs/nova/world/block/NovaBlock\n*L\n1#1,157:1\n708#2,7:158\n1634#3,3:165\n1869#3,2:168\n1869#3,2:170\n1#4:172\n89#5:173\n*S KotlinDebug\n*F\n+ 1 DisplayEntityModelProvider.kt\nxyz/xenondevs/nova/world/block/state/model/DisplayEntityBlockModelProvider\n*L\n77#1:158,7\n90#1:165,3\n102#1:168,2\n106#1:170,2\n136#1:173\n*E\n"})
public final class DisplayEntityBlockModelProvider
implements BlockModelProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DisplayEntityBlockModelData info;
    @NotNull
    private static final ConcurrentHashMap<BlockPos, List<FakeItemDisplay>> entities = new ConcurrentHashMap();

    public DisplayEntityBlockModelProvider(@NotNull DisplayEntityBlockModelData info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.info = info;
    }

    @NotNull
    public final DisplayEntityBlockModelData getInfo() {
        return this.info;
    }

    @Override
    public void set(@NotNull BlockPos pos, @NotNull BlockUpdateMethod method) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.placeHitbox(pos, method);
        this.load(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void placeHitbox(BlockPos pos, BlockUpdateMethod method) {
        BlockPos pos$iv = pos;
        boolean $i$f$withoutBlockMigration = false;
        BlockMigrator.migrationSuppression.set(((Number)BlockMigrator.migrationSuppression.get()).intValue() + 1);
        try {
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
                case 1: {
                    NMSUtilsKt.setBlockState(pos, this.info.getHitboxType());
                    break;
                }
                case 2: {
                    NMSUtilsKt.setBlockStateNoUpdate(pos, this.info.getHitboxType());
                    break;
                }
                case 3: {
                    NMSUtilsKt.setBlockStateSilently(pos, this.info.getHitboxType());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        finally {
            BlockMigrator.migrationSuppression.set(((Number)BlockMigrator.migrationSuppression.get()).intValue() - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load(@NotNull BlockPos pos) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (((ConcurrentHashMap.KeySetView)entities.keySet()).contains(pos)) {
            throw new IllegalStateException("ItemDisplay already exists at " + pos);
        }
        Iterable iterable = this.info.getModels();
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void model;
            DisplayEntityBlockModelData.Model model2 = (DisplayEntityBlockModelData.Model)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Location location = pos.getLocation().toCenterLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"toCenterLocation(...)");
            collection.add(new FakeItemDisplay(location, false, (arg_0, arg_1) -> DisplayEntityBlockModelProvider.load$lambda$0$0(this, (DisplayEntityBlockModelData.Model)model, arg_0, arg_1), 2, null));
        }
        ArrayList models = (ArrayList)destination$iv;
        if (this.hasWaterlogEntity()) {
            iterable = models;
            Location location = pos.getLocation().toCenterLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"toCenterLocation(...)");
            iterable.add(new FakeItemDisplay(location, false, (arg_0, arg_1) -> DisplayEntityBlockModelProvider.load$lambda$1(this, pos, arg_0, arg_1), 2, null));
        }
        ((Map)entities).put(pos, models);
    }

    @Override
    public void remove(@NotNull BlockPos pos, @NotNull BlockUpdateMethod method) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
            BlockModelProvider.super.remove(pos, method);
            List<FakeItemDisplay> list = entities.remove(pos);
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FakeEntity p0 = (FakeEntity)element$iv;
                boolean bl = false;
                p0.remove();
            }
        }
    }

    @Override
    public void unload(@NotNull BlockPos pos) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            List<FakeItemDisplay> list = entities.remove(pos);
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FakeEntity p0 = (FakeEntity)element$iv;
                boolean bl = false;
                p0.remove();
            }
        }
    }

    @Override
    public void replace(@NotNull BlockPos pos, @NotNull BlockUpdateMethod method) {
        FakeItemDisplay fakeItemDisplay;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.placeHitbox(pos, method);
        List list = entities.get(pos);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List prevEntities = list;
        ArrayList newEntities = new ArrayList();
        int i2 = 0;
        for (DisplayEntityBlockModelData.Model model : this.info.getModels()) {
            FakeItemDisplay fakeItemDisplay2;
            Collection collection = newEntities;
            if ((fakeItemDisplay = (FakeItemDisplay)CollectionsKt.getOrNull((List)prevEntities, (int)i2++)) != null) {
                FakeItemDisplay fakeItemDisplay3;
                FakeItemDisplay prevEntity = fakeItemDisplay3 = fakeItemDisplay;
                boolean bl = false;
                prevEntity.updateEntityData(true, arg_0 -> DisplayEntityBlockModelProvider.replace$lambda$0$0(this, model, arg_0));
                fakeItemDisplay2 = fakeItemDisplay3;
            } else {
                Location location = pos.getLocation().toCenterLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"toCenterLocation(...)");
                fakeItemDisplay2 = new FakeItemDisplay(location, false, (arg_0, arg_1) -> DisplayEntityBlockModelProvider.replace$lambda$1(this, model, arg_0, arg_1), 2, null);
            }
            fakeItemDisplay = fakeItemDisplay2;
            collection.add(fakeItemDisplay);
        }
        if (this.hasWaterlogEntity()) {
            FakeItemDisplay fakeItemDisplay4;
            Collection collection = newEntities;
            FakeItemDisplay fakeItemDisplay5 = (FakeItemDisplay)CollectionsKt.getOrNull((List)prevEntities, (int)i2);
            if (fakeItemDisplay5 != null) {
                FakeItemDisplay prevEntity = fakeItemDisplay = fakeItemDisplay5;
                boolean bl = false;
                prevEntity.updateEntityData(true, arg_0 -> DisplayEntityBlockModelProvider.replace$lambda$2$0(this, pos, arg_0));
                fakeItemDisplay4 = fakeItemDisplay;
            } else {
                Location location = pos.getLocation().toCenterLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"toCenterLocation(...)");
                fakeItemDisplay4 = new FakeItemDisplay(location, false, (arg_0, arg_1) -> DisplayEntityBlockModelProvider.replace$lambda$3(this, pos, arg_0, arg_1), 2, null);
            }
            fakeItemDisplay5 = fakeItemDisplay4;
            collection.add(fakeItemDisplay5);
        }
        ((Map)entities).put(pos, newEntities);
    }

    public final void updateWaterlogEntity(@NotNull BlockPos pos) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            List<FakeItemDisplay> list = entities.get(pos);
            if (list == null || (list = (FakeItemDisplay)CollectionsKt.lastOrNull(list)) == null) break block0;
            ((FakeEntity)((Object)list)).updateEntityData(true, arg_0 -> DisplayEntityBlockModelProvider.updateWaterlogEntity$lambda$0(this, pos, arg_0));
        }
    }

    private final boolean hasWaterlogEntity() {
        NovaBlock this_$iv = this.info.getBlockState().getBlock();
        boolean $i$f$hasBehavior = false;
        return this_$iv.hasBehavior(Reflection.getOrCreateKotlinClass(Waterloggable.class)) && (Boolean)this.info.getBlockState().getOrThrow(DefaultBlockStateProperties.INSTANCE.getWATERLOGGED()) != false;
    }

    private final void setWaterlogMetadata(ItemDisplayMetadata data2, BlockPos pos) {
        data2.setBrightness(null);
        data2.setItemStack(DefaultBlockOverlays.INSTANCE.getWATERLOGGED().createClientsideItemBuilder().setCustomModelData(0, Intrinsics.areEqual((Object)pos.getWorld().getFluidData(pos.getX(), pos.getY() + 1, pos.getZ()).getFluidType(), (Object)Fluid.WATER)).setCustomModelData(0, new Color(((Biome)NMSUtilsKt.getServerLevel(pos.getWorld()).getBiome(pos.getNmsPos()).value()).getWaterColor())).build());
        data2.setTransform((Matrix4fc)new Matrix4f());
    }

    private final void setMetadata(ItemDisplayMetadata data2, DisplayEntityBlockModelData.Model model) {
        if (MaterialUtilsKt.getRequiresLight(this.info.getHitboxType().getBukkitMaterial())) {
            data2.setBrightness(new Display.Brightness(15, 15));
        }
        data2.setItemStack(model.getItemStack());
        data2.setTransform(model.getTransform());
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$nova(DisplayEntityBlockModelProvider self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)DisplayEntityBlockModelData$.serializer.INSTANCE, (Object)self.info);
    }

    public /* synthetic */ DisplayEntityBlockModelProvider(int seen0, DisplayEntityBlockModelData info, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.info = info;
    }

    private static final Unit load$lambda$0$0(DisplayEntityBlockModelProvider this$0, DisplayEntityBlockModelData.Model $model, FakeItemDisplay fakeItemDisplay, ItemDisplayMetadata data2) {
        Intrinsics.checkNotNullParameter((Object)fakeItemDisplay, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this$0.setMetadata(data2, $model);
        return Unit.INSTANCE;
    }

    private static final Unit load$lambda$1(DisplayEntityBlockModelProvider this$0, BlockPos $pos, FakeItemDisplay fakeItemDisplay, ItemDisplayMetadata data2) {
        Intrinsics.checkNotNullParameter((Object)fakeItemDisplay, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this$0.setWaterlogMetadata(data2, $pos);
        return Unit.INSTANCE;
    }

    private static final Unit replace$lambda$0$0(DisplayEntityBlockModelProvider this$0, DisplayEntityBlockModelData.Model $model, ItemDisplayMetadata $this$updateEntityData) {
        Intrinsics.checkNotNullParameter((Object)$this$updateEntityData, (String)"$this$updateEntityData");
        this$0.setMetadata($this$updateEntityData, $model);
        return Unit.INSTANCE;
    }

    private static final Unit replace$lambda$1(DisplayEntityBlockModelProvider this$0, DisplayEntityBlockModelData.Model $model, FakeItemDisplay fakeItemDisplay, ItemDisplayMetadata data2) {
        Intrinsics.checkNotNullParameter((Object)fakeItemDisplay, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this$0.setMetadata(data2, $model);
        return Unit.INSTANCE;
    }

    private static final Unit replace$lambda$2$0(DisplayEntityBlockModelProvider this$0, BlockPos $pos, ItemDisplayMetadata $this$updateEntityData) {
        Intrinsics.checkNotNullParameter((Object)$this$updateEntityData, (String)"$this$updateEntityData");
        this$0.setWaterlogMetadata($this$updateEntityData, $pos);
        return Unit.INSTANCE;
    }

    private static final Unit replace$lambda$3(DisplayEntityBlockModelProvider this$0, BlockPos $pos, FakeItemDisplay fakeItemDisplay, ItemDisplayMetadata data2) {
        Intrinsics.checkNotNullParameter((Object)fakeItemDisplay, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this$0.setWaterlogMetadata(data2, $pos);
        return Unit.INSTANCE;
    }

    private static final Unit updateWaterlogEntity$lambda$0(DisplayEntityBlockModelProvider this$0, BlockPos $pos, ItemDisplayMetadata $this$updateEntityData) {
        Intrinsics.checkNotNullParameter((Object)$this$updateEntityData, (String)"$this$updateEntityData");
        this$0.setWaterlogMetadata($this$updateEntityData, $pos);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lxyz/xenondevs/nova/world/block/state/model/DisplayEntityBlockModelProvider$Companion;", "", "<init>", "()V", "entities", "Ljava/util/concurrent/ConcurrentHashMap;", "Lxyz/xenondevs/nova/world/BlockPos;", "", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeItemDisplay;", "getEntities", "()Ljava/util/concurrent/ConcurrentHashMap;", "serializer", "Lkotlinx/serialization/KSerializer;", "Lxyz/xenondevs/nova/world/block/state/model/DisplayEntityBlockModelProvider;", "nova"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConcurrentHashMap<BlockPos, List<FakeItemDisplay>> getEntities() {
            return entities;
        }

        @NotNull
        public final KSerializer<DisplayEntityBlockModelProvider> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockUpdateMethod.values().length];
            try {
                nArray[BlockUpdateMethod.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockUpdateMethod.NO_UPDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockUpdateMethod.SILENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

