/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.tileentity.network.type.fluid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.commons.provider.Providers;
import xyz.xenondevs.commons.tuple.Tuple2;
import xyz.xenondevs.nova.config.ConfigProviderKt;
import xyz.xenondevs.nova.config.ConfigsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.tileentity.network.Network;
import xyz.xenondevs.nova.world.block.tileentity.network.NetworkData;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkEndPoint;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkNode;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkNodeConnection;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkConnectionType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.FluidBridge;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.channel.FluidNetworkChannel;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.world.block.tileentity.vanilla.VanillaCauldronTileEntity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001*B\u0017\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0007j\b\u0012\u0004\u0012\u00020\u000b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0012\u0010&\u001a\u00020'X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/FluidNetwork;", "Lxyz/xenondevs/nova/world/block/tileentity/network/Network;", "Lxyz/xenondevs/nova/world/block/tileentity/network/NetworkData;", "networkData", "<init>", "(Lxyz/xenondevs/nova/world/block/tileentity/network/NetworkData;)V", "endPoints", "Ljava/util/ArrayList;", "Lxyz/xenondevs/nova/world/block/tileentity/network/node/NetworkEndPoint;", "Lkotlin/collections/ArrayList;", "cauldrons", "Lxyz/xenondevs/nova/world/block/tileentity/vanilla/VanillaCauldronTileEntity;", "channels", "", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/channel/FluidNetworkChannel;", "[Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/channel/FluidNetworkChannel;", "transferRate", "", "complexity", "", "nextChannel", "isValid", "", "tick", "", "postTickSync", "toString", "", "nodes", "", "Lxyz/xenondevs/nova/world/BlockPos;", "Lxyz/xenondevs/nova/world/block/tileentity/network/node/NetworkNodeConnection;", "getNodes", "()Ljava/util/Map;", "type", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/NetworkType;", "getType", "()Lxyz/xenondevs/nova/world/block/tileentity/network/type/NetworkType;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "Companion", "nova"})
@SourceDebugExtension(value={"SMAP\nFluidNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FluidNetwork.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/FluidNetwork\n+ 2 Iterables.kt\nxyz/xenondevs/commons/collections/IterablesKt\n+ 3 Arrays.kt\nxyz/xenondevs/commons/collections/ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ConfigProvider.kt\nxyz/xenondevs/nova/config/ConfigProviderKt\n*L\n1#1,121:1\n82#2,9:122\n6#3,9:131\n1740#4,3:140\n75#5:143\n75#5:144\n75#5:145\n75#5:146\n*S KotlinDebug\n*F\n+ 1 FluidNetwork.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/FluidNetwork\n*L\n41#1:122,9\n46#1:131,9\n72#1:140,3\n101#1:143\n102#1:144\n105#1:145\n106#1:146\n*E\n"})
public final class FluidNetwork
implements Network<FluidNetwork>,
NetworkData<FluidNetwork> {
    @NotNull
    public static final Companion Companion;
    private final /* synthetic */ NetworkData<FluidNetwork> $$delegate_0;
    @NotNull
    private final ArrayList<NetworkEndPoint> endPoints;
    @NotNull
    private final ArrayList<VanillaCauldronTileEntity> cauldrons;
    @NotNull
    private final FluidNetworkChannel[] channels;
    private final long transferRate;
    private final int complexity;
    private int nextChannel;
    @NotNull
    private static final Provider<CommentedConfigurationNode> FLUID_NETWORK;
    @NotNull
    private static final Provider<Integer> TICK_DELAY_PROVIDER;
    @NotNull
    private static final Provider<Long> DEFAULT_TRANSFER_RATE$delegate;
    @NotNull
    private static final Provider<Integer> CHANNEL_AMOUNT$delegate;
    @NotNull
    private static final Provider<Integer> MAX_COMPLEXITY$delegate;

    /*
     * WARNING - void declaration
     */
    public FluidNetwork(@NotNull NetworkData<FluidNetwork> networkData) {
        Intrinsics.checkNotNullParameter(networkData, (String)"networkData");
        this.$$delegate_0 = networkData;
        this.endPoints = new ArrayList();
        this.cauldrons = new ArrayList();
        this.channels = new FluidNetworkChannel[Companion.getCHANNEL_AMOUNT()];
        long transferRate = Companion.getDEFAULT_TRANSFER_RATE();
        int complexity = 0;
        for (Map.Entry<BlockPos, NetworkNodeConnection> entry : networkData.getNodes().entrySet()) {
            BlockPos pos = entry.getKey();
            NetworkNodeConnection con = entry.getValue();
            NetworkNode node2 = con.component1();
            Set<BlockFace> faces = con.component2();
            try {
                if (node2 instanceof NetworkEndPoint) {
                    FluidHolder fluidHolder2;
                    Object v0;
                    block10: {
                        Iterable $this$firstInstanceOfOrNull$iv = ((NetworkEndPoint)node2).getHolders();
                        boolean $i$f$firstInstanceOfOrNull = false;
                        for (Object element$iv : $this$firstInstanceOfOrNull$iv) {
                            if (!(element$iv instanceof FluidHolder)) continue;
                            v0 = element$iv;
                            break block10;
                        }
                        v0 = null;
                    }
                    if ((FluidHolder)v0 == null) continue;
                    for (Map.Entry<BlockFace, Integer> entry2 : fluidHolder2.getChannels().entrySet()) {
                        FluidNetworkChannel fluidNetworkChannel;
                        void $this$getOrSet$iv;
                        BlockFace face = entry2.getKey();
                        int channelId = ((Number)entry2.getValue()).intValue();
                        if (!faces.contains(face)) continue;
                        FluidNetworkChannel[] fluidNetworkChannelArray = this.channels;
                        int index$iv = channelId;
                        boolean $i$f$getOrSet = false;
                        FluidNetworkChannel value$iv = $this$getOrSet$iv[index$iv];
                        if (value$iv == null) {
                            boolean bl = false;
                            $this$getOrSet$iv[index$iv] = value$iv = new FluidNetworkChannel();
                            fluidNetworkChannel = value$iv;
                        } else {
                            fluidNetworkChannel = value$iv;
                        }
                        void channel = fluidNetworkChannel;
                        channel.addHolder(fluidHolder2, face);
                    }
                    if (node2 instanceof VanillaCauldronTileEntity) {
                        ((Collection)this.cauldrons).add(node2);
                    }
                    ((Collection)this.endPoints).add(node2);
                    ++complexity;
                    continue;
                }
                if (!(node2 instanceof FluidBridge)) continue;
                transferRate = Math.min(transferRate, ((FluidBridge)node2).getFluidTransferRate());
            }
            catch (Exception e) {
                throw new Exception("Failed to add to fluid network: " + pos + " " + con, e);
            }
        }
        this.transferRate = transferRate;
        this.complexity = complexity;
        FluidNetworkChannel[] fluidNetworkChannelArray = this.channels;
        int n = fluidNetworkChannelArray.length;
        for (int j = 0; j < n; ++j) {
            FluidNetworkChannel channel;
            FluidNetworkChannel fluidNetworkChannel = channel = fluidNetworkChannelArray[j];
            if (fluidNetworkChannel == null) continue;
            fluidNetworkChannel.createDistributor();
        }
    }

    @Override
    public boolean isValid() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.endPoints;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    NetworkEndPoint it = (NetworkEndPoint)element$iv;
                    boolean bl2 = false;
                    if (it.isValid()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final void tick() {
        if (Companion.getMAX_COMPLEXITY() != -1 && this.complexity > Companion.getMAX_COMPLEXITY()) {
            return;
        }
        int startingChannel = this.nextChannel;
        long amountLeft = this.transferRate;
        do {
            FluidNetworkChannel fluidNetworkChannel = this.channels[this.nextChannel];
            amountLeft = fluidNetworkChannel != null ? fluidNetworkChannel.distributeFluids(amountLeft) : amountLeft;
            int n = this.nextChannel;
            this.nextChannel = n + 1;
            if (this.nextChannel < this.channels.length) continue;
            this.nextChannel = 0;
        } while (amountLeft != 0L && this.nextChannel != startingChannel);
    }

    public final void postTickSync() {
        Iterator<VanillaCauldronTileEntity> iterator = this.cauldrons.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<VanillaCauldronTileEntity> iterator2 = iterator;
        while (iterator2.hasNext()) {
            VanillaCauldronTileEntity cauldron;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            cauldron.postNetworkTickSync();
        }
    }

    @NotNull
    public String toString() {
        return "FluidNetwork(nodes=" + this.getNodes() + ")";
    }

    @Override
    @NotNull
    public NetworkType<FluidNetwork> getType() {
        return this.$$delegate_0.getType();
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.$$delegate_0.getUuid();
    }

    @Override
    @NotNull
    public Map<BlockPos, NetworkNodeConnection> getNodes() {
        return this.$$delegate_0.getNodes();
    }

    private static final long DEFAULT_TRANSFER_RATE_delegate$lambda$0(Tuple2 tuple2) {
        Intrinsics.checkNotNullParameter((Object)tuple2, (String)"<destruct>");
        double defaultTransferRate = ((Number)tuple2.component1()).doubleValue();
        int tickDelay = ((Number)tuple2.component2()).intValue();
        return MathKt.roundToLong((double)(defaultTransferRate * (double)tickDelay));
    }

    private static final long DEFAULT_TRANSFER_RATE_delegate$lambda$1(long defaultTransferRate) {
        return defaultTransferRate < 0L ? Long.MAX_VALUE : defaultTransferRate;
    }

    static {
        String[] path$iv;
        Provider<CommentedConfigurationNode> $this$entry$iv;
        Companion = new Companion(null);
        String[] stringArray = new String[]{"network", "fluid"};
        stringArray = FLUID_NETWORK = ConfigProviderKt.weakNodeTyped(ConfigsKt.getMAIN_CONFIG(), stringArray);
        String[] stringArray2 = new String[]{"tick_delay"};
        boolean $i$f$entry = false;
        TICK_DELAY_PROVIDER = ConfigProviderKt.entry((Provider<? extends ConfigurationNode>)$this$entry$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(Integer.TYPE)), (String[])Arrays.copyOf(path$iv, path$iv.length));
        $this$entry$iv = FLUID_NETWORK;
        path$iv = new String[]{"default_transfer_rate"};
        $i$f$entry = false;
        DEFAULT_TRANSFER_RATE$delegate = Providers.combinedProvider(ConfigProviderKt.entry($this$entry$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(Double.TYPE)), Arrays.copyOf(path$iv, path$iv.length)), TICK_DELAY_PROVIDER).map(FluidNetwork::DEFAULT_TRANSFER_RATE_delegate$lambda$0).map(FluidNetwork::DEFAULT_TRANSFER_RATE_delegate$lambda$1);
        $this$entry$iv = FLUID_NETWORK;
        path$iv = new String[]{"channel_amount"};
        $i$f$entry = false;
        CHANNEL_AMOUNT$delegate = ConfigProviderKt.entry($this$entry$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(Integer.TYPE)), Arrays.copyOf(path$iv, path$iv.length));
        $this$entry$iv = FLUID_NETWORK;
        path$iv = new String[]{"max_complexity"};
        $i$f$entry = false;
        MAX_COMPLEXITY$delegate = ConfigProviderKt.entry($this$entry$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(Integer.TYPE)), Arrays.copyOf(path$iv, path$iv.length));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006!"}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/FluidNetwork$Companion;", "", "<init>", "()V", "FLUID_NETWORK", "Lxyz/xenondevs/commons/provider/Provider;", "Lorg/spongepowered/configurate/CommentedConfigurationNode;", "kotlin.jvm.PlatformType", "TICK_DELAY_PROVIDER", "", "getTICK_DELAY_PROVIDER", "()Lxyz/xenondevs/commons/provider/Provider;", "DEFAULT_TRANSFER_RATE", "", "getDEFAULT_TRANSFER_RATE", "()J", "DEFAULT_TRANSFER_RATE$delegate", "Lxyz/xenondevs/commons/provider/Provider;", "CHANNEL_AMOUNT", "getCHANNEL_AMOUNT", "()I", "CHANNEL_AMOUNT$delegate", "MAX_COMPLEXITY", "getMAX_COMPLEXITY", "MAX_COMPLEXITY$delegate", "validateLocal", "", "from", "Lxyz/xenondevs/nova/world/block/tileentity/network/node/NetworkEndPoint;", "to", "face", "Lorg/bukkit/block/BlockFace;", "validateLocal$nova", "nova"})
    @SourceDebugExtension(value={"SMAP\nFluidNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FluidNetwork.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/FluidNetwork$Companion\n+ 2 Iterables.kt\nxyz/xenondevs/commons/collections/IterablesKt\n*L\n1#1,121:1\n82#2,9:122\n82#2,9:131\n*S KotlinDebug\n*F\n+ 1 FluidNetwork.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/FluidNetwork$Companion\n*L\n109#1:122,9\n110#1:131,9\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Provider<Integer> getTICK_DELAY_PROVIDER() {
            return TICK_DELAY_PROVIDER;
        }

        public final long getDEFAULT_TRANSFER_RATE() {
            return ((Number)DEFAULT_TRANSFER_RATE$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
        }

        public final int getCHANNEL_AMOUNT() {
            return ((Number)CHANNEL_AMOUNT$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
        }

        public final int getMAX_COMPLEXITY() {
            return ((Number)MAX_COMPLEXITY$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
        }

        public final boolean validateLocal$nova(@NotNull NetworkEndPoint from, @NotNull NetworkEndPoint to, @NotNull BlockFace face) {
            NetworkConnectionType conTo;
            Object v2;
            FluidHolder itemHolderFrom;
            block5: {
                Object v0;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)from, (String)"from");
                    Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                    Intrinsics.checkNotNullParameter((Object)face, (String)"face");
                    Iterable $this$firstInstanceOfOrNull$iv = from.getHolders();
                    boolean $i$f$firstInstanceOfOrNull = false;
                    for (Object element$iv : $this$firstInstanceOfOrNull$iv) {
                        if (!(element$iv instanceof FluidHolder)) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                FluidHolder fluidHolder2 = v0;
                if (fluidHolder2 == null) {
                    return false;
                }
                itemHolderFrom = fluidHolder2;
                Iterable $this$firstInstanceOfOrNull$iv = to.getHolders();
                boolean $i$f$firstInstanceOfOrNull = false;
                for (Object element$iv : $this$firstInstanceOfOrNull$iv) {
                    if (!(element$iv instanceof FluidHolder)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            FluidHolder fluidHolder3 = v2;
            if (fluidHolder3 == null) {
                return false;
            }
            FluidHolder itemHolderTo = fluidHolder3;
            NetworkConnectionType conFrom = itemHolderFrom.getConnectionConfig().get(face);
            return conFrom != (conTo = itemHolderTo.getConnectionConfig().get(face.getOppositeFace())) || conFrom == NetworkConnectionType.BUFFER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "DEFAULT_TRANSFER_RATE", "getDEFAULT_TRANSFER_RATE()J", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "CHANNEL_AMOUNT", "getCHANNEL_AMOUNT()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "MAX_COMPLEXITY", "getMAX_COMPLEXITY()I", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

