/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.format;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.cbf.io.ByteReader;
import xyz.xenondevs.nova.world.ChunkPos;
import xyz.xenondevs.nova.world.format.AsyncFileAccess;
import xyz.xenondevs.nova.world.format.RegionFileStorage;
import xyz.xenondevs.nova.world.format.RegionizedFile;
import xyz.xenondevs.nova.world.format.RegionizedFileReader;
import xyz.xenondevs.nova.world.format.chunk.RegionizedChunk;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B;\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010\u0015\u001a\u00028\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u001bJ,\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\u0004\b\u0002\u0010\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0\u001e0!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013J(\u0010%\u001a\u00020&2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020#0(H\u0086@\u00a2\u0006\u0002\u0010)J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eH\u0086@\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0013H\u0002J\u0018\u00100\u001a\u0002012\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lxyz/xenondevs/nova/world/format/RegionFileStorage;", "C", "Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunk;", "F", "Lxyz/xenondevs/nova/world/format/RegionizedFile;", "", "world", "Lorg/bukkit/World;", "folder", "", "fileExt", "fileAccess", "Lxyz/xenondevs/nova/world/format/AsyncFileAccess;", "reader", "Lxyz/xenondevs/nova/world/format/RegionizedFileReader;", "<init>", "(Lorg/bukkit/World;Ljava/lang/String;Ljava/lang/String;Lxyz/xenondevs/nova/world/format/AsyncFileAccess;Lxyz/xenondevs/nova/world/format/RegionizedFileReader;)V", "regionFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlinx/coroutines/Deferred;", "getOrLoadRegionizedFile", "pos", "Lxyz/xenondevs/nova/world/ChunkPos;", "(Lxyz/xenondevs/nova/world/ChunkPos;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOrLoadRegionizedChunk", "getRegionizedChunkOrThrow", "(Lxyz/xenondevs/nova/world/ChunkPos;)Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunk;", "getRegionizedChunkOrNull", "collectFromChunks", "", "T", "collector", "Lkotlin/Function1;", "isLoaded", "", "regionId", "saveAndUnload", "", "unloadCondition", "Lkotlin/Function2;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitRegionizedFiles", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRegionId", "regionX", "", "regionZ", "getRegionFile", "Ljava/nio/file/Path;", "id", "nova"})
public final class RegionFileStorage<C extends RegionizedChunk, F extends RegionizedFile<C>> {
    @NotNull
    private final World world;
    @NotNull
    private final String folder;
    @NotNull
    private final String fileExt;
    @NotNull
    private final AsyncFileAccess fileAccess;
    @NotNull
    private final RegionizedFileReader<C, F> reader;
    @NotNull
    private final ConcurrentHashMap<Long, Deferred<F>> regionFiles;

    public RegionFileStorage(@NotNull World world, @NotNull String folder, @NotNull String fileExt, @NotNull AsyncFileAccess fileAccess, @NotNull RegionizedFileReader<C, F> reader) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)fileExt, (String)"fileExt");
        Intrinsics.checkNotNullParameter((Object)fileAccess, (String)"fileAccess");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        this.world = world;
        this.folder = folder;
        this.fileExt = fileExt;
        this.fileAccess = fileAccess;
        this.reader = reader;
        this.regionFiles = new ConcurrentHashMap();
        File file = this.world.getWorldFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getWorldFolder(...)");
        FilesKt.resolve((File)file, (String)this.folder).mkdirs();
    }

    @Nullable
    public final Object getOrLoadRegionizedFile(@NotNull ChunkPos pos, @NotNull Continuation<? super F> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super F>, Object>(pos, this, null){
            int I$0;
            int I$1;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ChunkPos $pos;
            final /* synthetic */ RegionFileStorage<C, F> this$0;
            {
                this.$pos = $pos;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$coroutineScope;
                        ResultKt.throwOnFailure((Object)$result);
                        int regionX = this.$pos.getX() >> 5;
                        int regionZ = this.$pos.getZ() >> 5;
                        long regionId = RegionFileStorage.access$getRegionId(this.this$0, regionX, regionZ);
                        this.L$0 = $this$coroutineScope;
                        this.I$0 = regionX;
                        this.I$1 = regionZ;
                        this.J$0 = regionId;
                        this.label = 1;
                        Object object2 = RegionFileStorage.access$getRegionFiles$p(this.this$0).computeIfAbsent(Boxing.boxLong((long)regionId), arg_0 -> getOrLoadRegionizedFile.2.invokeSuspend$lambda$1(arg_0 -> getOrLoadRegionizedFile.2.invokeSuspend$lambda$0((CoroutineScope)$this$coroutineScope, this.this$0, regionX, regionZ, arg_0), arg_0)).await((Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        long regionId = this.J$0;
                        int regionZ = this.I$1;
                        int regionX = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super F> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Deferred invokeSuspend$lambda$0(CoroutineScope $$this$coroutineScope, RegionFileStorage this$0, int $regionX, int $regionZ, Long it) {
                return BuildersKt.async$default((CoroutineScope)$$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super F>, Object>(this$0, $regionX, $regionZ, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ RegionFileStorage<C, F> this$0;
                    final /* synthetic */ int $regionX;
                    final /* synthetic */ int $regionZ;
                    {
                        this.this$0 = $receiver;
                        this.$regionX = $regionX;
                        this.$regionZ = $regionZ;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                file = RegionFileStorage.access$getRegionFile(this.this$0, this.$regionX, this.$regionZ);
                                this.L$0 = file;
                                this.label = 1;
                                v0 = RegionFileStorage.access$getFileAccess$p(this.this$0).read(file, (Continuation<? super byte[]>)((Continuation)this));
                                ** if (v0 != var9_2) goto lbl13
lbl12:
                                // 1 sources

                                return var9_2;
lbl13:
                                // 1 sources

                                ** GOTO lbl20
                            }
                            case 1: {
                                file = (Path)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl20:
                                    // 2 sources

                                    v1 = (byte[])v0;
                                    if (v1 != null) {
                                        var5_4 = v1;
                                        var6_5 = ByteReader.Companion;
                                        p0 = var5_4;
                                        $i$a$-let-RegionFileStorage$getOrLoadRegionizedFile$2$1$1$byteReader$1 = false;
                                        v2 = var6_5.fromByteArray(p0);
                                    } else {
                                        v2 = null;
                                    }
                                    byteReader = v2;
                                    var3_8 = RegionFileStorage.access$getReader$p(this.this$0).read(byteReader, RegionFileStorage.access$getWorld$p(this.this$0), this.$regionX, this.$regionZ);
                                }
                                catch (Exception e) {
                                    throw new Exception("Failed to read region file " + file, e);
                                }
                                return var3_8;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super F> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            private static final Deferred invokeSuspend$lambda$1(Function1 $tmp0, Object p0) {
                return (Deferred)$tmp0.invoke(p0);
            }
        }, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getOrLoadRegionizedChunk(@NotNull ChunkPos pos, @NotNull Continuation<? super C> $completion) {
        if (!($completion instanceof getOrLoadRegionizedChunk.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RegionFileStorage<C, F> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getOrLoadRegionizedChunk(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = pos;
                $continuation.label = 1;
                v0 = this.getOrLoadRegionizedFile(pos, (Continuation<? super F>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                pos = (ChunkPos)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return ((RegionizedFile)v0).getChunk(pos);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final C getRegionizedChunkOrThrow(@NotNull ChunkPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Object object = this.regionFiles.get(this.getRegionId(pos));
        if (object == null || (object = (RegionizedFile)object.getCompleted()) == null || (object = object.getChunk(pos)) == null) {
            throw new IllegalStateException("Regionized chunk at " + pos + " is not loaded");
        }
        return (C)object;
    }

    @Nullable
    public final C getRegionizedChunkOrNull(@NotNull ChunkPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Deferred<F> deferred = this.regionFiles.get(this.getRegionId(pos));
        if (deferred == null || !deferred.isCompleted()) {
            return null;
        }
        return (C)((RegionizedFile)deferred.getCompleted()).getChunk(pos);
    }

    @NotNull
    public final <T> List<T> collectFromChunks(@NotNull Function1<? super C, ? extends List<? extends T>> collector) {
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        ArrayList list = new ArrayList();
        Iterator<Deferred<F>> iterator = this.regionFiles.values().iterator();
        while (iterator.hasNext()) {
            Deferred<F> regionFile;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            if (!regionFile.isCompleted()) continue;
            for (RegionizedChunk chunk : ((RegionizedFile)regionFile.getCompleted()).getChunks()) {
                CollectionsKt.addAll((Collection)list, (Iterable)((Iterable)collector.invoke((Object)chunk)));
            }
        }
        return list;
    }

    public final boolean isLoaded(long regionId) {
        return this.regionFiles.containsKey(regionId);
    }

    @Nullable
    public final Object saveAndUnload(@NotNull Function2<? super Long, ? super F, Boolean> unloadCondition, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, unloadCondition, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RegionFileStorage<C, F> this$0;
            final /* synthetic */ Function2<Long, F, Boolean> $unloadCondition;
            {
                this.this$0 = $receiver;
                this.$unloadCondition = $unloadCondition;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        for (Map.Entry<K, V> entry : ((Map)RegionFileStorage.access$getRegionFiles$p(this.this$0)).entrySet()) {
                            void $this$coroutineScope;
                            long rid = ((Number)entry.getKey()).longValue();
                            Deferred deferredRegionFile = (Deferred)entry.getValue();
                            BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(deferredRegionFile, this.this$0, rid, this.$unloadCondition, null){
                                Object L$0;
                                Object L$1;
                                int label;
                                final /* synthetic */ Deferred<F> $deferredRegionFile;
                                final /* synthetic */ RegionFileStorage<C, F> this$0;
                                final /* synthetic */ long $rid;
                                final /* synthetic */ Function2<Long, F, Boolean> $unloadCondition;
                                {
                                    this.$deferredRegionFile = $deferredRegionFile;
                                    this.this$0 = $receiver;
                                    this.$rid = $rid;
                                    this.$unloadCondition = $unloadCondition;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            v0 = this.$deferredRegionFile.await((Continuation)this);
                                            if (v0 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            regionFile = (RegionizedFile)v0;
                                            bin = regionFile.save();
                                            this.L$0 = regionFile;
                                            this.L$1 = bin;
                                            this.label = 2;
                                            v1 = RegionFileStorage.access$getFileAccess$p(this.this$0).write(RegionFileStorage.access$getRegionFile(this.this$0, this.$rid), bin, (Continuation<? super Unit>)((Continuation)this));
                                            if (v1 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl27
                                        }
                                        case 2: {
                                            bin = (byte[])this.L$1;
                                            regionFile = (RegionizedFile)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl27:
                                            // 2 sources

                                            if (((Boolean)this.$unloadCondition.invoke((Object)Boxing.boxLong((long)this.$rid), (Object)regionFile)).booleanValue()) {
                                                ((Map)RegionFileStorage.access$getRegionFiles$p(this.this$0)).remove(Boxing.boxLong((long)this.$rid));
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object awaitRegionizedFiles(@NotNull Continuation<? super List<? extends F>> $completion) {
        Collection<Deferred<F>> collection = this.regionFiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return AwaitKt.awaitAll(collection, $completion);
    }

    private final long getRegionId(ChunkPos pos) {
        return this.getRegionId(pos.getX() >> 5, pos.getZ() >> 5);
    }

    private final long getRegionId(int regionX, int regionZ) {
        return (long)regionX << 32 | (long)regionZ & 0xFFFFFFFFL;
    }

    private final Path getRegionFile(long id) {
        long regionX = id >> 32;
        long regionZ = id & 0xFFFFFFFFL;
        return this.getRegionFile((int)regionX, (int)regionZ);
    }

    private final Path getRegionFile(int regionX, int regionZ) {
        Path path = this.world.getWorldFolder().toPath().resolve(this.folder + "/r." + regionX + "." + regionZ + "." + this.fileExt);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public static final /* synthetic */ long access$getRegionId(RegionFileStorage $this, int regionX, int regionZ) {
        return $this.getRegionId(regionX, regionZ);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getRegionFiles$p(RegionFileStorage $this) {
        return $this.regionFiles;
    }

    public static final /* synthetic */ Path access$getRegionFile(RegionFileStorage $this, int regionX, int regionZ) {
        return $this.getRegionFile(regionX, regionZ);
    }

    public static final /* synthetic */ AsyncFileAccess access$getFileAccess$p(RegionFileStorage $this) {
        return $this.fileAccess;
    }

    public static final /* synthetic */ RegionizedFileReader access$getReader$p(RegionFileStorage $this) {
        return $this.reader;
    }

    public static final /* synthetic */ World access$getWorld$p(RegionFileStorage $this) {
        return $this.world;
    }

    public static final /* synthetic */ Path access$getRegionFile(RegionFileStorage $this, long id) {
        return $this.getRegionFile(id);
    }
}

