/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.format;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.io.ByteWriter;
import xyz.xenondevs.cbf.io.ByteWriterKt;
import xyz.xenondevs.nova.util.CompressionType;
import xyz.xenondevs.nova.world.ChunkPos;
import xyz.xenondevs.nova.world.format.RegionizedFileKt;
import xyz.xenondevs.nova.world.format.chunk.RegionizedChunk;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lxyz/xenondevs/nova/world/format/RegionizedFile;", "T", "Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunk;", "", "magic", "", "fileVersion", "", "_chunks", "", "<init>", "(IB[Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunk;)V", "[Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunk;", "chunks", "", "getChunks", "()Ljava/util/List;", "getChunk", "pos", "Lxyz/xenondevs/nova/world/ChunkPos;", "(Lxyz/xenondevs/nova/world/ChunkPos;)Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunk;", "save", "", "nova"})
public abstract class RegionizedFile<T extends RegionizedChunk> {
    private final int magic;
    private final byte fileVersion;
    @NotNull
    private final T[] _chunks;

    public RegionizedFile(int magic, byte fileVersion, @NotNull T[] _chunks) {
        Intrinsics.checkNotNullParameter(_chunks, (String)"_chunks");
        this.magic = magic;
        this.fileVersion = fileVersion;
        this._chunks = _chunks;
    }

    @NotNull
    public final List<T> getChunks() {
        return ArraysKt.asList((Object[])this._chunks);
    }

    @NotNull
    public final T getChunk(@NotNull ChunkPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int dx = pos.getX() & 0x1F;
        int dz = pos.getZ() & 0x1F;
        int packedCoords = dx << 5 | dz;
        return this._chunks[packedCoords];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] save() {
        CompressionType compressionType = RegionizedFileKt.access$getCOMPRESSION_TYPE();
        BitSet chunkBitmask = new BitSet(1024);
        ByteArrayOutputStream chunksBuffer = new ByteArrayOutputStream();
        Closeable closeable = (Closeable)compressionType.getWrapOutput().invoke((Object)chunksBuffer);
        Throwable throwable = null;
        try {
            OutputStream compOut = (OutputStream)closeable;
            boolean bl = false;
            ByteWriter chunksWriter = ByteWriter.Companion.fromStream(compOut);
            T[] TArray = this._chunks;
            int n = TArray.length;
            for (int j = 0; j < n; ++j) {
                int chunkIdx = j;
                T chunk = TArray[j];
                chunkBitmask.set(chunkIdx, chunk.write(chunksWriter));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] bin = ByteWriterKt.byteWriter(arg_0 -> RegionizedFile.save$lambda$1(this, compressionType, chunkBitmask, chunksBuffer, arg_0));
        return bin;
    }

    private static final Unit save$lambda$1(RegionizedFile this$0, CompressionType $compressionType, BitSet $chunkBitmask, ByteArrayOutputStream $chunksBuffer, ByteWriter $this$byteWriter) {
        Intrinsics.checkNotNullParameter((Object)$this$byteWriter, (String)"$this$byteWriter");
        $this$byteWriter.writeInt(this$0.magic);
        $this$byteWriter.writeByte(this$0.fileVersion);
        $this$byteWriter.writeByte((byte)$compressionType.ordinal());
        byte[] byArray = $chunkBitmask.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] byArray2 = byArray;
        int n = 128;
        byte[] byArray3 = Arrays.copyOf(byArray2, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
        $this$byteWriter.writeBytes(byArray3);
        byte[] byArray4 = $chunksBuffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"toByteArray(...)");
        $this$byteWriter.writeBytes(byArray4);
        return Unit.INSTANCE;
    }
}

