/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.format;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.io.Closeable;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.cbf.io.ByteReader;
import xyz.xenondevs.nova.util.CompressionType;
import xyz.xenondevs.nova.world.ChunkPos;
import xyz.xenondevs.nova.world.format.RegionizedFile;
import xyz.xenondevs.nova.world.format.chunk.RegionizedChunk;
import xyz.xenondevs.nova.world.format.chunk.RegionizedChunkReader;
import xyz.xenondevs.nova.world.format.legacy.LegacyRegionizedFileReader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000  *\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005:\u0001 B\u00af\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012*\u0010\n\u001a&\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u000b\u0012\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0004\u0012\u00028\u00010\f\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\u0012B\u0010\u0011\u001a\"\u0012\u001e\b\u0001\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00130\u00120\r\"\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00130\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u0017\u001a\u00028\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001eJ-\u0010\u001f\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0004\u0012\u00028\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00130\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lxyz/xenondevs/nova/world/format/RegionizedFileReader;", "C", "Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunk;", "F", "Lxyz/xenondevs/nova/world/format/RegionizedFile;", "", "magic", "", "version", "", "createArray", "Lkotlin/Function2;", "Lkotlin/Function1;", "", "createFile", "chunkReader", "Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunkReader;", "legacyReaders", "Lkotlin/Pair;", "Lxyz/xenondevs/nova/world/format/legacy/LegacyRegionizedFileReader;", "<init>", "(IBLkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunkReader;[Lkotlin/Pair;)V", "Lit/unimi/dsi/fastutil/bytes/Byte2ObjectMap;", "read", "reader", "Lxyz/xenondevs/cbf/io/ByteReader;", "world", "Lorg/bukkit/World;", "regionX", "regionZ", "(Lxyz/xenondevs/cbf/io/ByteReader;Lorg/bukkit/World;II)Lxyz/xenondevs/nova/world/format/RegionizedFile;", "readLatest", "Companion", "nova"})
@SourceDebugExtension(value={"SMAP\nRegionizedFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegionizedFile.kt\nxyz/xenondevs/nova/world/format/RegionizedFileReader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,129:1\n9584#2,4:130\n*S KotlinDebug\n*F\n+ 1 RegionizedFile.kt\nxyz/xenondevs/nova/world/format/RegionizedFileReader\n*L\n77#1:130,4\n*E\n"})
public abstract class RegionizedFileReader<C extends RegionizedChunk, F extends RegionizedFile<C>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int magic;
    private final byte version;
    @NotNull
    private final Function2<Integer, Function1<? super Integer, ? extends C>, C[]> createArray;
    @NotNull
    private final Function1<C[], F> createFile;
    @NotNull
    private final RegionizedChunkReader<C> chunkReader;
    @NotNull
    private final Byte2ObjectMap<LegacyRegionizedFileReader<C, F>> legacyReaders;

    /*
     * WARNING - void declaration
     */
    public RegionizedFileReader(int magic, byte version, @NotNull Function2<? super Integer, ? super Function1<? super Integer, ? extends C>, C[]> createArray, @NotNull Function1<? super C[], ? extends F> createFile, @NotNull RegionizedChunkReader<C> chunkReader, Pair<Integer, ? extends LegacyRegionizedFileReader<C, F>> ... legacyReaders) {
        void destination$iv;
        void $this$associateTo$iv;
        Intrinsics.checkNotNullParameter(createArray, (String)"createArray");
        Intrinsics.checkNotNullParameter(createFile, (String)"createFile");
        Intrinsics.checkNotNullParameter(chunkReader, (String)"chunkReader");
        Intrinsics.checkNotNullParameter(legacyReaders, (String)"legacyReaders");
        this.magic = magic;
        this.version = version;
        this.createArray = createArray;
        this.createFile = createFile;
        this.chunkReader = chunkReader;
        Pair<Integer, ? extends LegacyRegionizedFileReader<C, F>>[] pairArray = legacyReaders;
        Map map2 = (Map)new Byte2ObjectOpenHashMap();
        RegionizedFileReader regionizedFileReader = this;
        boolean $i$f$associateTo = false;
        for (void element$iv : $this$associateTo$iv) {
            void var13_14 = destination$iv;
            Pair pair = element$iv;
            boolean bl = false;
            int version2 = ((Number)pair.component1()).intValue();
            LegacyRegionizedFileReader reader = (LegacyRegionizedFileReader)pair.component2();
            pair = TuplesKt.to((Object)((byte)version2), (Object)reader);
            var13_14.put(pair.getFirst(), pair.getSecond());
        }
        regionizedFileReader.legacyReaders = (Byte2ObjectMap)destination$iv;
    }

    @NotNull
    public final F read(@Nullable ByteReader reader, @NotNull World world, int regionX, int regionZ) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (reader != null) {
            int fileMagic = reader.readInt();
            if (fileMagic != this.magic && fileMagic != -1209920713) {
                throw new IllegalStateException("Not a valid region file");
            }
            byte fileVersion = reader.readByte();
            if (fileVersion == this.version) {
                return this.readLatest(reader, world, regionX, regionZ);
            }
            LegacyRegionizedFileReader legacyRegionizedFileReader = (LegacyRegionizedFileReader)this.legacyReaders.get(fileVersion);
            if (legacyRegionizedFileReader == null) {
                throw new IllegalStateException("Unsupported region file version " + fileVersion);
            }
            LegacyRegionizedFileReader legacyReader = legacyRegionizedFileReader;
            return legacyReader.read(reader, world, regionX, regionZ);
        }
        RegionizedChunk[] chunks = (RegionizedChunk[])this.createArray.invoke((Object)1024, arg_0 -> RegionizedFileReader.read$lambda$0(this, world, regionX, regionZ, arg_0));
        return (F)((RegionizedFile)this.createFile.invoke((Object)chunks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final F readLatest(ByteReader reader, World world, int regionX, int regionZ) {
        CompressionType compressionType = (CompressionType)((Object)CompressionType.getEntries().get((int)reader.readByte()));
        Closeable closeable = (Closeable)compressionType.getWrapInput().invoke((Object)reader.asInputStream());
        Throwable throwable = null;
        try {
            InputStream decompInp = (InputStream)closeable;
            boolean bl = false;
            BitSet chunkBitmask = BitSet.valueOf(reader.readBytes(128));
            ByteReader decompReader = ByteReader.Companion.fromStream(decompInp);
            RegionizedChunk[] chunks = (RegionizedChunk[])this.createArray.invoke((Object)1024, arg_0 -> RegionizedFileReader.readLatest$lambda$0$0(world, regionX, regionZ, chunkBitmask, this, decompReader, arg_0));
            RegionizedFile regionizedFile = (RegionizedFile)this.createFile.invoke((Object)chunks);
            return (F)regionizedFile;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final RegionizedChunk read$lambda$0(RegionizedFileReader this$0, World $world, int $regionX, int $regionZ, int it) {
        return this$0.chunkReader.createEmpty(Companion.chunkIdxToPos(it, $world, $regionX, $regionZ));
    }

    private static final RegionizedChunk readLatest$lambda$0$0(World $world, int $regionX, int $regionZ, BitSet $chunkBitmask, RegionizedFileReader this$0, ByteReader $decompReader, int it) {
        ChunkPos pos = Companion.chunkIdxToPos(it, $world, $regionX, $regionZ);
        return $chunkBitmask.get(it) ? this$0.chunkReader.read(pos, $decompReader) : this$0.chunkReader.createEmpty(pos);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lxyz/xenondevs/nova/world/format/RegionizedFileReader$Companion;", "", "<init>", "()V", "chunkIdxToPos", "Lxyz/xenondevs/nova/world/ChunkPos;", "idx", "", "world", "Lorg/bukkit/World;", "regionX", "regionZ", "nova"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChunkPos chunkIdxToPos(int idx, @NotNull World world, int regionX, int regionZ) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            int x = regionX << 5 | idx >> 5;
            int z = regionZ << 5 | idx & 0x1F;
            UUID uUID = world.getUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUID(...)");
            return new ChunkPos(uUID, x, z);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

