/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.generation;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.addon.Addon;
import xyz.xenondevs.nova.addon.AddonBootstrapper;
import xyz.xenondevs.nova.addon.AddonKt;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.registry.NovaRegistries;
import xyz.xenondevs.nova.registry.RegistryEventManagerKt;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.data.DataFixerUpperUtilsKt;
import xyz.xenondevs.nova.util.data.UpdatableFile;
import xyz.xenondevs.nova.world.generation.inject.biome.BiomeInjection;

@InternalInit(stage=InternalInitStage.PRE_WORLD)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u00020\f\"\b\b\u0000\u0010\u000e*\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\nH\u0002J \u0010\r\u001a\u00020\f\"\b\b\u0000\u0010\u000e*\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0006H\u0002J>\u0010\u0010\u001a\u00020\f\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\"\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00010\u00010\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lxyz/xenondevs/nova/world/generation/WorldGenFileParser;", "", "<init>", "()V", "NOVA_WORLD_GEN_DIRECTORIES", "", "Lxyz/xenondevs/nova/world/generation/WorldGenFileParser$NovaWorldGenDir;", "Lxyz/xenondevs/nova/world/generation/inject/biome/BiomeInjection;", "kotlin.jvm.PlatformType", "VANILLA_WORLD_GEN_DIRECTORIES", "Lxyz/xenondevs/nova/world/generation/WorldGenFileParser$VanillaWorldGenDir;", "init", "", "loadFiles", "T", "worldGenDir", "processFiles", "dirName", "", "codec", "Lcom/mojang/serialization/Codec;", "registry", "Lnet/minecraft/core/WritableRegistry;", "lookup", "Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;", "VanillaWorldGenDir", "NovaWorldGenDir", "nova"})
@SourceDebugExtension(value={"SMAP\nWorldGenFileParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGenFileParser.kt\nxyz/xenondevs/nova/world/generation/WorldGenFileParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,110:1\n1869#2,2:111\n1869#2,2:113\n1321#3,2:115\n*S KotlinDebug\n*F\n+ 1 WorldGenFileParser.kt\nxyz/xenondevs/nova/world/generation/WorldGenFileParser\n*L\n62#1:111,2\n63#1:113,2\n87#1:115,2\n*E\n"})
public final class WorldGenFileParser {
    @NotNull
    public static final WorldGenFileParser INSTANCE = new WorldGenFileParser();
    @NotNull
    private static final List<NovaWorldGenDir<BiomeInjection>> NOVA_WORLD_GEN_DIRECTORIES;
    @NotNull
    private static final List<VanillaWorldGenDir<? extends Object>> VANILLA_WORLD_GEN_DIRECTORIES;

    private WorldGenFileParser() {
    }

    @InitFun
    public final void init() {
        Object it;
        UpdatableFile.INSTANCE.extractIdNamedFromAllAddons$nova("worldgen");
        Iterable $this$forEach$iv = VANILLA_WORLD_GEN_DIRECTORIES;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VanillaWorldGenDir)element$iv;
            boolean bl = false;
            INSTANCE.loadFiles((VanillaWorldGenDir)it);
        }
        $this$forEach$iv = NOVA_WORLD_GEN_DIRECTORIES;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NovaWorldGenDir)element$iv;
            boolean bl = false;
            INSTANCE.loadFiles((NovaWorldGenDir)it);
        }
    }

    private final <T> void loadFiles(VanillaWorldGenDir<T> worldGenDir) {
        RegistryEventManagerKt.preFreeze(worldGenDir.getRegistry(), (arg_0, arg_1) -> WorldGenFileParser.loadFiles$lambda$0(worldGenDir, arg_0, arg_1));
    }

    private final <T> void loadFiles(NovaWorldGenDir<T> worldGenDir) {
        RegistryEventManagerKt.preFreeze(worldGenDir.getDependency(), (Function1<? super RegistryOps.RegistryInfoLookup, Unit>)((Function1)arg_0 -> WorldGenFileParser.loadFiles$lambda$1(worldGenDir, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void processFiles(String dirName, Codec<T> codec, WritableRegistry<T> registry, RegistryOps.RegistryInfoLookup lookup2) {
        for (Addon addon : AddonBootstrapper.getAddons()) {
            void $this$forEach$iv;
            Path path = addon.getDataFolder().resolve(dirName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Sequence sequence = SequencesKt.filter((Sequence)PathsKt.walk((Path)path, (PathWalkOption[])new PathWalkOption[0]), WorldGenFileParser::processFiles$lambda$0);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Key id;
                Path file = (Path)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)Key.key((String)AddonKt.getId(addon), (String)PathsKt.getNameWithoutExtension((Path)file)), (String)"key(...)");
                RegistryOps registryOps = RegistryOps.create((DynamicOps)((DynamicOps)JsonOps.INSTANCE), (RegistryOps.RegistryInfoLookup)lookup2);
                Intrinsics.checkNotNullExpressionValue((Object)registryOps, (String)"create(...)");
                T t = DataFixerUpperUtilsKt.getFirstOrThrow(DataFixerUpperUtilsKt.decodeJsonFile(codec, (DynamicOps<JsonElement>)((DynamicOps)registryOps), file), "Failed to parse " + file);
                Intrinsics.checkNotNullExpressionValue(t, (String)"getFirstOrThrow(...)");
                NMSUtilsKt.set(registry, id, t);
            }
        }
    }

    private static final Unit loadFiles$lambda$0(VanillaWorldGenDir $worldGenDir, WritableRegistry registry, RegistryOps.RegistryInfoLookup lookup2) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        INSTANCE.processFiles("worldgen/" + $worldGenDir.getDir(), $worldGenDir.getCodec(), registry, lookup2);
        return Unit.INSTANCE;
    }

    private static final Unit loadFiles$lambda$1(NovaWorldGenDir $worldGenDir, RegistryOps.RegistryInfoLookup lookup2) {
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        INSTANCE.processFiles("worldgen/" + $worldGenDir.getDir(), $worldGenDir.getCodec(), $worldGenDir.getRegistry(), lookup2);
        return Unit.INSTANCE;
    }

    private static final boolean processFiles$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"json") && ResourcePath.Companion.isValidPath(PathsKt.getName((Path)it));
    }

    static {
        Codec<BiomeInjection> codec = BiomeInjection.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(codec, (String)"<get-CODEC>(...)");
        ResourceKey resourceKey = Registries.BIOME;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"BIOME");
        NOVA_WORLD_GEN_DIRECTORIES = CollectionsKt.listOf(new NovaWorldGenDir<BiomeInjection>("inject/biome", codec, NovaRegistries.BIOME_INJECTION, resourceKey));
        Object[] objectArray = new VanillaWorldGenDir[9];
        Codec codec2 = Biome.DIRECT_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"DIRECT_CODEC");
        ResourceKey resourceKey2 = Registries.BIOME;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey2, (String)"BIOME");
        objectArray[0] = new VanillaWorldGenDir("biome", codec2, resourceKey2);
        Codec codec3 = ConfiguredWorldCarver.DIRECT_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec3, (String)"DIRECT_CODEC");
        ResourceKey resourceKey3 = Registries.CONFIGURED_CARVER;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey3, (String)"CONFIGURED_CARVER");
        objectArray[1] = new VanillaWorldGenDir("configured_carver", codec3, resourceKey3);
        Codec codec4 = DimensionType.DIRECT_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec4, (String)"DIRECT_CODEC");
        ResourceKey resourceKey4 = Registries.DIMENSION_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey4, (String)"DIMENSION_TYPE");
        objectArray[2] = new VanillaWorldGenDir("dimension_type", codec4, resourceKey4);
        Codec codec5 = ConfiguredFeature.DIRECT_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec5, (String)"DIRECT_CODEC");
        ResourceKey resourceKey5 = Registries.CONFIGURED_FEATURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey5, (String)"CONFIGURED_FEATURE");
        objectArray[3] = new VanillaWorldGenDir("configured_feature", codec5, resourceKey5);
        Codec codec6 = PlacedFeature.DIRECT_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec6, (String)"DIRECT_CODEC");
        ResourceKey resourceKey6 = Registries.PLACED_FEATURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey6, (String)"PLACED_FEATURE");
        objectArray[4] = new VanillaWorldGenDir("placed_feature", codec6, resourceKey6);
        Codec codec7 = NormalNoise.NoiseParameters.DIRECT_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec7, (String)"DIRECT_CODEC");
        ResourceKey resourceKey7 = Registries.NOISE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey7, (String)"NOISE");
        objectArray[5] = new VanillaWorldGenDir("noise", codec7, resourceKey7);
        Codec codec8 = NoiseGeneratorSettings.DIRECT_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec8, (String)"DIRECT_CODEC");
        ResourceKey resourceKey8 = Registries.NOISE_SETTINGS;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey8, (String)"NOISE_SETTINGS");
        objectArray[6] = new VanillaWorldGenDir("noise_settings", codec8, resourceKey8);
        Codec codec9 = Structure.DIRECT_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec9, (String)"DIRECT_CODEC");
        ResourceKey resourceKey9 = Registries.STRUCTURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey9, (String)"STRUCTURE");
        objectArray[7] = new VanillaWorldGenDir("structure", codec9, resourceKey9);
        Codec codec10 = StructureSet.DIRECT_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec10, (String)"DIRECT_CODEC");
        ResourceKey resourceKey10 = Registries.STRUCTURE_SET;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey10, (String)"STRUCTURE_SET");
        objectArray[8] = new VanillaWorldGenDir("structure_set", codec10, resourceKey10);
        VANILLA_WORLD_GEN_DIRECTORIES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u00c6\u0003JO\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\t\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lxyz/xenondevs/nova/world/generation/WorldGenFileParser$NovaWorldGenDir;", "T", "", "dir", "", "codec", "Lcom/mojang/serialization/Codec;", "registry", "Lnet/minecraft/core/WritableRegistry;", "dependency", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "<init>", "(Ljava/lang/String;Lcom/mojang/serialization/Codec;Lnet/minecraft/core/WritableRegistry;Lnet/minecraft/resources/ResourceKey;)V", "getDir", "()Ljava/lang/String;", "getCodec", "()Lcom/mojang/serialization/Codec;", "getRegistry", "()Lnet/minecraft/core/WritableRegistry;", "getDependency", "()Lnet/minecraft/resources/ResourceKey;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "nova"})
    private static final class NovaWorldGenDir<T> {
        @NotNull
        private final String dir;
        @NotNull
        private final Codec<T> codec;
        @NotNull
        private final WritableRegistry<T> registry;
        @NotNull
        private final ResourceKey<? extends Registry<?>> dependency;

        public NovaWorldGenDir(@NotNull String dir, @NotNull Codec<T> codec, @NotNull WritableRegistry<T> registry, @NotNull ResourceKey<? extends Registry<?>> dependency) {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            Intrinsics.checkNotNullParameter(registry, (String)"registry");
            Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
            this.dir = dir;
            this.codec = codec;
            this.registry = registry;
            this.dependency = dependency;
        }

        @NotNull
        public final String getDir() {
            return this.dir;
        }

        @NotNull
        public final Codec<T> getCodec() {
            return this.codec;
        }

        @NotNull
        public final WritableRegistry<T> getRegistry() {
            return this.registry;
        }

        @NotNull
        public final ResourceKey<? extends Registry<?>> getDependency() {
            return this.dependency;
        }

        @NotNull
        public final String component1() {
            return this.dir;
        }

        @NotNull
        public final Codec<T> component2() {
            return this.codec;
        }

        @NotNull
        public final WritableRegistry<T> component3() {
            return this.registry;
        }

        @NotNull
        public final ResourceKey<? extends Registry<?>> component4() {
            return this.dependency;
        }

        @NotNull
        public final NovaWorldGenDir<T> copy(@NotNull String dir, @NotNull Codec<T> codec, @NotNull WritableRegistry<T> registry, @NotNull ResourceKey<? extends Registry<?>> dependency) {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            Intrinsics.checkNotNullParameter(registry, (String)"registry");
            Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
            return new NovaWorldGenDir<T>(dir, codec, registry, dependency);
        }

        public static /* synthetic */ NovaWorldGenDir copy$default(NovaWorldGenDir novaWorldGenDir, String string, Codec codec, WritableRegistry writableRegistry, ResourceKey resourceKey, int n, Object object) {
            if ((n & 1) != 0) {
                string = novaWorldGenDir.dir;
            }
            if ((n & 2) != 0) {
                codec = novaWorldGenDir.codec;
            }
            if ((n & 4) != 0) {
                writableRegistry = novaWorldGenDir.registry;
            }
            if ((n & 8) != 0) {
                resourceKey = novaWorldGenDir.dependency;
            }
            return novaWorldGenDir.copy(string, codec, writableRegistry, resourceKey);
        }

        @NotNull
        public String toString() {
            return "NovaWorldGenDir(dir=" + this.dir + ", codec=" + this.codec + ", registry=" + this.registry + ", dependency=" + this.dependency + ")";
        }

        public int hashCode() {
            int result = this.dir.hashCode();
            result = result * 31 + this.codec.hashCode();
            result = result * 31 + this.registry.hashCode();
            result = result * 31 + this.dependency.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NovaWorldGenDir)) {
                return false;
            }
            NovaWorldGenDir novaWorldGenDir = (NovaWorldGenDir)other;
            if (!Intrinsics.areEqual((Object)this.dir, (Object)novaWorldGenDir.dir)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.codec, novaWorldGenDir.codec)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.registry, novaWorldGenDir.registry)) {
                return false;
            }
            return Intrinsics.areEqual(this.dependency, novaWorldGenDir.dependency);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J\u0017\u0010\u0014\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bH\u00c6\u0003JA\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0007\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lxyz/xenondevs/nova/world/generation/WorldGenFileParser$VanillaWorldGenDir;", "T", "", "dir", "", "codec", "Lcom/mojang/serialization/Codec;", "registry", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "<init>", "(Ljava/lang/String;Lcom/mojang/serialization/Codec;Lnet/minecraft/resources/ResourceKey;)V", "getDir", "()Ljava/lang/String;", "getCodec", "()Lcom/mojang/serialization/Codec;", "getRegistry", "()Lnet/minecraft/resources/ResourceKey;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "nova"})
    private static final class VanillaWorldGenDir<T> {
        @NotNull
        private final String dir;
        @NotNull
        private final Codec<T> codec;
        @NotNull
        private final ResourceKey<? extends Registry<T>> registry;

        public VanillaWorldGenDir(@NotNull String dir, @NotNull Codec<T> codec, @NotNull ResourceKey<? extends Registry<T>> registry) {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            Intrinsics.checkNotNullParameter(registry, (String)"registry");
            this.dir = dir;
            this.codec = codec;
            this.registry = registry;
        }

        @NotNull
        public final String getDir() {
            return this.dir;
        }

        @NotNull
        public final Codec<T> getCodec() {
            return this.codec;
        }

        @NotNull
        public final ResourceKey<? extends Registry<T>> getRegistry() {
            return this.registry;
        }

        @NotNull
        public final String component1() {
            return this.dir;
        }

        @NotNull
        public final Codec<T> component2() {
            return this.codec;
        }

        @NotNull
        public final ResourceKey<? extends Registry<T>> component3() {
            return this.registry;
        }

        @NotNull
        public final VanillaWorldGenDir<T> copy(@NotNull String dir, @NotNull Codec<T> codec, @NotNull ResourceKey<? extends Registry<T>> registry) {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            Intrinsics.checkNotNullParameter(registry, (String)"registry");
            return new VanillaWorldGenDir<T>(dir, codec, registry);
        }

        public static /* synthetic */ VanillaWorldGenDir copy$default(VanillaWorldGenDir vanillaWorldGenDir, String string, Codec codec, ResourceKey resourceKey, int n, Object object) {
            if ((n & 1) != 0) {
                string = vanillaWorldGenDir.dir;
            }
            if ((n & 2) != 0) {
                codec = vanillaWorldGenDir.codec;
            }
            if ((n & 4) != 0) {
                resourceKey = vanillaWorldGenDir.registry;
            }
            return vanillaWorldGenDir.copy(string, codec, resourceKey);
        }

        @NotNull
        public String toString() {
            return "VanillaWorldGenDir(dir=" + this.dir + ", codec=" + this.codec + ", registry=" + this.registry + ")";
        }

        public int hashCode() {
            int result = this.dir.hashCode();
            result = result * 31 + this.codec.hashCode();
            result = result * 31 + this.registry.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VanillaWorldGenDir)) {
                return false;
            }
            VanillaWorldGenDir vanillaWorldGenDir = (VanillaWorldGenDir)other;
            if (!Intrinsics.areEqual((Object)this.dir, (Object)vanillaWorldGenDir.dir)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.codec, vanillaWorldGenDir.codec)) {
                return false;
            }
            return Intrinsics.areEqual(this.registry, vanillaWorldGenDir.registry);
        }
    }
}

