/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.behavior;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.world.item.behavior.BowKt;
import xyz.xenondevs.nova.world.item.behavior.BowLogic;
import xyz.xenondevs.nova.world.item.behavior.ItemBehavior;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J(\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lxyz/xenondevs/nova/world/item/behavior/Bow;", "Lxyz/xenondevs/nova/world/item/behavior/ItemBehavior;", "logic", "Lxyz/xenondevs/nova/world/item/behavior/BowLogic;", "<init>", "(Lxyz/xenondevs/nova/world/item/behavior/BowLogic;)V", "modifyUseDuration", "", "entity", "Lorg/bukkit/entity/LivingEntity;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "duration", "handleUseTick", "", "hand", "Lorg/bukkit/inventory/EquipmentSlot;", "remainingUseTicks", "handleUseStopped", "handleEquipmentTick", "player", "Lorg/bukkit/entity/Player;", "slot", "modifyClientSideItemType", "Lorg/bukkit/Material;", "server", "client", "nova"})
public final class Bow
implements ItemBehavior {
    @NotNull
    private final BowLogic logic;

    public Bow(@NotNull BowLogic logic) {
        Intrinsics.checkNotNullParameter((Object)logic, (String)"logic");
        this.logic = logic;
    }

    public /* synthetic */ Bow(BowLogic bowLogic, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bowLogic = BowLogic.Vanilla.INSTANCE;
        }
        this(bowLogic);
    }

    @Override
    public int modifyUseDuration(@NotNull LivingEntity entity, @NotNull ItemStack itemStack, int duration) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        ItemStack itemStack2 = itemStack.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
        if (this.logic.canDraw(entity, itemStack2)) {
            return 72000;
        }
        return 0;
    }

    @Override
    public void handleUseTick(@NotNull LivingEntity entity, @NotNull ItemStack itemStack, @NotNull EquipmentSlot hand, int remainingUseTicks) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        int tick2 = 72000 - remainingUseTicks;
        ItemStack itemStack2 = itemStack.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
        this.logic.handleDrawTick(entity, itemStack2, tick2);
    }

    @Override
    public void handleUseStopped(@NotNull LivingEntity entity, @NotNull ItemStack itemStack, @NotNull EquipmentSlot hand, int remainingUseTicks) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
            ItemStack itemStack2 = itemStack.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
            ItemStack result = this.logic.shoot(entity, hand, itemStack2, 72000 - remainingUseTicks);
            EntityEquipment entityEquipment = entity.getEquipment();
            if (entityEquipment == null) break block0;
            entityEquipment.setItem(hand, result);
        }
    }

    @Override
    public void handleEquipmentTick(@NotNull Player player, @NotNull ItemStack itemStack, @NotNull EquipmentSlot slot) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        if (Intrinsics.areEqual((Object)this.logic, (Object)BowLogic.Vanilla.INSTANCE) || !slot.isHand()) {
            return;
        }
        boolean currentCanUse = itemStack.getPersistentDataContainer().has(BowKt.access$getCAN_USE_KEY$p());
        LivingEntity livingEntity = (LivingEntity)player;
        ItemStack itemStack2 = itemStack.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
        boolean canUse = this.logic.canDraw(livingEntity, itemStack2);
        if (currentCanUse && !canUse) {
            itemStack.editPersistentDataContainer(Bow::handleEquipmentTick$lambda$0);
            player.getInventory().setItem(slot, itemStack);
        } else if (!currentCanUse && canUse) {
            itemStack.editPersistentDataContainer(Bow::handleEquipmentTick$lambda$1);
            player.getInventory().setItem(slot, itemStack);
        }
    }

    @Override
    @NotNull
    public Material modifyClientSideItemType(@Nullable Player player, @NotNull ItemStack server, @NotNull Material client) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (Intrinsics.areEqual((Object)this.logic, (Object)BowLogic.Vanilla.INSTANCE) || server.getPersistentDataContainer().has(BowKt.access$getCAN_USE_KEY$p())) {
            return Material.BOW;
        }
        return client;
    }

    private static final void handleEquipmentTick$lambda$0(PersistentDataContainer pdc) {
        pdc.remove(BowKt.access$getCAN_USE_KEY$p());
    }

    private static final void handleEquipmentTick$lambda$1(PersistentDataContainer pdc) {
        pdc.set(BowKt.access$getCAN_USE_KEY$p(), PersistentDataType.BOOLEAN, (Object)true);
    }

    public Bow() {
        this(null, 1, null);
    }
}

