/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.behavior;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.collections.SetsKt;
import xyz.xenondevs.commons.provider.MutableProvider;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.commons.provider.Providers;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.network.PacketFactoryFunctionsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.world.item.NovaItem;
import xyz.xenondevs.nova.world.item.behavior.ItemBehavior;

@InternalInit(stage=InternalInitStage.POST_WORLD)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0003J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lxyz/xenondevs/nova/world/item/behavior/EquipmentAnimator;", "", "<init>", "()V", "ARMOR_EQUIPMENT_SLOTS", "", "Lorg/bukkit/inventory/EquipmentSlot;", "_tick", "Lxyz/xenondevs/commons/provider/MutableProvider;", "", "tick", "Lxyz/xenondevs/commons/provider/Provider;", "getTick", "()Lxyz/xenondevs/commons/provider/Provider;", "animatedBehaviors", "", "Lxyz/xenondevs/nova/world/item/behavior/ItemBehavior;", "getAnimatedBehaviors", "()Ljava/util/Set;", "startAnimationTask", "", "handleTick", "updatePlayerArmor", "player", "Lorg/bukkit/entity/Player;", "updateNonPlayerArmor", "entity", "Lorg/bukkit/entity/LivingEntity;", "nova"})
@SourceDebugExtension(value={"SMAP\nEquipmentAnimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EquipmentAnimator.kt\nxyz/xenondevs/nova/world/item/behavior/EquipmentAnimator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1321#2,2:109\n1761#3,3:111\n1761#3,3:114\n*S KotlinDebug\n*F\n+ 1 EquipmentAnimator.kt\nxyz/xenondevs/nova/world/item/behavior/EquipmentAnimator\n*L\n61#1:109,2\n75#1:111,3\n97#1:114,3\n*E\n"})
public final class EquipmentAnimator {
    @NotNull
    public static final EquipmentAnimator INSTANCE = new EquipmentAnimator();
    @NotNull
    private static final List<org.bukkit.inventory.EquipmentSlot> ARMOR_EQUIPMENT_SLOTS;
    @NotNull
    private static final MutableProvider<Integer> _tick;
    @NotNull
    private static final Set<ItemBehavior> animatedBehaviors;

    private EquipmentAnimator() {
    }

    @NotNull
    public final Provider<Integer> getTick() {
        return (Provider)_tick;
    }

    @NotNull
    public final Set<ItemBehavior> getAnimatedBehaviors() {
        return animatedBehaviors;
    }

    @InitFun
    private final void startAnimationTask() {
        SchedulerUtilsKt.runTaskTimer(0L, 1L, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                EquipmentAnimator.access$handleTick((EquipmentAnimator)this.receiver);
            }
        }));
    }

    private final void handleTick() {
        if (animatedBehaviors.isEmpty()) {
            return;
        }
        _tick.set((Object)(((Number)_tick.get()).intValue() + 1));
        List list = Bukkit.getWorlds();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWorlds(...)");
        Sequence $this$forEach$iv = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)list), EquipmentAnimator::handleTick$lambda$0);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LivingEntity entity = (LivingEntity)element$iv;
            boolean bl = false;
            LivingEntity livingEntity = entity;
            if (livingEntity instanceof Player) {
                INSTANCE.updatePlayerArmor((Player)entity);
                continue;
            }
            if (!(livingEntity instanceof HumanEntity) && !(livingEntity instanceof Zombie) && !(livingEntity instanceof Skeleton) && !(livingEntity instanceof Piglin) && !(livingEntity instanceof ArmorStand) && !(livingEntity instanceof Horse) && !(livingEntity instanceof Llama) && !(livingEntity instanceof Wolf)) continue;
            INSTANCE.updateNonPlayerArmor(entity);
        }
    }

    private final void updatePlayerArmor(Player player) {
        ServerPlayer serverPlayer = NMSUtilsKt.getServerPlayer(player);
        HashMap updatedEquipment = new HashMap();
        ItemStack[] itemStackArray = player.getEquipment().getArmorContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getArmorContents(...)");
        ItemStack[] itemStackArray2 = itemStackArray;
        int n = itemStackArray2.length;
        for (int j = 0; j < n; ++j) {
            boolean bl;
            int armorSlot = j;
            ItemStack armorStack = itemStackArray2[j];
            Object object = armorStack;
            if (object != null && (object = ItemUtilsKt.getNovaItem((ItemStack)object)) != null && (object = ((NovaItem)object).getBehaviors()) != null) {
                boolean bl2;
                block7: {
                    Iterable $this$any$iv = (Iterable)object;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ItemBehavior it = (ItemBehavior)element$iv;
                            boolean bl3 = false;
                            if (!animatedBehaviors.contains(it)) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                }
                bl = bl2;
            } else {
                bl = false;
            }
            if (!bl) continue;
            serverPlayer.inventoryMenu.setRemoteSlot(8 - armorSlot, net.minecraft.world.item.ItemStack.EMPTY);
            ((Map)updatedEquipment).put(EntriesMappings.entries$0.get(armorSlot + 2), NMSUtilsKt.unwrap(armorStack));
        }
        if (!((Map)updatedEquipment).isEmpty()) {
            ClientboundSetEquipmentPacket packet = PacketFactoryFunctionsKt.ClientboundSetEquipmentPacket(player.getEntityId(), updatedEquipment);
            serverPlayer.level().chunkSource.sendToTrackingPlayers((Entity)serverPlayer, (Packet)packet);
        }
    }

    private final void updateNonPlayerArmor(LivingEntity entity) {
        EntityEquipment entityEquipment = entity.getEquipment();
        if (entityEquipment == null) {
            return;
        }
        EntityEquipment equipment = entityEquipment;
        HashMap updatedEquipment = new HashMap();
        for (org.bukkit.inventory.EquipmentSlot slot : ARMOR_EQUIPMENT_SLOTS) {
            boolean bl;
            ItemStack itemStack;
            if (!entity.canUseEquipmentSlot(slot)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)equipment.getItem(slot), (String)"getItem(...)");
            Object object = ItemUtilsKt.getNovaItem(itemStack);
            if (object != null && (object = ((NovaItem)object).getBehaviors()) != null) {
                boolean bl2;
                block8: {
                    Iterable $this$any$iv = (Iterable)object;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ItemBehavior it = (ItemBehavior)element$iv;
                            boolean bl3 = false;
                            if (!animatedBehaviors.contains(it)) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                }
                bl = bl2;
            } else {
                bl = false;
            }
            if (!bl) continue;
            ((Map)updatedEquipment).put(NMSUtilsKt.getNmsEquipmentSlot(slot), NMSUtilsKt.unwrap(itemStack));
        }
        if (!((Map)updatedEquipment).isEmpty()) {
            ClientboundSetEquipmentPacket packet = PacketFactoryFunctionsKt.ClientboundSetEquipmentPacket(entity.getEntityId(), updatedEquipment);
            World world = entity.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            NMSUtilsKt.getServerLevel((World)world).chunkSource.sendToTrackingPlayers((Entity)NMSUtilsKt.getNmsEntity(entity), (Packet)packet);
        }
    }

    private static final Iterable handleTick$lambda$0(World it) {
        List list = it.getLivingEntities();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLivingEntities(...)");
        return list;
    }

    public static final /* synthetic */ void access$handleTick(EquipmentAnimator $this) {
        $this.handleTick();
    }

    static {
        Object[] objectArray = new org.bukkit.inventory.EquipmentSlot[]{org.bukkit.inventory.EquipmentSlot.FEET, org.bukkit.inventory.EquipmentSlot.LEGS, org.bukkit.inventory.EquipmentSlot.CHEST, org.bukkit.inventory.EquipmentSlot.HEAD, org.bukkit.inventory.EquipmentSlot.BODY};
        ARMOR_EQUIPMENT_SLOTS = CollectionsKt.listOf((Object[])objectArray);
        _tick = Providers.mutableProvider((Object)0);
        animatedBehaviors = SetsKt.concurrentHashSet();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }
}

