/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.player;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.InteractionHand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.network.event.PacketHandler;
import xyz.xenondevs.nova.network.event.PacketListener;
import xyz.xenondevs.nova.network.event.PacketListenerKt;
import xyz.xenondevs.nova.network.event.serverbound.ServerboundSwingPacketEvent;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.MathUtilsKt;

@InternalInit(stage=InternalInitStage.POST_WORLD)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0003J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0015H\u0003R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lxyz/xenondevs/nova/world/player/EventlessHandSwinging;", "Lxyz/xenondevs/nova/network/event/PacketListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "toDrop", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lkotlin/Pair;", "Ljava/util/concurrent/atomic/AtomicInteger;", "init", "", "handleSwingPacket", "event", "Lxyz/xenondevs/nova/network/event/serverbound/ServerboundSwingPacketEvent;", "registerDrop", "player", "Lorg/bukkit/entity/Player;", "mainHand", "", "handleQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "nova"})
public final class EventlessHandSwinging
implements PacketListener,
Listener {
    @NotNull
    public static final EventlessHandSwinging INSTANCE = new EventlessHandSwinging();
    @NotNull
    private static final ConcurrentHashMap<UUID, Pair<AtomicInteger, AtomicInteger>> toDrop = new ConcurrentHashMap();

    private EventlessHandSwinging() {
    }

    @InitFun
    private final void init() {
        PacketListenerKt.registerPacketListener(this);
        EventUtilsKt.registerEvents(this);
    }

    @PacketHandler
    private final void handleSwingPacket(ServerboundSwingPacketEvent event) {
        Pair<AtomicInteger, AtomicInteger> pair = toDrop.get(event.getPlayer().getUniqueId());
        if (pair == null) {
            return;
        }
        Pair<AtomicInteger, AtomicInteger> pair2 = pair;
        AtomicInteger main = (AtomicInteger)pair2.component1();
        AtomicInteger off = (AtomicInteger)pair2.component2();
        if (event.getHand() == InteractionHand.MAIN_HAND && MathUtilsKt.decrementIfGreaterThanZero(main)) {
            event.setCancelled(true);
        } else if (event.getHand() == InteractionHand.OFF_HAND && MathUtilsKt.decrementIfGreaterThanZero(off)) {
            event.setCancelled(true);
        }
    }

    public final void registerDrop(@NotNull Player player, boolean mainHand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Pair pair = toDrop.computeIfAbsent(player.getUniqueId(), arg_0 -> EventlessHandSwinging.registerDrop$lambda$1(EventlessHandSwinging::registerDrop$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"computeIfAbsent(...)");
        Pair pair2 = pair;
        AtomicInteger main = (AtomicInteger)pair2.component1();
        AtomicInteger off = (AtomicInteger)pair2.component2();
        int n = mainHand ? main.incrementAndGet() : off.incrementAndGet();
    }

    @EventHandler
    private final void handleQuit(PlayerQuitEvent event) {
        toDrop.remove(event.getPlayer().getUniqueId());
    }

    private static final Pair registerDrop$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TuplesKt.to((Object)new AtomicInteger(), (Object)new AtomicInteger());
    }

    private static final Pair registerDrop$lambda$1(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }
}

