/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.region;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeItemDisplay;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ItemDisplayMetadata;
import xyz.xenondevs.nova.world.item.DefaultBlockOverlays;
import xyz.xenondevs.nova.world.region.Region;
import xyz.xenondevs.nova.world.region.VisualRegionKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0006J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0006J\u0016\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J0\u0010\u0018\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00072\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R2\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lxyz/xenondevs/nova/world/region/VisualRegion;", "", "<init>", "()V", "regions", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lkotlin/Pair;", "", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeItemDisplay;", "", "Lorg/bukkit/entity/Player;", "isVisible", "", "player", "regionId", "toggleView", "", "region", "Lxyz/xenondevs/nova/world/region/Region;", "showRegion", "hideRegion", "removeRegion", "updateRegion", "getOrCreateVisualRegion", "createOutline", "getEdgeDisplays", "min", "Lorg/bukkit/Location;", "max", "color", "", "createLine", "from", "to", "lineWidth", "", "nova"})
@SourceDebugExtension(value={"SMAP\nVisualRegion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualRegion.kt\nxyz/xenondevs/nova/world/region/VisualRegion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,128:1\n382#2,7:129\n*S KotlinDebug\n*F\n+ 1 VisualRegion.kt\nxyz/xenondevs/nova/world/region/VisualRegion\n*L\n68#1:129,7\n*E\n"})
public final class VisualRegion {
    @NotNull
    public static final VisualRegion INSTANCE = new VisualRegion();
    @NotNull
    private static final HashMap<UUID, Pair<List<FakeItemDisplay>, Set<Player>>> regions = new HashMap();

    private VisualRegion() {
    }

    public final boolean isVisible(@NotNull Player player, @NotNull UUID regionId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)regionId, (String)"regionId");
        Object object = regions.get(regionId);
        return object != null && (object = (Set)object.getSecond()) != null ? object.contains(player) : false;
    }

    public final void toggleView(@NotNull Player player, @NotNull UUID regionId, @NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)regionId, (String)"regionId");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        if (this.isVisible(player, regionId)) {
            this.hideRegion(player, regionId);
        } else {
            this.showRegion(player, regionId, region);
        }
    }

    public final void showRegion(@NotNull Player player, @NotNull UUID regionId, @NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)regionId, (String)"regionId");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Pair<List<FakeItemDisplay>, Set<Player>> pair = this.getOrCreateVisualRegion(regionId, region);
        List outline = (List)pair.component1();
        Set viewers = (Set)pair.component2();
        if (!viewers.contains(player)) {
            VisualRegionKt.access$spawn((Iterable)outline, player);
            viewers.add(player);
        }
    }

    public final void hideRegion(@NotNull Player player, @NotNull UUID regionId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)regionId, (String)"regionId");
        Pair<List<FakeItemDisplay>, Set<Player>> pair = regions.get(regionId);
        if (pair == null) {
            return;
        }
        Pair<List<FakeItemDisplay>, Set<Player>> pair2 = pair;
        List outline = (List)pair2.component1();
        Set viewers = (Set)pair2.component2();
        VisualRegionKt.access$despawn((Iterable)outline, player);
        viewers.remove(player);
        if (viewers.isEmpty()) {
            this.removeRegion(regionId);
        }
    }

    public final void removeRegion(@NotNull UUID regionId) {
        Intrinsics.checkNotNullParameter((Object)regionId, (String)"regionId");
        Pair<List<FakeItemDisplay>, Set<Player>> pair = regions.remove(regionId);
        if (pair == null) {
            return;
        }
        Pair<List<FakeItemDisplay>, Set<Player>> pair2 = pair;
        List outline = (List)pair2.component1();
        Set viewers = (Set)pair2.component2();
        VisualRegionKt.access$despawn((Iterable)outline, viewers);
    }

    public final void updateRegion(@NotNull UUID regionId, @NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)regionId, (String)"regionId");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Pair<List<FakeItemDisplay>, Set<Player>> pair = regions.get(regionId);
        if (pair == null) {
            return;
        }
        Pair<List<FakeItemDisplay>, Set<Player>> pair2 = pair;
        List outline = (List)pair2.component1();
        Set viewers = (Set)pair2.component2();
        VisualRegionKt.access$despawn((Iterable)outline, viewers);
        List<FakeItemDisplay> newOutline = this.createOutline(regionId, region);
        VisualRegionKt.access$spawn((Iterable)newOutline, viewers);
        ((Map)regions).put(regionId, TuplesKt.to(newOutline, (Object)viewers));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<FakeItemDisplay>, Set<Player>> getOrCreateVisualRegion(UUID regionId, Region region) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = regions;
        UUID key$iv = regionId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List<FakeItemDisplay> outline = INSTANCE.createOutline(regionId, region);
            Set viewers = Collections.newSetFromMap(new WeakHashMap());
            Pair answer$iv = TuplesKt.to(outline, viewers);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Pair)object;
    }

    private final List<FakeItemDisplay> createOutline(UUID regionId, Region region) {
        Location min = region.getMin();
        Location max = region.getMax();
        int color = new Color(regionId.hashCode()).getRGB();
        return this.getEdgeDisplays(min, max, color);
    }

    private final List<FakeItemDisplay> getEdgeDisplays(Location min, Location max, int color) {
        World world = LocationUtilsKt.component1(min);
        double minX = LocationUtilsKt.component2(min);
        double minY = LocationUtilsKt.component3(min);
        double minZ = LocationUtilsKt.component4(min);
        double maxX = LocationUtilsKt.component2(max);
        double maxY = LocationUtilsKt.component3(max);
        double maxZ = LocationUtilsKt.component4(max);
        double lineWidth = RangesKt.coerceIn((double)(min.distance(max) / 10.0), (double)0.0, (double)1.0) * 0.045000000000000005 + 0.005;
        Object[] objectArray = new FakeItemDisplay[]{VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, minX, minY, minZ, maxX, minY, minZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, minX, minY, maxZ, maxX, minY, maxZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, minX, maxY, minZ, maxX, maxY, minZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, minX, maxY, maxZ, maxX, maxY, maxZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, minX, minY, minZ, minX, maxY, minZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, minX, minY, maxZ, minX, maxY, maxZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, maxX, minY, minZ, maxX, maxY, minZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, maxX, minY, maxZ, maxX, maxY, maxZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, minX, minY, minZ, minX, minY, maxZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, minX, maxY, minZ, minX, maxY, maxZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, maxX, minY, minZ, maxX, minY, maxZ), VisualRegion.getEdgeDisplays$createLine(world, lineWidth, color, maxX, maxY, minZ, maxX, maxY, maxZ)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final FakeItemDisplay createLine(Location from, Location to, double lineWidth, int color) {
        Location location = from.clone().add(to).multiply(0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"multiply(...)");
        Location center = location;
        return new FakeItemDisplay(center, false, (Function2<? super FakeItemDisplay, ? super ItemDisplayMetadata, Unit>)((Function2)(arg_0, arg_1) -> VisualRegion.createLine$lambda$0(to, from, lineWidth, color, arg_0, arg_1)));
    }

    private static final FakeItemDisplay getEdgeDisplays$createLine(World world, double lineWidth, int $color, double x1, double y1, double z1, double x2, double y2, double z2) {
        return INSTANCE.createLine(new Location(world, x1, y1, z1), new Location(world, x2, y2, z2), lineWidth, $color);
    }

    private static final Unit createLine$lambda$0(Location $to, Location $from, double $lineWidth, int $color, FakeItemDisplay fakeItemDisplay, ItemDisplayMetadata data2) {
        Intrinsics.checkNotNullParameter((Object)fakeItemDisplay, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        data2.setItemStack(DefaultBlockOverlays.INSTANCE.getTRANSPARENT_BLOCK().getClientsideProvider().get());
        data2.setScale((Vector3fc)new Vector3f((float)($to.getX() - $from.getX() + $lineWidth), (float)($to.getY() - $from.getY() + $lineWidth), (float)($to.getZ() - $from.getZ() + $lineWidth)));
        data2.setGlowing(true);
        data2.setGlowColor($color);
        return Unit.INSTANCE;
    }
}

