/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova;

import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.impl.JarLibrary;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class NovaLoader
implements PluginLoader {
    private static final Path LIBRARIES_DIR = Path.of("libraries/", new String[0]);

    public void classloader(@NotNull PluginClasspathBuilder classpathBuilder) {
        try (FileSystem zfs = FileSystems.newFileSystem(Path.of(NovaLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI()));){
            List<String> lines = Files.readAllLines(zfs.getPath("nova-libraries", new String[0]));
            for (String line : lines) {
                Path src = zfs.getPath(line, new String[0]);
                Path dst = LIBRARIES_DIR.resolve(line.substring("lib/".length()));
                if (!Files.exists(dst, new LinkOption[0])) {
                    Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                    Files.copy(src, dst, new CopyOption[0]);
                }
                classpathBuilder.addLibrary((ClassPathLibrary)new JarLibrary(dst));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract Nova libraries", e);
        }
    }
}

