/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.block.sound;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.block.behavior.BlockSounds;
import xyz.xenondevs.nova.world.block.logic.sound.SoundEngine;
import xyz.xenondevs.nova.world.block.sound.SoundGroup;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@Mixin(value={Player.class})
abstract class PlayerMixin {
    PlayerMixin() {
    }

    @Redirect(method={"playStepSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;playCombinationStepSounds(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V"))
    private void playCombinationStepSounds(Player instance, BlockState primaryState, BlockState secondaryState, @Local(ordinal=0, argsOnly=true) BlockPos secondaryPos, @Local(ordinal=1) BlockPos primaryPos) {
        this.nova$playStepSound(primaryPos, primaryState);
        this.nova$playMuffledStepSound(secondaryPos, secondaryState);
    }

    @Redirect(method={"playStepSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Avatar;playStepSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"))
    private void playStepSound(Avatar entity, BlockPos pos, BlockState state) {
        this.nova$playStepSound(pos, state);
    }

    @Unique
    private void nova$playStepSound(BlockPos pos, BlockState state) {
        this.nova$playStepSound(pos, state, 0.15f, 1.0f);
    }

    @Unique
    private void nova$playMuffledStepSound(BlockPos pos, BlockState state) {
        this.nova$playStepSound(pos, state, 0.05f, 0.8f);
    }

    @Unique
    private void nova$playStepSound(BlockPos pos, BlockState state, float volumeMultiplier, float pitchMultiplier) {
        float pitch;
        float volume;
        String newSound;
        Player player = (Player)this;
        SoundType vanillaSoundType = state.getSoundType();
        xyz.xenondevs.nova.world.BlockPos novaPos = NMSUtilsKt.toNovaPos(pos, (World)player.level().getWorld());
        NovaBlockState novaState = WorldDataManager.INSTANCE.getBlockState(novaPos);
        String oldSound = vanillaSoundType.getStepSound().location().getPath();
        if (novaState != null) {
            BlockSounds sounds = novaState.getBlock().getBehaviorOrNull(BlockSounds.class);
            if (sounds == null) {
                return;
            }
            SoundGroup soundGroup = sounds.getSoundGroup();
            newSound = soundGroup.getStepSound();
            volume = soundGroup.getVolume() * volumeMultiplier;
            pitch = soundGroup.getPitch() * pitchMultiplier;
        } else {
            newSound = oldSound;
            volume = vanillaSoundType.getVolume() * volumeMultiplier;
            pitch = vanillaSoundType.getPitch() * pitchMultiplier;
        }
        SoundEngine.broadcast((Entity)player, oldSound, newSound, volume, pitch);
    }
}

