/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.item.enchantment;

import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.world.item.NovaItem;
import xyz.xenondevs.nova.world.item.behavior.Enchantable;
import xyz.xenondevs.nova.world.item.enchantment.CustomEnchantmentLogic;

@Mixin(value={Enchantment.class})
abstract class EnchantmentMixin {
    EnchantmentMixin() {
    }

    @Inject(method={"isPrimaryItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void isPrimaryItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Enchantment ench = (Enchantment)this;
        CustomEnchantmentLogic cel = CustomEnchantmentLogic.customEnchantments.get(ench);
        if (cel != null && cel.isPrimaryItem(stack.asBukkitMirror())) {
            cir.setReturnValue((Object)true);
            return;
        }
        NovaItem novaItem = ItemUtilsKt.getNovaItem(stack);
        if (novaItem == null) {
            return;
        }
        org.bukkit.enchantments.Enchantment bukkitEnch = CraftEnchantment.minecraftToBukkit((Enchantment)ench);
        Enchantable enchantable = novaItem.getBehaviorOrNull(Enchantable.class);
        cir.setReturnValue((Object)(enchantable != null && enchantable.getPrimaryEnchantments().contains(bukkitEnch) ? 1 : 0));
    }

    @Inject(method={"isSupportedItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void isSupportedItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Boolean supported = this.nova$isSupportedItem(stack);
        if (supported != null) {
            cir.setReturnValue((Object)supported);
        }
    }

    @Inject(method={"canEnchant"}, at={@At(value="HEAD")}, cancellable=true)
    private void canEnchant(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Boolean supported = this.nova$isSupportedItem(stack);
        if (supported != null) {
            cir.setReturnValue((Object)supported);
        }
    }

    @Unique
    private Boolean nova$isSupportedItem(ItemStack stack) {
        Enchantment ench = (Enchantment)this;
        CustomEnchantmentLogic cel = CustomEnchantmentLogic.customEnchantments.get(ench);
        if (cel != null && cel.isSupportedItem(stack.asBukkitMirror())) {
            return true;
        }
        NovaItem novaItem = ItemUtilsKt.getNovaItem(stack);
        if (novaItem == null) {
            return null;
        }
        org.bukkit.enchantments.Enchantment bukkitEnch = CraftEnchantment.minecraftToBukkit((Enchantment)ench);
        Enchantable enchantable = novaItem.getBehaviorOrNull(Enchantable.class);
        return enchantable != null && enchantable.getSupportedEnchantments().contains(bukkitEnch);
    }

    @Inject(method={"getMinCost"}, at={@At(value="HEAD")}, cancellable=true)
    private void getMinCost(int level, CallbackInfoReturnable<Integer> cir) {
        CustomEnchantmentLogic cel = CustomEnchantmentLogic.customEnchantments.get((Enchantment)this);
        if (cel != null) {
            cir.setReturnValue((Object)cel.getMinCost(level));
        }
    }

    @Inject(method={"getMaxCost"}, at={@At(value="HEAD")}, cancellable=true)
    private void getMaxCost(int level, CallbackInfoReturnable<Integer> cir) {
        CustomEnchantmentLogic cel = CustomEnchantmentLogic.customEnchantments.get((Enchantment)this);
        if (cel != null) {
            cir.setReturnValue((Object)cel.getMaxCost(level));
        }
    }

    @Overwrite
    public static boolean areCompatible(Holder<Enchantment> first, Holder<Enchantment> second) {
        boolean firstCompatibleWithSecond;
        if (first == second) {
            return false;
        }
        CustomEnchantmentLogic celFirst = CustomEnchantmentLogic.customEnchantments.get(first.value());
        CustomEnchantmentLogic celSecond = CustomEnchantmentLogic.customEnchantments.get(second.value());
        boolean bl = celFirst != null ? celFirst.compatibleWith((Enchantment)second.value()) : (firstCompatibleWithSecond = !((Enchantment)first.value()).exclusiveSet().contains(second));
        boolean secondCompatibleWithFirst = celSecond != null ? celSecond.compatibleWith((Enchantment)first.value()) : !((Enchantment)second.value()).exclusiveSet().contains(first);
        return firstCompatibleWithSecond && secondCompatibleWithFirst;
    }
}

