/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.item.fuel;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.FuelValues;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.world.item.NovaItem;
import xyz.xenondevs.nova.world.item.behavior.Fuel;

@Mixin(value={FuelValues.class})
abstract class FuelValuesMixin {
    FuelValuesMixin() {
    }

    @Inject(method={"isFuel"}, at={@At(value="HEAD")}, cancellable=true)
    private void isFuel(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        NovaItem novaItem = ItemUtilsKt.getNovaItem(stack);
        if (novaItem != null) {
            cir.setReturnValue((Object)novaItem.hasBehavior(Fuel.class));
        }
    }

    @Inject(method={"burnDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void burnDuration(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        NovaItem novaItem = ItemUtilsKt.getNovaItem(stack);
        if (novaItem != null) {
            Fuel fuelBehavior = novaItem.getBehaviorOrNull(Fuel.class);
            cir.setReturnValue((Object)(fuelBehavior != null ? fuelBehavior.getBurnTime() : 0));
        }
    }
}

