/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.registry;

import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.addon.Addon;
import xyz.xenondevs.nova.registry.FuzzyMappedRegistry;
import xyz.xenondevs.nova.registry.NovaRegistryAccess;
import xyz.xenondevs.nova.util.NMSUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00070\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\n0\u00070\u0006H\u0016J\u0012\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0010\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\n0\u0016\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014JW\u0010\u000f\u001a\u0002H\u0017\"\b\b\u0000\u0010\n*\u00020\u000b\"\u000e\b\u0001\u0010\u0017*\b\u0012\u0004\u0012\u0002H\n0\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142 \u0010\u0018\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00170\u0006\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\u0010\u001bJS\u0010\u000f\u001a\u0002H\u0017\"\b\b\u0000\u0010\n*\u00020\u000b\"\u000e\b\u0001\u0010\u0017*\b\u0012\u0004\u0012\u0002H\n0\u00072\u0006\u0010\u0013\u001a\u00020\u001c2 \u0010\u0018\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00170\u0006\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u0019H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ-\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0010\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001dJ%\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0010\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ%\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\n0\u0016\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$R*\u0010\u0004\u001a\u001e\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lxyz/xenondevs/nova/registry/NovaRegistryAccess;", "Lnet/minecraft/core/RegistryAccess;", "<init>", "()V", "registries", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "lookup", "Ljava/util/Optional;", "E", "", "registry", "Ljava/util/stream/Stream;", "Lnet/minecraft/core/RegistryAccess$RegistryEntry;", "addRegistry", "Lnet/minecraft/core/WritableRegistry;", "addon", "Lxyz/xenondevs/nova/addon/Addon;", "registryName", "", "addFuzzyRegistry", "Lxyz/xenondevs/nova/registry/FuzzyMappedRegistry;", "R", "registryConstructor", "Lkotlin/Function2;", "Lcom/mojang/serialization/Lifecycle;", "(Lxyz/xenondevs/nova/addon/Addon;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Lnet/minecraft/core/Registry;", "Lnet/minecraft/resources/ResourceLocation;", "addRegistry$nova", "(Lnet/minecraft/resources/ResourceLocation;Lkotlin/jvm/functions/Function2;)Lnet/minecraft/core/Registry;", "namespace", "path", "addFuzzyRegistry$nova", "freezeAll", "", "freezeAll$nova", "nova"})
@SourceDebugExtension(value={"SMAP\nNovaRegistryAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NovaRegistryAccess.kt\nxyz/xenondevs/nova/registry/NovaRegistryAccess\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,75:1\n1#2:76\n216#3,2:77\n*S KotlinDebug\n*F\n+ 1 NovaRegistryAccess.kt\nxyz/xenondevs/nova/registry/NovaRegistryAccess\n*L\n72#1:77,2\n*E\n"})
public final class NovaRegistryAccess
implements RegistryAccess {
    @NotNull
    public static final NovaRegistryAccess INSTANCE = new NovaRegistryAccess();
    @NotNull
    private static final Object2ObjectOpenHashMap<ResourceKey<? extends Registry<?>>, Registry<?>> registries = new Object2ObjectOpenHashMap();

    private NovaRegistryAccess() {
    }

    @NotNull
    public <E> Optional<Registry<E>> lookup(@NotNull ResourceKey<? extends Registry<? extends E>> registry) {
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        Object object = registries.get(registry);
        Optional<Registry<E>> optional = Optional.ofNullable(object instanceof Registry ? (Registry)object : null);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public Stream<RegistryAccess.RegistryEntry<?>> registries() {
        return StreamsKt.asStream((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence((Map)((Map)registries)), NovaRegistryAccess::registries$lambda$0));
    }

    @NotNull
    public final <E> WritableRegistry<E> addRegistry(@NotNull Addon addon, @NotNull String registryName) {
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        Intrinsics.checkNotNullParameter((Object)registryName, (String)"registryName");
        return this.addRegistry$nova(NMSUtilsKt.ResourceLocation(addon, registryName));
    }

    @NotNull
    public final <E> FuzzyMappedRegistry<E> addFuzzyRegistry(@NotNull Addon addon, @NotNull String registryName) {
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        Intrinsics.checkNotNullParameter((Object)registryName, (String)"registryName");
        return (FuzzyMappedRegistry)((Object)this.addRegistry$nova(NMSUtilsKt.ResourceLocation(addon, registryName), addFuzzyRegistry.1.INSTANCE));
    }

    @NotNull
    public final <E, R extends Registry<E>> R addRegistry(@NotNull Addon addon, @NotNull String registryName, @NotNull Function2<? super ResourceKey<? extends R>, ? super Lifecycle, ? extends R> registryConstructor) {
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        Intrinsics.checkNotNullParameter((Object)registryName, (String)"registryName");
        Intrinsics.checkNotNullParameter(registryConstructor, (String)"registryConstructor");
        return this.addRegistry$nova(NMSUtilsKt.ResourceLocation(addon, registryName), registryConstructor);
    }

    @NotNull
    public final <E, R extends Registry<E>> R addRegistry$nova(@NotNull ResourceLocation registryName, @NotNull Function2<? super ResourceKey<? extends R>, ? super Lifecycle, ? extends R> registryConstructor) {
        Intrinsics.checkNotNullParameter((Object)registryName, (String)"registryName");
        Intrinsics.checkNotNullParameter(registryConstructor, (String)"registryConstructor");
        ResourceKey resourceKey = ResourceKey.createRegistryKey((ResourceLocation)registryName);
        if (!(!((Map)registries).containsKey(resourceKey))) {
            boolean bl = false;
            String string = "Duplicate registry " + resourceKey;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)resourceKey, (String)"null cannot be cast to non-null type net.minecraft.resources.ResourceKey<out R of xyz.xenondevs.nova.registry.NovaRegistryAccess.addRegistry>");
        Lifecycle lifecycle = Lifecycle.stable();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"stable(...)");
        Registry registry = (Registry)registryConstructor.invoke((Object)resourceKey, (Object)lifecycle);
        if (!Intrinsics.areEqual((Object)registry.key(), (Object)resourceKey)) {
            boolean bl = false;
            String string = "Registry " + resourceKey + " has wrong key (expected " + resourceKey + ", got " + registry.key() + ")";
            throw new IllegalArgumentException(string.toString());
        }
        ((Map)registries).put(resourceKey, registry);
        return (R)registry;
    }

    @NotNull
    public final <E> WritableRegistry<E> addRegistry$nova(@NotNull String namespace, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return (WritableRegistry)this.addRegistry$nova(resourceLocation, addRegistry.3.INSTANCE);
    }

    @NotNull
    public final <E> WritableRegistry<E> addRegistry$nova(@NotNull ResourceLocation registryName) {
        Intrinsics.checkNotNullParameter((Object)registryName, (String)"registryName");
        return (WritableRegistry)this.addRegistry$nova(registryName, addRegistry.4.INSTANCE);
    }

    @NotNull
    public final <E> FuzzyMappedRegistry<E> addFuzzyRegistry$nova(@NotNull ResourceLocation registryName) {
        Intrinsics.checkNotNullParameter((Object)registryName, (String)"registryName");
        return (FuzzyMappedRegistry)((Object)this.addRegistry$nova(registryName, addFuzzyRegistry.2.INSTANCE));
    }

    public final void freezeAll$nova() {
        Map $this$forEach$iv = (Map)registries;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            ((Registry)it.getValue()).freeze();
        }
    }

    private static final RegistryAccess.RegistryEntry registries$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object k = it.getKey();
        Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type net.minecraft.resources.ResourceKey<out net.minecraft.core.Registry<kotlin.Any>>");
        ResourceKey resourceKey = (ResourceKey)k;
        Object v = it.getValue();
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type net.minecraft.core.Registry<kotlin.Any>");
        return new RegistryAccess.RegistryEntry(resourceKey, (Registry)v);
    }
}

