/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.model.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix2d;
import org.joml.Matrix2dc;
import org.joml.Matrix4d;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import xyz.xenondevs.commons.collections.ListsKt;
import xyz.xenondevs.nova.resources.builder.model.Model;
import xyz.xenondevs.nova.resources.builder.model.transform.ElementTransformException;
import xyz.xenondevs.nova.resources.builder.model.transform.NonContextualModelBuildAction;
import xyz.xenondevs.nova.resources.builder.model.transform.Transform;
import xyz.xenondevs.nova.util.MathUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0001@B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J$\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0002J*\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0002J*\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0002J0\u0010.\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u00100\u001a\u00020#2\u0006\u0010*\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020'H\u0002J\t\u00104\u001a\u00020\u0004H\u00c6\u0003J\t\u00105\u001a\u00020\u0006H\u00c6\u0003J\t\u00106\u001a\u00020\bH\u00c6\u0003J\t\u00107\u001a\u00020\nH\u00c6\u0003J\t\u00108\u001a\u00020\nH\u00c6\u0003J;\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010:\u001a\u00020\n2\b\u0010;\u001a\u0004\u0018\u00010<H\u00d6\u0003J\t\u0010=\u001a\u00020'H\u00d6\u0001J\t\u0010>\u001a\u00020?H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006A"}, d2={"Lxyz/xenondevs/nova/resources/builder/model/transform/RotationTransform;", "Lxyz/xenondevs/nova/resources/builder/model/transform/NonContextualModelBuildAction;", "Lxyz/xenondevs/nova/resources/builder/model/transform/Transform;", "pivot", "Lorg/joml/Vector3dc;", "axis", "Lxyz/xenondevs/nova/resources/builder/model/Model$Axis;", "rot", "", "uvLock", "", "rescale", "<init>", "(Lorg/joml/Vector3dc;Lxyz/xenondevs/nova/resources/builder/model/Model$Axis;DZZ)V", "getPivot", "()Lorg/joml/Vector3dc;", "getAxis", "()Lxyz/xenondevs/nova/resources/builder/model/Model$Axis;", "getRot", "()D", "getUvLock", "()Z", "getRescale", "apply", "", "matrix", "Lorg/joml/Matrix4d;", "Lxyz/xenondevs/nova/resources/builder/model/Model;", "model", "rotatedElements", "", "Lxyz/xenondevs/nova/resources/builder/model/Model$Element;", "elements", "rotatedFacesUvLocked", "", "Lxyz/xenondevs/nova/resources/builder/model/Model$Direction;", "Lxyz/xenondevs/nova/resources/builder/model/Model$Element$Face;", "element", "rots", "", "rotatedUv", "Lorg/joml/Vector4dc;", "dir", "face", "rotatedUvReordered", "uv", "rotatedFaces", "faces", "rotatedDirection", "rotated", "v", "fullRots", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "", "Companion", "nova"})
@SourceDebugExtension(value={"SMAP\nRotationTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RotationTransform.kt\nxyz/xenondevs/nova/resources/builder/model/transform/RotationTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nxyz/xenondevs/commons/collections/MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1563#2:314\n1634#2,3:315\n17#3:318\n17#3:320\n1#4:319\n*S KotlinDebug\n*F\n+ 1 RotationTransform.kt\nxyz/xenondevs/nova/resources/builder/model/transform/RotationTransform\n*L\n63#1:314\n63#1:315,3\n129#1:318\n225#1:320\n*E\n"})
public final class RotationTransform
implements NonContextualModelBuildAction,
Transform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3dc pivot;
    @NotNull
    private final Model.Axis axis;
    private final double rot;
    private final boolean uvLock;
    private final boolean rescale;
    @NotNull
    private static final List<Model.Direction> AROUND_X;
    @NotNull
    private static final List<Model.Direction> AROUND_Y;
    @NotNull
    private static final List<Model.Direction> AROUND_Z;

    public RotationTransform(@NotNull Vector3dc pivot, @NotNull Model.Axis axis, double rot, boolean uvLock, boolean rescale) {
        Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        this.pivot = pivot;
        this.axis = axis;
        this.rot = rot;
        this.uvLock = uvLock;
        this.rescale = rescale;
    }

    @NotNull
    public final Vector3dc getPivot() {
        return this.pivot;
    }

    @NotNull
    public final Model.Axis getAxis() {
        return this.axis;
    }

    public final double getRot() {
        return this.rot;
    }

    public final boolean getUvLock() {
        return this.uvLock;
    }

    public final boolean getRescale() {
        return this.rescale;
    }

    @Override
    public void apply(@NotNull Matrix4d matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        if (this.uvLock) {
            throw new UnsupportedOperationException("UV lock is not supported in matrix transformations");
        }
        if (this.rescale) {
            throw new UnsupportedOperationException("Rescale is not supported in matrix transformations");
        }
        matrix.translateLocal(-((double)8 - this.pivot.x()) / (double)16, -((double)8 - this.pivot.y()) / (double)16, -((double)8 - this.pivot.z()) / (double)16);
        switch (WhenMappings.$EnumSwitchMapping$0[this.axis.ordinal()]) {
            case 1: {
                Matrix4d matrix4d = matrix.rotateLocalX(org.joml.Math.toRadians((double)this.rot));
                break;
            }
            case 2: {
                Matrix4d matrix4d = matrix.rotateLocalY(org.joml.Math.toRadians((double)this.rot));
                break;
            }
            case 3: {
                Matrix4d matrix4d = matrix.rotateLocalZ(org.joml.Math.toRadians((double)this.rot));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        matrix.translateLocal(((double)8 - this.pivot.x()) / (double)16, ((double)8 - this.pivot.y()) / (double)16, ((double)8 - this.pivot.z()) / (double)16);
    }

    @Override
    @NotNull
    public Model apply(@NotNull Model model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        List<Model.Element> list = model.getElements();
        if (list == null) {
            throw new IllegalArgumentException("Model does not define elements list");
        }
        List<Model.Element> elements = list;
        return Model.copy$default(model, null, null, this.rotatedElements(elements), null, null, null, 59, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Model.Element> rotatedElements(List<Model.Element> elements) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void element;
            Model.Element element2 = (Model.Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Model.Element.Rotation rotation = element.getRotation();
            double rot = this.rot % (double)360;
            if (rotation != null) {
                if (rotation.getAxis() == this.axis && Intrinsics.areEqual((Object)rotation.getOrigin(), (Object)this.pivot)) {
                    rot += rotation.getAngle();
                    rotation = null;
                } else if (!(rot % (double)90 == 0.0)) {
                    throw new ElementTransformException("Rotation angle " + rot + " requires rotation property, but it is already occupied by a different axis or pivot.", this, (Model.Element)element);
                }
            }
            int fullRots = (int)(rot / (double)90);
            double angle = rot % (double)90;
            if (Math.abs(angle) > 45.0) {
                fullRots = (fullRots + (int)Math.signum(angle)) % 4;
                angle -= Math.signum(angle) * (double)90;
            }
            Vector3dc from = null;
            Vector3dc to = null;
            if (fullRots != 0) {
                Pair sorted = RotationTransform.Companion.sort(this.rotated(element.getFrom(), fullRots), this.rotated(element.getTo(), fullRots));
                from = (Vector3dc)sorted.getFirst();
                to = (Vector3dc)sorted.getSecond();
            } else {
                from = element.getFrom();
                to = element.getTo();
            }
            if (rotation != null) {
                if (!(angle == 0.0)) {
                    throw new IllegalStateException("Check failed.");
                }
                Vector3d direction = new Vector3d();
                MathUtilsKt.set(direction, rotation.getAxis(), rotation.getAngle());
                MathUtilsKt.rotate(direction, this.axis, 1.5707963267948966 * (double)fullRots);
                Model.Axis newAxis = MathUtilsKt.firstNonZeroAxis((Vector3dc)direction);
                if (!(newAxis != null)) {
                    throw new IllegalStateException("Check failed.");
                }
                Model.Element.Rotation rotation2 = rotation;
                Vector3dc vector3dc = this.rotated(rotation.getOrigin(), fullRots);
                Model.Axis axis = newAxis;
                double d = MathUtilsKt.get((Vector3dc)direction, newAxis);
                rotation = Model.Element.Rotation.copy$default(rotation2, d, axis, vector3dc, false, 8, null);
            } else if (!(angle == 0.0)) {
                rotation = new Model.Element.Rotation(angle, this.axis, this.pivot, this.rescale);
            }
            collection.add(Model.Element.copy$default((Model.Element)element, from, to, rotation, this.uvLock ? this.rotatedFacesUvLocked((Model.Element)element, fullRots) : this.rotatedFaces(element.getFaces(), fullRots), false, 0, 48, null));
        }
        return (List)destination$iv$iv;
    }

    private final Map<Model.Direction, Model.Element.Face> rotatedFacesUvLocked(Model.Element element, int rots) {
        Map<Model.Direction, Model.Element.Face> faces = element.getFaces();
        if (rots == 0) {
            return faces;
        }
        boolean $i$f$enumMap = false;
        EnumMap result = new EnumMap(Model.Direction.class);
        for (Model.Direction dir : Model.Direction.getEntries()) {
            Model.Element.Face face;
            if (faces.get((Object)dir) == null) continue;
            if (dir.getAxis() != this.axis) {
                Model.Direction direction;
                Model.Direction newDir = this.rotatedDirection(dir, rots);
                int r = switch (WhenMappings.$EnumSwitchMapping$0[this.axis.ordinal()]) {
                    case 1 -> {
                        if (dir == Model.Direction.NORTH) {
                            yield 2;
                        }
                        if (newDir == Model.Direction.NORTH) {
                            yield -2;
                        }
                        yield 0;
                    }
                    case 3 -> rots;
                    case 2 -> 0;
                    default -> throw new NoWhenBranchMatchedException();
                };
                Map map2 = result;
                Object object = this.rotatedUv(element, dir, face, r);
                int n = face.getRotation() + r * 90;
                int n2 = 360;
                int n3 = n % n2;
                int n4 = n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31);
                if (face.getCullface() != null) {
                    boolean bl = false;
                    direction = this.rotatedDirection(dir, rots);
                } else {
                    direction = null;
                }
                Model.Direction direction2 = direction;
                object = Model.Element.Face.copy$default(face, object, null, direction2, n4, 0, 18, null);
                map2.put(newDir, object);
                continue;
            }
            ((Map)result).put(dir, Model.Element.Face.copy$default(face, this.rotatedUvReordered(element, dir, face, rots * -RotationTransform.Companion.dirSign(dir)), null, null, 0, 0, 30, null));
        }
        return result;
    }

    private final Vector4dc rotatedUv(Model.Element element, Model.Direction dir, Model.Element.Face face, int rots) {
        if (rots == 0) {
            return face.getUv();
        }
        Vector4dc vector4dc = face.getUv();
        if (vector4dc == null) {
            vector4dc = element.generateUV(dir);
        }
        Vector4dc uv = vector4dc;
        return this.rotatedUv(uv, rots);
    }

    private final Vector4dc rotatedUvReordered(Model.Element element, Model.Direction dir, Model.Element.Face face, int rots) {
        Vector4dc uv;
        if (rots == 0) {
            return face.getUv();
        }
        Vector4dc vector4dc = face.getUv();
        if (vector4dc == null) {
            vector4dc = element.generateUV(dir);
        }
        boolean mirrorU = (uv = vector4dc).x() > uv.z();
        boolean mirrorV = uv.y() > uv.w();
        Vector4dc vector4dc2 = this.rotatedUv(uv, rots);
        double u0 = MathUtilsKt.component1(vector4dc2);
        double v0 = MathUtilsKt.component2(vector4dc2);
        double u1 = MathUtilsKt.component3(vector4dc2);
        double v1 = MathUtilsKt.component4(vector4dc2);
        double minU = Math.min(u0, u1);
        double minV = Math.min(v0, v1);
        double maxU = Math.max(u0, u1);
        double maxV = Math.max(v0, v1);
        return (Vector4dc)new Vector4d(mirrorU ? maxU : minU, mirrorV ? maxV : minV, mirrorU ? minU : maxU, mirrorV ? minV : maxV);
    }

    private final Vector4dc rotatedUv(Vector4dc uv, int rots) {
        Vector2d uv0 = new Vector2d(uv.x() - (double)8, uv.y() - (double)8);
        Vector2d uv1 = new Vector2d(uv.z() - (double)8, uv.w() - (double)8);
        Matrix2d rot = new Matrix2d().rotate(1.5707963267948966 * (double)rots);
        uv0.mul((Matrix2dc)rot);
        uv1.mul((Matrix2dc)rot);
        return (Vector4dc)new Vector4d(uv0.x + 8.0, uv0.y + 8.0, uv1.x + 8.0, uv1.y + 8.0);
    }

    private final Map<Model.Direction, Model.Element.Face> rotatedFaces(Map<Model.Direction, Model.Element.Face> faces, int rots) {
        if (rots == 0) {
            return faces;
        }
        boolean $i$f$enumMap = false;
        EnumMap result = new EnumMap(Model.Direction.class);
        for (Model.Direction dir : Model.Direction.getEntries()) {
            Model.Direction direction;
            int n;
            Model.Element.Face face;
            if (faces.get((Object)dir) == null) continue;
            if (dir.getAxis() == this.axis) {
                Map map2 = result;
                int n2 = face.getRotation() + rots * 90 * -RotationTransform.Companion.dirSign(dir);
                int n3 = 360;
                n = n2 % n3;
                Model.Element.Face face2 = Model.Element.Face.copy$default(face, null, null, null, n + (n3 & ((n ^ n3) & (n | -n)) >> 31), 0, 23, null);
                map2.put(dir, face2);
                continue;
            }
            Model.Direction newDir = this.rotatedDirection(dir, rots);
            int rotation = switch (WhenMappings.$EnumSwitchMapping$0[this.axis.ordinal()]) {
                case 1 -> {
                    if (dir == Model.Direction.NORTH) {
                        yield -180;
                    }
                    if (newDir == Model.Direction.NORTH) {
                        yield 180;
                    }
                    yield 0;
                }
                case 3 -> -90 * rots;
                case 2 -> 0;
                default -> throw new NoWhenBranchMatchedException();
            };
            Map map3 = result;
            int n4 = face.getRotation() + rotation;
            int n5 = 360;
            int n6 = n4 % n5;
            n = n6 + (n5 & ((n6 ^ n5) & (n6 | -n6)) >> 31);
            if (face.getCullface() != null) {
                boolean bl = false;
                direction = this.rotatedDirection(dir, rots);
            } else {
                direction = null;
            }
            Model.Direction direction2 = direction;
            Model.Element.Face face3 = Model.Element.Face.copy$default(face, null, null, direction2, n, 0, 19, null);
            map3.put(newDir, face3);
        }
        return result;
    }

    private final Model.Direction rotatedDirection(Model.Direction dir, int rots) {
        return (Model.Direction)((Object)ListsKt.after((List)RotationTransform.Companion.directionsAround(this.axis), (Object)((Object)dir), (int)rots));
    }

    private final Vector3dc rotated(Vector3dc v, int fullRots) {
        Vector3d result = new Vector3d(v);
        result.sub(this.pivot);
        double radians = org.joml.Math.toRadians((double)(90.0 * (double)fullRots));
        switch (WhenMappings.$EnumSwitchMapping$0[this.axis.ordinal()]) {
            case 1: {
                Vector3d vector3d = result.rotateX(radians);
                break;
            }
            case 2: {
                Vector3d vector3d = result.rotateY(radians);
                break;
            }
            case 3: {
                Vector3d vector3d = result.rotateZ(radians);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        result.add(this.pivot);
        MathUtilsKt.round(result, 10);
        return (Vector3dc)result;
    }

    @NotNull
    public final Vector3dc component1() {
        return this.pivot;
    }

    @NotNull
    public final Model.Axis component2() {
        return this.axis;
    }

    public final double component3() {
        return this.rot;
    }

    public final boolean component4() {
        return this.uvLock;
    }

    public final boolean component5() {
        return this.rescale;
    }

    @NotNull
    public final RotationTransform copy(@NotNull Vector3dc pivot, @NotNull Model.Axis axis, double rot, boolean uvLock, boolean rescale) {
        Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        return new RotationTransform(pivot, axis, rot, uvLock, rescale);
    }

    public static /* synthetic */ RotationTransform copy$default(RotationTransform rotationTransform, Vector3dc vector3dc, Model.Axis axis, double d, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            vector3dc = rotationTransform.pivot;
        }
        if ((n & 2) != 0) {
            axis = rotationTransform.axis;
        }
        if ((n & 4) != 0) {
            d = rotationTransform.rot;
        }
        if ((n & 8) != 0) {
            bl = rotationTransform.uvLock;
        }
        if ((n & 0x10) != 0) {
            bl2 = rotationTransform.rescale;
        }
        return rotationTransform.copy(vector3dc, axis, d, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "RotationTransform(pivot=" + this.pivot + ", axis=" + this.axis + ", rot=" + this.rot + ", uvLock=" + this.uvLock + ", rescale=" + this.rescale + ")";
    }

    public int hashCode() {
        int result = this.pivot.hashCode();
        result = result * 31 + this.axis.hashCode();
        result = result * 31 + Double.hashCode(this.rot);
        result = result * 31 + Boolean.hashCode(this.uvLock);
        result = result * 31 + Boolean.hashCode(this.rescale);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RotationTransform)) {
            return false;
        }
        RotationTransform rotationTransform = (RotationTransform)other;
        if (!Intrinsics.areEqual((Object)this.pivot, (Object)rotationTransform.pivot)) {
            return false;
        }
        if (this.axis != rotationTransform.axis) {
            return false;
        }
        if (Double.compare(this.rot, rotationTransform.rot) != 0) {
            return false;
        }
        if (this.uvLock != rotationTransform.uvLock) {
            return false;
        }
        return this.rescale == rotationTransform.rescale;
    }

    static {
        Model.Direction[] directionArray = new Model.Direction[]{Model.Direction.NORTH, Model.Direction.UP, Model.Direction.SOUTH, Model.Direction.DOWN};
        AROUND_X = CollectionsKt.listOf((Object[])directionArray);
        directionArray = new Model.Direction[]{Model.Direction.NORTH, Model.Direction.WEST, Model.Direction.SOUTH, Model.Direction.EAST};
        AROUND_Y = CollectionsKt.listOf((Object[])directionArray);
        directionArray = new Model.Direction[]{Model.Direction.UP, Model.Direction.WEST, Model.Direction.DOWN, Model.Direction.EAST};
        AROUND_Z = CollectionsKt.listOf((Object[])directionArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/resources/builder/model/transform/RotationTransform$Companion;", "", "<init>", "()V", "AROUND_X", "", "Lxyz/xenondevs/nova/resources/builder/model/Model$Direction;", "AROUND_Y", "AROUND_Z", "directionsAround", "axis", "Lxyz/xenondevs/nova/resources/builder/model/Model$Axis;", "dirSign", "", "dir", "sort", "Lkotlin/Pair;", "Lorg/joml/Vector3dc;", "a", "b", "nova"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Model.Direction> directionsAround(Model.Axis axis) {
            return switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
                case 1 -> AROUND_X;
                case 2 -> AROUND_Y;
                case 3 -> AROUND_Z;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final int dirSign(Model.Direction dir) {
            return switch (WhenMappings.$EnumSwitchMapping$1[dir.ordinal()]) {
                case 1, 2, 3 -> 1;
                case 4, 5, 6 -> -1;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final Pair<Vector3dc, Vector3dc> sort(Vector3dc a, Vector3dc b) {
            Vector3d min = new Vector3d(Math.min(a.x(), b.x()), Math.min(a.y(), b.y()), Math.min(a.z(), b.z()));
            Vector3d max = new Vector3d(Math.max(a.x(), b.x()), Math.max(a.y(), b.y()), Math.max(a.z(), b.z()));
            return TuplesKt.to((Object)min, (Object)max);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Model.Axis.values().length];
                try {
                    nArray[Model.Axis.X.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Model.Axis.Y.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Model.Axis.Z.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Model.Direction.values().length];
                try {
                    nArray[Model.Direction.SOUTH.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Model.Direction.EAST.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Model.Direction.UP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Model.Direction.NORTH.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Model.Direction.WEST.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Model.Direction.DOWN.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Model.Axis.values().length];
            try {
                nArray[Model.Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Model.Axis.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Model.Axis.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

