/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.model.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import xyz.xenondevs.nova.resources.builder.model.Model;
import xyz.xenondevs.nova.resources.builder.model.transform.NonContextualModelBuildAction;
import xyz.xenondevs.nova.resources.builder.model.transform.Transform;
import xyz.xenondevs.nova.util.MathUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J*\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u0011\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\t\u0010(\u001a\u00020\u0004H\u00c6\u0003J\t\u0010)\u001a\u00020\u0004H\u00c6\u0003J\t\u0010*\u001a\u00020\u0007H\u00c6\u0003J\t\u0010+\u001a\u00020\u0007H\u00c6\u0003J1\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00072\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u00020\u001eH\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u00063"}, d2={"Lxyz/xenondevs/nova/resources/builder/model/transform/ScaleTransform;", "Lxyz/xenondevs/nova/resources/builder/model/transform/NonContextualModelBuildAction;", "Lxyz/xenondevs/nova/resources/builder/model/transform/Transform;", "pivot", "Lorg/joml/Vector3dc;", "scale", "scaleUV", "", "keepDisplaySize", "<init>", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;ZZ)V", "getPivot", "()Lorg/joml/Vector3dc;", "getScale", "getScaleUV", "()Z", "getKeepDisplaySize", "apply", "Lxyz/xenondevs/nova/resources/builder/model/Model;", "model", "scaled", "v", "scaledUV", "Lorg/joml/Vector4dc;", "face", "Lxyz/xenondevs/nova/resources/builder/model/Model$Direction;", "from", "to", "uv", "rotation", "", "uvPivot", "Lorg/joml/Vector2dc;", "uvScale", "getUVAxes", "Lkotlin/Triple;", "Lorg/joml/Vector3d;", "", "matrix", "Lorg/joml/Matrix4d;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "", "nova"})
@SourceDebugExtension(value={"SMAP\nScaleTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleTransform.kt\nxyz/xenondevs/nova/resources/builder/model/transform/ScaleTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,150:1\n1563#2:151\n1634#2,2:152\n1252#2,4:157\n1636#2:161\n1252#2,4:164\n1#3:154\n463#4:155\n413#4:156\n463#4:162\n413#4:163\n*S KotlinDebug\n*F\n+ 1 ScaleTransform.kt\nxyz/xenondevs/nova/resources/builder/model/transform/ScaleTransform\n*L\n32#1:151\n32#1:152,2\n36#1:157,4\n32#1:161\n50#1:164,4\n36#1:155\n36#1:156\n50#1:162\n50#1:163\n*E\n"})
public final class ScaleTransform
implements NonContextualModelBuildAction,
Transform {
    @NotNull
    private final Vector3dc pivot;
    @NotNull
    private final Vector3dc scale;
    private final boolean scaleUV;
    private final boolean keepDisplaySize;

    public ScaleTransform(@NotNull Vector3dc pivot, @NotNull Vector3dc scale, boolean scaleUV, boolean keepDisplaySize) {
        Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        this.pivot = pivot;
        this.scale = scale;
        this.scaleUV = scaleUV;
        this.keepDisplaySize = keepDisplaySize;
    }

    public /* synthetic */ ScaleTransform(Vector3dc vector3dc, Vector3dc vector3dc2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(vector3dc, vector3dc2, bl, bl2);
    }

    @NotNull
    public final Vector3dc getPivot() {
        return this.pivot;
    }

    @NotNull
    public final Vector3dc getScale() {
        return this.scale;
    }

    public final boolean getScaleUV() {
        return this.scaleUV;
    }

    public final boolean getKeepDisplaySize() {
        return this.keepDisplaySize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Model apply(@NotNull Model model) {
        Object object;
        Map.Entry entry;
        Iterable element;
        Object object2;
        Map<Model.Display.Position, Model.Display.Entry> $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        List list = model.getElements();
        if (list == null) {
            throw new IllegalArgumentException("Model does not define elements list");
        }
        List elements = list;
        Iterable $this$map$iv = elements;
        boolean $i$f$map = false;
        Object object3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Map map2;
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Model.Element.Rotation rotation;
            Model.Element.Rotation rotation2;
            void it;
            Vector3dc vector3dc;
            Object object4;
            Object item$iv$iv = iterator.next();
            Model.Element element2 = (Model.Element)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            void v1 = element;
            Vector3dc vector3dc2 = this.scaled(((Model.Element)((Object)element)).getFrom());
            Vector3dc vector3dc3 = this.scaled(((Model.Element)((Object)element)).getTo());
            if (((Model.Element)((Object)element)).getRotation() != null) {
                object4 = vector3dc3;
                vector3dc = vector3dc2;
                entry = v1;
                boolean bl2 = false;
                rotation2 = Model.Element.Rotation.copy$default((Model.Element.Rotation)it, 0.0, null, this.scaled(it.getOrigin()), false, 11, null);
                v1 = entry;
                vector3dc2 = vector3dc;
                vector3dc3 = object4;
                rotation = rotation2;
            } else {
                rotation = null;
            }
            object = ((Model.Element)((Object)element)).getFaces();
            rotation2 = rotation;
            object4 = vector3dc3;
            vector3dc = vector3dc2;
            entry = v1;
            boolean $i$f$mapValues = false;
            it = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Vector4dc uv;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv$iv;
                boolean bl3 = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                map2 = map3;
                boolean bl4 = false;
                Model.Direction direction = (Model.Direction)((Object)entry3.getKey());
                Model.Element.Face face = (Model.Element.Face)entry3.getValue();
                Vector4dc vector4dc = face.getUv();
                if (vector4dc == null) {
                    vector4dc = uv = ((Model.Element)((Object)element)).generateUV(direction);
                }
                if (this.scaleUV) {
                    uv = this.scaledUV(direction, ((Model.Element)((Object)element)).getFrom(), ((Model.Element)((Object)element)).getTo(), uv, face.getRotation());
                }
                Model.Element.Face face2 = Model.Element.Face.copy$default(face, uv, null, null, 0, 0, 30, null);
                map2.put(k, face2);
            }
            map2 = destination$iv$iv$iv;
            object2.add(Model.Element.copy$default((Model.Element)((Object)entry), vector3dc, (Vector3dc)object4, rotation2, map2, false, 0, 48, null));
        }
        elements = (List)destination$iv$iv;
        Model.Display display = model.getDisplay();
        if (this.keepDisplaySize) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Vector3d inverseScale = new Vector3d(1.0, 1.0, 1.0).div(this.scale, new Vector3d());
            $this$mapTo$iv$iv = display.toEffectiveMap();
            boolean $i$f$mapValues = false;
            void $i$f$mapTo2 = $this$mapValues$iv;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            element = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv$iv;
                boolean bl = false;
                object = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object2 = map4;
                boolean bl5 = false;
                Model.Display.Entry dp = (Model.Display.Entry)object.getValue();
                Vector3d vector3d = dp.getScale().mul((Vector3dc)inverseScale, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
                Model.Display.Entry entry4 = Model.Display.Entry.copy$default(dp, null, null, (Vector3dc)vector3d, 3, null);
                object2.put(k, entry4);
            }
            object3 = destination$iv$iv$iv;
            Model.Display.Companion companion = Model.Display.Companion;
            Object p0 = object3;
            boolean bl = false;
            display = companion.of((Map<Model.Display.Position, Model.Display.Entry>)p0);
        }
        return Model.copy$default(model, null, null, elements, null, null, display, 27, null);
    }

    private final Vector3dc scaled(Vector3dc v) {
        Vector3d vector3d = new Vector3d(v).sub(this.pivot).mul(this.scale).add(this.pivot);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
        return (Vector3dc)vector3d;
    }

    private final Vector4dc scaledUV(Model.Direction face, Vector3dc from, Vector3dc to, Vector4dc uv, int rotation) {
        Triple<Vector3d, Vector3d, Vector3d> triple = this.getUVAxes(face, rotation);
        Vector3d uv0 = (Vector3d)triple.component1();
        Vector3d uAxis = (Vector3d)triple.component2();
        Vector3d vAxis = (Vector3d)triple.component3();
        Vector3d elementSize = new Vector3d(to).sub(from);
        Vector3d relPivot = new Vector3d(this.pivot).div((Vector3dc)elementSize).sub((Vector3dc)uv0);
        Vector2d uvSize = new Vector2d(uv.z(), uv.w()).sub(uv.x(), uv.y());
        Vector2d uvScale = new Vector2d(uAxis.dot(this.scale), vAxis.dot(this.scale)).absolute();
        Vector2d uvPivot = new Vector2d(uAxis.dot((Vector3dc)relPivot), vAxis.dot((Vector3dc)relPivot)).mul((Vector2dc)uvSize).add((Vector2dc)new Vector2d(uv.x(), uv.y()));
        Intrinsics.checkNotNull((Object)uvPivot);
        Vector2dc vector2dc = (Vector2dc)uvPivot;
        Intrinsics.checkNotNull((Object)uvScale);
        return this.scaledUV(uv, vector2dc, (Vector2dc)uvScale);
    }

    private final Vector4dc scaledUV(Vector4dc uv, Vector2dc uvPivot, Vector2dc uvScale) {
        Vector2d from = new Vector2d(uv.x(), uv.y());
        Vector2d to = new Vector2d(uv.z(), uv.w());
        from.sub(uvPivot).mul(uvScale).add(uvPivot);
        to.sub(uvPivot).mul(uvScale).add(uvPivot);
        return (Vector4dc)new Vector4d(from.x(), from.y(), to.x(), to.y());
    }

    private final Triple<Vector3d, Vector3d, Vector3d> getUVAxes(Model.Direction face, int rotation) {
        Vector3d uv0 = new Vector3d(0.0, 1.0, 1.0);
        Vector3d u = new Vector3d(1.0, 0.0, 0.0);
        Vector3d v = new Vector3d(0.0, -1.0, 0.0);
        switch (WhenMappings.$EnumSwitchMapping$0[face.ordinal()]) {
            case 1: {
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.Z, -((double)rotation));
                break;
            }
            case 2: {
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.Y, 90.0);
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.X, -((double)rotation));
                break;
            }
            case 3: {
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.Y, 180.0);
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.Z, rotation);
                break;
            }
            case 4: {
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.Y, 270.0);
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.X, rotation);
                break;
            }
            case 5: {
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.X, -90.0);
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.Y, -((double)rotation));
                break;
            }
            case 6: {
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.X, 90.0);
                ScaleTransform.getUVAxes$rotate(uv0, v, u, Model.Axis.Y, rotation);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new Triple((Object)uv0, (Object)u, (Object)v);
    }

    @Override
    public void apply(@NotNull Matrix4d matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        if (this.scaleUV) {
            throw new UnsupportedOperationException("Cannot apply UV adjustments to a matrix");
        }
        matrix.translateLocal(-((double)8 - this.pivot.x()) / (double)16, -((double)8 - this.pivot.y()) / (double)16, -((double)8 - this.pivot.z()) / (double)16);
        matrix.scaleLocal(this.scale.x(), this.scale.y(), this.scale.z());
        matrix.translateLocal(((double)8 - this.pivot.x()) / (double)16, ((double)8 - this.pivot.y()) / (double)16, ((double)8 - this.pivot.z()) / (double)16);
    }

    @NotNull
    public final Vector3dc component1() {
        return this.pivot;
    }

    @NotNull
    public final Vector3dc component2() {
        return this.scale;
    }

    public final boolean component3() {
        return this.scaleUV;
    }

    public final boolean component4() {
        return this.keepDisplaySize;
    }

    @NotNull
    public final ScaleTransform copy(@NotNull Vector3dc pivot, @NotNull Vector3dc scale, boolean scaleUV, boolean keepDisplaySize) {
        Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        return new ScaleTransform(pivot, scale, scaleUV, keepDisplaySize);
    }

    public static /* synthetic */ ScaleTransform copy$default(ScaleTransform scaleTransform, Vector3dc vector3dc, Vector3dc vector3dc2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            vector3dc = scaleTransform.pivot;
        }
        if ((n & 2) != 0) {
            vector3dc2 = scaleTransform.scale;
        }
        if ((n & 4) != 0) {
            bl = scaleTransform.scaleUV;
        }
        if ((n & 8) != 0) {
            bl2 = scaleTransform.keepDisplaySize;
        }
        return scaleTransform.copy(vector3dc, vector3dc2, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "ScaleTransform(pivot=" + this.pivot + ", scale=" + this.scale + ", scaleUV=" + this.scaleUV + ", keepDisplaySize=" + this.keepDisplaySize + ")";
    }

    public int hashCode() {
        int result = this.pivot.hashCode();
        result = result * 31 + this.scale.hashCode();
        result = result * 31 + Boolean.hashCode(this.scaleUV);
        result = result * 31 + Boolean.hashCode(this.keepDisplaySize);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScaleTransform)) {
            return false;
        }
        ScaleTransform scaleTransform = (ScaleTransform)other;
        if (!Intrinsics.areEqual((Object)this.pivot, (Object)scaleTransform.pivot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scale, (Object)scaleTransform.scale)) {
            return false;
        }
        if (this.scaleUV != scaleTransform.scaleUV) {
            return false;
        }
        return this.keepDisplaySize == scaleTransform.keepDisplaySize;
    }

    private static final void getUVAxes$rotate(Vector3d uv0, Vector3d v, Vector3d u, Model.Axis axis, double angleDeg) {
        double angleRad = Math.toRadians(angleDeg);
        Vector3d vector3d = uv0.sub(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"sub(...)");
        MathUtilsKt.rotate(vector3d, axis, angleRad).add(0.5, 0.5, 0.5);
        MathUtilsKt.rotate(v, axis, angleRad);
        MathUtilsKt.rotate(u, axis, angleRad);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Model.Direction.values().length];
            try {
                nArray[Model.Direction.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Model.Direction.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Model.Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Model.Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Model.Direction.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Model.Direction.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

