/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.task;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.commons.collections.ListsKt;
import xyz.xenondevs.nova.registry.NovaRegistries;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.resources.ResourceType;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.data.EquipmentDefinition;
import xyz.xenondevs.nova.resources.builder.layout.equipment.AnimatedEquipmentLayout;
import xyz.xenondevs.nova.resources.builder.layout.equipment.EquipmentLayout;
import xyz.xenondevs.nova.resources.builder.layout.equipment.InterpolationMode;
import xyz.xenondevs.nova.resources.builder.layout.equipment.StaticEquipmentLayout;
import xyz.xenondevs.nova.resources.builder.task.BuildStage;
import xyz.xenondevs.nova.resources.builder.task.ExtractTask;
import xyz.xenondevs.nova.resources.builder.task.PackBuildData;
import xyz.xenondevs.nova.resources.builder.task.PackTask;
import xyz.xenondevs.nova.resources.builder.task.RuntimeEquipmentData;
import xyz.xenondevs.nova.resources.builder.task.TextureContent;
import xyz.xenondevs.nova.resources.lookup.ResourceLookups;
import xyz.xenondevs.nova.util.MathUtils;
import xyz.xenondevs.nova.util.data.ImageUtils;
import xyz.xenondevs.nova.world.item.Equipment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010 \u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010\"J\u001e\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00192\u0006\u0010'\u001a\u00020(H\u0002J\u001e\u0010)\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00192\u0006\u0010'\u001a\u00020*H\u0002J\u0018\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\u0006\u0010'\u001a\u00020*H\u0002J$\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00192\u0006\u0010'\u001a\u00020*H\u0002J,\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00\u00190,\"\b\b\u0000\u00100*\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H003H\u0002J$\u00104\u001a\u00020!2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c0,2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001c0,H\u0002J,\u00107\u001a\u00020!2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u00107\u001a\u00020!2\u0006\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001cH\u0002J9\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00\u00190,\"\b\b\u0000\u00100*\u00020\u001a2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H00>2\u0006\u0010?\u001a\u0002H0H\u0002\u00a2\u0006\u0002\u0010@J\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001c0,2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030>H\u0002J2\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001c0,2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010E\u001a\u00020\u001fH\u0002J9\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00\u00190,\"\b\b\u0000\u00100*\u00020\u001a2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001c0,2\u0006\u0010?\u001a\u0002H0H\u0002\u00a2\u0006\u0002\u0010HJ-\u0010I\u001a\b\u0012\u0004\u0012\u0002H00\u0019\"\b\b\u0000\u00100*\u00020\u001a2\u0006\u0010J\u001a\u00020\u001c2\u0006\u0010?\u001a\u0002H0H\u0002\u00a2\u0006\u0002\u0010KJ\u0010\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020NH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013Rf\u0010\u0016\u001aZ\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u0017j,\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O\u00b2\u0006\n\u0010P\u001a\u00020\u001cX\u008a\u0084\u0002\u00b2\u0006\n\u0010Q\u001a\u00020\u001cX\u008a\u0084\u0002"}, d2={"Lxyz/xenondevs/nova/resources/builder/task/EquipmentTask;", "Lxyz/xenondevs/nova/resources/builder/task/PackTask;", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "<init>", "(Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;)V", "stage", "Lxyz/xenondevs/nova/resources/builder/task/BuildStage;", "getStage", "()Lxyz/xenondevs/nova/resources/builder/task/BuildStage;", "runsAfter", "", "Lkotlin/reflect/KClass;", "Lxyz/xenondevs/nova/resources/builder/task/ExtractTask;", "getRunsAfter", "()Ljava/util/Set;", "textureContent", "Lxyz/xenondevs/nova/resources/builder/task/TextureContent;", "getTextureContent", "()Lxyz/xenondevs/nova/resources/builder/task/TextureContent;", "textureContent$delegate", "Lkotlin/Lazy;", "interpolationCache", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$PngFile;", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Ljava/awt/image/BufferedImage;", "Lkotlin/collections/HashMap;", "generatedCount", "", "run", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generatedStaticEquipmentModel", "Lxyz/xenondevs/nova/resources/builder/task/RuntimeEquipmentData;", "id", "Lxyz/xenondevs/nova/resources/ResourceType$Equipment;", "layout", "Lxyz/xenondevs/nova/resources/builder/layout/equipment/StaticEquipmentLayout;", "generateAnimatedEquipmentModel", "Lxyz/xenondevs/nova/resources/builder/layout/equipment/AnimatedEquipmentLayout;", "generateAnimatedCameraOverlay", "", "Lnet/kyori/adventure/key/Key;", "generateAnimatedEquipmentTexture", "generateLayerAnimation", "T", "Lxyz/xenondevs/nova/resources/ResourceType$EquipmentTexture;", "layer", "Lxyz/xenondevs/nova/resources/builder/layout/equipment/AnimatedEquipmentLayout$Layer;", "applyEmissivityMaps", "textureFrames", "emissivityMapFrames", "applyEmissivityMap", "texture", "emissivityMap", "textureDir", "", "generateTextureAnimation", "animation", "Lxyz/xenondevs/nova/resources/builder/layout/equipment/AnimatedEquipmentLayout$Animation;", "location", "(Lxyz/xenondevs/nova/resources/builder/layout/equipment/AnimatedEquipmentLayout$Animation;Lxyz/xenondevs/nova/resources/ResourceType$PngFile;)Ljava/util/List;", "generateTextureAnimationImages", "generateInterpolatedImages", "from", "to", "count", "writeImages", "images", "(Ljava/util/List;Lxyz/xenondevs/nova/resources/ResourceType$PngFile;)Ljava/util/List;", "writeImage", "image", "(Ljava/awt/image/BufferedImage;Lxyz/xenondevs/nova/resources/ResourceType$PngFile;)Lxyz/xenondevs/nova/resources/ResourcePath;", "validateEquipmentModel", "model", "Lxyz/xenondevs/nova/resources/builder/data/EquipmentDefinition;", "nova", "fromImage", "toImage"})
@SourceDebugExtension(value={"SMAP\nEquipmentTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EquipmentTask.kt\nxyz/xenondevs/nova/resources/builder/task/EquipmentTask\n+ 2 ResourcePackBuilder.kt\nxyz/xenondevs/nova/resources/builder/ResourcePackBuilder\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 IOUtils.kt\nxyz/xenondevs/nova/util/data/IOUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,322:1\n380#2:323\n476#2,4:330\n480#2:338\n476#2,4:361\n480#2:369\n1285#3,2:324\n1299#3,4:326\n1252#3,2:342\n1563#3:344\n1634#3,3:345\n1255#3:348\n1252#3,2:354\n1563#3:356\n1634#3,3:357\n1255#3:360\n1563#3:370\n1634#3,3:371\n1563#3:374\n1634#3,3:375\n1563#3:379\n1634#3,3:380\n1563#3:383\n1634#3,3:384\n1563#3:401\n1634#3,3:402\n100#4:334\n101#4:337\n100#4:365\n101#4:368\n1#5:335\n1#5:339\n1#5:366\n1#5:378\n42#6:336\n42#6:367\n463#7:340\n413#7:341\n463#7:352\n413#7:353\n382#7,7:387\n382#7,7:394\n1292#8,3:349\n*S KotlinDebug\n*F\n+ 1 EquipmentTask.kt\nxyz/xenondevs/nova/resources/builder/task/EquipmentTask\n*L\n55#1:323\n86#1:330,4\n86#1:338\n141#1:361,4\n141#1:369\n65#1:324,2\n65#1:326,4\n119#1:342,2\n119#1:344\n119#1:345,3\n119#1:348\n132#1:354,2\n133#1:356\n133#1:357,3\n132#1:360\n157#1:370\n157#1:371,3\n158#1:374\n158#1:375,3\n253#1:379\n253#1:380,3\n255#1:383\n255#1:384,3\n300#1:401\n300#1:402,3\n86#1:334\n86#1:337\n141#1:365\n141#1:368\n86#1:335\n141#1:366\n86#1:336\n141#1:367\n119#1:340\n119#1:341\n132#1:352\n132#1:353\n288#1:387,7\n289#1:394,7\n124#1:349,3\n*E\n"})
public final class EquipmentTask
implements PackTask {
    @NotNull
    private final ResourcePackBuilder builder;
    @NotNull
    private final BuildStage stage;
    @NotNull
    private final Set<KClass<ExtractTask>> runsAfter;
    @NotNull
    private final Lazy textureContent$delegate;
    @NotNull
    private final HashMap<Pair<ResourcePath<ResourceType.PngFile>, ResourcePath<ResourceType.PngFile>>, Int2ObjectMap<BufferedImage>> interpolationCache;
    private int generatedCount;

    public EquipmentTask(@NotNull ResourcePackBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.stage = BuildStage.PRE_WORLD;
        this.runsAfter = SetsKt.setOf((Object)Reflection.getOrCreateKotlinClass(ExtractTask.class));
        ResourcePackBuilder this_$iv = this.builder;
        boolean $i$f$getBuildDataLazily = false;
        this.textureContent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TextureContent>(this_$iv){
            final /* synthetic */ ResourcePackBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            public final TextureContent invoke() {
                PackBuildData holder$iv;
                Object v0;
                block3: {
                    ResourcePackBuilder this_$iv = this.this$0;
                    boolean $i$f$getBuildData = false;
                    Iterable $this$firstOrNull$iv$iv = this_$iv.getData();
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv$iv : $this$firstOrNull$iv$iv) {
                        PackBuildData it$iv = (PackBuildData)element$iv$iv;
                        boolean bl = false;
                        if (!(it$iv instanceof TextureContent)) continue;
                        v0 = element$iv$iv;
                        break block3;
                    }
                    v0 = null;
                }
                PackBuildData packBuildData = v0;
                if (packBuildData == null) {
                    throw new IllegalArgumentException("No holder of type " + Reflection.getOrCreateKotlinClass(TextureContent.class).getSimpleName() + " is present");
                }
                PackBuildData packBuildData2 = holder$iv = packBuildData;
                if (packBuildData2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type xyz.xenondevs.nova.resources.builder.task.TextureContent");
                }
                return (TextureContent)packBuildData2;
            }
        }));
        this.interpolationCache = new HashMap();
    }

    @Override
    @NotNull
    public BuildStage getStage() {
        return this.stage;
    }

    @NotNull
    public Set<KClass<ExtractTask>> getRunsAfter() {
        return this.runsAfter;
    }

    private final TextureContent getTextureContent() {
        Lazy lazy = this.textureContent$delegate;
        return (TextureContent)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object run(@NotNull Continuation<? super Unit> $completion) {
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        Iterable iterable = (Iterable)NovaRegistries.EQUIPMENT;
        ResourceLookups resourceLookups = ResourceLookups.INSTANCE;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void var5_6 = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            RuntimeEquipmentData runtimeEquipmentData;
            void equipment;
            Equipment equipment2 = (Equipment)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            ResourcePath<ResourceType> path = ResourcePath.Companion.of((ResourceType)ResourceType.Equipment.INSTANCE, equipment.getId());
            EquipmentLayout layout = (EquipmentLayout)equipment.getMakeLayout$nova().invoke((Object)this.builder);
            if (layout instanceof StaticEquipmentLayout) {
                runtimeEquipmentData = this.generatedStaticEquipmentModel(path, (StaticEquipmentLayout)layout);
            } else if (layout instanceof AnimatedEquipmentLayout) {
                runtimeEquipmentData = this.generateAnimatedEquipmentModel(path, (AnimatedEquipmentLayout)layout);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            RuntimeEquipmentData runtimeEquipmentData2 = runtimeEquipmentData;
            map2.put(t, runtimeEquipmentData2);
        }
        resourceLookups.setEQUIPMENT(destination$iv$iv);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final RuntimeEquipmentData generatedStaticEquipmentModel(ResourcePath<ResourceType.Equipment> id, StaticEquipmentLayout layout) {
        List list;
        void $this$writeJson$iv$iv;
        void path$iv;
        Object equipmentType;
        for (Map.Entry<EquipmentDefinition.Type, List<StaticEquipmentLayout.Layer<?>>> object2 : layout.getTypes().entrySet()) {
            equipmentType = object2.getKey();
            List<StaticEquipmentLayout.Layer<?>> layers = object2.getValue();
            for (StaticEquipmentLayout.Layer<?> layer : layers) {
                if (layer.getEmissivityMap() == null) continue;
                this.applyEmissivityMap(layer.getTexture(), layer.getEmissivityMap(), "textures/entity/equipment/" + equipmentType + "/");
            }
        }
        EquipmentDefinition model = layout.toEquipmentModel();
        this.validateEquipmentModel(model);
        ResourcePackBuilder resourcePackBuilder = this.builder;
        equipmentType = id;
        Object value$iv = model;
        Json json$iv = (Json)Json.Default;
        boolean $i$f$writeJson = false;
        Path file$iv = resourcePackBuilder.resolve((ResourcePath<?>)path$iv);
        Path path = file$iv.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
        path2 = file$iv;
        object = value$iv;
        Json json$iv$iv = json$iv;
        boolean $i$f$writeJson2 = false;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream((Path)$this$writeJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            void value$iv$iv$iv;
            void $this$encodeToStream$iv$iv$iv;
            void value$iv$iv;
            OutputStream it$iv$iv = (OutputStream)closeable;
            boolean bl = false;
            Json json = json$iv$iv;
            void var19_24 = value$iv$iv;
            OutputStream stream$iv$iv$iv = it$iv$iv;
            boolean $i$f$encodeToStream = false;
            $this$encodeToStream$iv$iv$iv.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv$iv$iv, (SerializationStrategy)((SerializationStrategy)EquipmentDefinition.Companion.serializer()), (Object)value$iv$iv$iv, (OutputStream)stream$iv$iv$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        List list2 = CollectionsKt.listOf(id);
        ResourcePath<ResourceType.Texture> resourcePath = layout.getCameraOverlay();
        if (resourcePath != null) {
            void it;
            value$iv = resourcePath;
            List list3 = list2;
            boolean bl = false;
            list = CollectionsKt.listOf((Object)it);
            list2 = list3;
        } else {
            list = null;
        }
        List list4 = list;
        List list5 = list2;
        return new RuntimeEquipmentData(list5, list4);
    }

    private final RuntimeEquipmentData generateAnimatedEquipmentModel(ResourcePath<ResourceType.Equipment> id, AnimatedEquipmentLayout layout) {
        List<Key> textureFrames = this.generateAnimatedEquipmentTexture(id, layout);
        List<Key> cameraOverlayFrames = this.generateAnimatedCameraOverlay(layout);
        return new RuntimeEquipmentData(textureFrames, cameraOverlayFrames);
    }

    private final List<Key> generateAnimatedCameraOverlay(AnimatedEquipmentLayout layout) {
        AnimatedEquipmentLayout.Animation<ResourceType.Texture> cameraOverlay = layout.getCameraOverlay();
        int cameraOverlayFrameCount = 0;
        List<ResourcePath<ResourceType.PngFile>> cameraOverlayFrames = null;
        if (cameraOverlay != null) {
            cameraOverlayFrameCount = cameraOverlay.getFrames().size() * cameraOverlay.getTicksPerFrame();
            cameraOverlayFrames = this.generateTextureAnimation(cameraOverlay, (ResourceType.PngFile)ResourceType.Texture.INSTANCE);
        } else {
            cameraOverlayFrameCount = 0;
            cameraOverlayFrames = CollectionsKt.emptyList();
        }
        return (List)xyz.xenondevs.commons.collections.CollectionsKt.takeUnlessEmpty((Collection)cameraOverlayFrames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Key> generateAnimatedEquipmentTexture(ResourcePath<ResourceType.Equipment> id, AnimatedEquipmentLayout layout) {
        void $this$fold$iv;
        Object object;
        Map.Entry $this$mapTo$iv$iv;
        Object object2;
        Map<EquipmentDefinition.Type, List<AnimatedEquipmentLayout.Layer<?>>> it$iv$iv;
        Object object3;
        Iterator $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map<EquipmentDefinition.Type, List<AnimatedEquipmentLayout.Layer<?>>> $this$mapValues$iv = layout.getTypes();
        boolean $i$f$mapValues22 = false;
        Map<EquipmentDefinition.Type, List<AnimatedEquipmentLayout.Layer<?>>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo2 = false;
        Iterator iterator = $this$associateByTo$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv = iterator.next();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            object3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            List layers = (List)object3.getValue();
            Iterable $this$map$iv = layers;
            boolean $i$f$map = false;
            object2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void p0;
                Object item$iv$iv = iterator2.next();
                object = (AnimatedEquipmentLayout.Layer)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(this.generateLayerAnimation((AnimatedEquipmentLayout.Layer)p0));
            }
            List list = (List)destination$iv$iv2;
            map4.put(k, list);
        }
        Map animations = destination$iv$iv$iv;
        Sequence $i$f$mapValues22 = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)animations.values()));
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void layer;
            List $i$f$associateByTo2 = (List)element$iv;
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = MathUtils.INSTANCE.lcm(acc, layer.size());
        }
        int textureFrameCount = accumulator$iv;
        ArrayList textureFrames = new ArrayList(textureFrameCount);
        for (int j = 0; j < textureFrameCount; ++j) {
            void $this$writeJson$iv$iv;
            void path$iv;
            void $this$iv;
            EquipmentDefinition.Type equipmentType;
            Object object4;
            void $this$associateByTo$iv$iv$iv2;
            void $this$mapValuesTo$iv$iv2;
            int frame = j;
            boolean bl = false;
            ResourcePath<ResourceType> path = new ResourcePath<ResourceType>(ResourceType.Equipment.INSTANCE, id.getNamespace(), id.getPath() + "_" + frame);
            ((Collection)textureFrames).add(path);
            Object $this$mapValues$iv2 = layout.getTypes();
            boolean $i$f$mapValues32 = false;
            it$iv$iv = $this$mapValues$iv2;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
            boolean $i$f$mapValuesTo2 = false;
            object3 = $this$mapValuesTo$iv$iv2.entrySet();
            Object destination$iv$iv$iv2 = destination$iv$iv3;
            boolean $i$f$associateByTo22 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void $this$mapTo$iv$iv2;
                void it$iv$iv2;
                $this$mapTo$iv$iv = (Map.Entry)element$iv$iv$iv;
                object4 = destination$iv$iv$iv2;
                boolean bl4 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv2.getKey();
                object = object4;
                boolean bl5 = false;
                equipmentType = (EquipmentDefinition.Type)((Object)entry.getKey());
                List layers = (List)entry.getValue();
                Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)layers);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                    Collection collection = destination$iv$iv4;
                    boolean bl6 = false;
                    int layerIdx = indexedValue.component1();
                    AnimatedEquipmentLayout.Layer layer = (AnimatedEquipmentLayout.Layer)indexedValue.component2();
                    Object v = animations.get((Object)equipmentType);
                    Intrinsics.checkNotNull(v);
                    List layerFrames = (List)((List)v).get(layerIdx);
                    ResourcePath texture = (ResourcePath)layerFrames.get(frame % layerFrames.size());
                    collection.add(new EquipmentDefinition.Layer(texture, false, layer.getDyeable()));
                }
                List list = (List)destination$iv$iv4;
                object.put(k, list);
            }
            Map map5 = destination$iv$iv$iv2;
            EquipmentDefinition equipmentDefinitionForFrame = new EquipmentDefinition(map5);
            $this$mapValues$iv2 = this.builder;
            ResourcePath<ResourceType> $i$f$mapValues32 = path;
            EquipmentDefinition value$iv = equipmentDefinitionForFrame;
            Json json$iv = (Json)Json.Default;
            boolean $i$f$writeJson = false;
            Path file$iv = $this$iv.resolve((ResourcePath<?>)path$iv);
            Path path2 = file$iv.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            destination$iv$iv$iv2 = path2;
            Object $i$f$associateByTo22 = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)destination$iv$iv$iv2, Arrays.copyOf($i$f$associateByTo22, ((FileAttribute[])$i$f$associateByTo22).length)), (String)"createDirectories(...)");
            destination$iv$iv$iv2 = file$iv;
            $i$f$associateByTo22 = value$iv;
            Json json$iv$iv = json$iv;
            boolean $i$f$writeJson2 = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream((Path)$this$writeJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            object2 = outputStream;
            object4 = null;
            try {
                void value$iv$iv$iv;
                void $this$encodeToStream$iv$iv$iv;
                void value$iv$iv;
                OutputStream it$iv$iv3 = (OutputStream)object2;
                boolean bl7 = false;
                Json bl5 = json$iv$iv;
                equipmentType = value$iv$iv;
                OutputStream stream$iv$iv$iv = it$iv$iv3;
                boolean $i$f$encodeToStream = false;
                $this$encodeToStream$iv$iv$iv.getSerializersModule();
                JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv$iv$iv, (SerializationStrategy)((SerializationStrategy)EquipmentDefinition.Companion.serializer()), (Object)value$iv$iv$iv, (OutputStream)stream$iv$iv$iv);
                Unit unit = Unit.INSTANCE;
                continue;
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object4);
            }
        }
        return textureFrames;
    }

    private final <T extends ResourceType.EquipmentTexture> List<ResourcePath<T>> generateLayerAnimation(AnimatedEquipmentLayout.Layer<? extends T> layer) {
        if (layer.getEmissivityMap() != null) {
            BufferedImage p0;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            List textureImages = this.generateTextureAnimationImages(layer.getTexture());
            List emissivityMapImages = this.generateTextureAnimationImages(layer.getEmissivityMap());
            int frameCount = MathUtils.INSTANCE.lcm(textureImages.size(), emissivityMapImages.size());
            Iterable iterable = ListsKt.repeated(textureImages, (int)(frameCount / textureImages.size()));
            ImageUtils imageUtils = ImageUtils.INSTANCE;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                BufferedImage bufferedImage = (BufferedImage)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(imageUtils.copyToARGB(p0));
            }
            textureImages = (List)destination$iv$iv;
            $this$map$iv = ListsKt.repeated(emissivityMapImages, (int)(frameCount / emissivityMapImages.size()));
            imageUtils = ImageUtils.INSTANCE;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (BufferedImage)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(imageUtils.copyToARGB(p0));
            }
            emissivityMapImages = (List)destination$iv$iv;
            this.applyEmissivityMaps(textureImages, emissivityMapImages);
            return this.writeImages(textureImages, (ResourceType.PngFile)layer.getResourceType());
        }
        return this.generateTextureAnimation(layer.getTexture(), (ResourceType.PngFile)layer.getResourceType());
    }

    private final void applyEmissivityMaps(List<? extends BufferedImage> textureFrames, List<? extends BufferedImage> emissivityMapFrames) {
        if (!(textureFrames.size() == emissivityMapFrames.size())) {
            boolean $i$a$-require-EquipmentTask$applyEmissivityMaps$22 = false;
            String $i$a$-require-EquipmentTask$applyEmissivityMaps$22 = "Texture and emissivity map frame counts don't match";
            throw new IllegalArgumentException($i$a$-require-EquipmentTask$applyEmissivityMaps$22.toString());
        }
        ArrayList emissiveFrames = new ArrayList();
        int n = ((Collection)textureFrames).size();
        for (int frame = 0; frame < n; ++frame) {
            BufferedImage texture = textureFrames.get(frame);
            BufferedImage emissivityMap = emissivityMapFrames.get(frame);
            this.applyEmissivityMap(texture, emissivityMap);
            ((Collection)emissiveFrames).add(texture);
        }
    }

    private final void applyEmissivityMap(ResourcePath<? extends ResourceType.PngFile> texture, ResourcePath<? extends ResourceType.PngFile> emissivityMap, String textureDir) {
        BufferedImage textureImage = ImageUtils.INSTANCE.copyToARGB(this.getTextureContent().getImage(texture));
        BufferedImage emissivityMapImage = this.getTextureContent().getImage(emissivityMap);
        this.applyEmissivityMap(textureImage, emissivityMapImage);
        this.builder.writeImage(texture, textureImage);
    }

    private final void applyEmissivityMap(BufferedImage texture, BufferedImage emissivityMap) {
        if (!(texture.getWidth() == emissivityMap.getWidth() && texture.getHeight() == emissivityMap.getHeight())) {
            boolean bl = false;
            String string = "Emissivity map must have the same dimensions as the texture";
            throw new IllegalArgumentException(string.toString());
        }
        int n = texture.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = texture.getHeight();
            for (int y = 0; y < n2; ++y) {
                int rgb = texture.getRGB(x, y);
                if (rgb >> 24 == 0) continue;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                int emissivity = emissivityMap.getRGB(x, y) & 0xFF;
                int alpha = RangesKt.coerceAtLeast((int)(255 - emissivity), (int)1);
                texture.setRGB(x, y, alpha << 24 | red << 16 | green << 8 | blue);
            }
        }
    }

    private final <T extends ResourceType.PngFile> List<ResourcePath<T>> generateTextureAnimation(AnimatedEquipmentLayout.Animation<? extends T> animation, T location) {
        List<ResourcePath<T>> keyFrames = animation.component1();
        int ticksPerFrame = animation.component2();
        InterpolationMode interpolationMode = animation.component3();
        if (interpolationMode == InterpolationMode.NONE) {
            return ListsKt.eachRepeated(keyFrames, (int)ticksPerFrame);
        }
        ArrayList frames = new ArrayList(keyFrames.size() * ticksPerFrame);
        Iterator iterator = ((Iterable)keyFrames).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int keyFrameId = n++;
            ResourcePath keyFrame = (ResourcePath)iterator.next();
            ((Collection)frames).add(keyFrame);
            CollectionsKt.addAll((Collection)frames, (Iterable)this.writeImages(this.generateInterpolatedImages(keyFrame, keyFrames.get((keyFrameId + 1) % keyFrames.size()), ticksPerFrame - 1), location));
        }
        return frames;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BufferedImage> generateTextureAnimationImages(AnimatedEquipmentLayout.Animation<?> animation) {
        Collection collection;
        void $this$mapTo$iv$iv;
        List<ResourcePath<?>> keyFrames = animation.component1();
        int ticksPerFrame = animation.component2();
        InterpolationMode interpolationMode = animation.component3();
        Iterable $this$map$iv = keyFrames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourcePath resourcePath = (ResourcePath)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getTextureContent().getImage((ResourcePath<? extends ResourceType.PngFile>)it));
        }
        List keyFrameImages = (List)destination$iv$iv;
        if (interpolationMode == InterpolationMode.NONE) {
            void $this$mapTo$iv$iv2;
            $this$map$iv = ListsKt.eachRepeated((List)keyFrameImages, (int)ticksPerFrame);
            ImageUtils imageUtils = ImageUtils.INSTANCE;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p0;
                BufferedImage bl = (BufferedImage)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(imageUtils.copyToARGB((BufferedImage)p0));
            }
            return (List)destination$iv$iv2;
        }
        ArrayList frames = new ArrayList(keyFrames.size() * ticksPerFrame);
        Iterator iterator = ((Iterable)keyFrames).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int keyFrameId = n++;
            ResourcePath keyFrame = (ResourcePath)iterator.next();
            ((Collection)frames).add(this.getTextureContent().getImage(keyFrame));
            CollectionsKt.addAll((Collection)frames, (Iterable)this.generateInterpolatedImages(keyFrame, keyFrames.get((keyFrameId + 1) % keyFrames.size()), ticksPerFrame - 1));
        }
        return frames;
    }

    private final List<BufferedImage> generateInterpolatedImages(ResourcePath<? extends ResourceType.PngFile> from, ResourcePath<? extends ResourceType.PngFile> to, int count) {
        if (count <= 0) {
            return CollectionsKt.emptyList();
        }
        Lazy<BufferedImage> fromImage$delegate = this.getTextureContent().getImageLazily(from);
        Lazy<BufferedImage> toImage$delegate = this.getTextureContent().getImageLazily(to);
        ArrayList interpolatedImages = new ArrayList();
        for (int frame = 0; frame < count; ++frame) {
            Object object;
            Object object2;
            Map $this$getOrPut$iv;
            int progress = frame * 255 / count;
            Collection collection = interpolatedImages;
            Map map2 = this.interpolationCache;
            Object key$iv = TuplesKt.to(from, to);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Int2ObjectOpenHashMap answer$iv = new Int2ObjectOpenHashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            $this$getOrPut$iv = (Map)object2;
            key$iv = progress;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                BufferedImage answer$iv = ImageUtils.INSTANCE.lerp(EquipmentTask.generateInterpolatedImages$lambda$0(fromImage$delegate), EquipmentTask.generateInterpolatedImages$lambda$1(toImage$delegate), (float)progress / 255.0f);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            map2 = object;
            collection.add(map2);
        }
        return interpolatedImages;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends ResourceType.PngFile> List<ResourcePath<T>> writeImages(List<? extends BufferedImage> images, T location) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = images;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BufferedImage bufferedImage = (BufferedImage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.writeImage((BufferedImage)it, location));
        }
        return (List)destination$iv$iv;
    }

    private final <T extends ResourceType.PngFile> ResourcePath<T> writeImage(BufferedImage image, T location) {
        int n = this.generatedCount;
        this.generatedCount = n + 1;
        ResourcePath<ResourceType> path = new ResourcePath<ResourceType>(location, "nova", "generated/equipment_" + n);
        this.builder.writeImage(path, image);
        return path;
    }

    private final void validateEquipmentModel(EquipmentDefinition model) {
        Iterator<Map.Entry<EquipmentDefinition.Type, List<EquipmentDefinition.Layer>>> iterator = model.getLayers().entrySet().iterator();
        while (iterator.hasNext()) {
            List<EquipmentDefinition.Layer> layers = iterator.next().getValue();
            for (EquipmentDefinition.Layer layer : layers) {
                this.builder.findOrThrow(layer.getTexture());
            }
        }
    }

    private static final BufferedImage generateInterpolatedImages$lambda$0(Lazy<? extends BufferedImage> $fromImage$delegate) {
        Lazy<? extends BufferedImage> lazy = $fromImage$delegate;
        return (BufferedImage)lazy.getValue();
    }

    private static final BufferedImage generateInterpolatedImages$lambda$1(Lazy<? extends BufferedImage> $toImage$delegate) {
        Lazy<? extends BufferedImage> lazy = $toImage$delegate;
        return (BufferedImage)lazy.getValue();
    }
}

