/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.task;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.io.path.CopyActionContext;
import kotlin.io.path.CopyActionResult;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.resources.builder.AssetPack;
import xyz.xenondevs.nova.resources.builder.PNGMetadataRemover;
import xyz.xenondevs.nova.resources.builder.ResourceFilter;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.task.PackTask;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0007H\u0002J,\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/resources/builder/task/ExtractTask;", "Lxyz/xenondevs/nova/resources/builder/task/PackTask;", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "<init>", "(Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;)V", "run", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractMinecraftAssets", "extractAssetPacks", "extractAssetPack", "assetPack", "Lxyz/xenondevs/nova/resources/builder/AssetPack;", "namespaceDir", "Ljava/nio/file/Path;", "fileFilter", "Lkotlin/Function1;", "", "", "nova"})
@SourceDebugExtension(value={"SMAP\nExtractTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractTask.kt\nxyz/xenondevs/nova/resources/builder/task/ExtractTask\n+ 2 IOUtils.kt\nxyz/xenondevs/nova/util/data/IOUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n64#2,3:104\n1#3:107\n1#3:108\n1740#4,3:109\n1740#4,3:112\n*S KotlinDebug\n*F\n+ 1 ExtractTask.kt\nxyz/xenondevs/nova/resources/builder/task/ExtractTask\n*L\n34#1:104,3\n34#1:107\n45#1:109,3\n66#1:112,3\n*E\n"})
public final class ExtractTask
implements PackTask {
    @NotNull
    private final ResourcePackBuilder builder;

    public ExtractTask(@NotNull ResourcePackBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
    }

    @Override
    @Nullable
    public Object run(@NotNull Continuation<? super Unit> $completion) {
        this.extractMinecraftAssets();
        this.extractAssetPacks();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void extractMinecraftAssets() {
        List<ResourceFilter> filters = this.builder.getResourceFilters(ResourceFilter.Stage.ASSET_PACK);
        Path $this$useZip_u24default$iv = NovaBootstrapperKt.getNOVA_JAR();
        boolean create$iv = false;
        boolean $i$f$useZip = false;
        Map env$iv = MapsKt.emptyMap();
        Closeable closeable = FileSystems.newFileSystem($this$useZip_u24default$iv, env$iv);
        Throwable throwable = null;
        try {
            FileSystem it$iv = (FileSystem)closeable;
            boolean bl = false;
            Iterable<Path> iterable = it$iv.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
            Object object = CollectionsKt.first(iterable);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            Path zip = (Path)object;
            boolean bl2 = false;
            Path path = zip.resolve("assets/minecraft/");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path path2 = PathsKt.copyToRecursively$default((Path)path, (Path)this.builder.resolve("assets/minecraft/"), null, (boolean)false, (arg_0, arg_1, arg_2) -> ExtractTask.extractMinecraftAssets$lambda$0$0(this, filters, arg_0, arg_1, arg_2), (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void extractAssetPacks() {
        List<ResourceFilter> filters = this.builder.getResourceFilters(ResourceFilter.Stage.ASSET_PACK);
        for (AssetPack pack : this.builder.getAssetPacks()) {
            String namespace = pack.getNamespace();
            this.extractAssetPack(pack, this.builder.resolve("assets/" + namespace), (Function1<? super String, Boolean>)((Function1)arg_0 -> ExtractTask.extractAssetPacks$lambda$0(filters, arg_0)));
        }
    }

    private final void extractAssetPack(AssetPack assetPack, Path namespaceDir, Function1<? super String, Boolean> fileFilter) {
        Path it;
        String namespace = assetPack.getNamespace();
        Path path = assetPack.getTexturesDir();
        if (path != null) {
            it = path;
            boolean bl = false;
            ExtractTask.extractAssetPack$extractDir(namespaceDir, fileFilter, namespace, it, "textures");
        }
        Path path2 = assetPack.getFontsDir();
        if (path2 != null) {
            it = path2;
            boolean bl = false;
            ExtractTask.extractAssetPack$extractDir(namespaceDir, fileFilter, namespace, it, "font");
        }
        Path path3 = assetPack.getSoundsDir();
        if (path3 != null) {
            it = path3;
            boolean bl = false;
            ExtractTask.extractAssetPack$extractDir(namespaceDir, fileFilter, namespace, it, "sounds");
        }
        Path path4 = assetPack.getSoundsFile();
        if (path4 != null) {
            Path path5 = path4;
            Path path6 = namespaceDir.resolve("sounds.json");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
            Path path7 = path6;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Path path8 = Files.copy(path5, path7, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
            v6 = path8;
            Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"copy(...)");
        } else {
            v6 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CopyActionResult extractMinecraftAssets$lambda$0$0(ExtractTask this$0, List $filters, CopyActionContext $this$copyToRecursively, Path source, Path target) {
        boolean bl;
        block17: {
            Intrinsics.checkNotNullParameter((Object)$this$copyToRecursively, (String)"$this$copyToRecursively");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(source, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return CopyActionResult.CONTINUE;
            }
            Path relPath = PathsKt.relativeTo((Path)target, (Path)this$0.builder.resolve("assets/minecraft/"));
            Iterable $this$all$iv = $filters;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ResourceFilter filter = (ResourceFilter)element$iv;
                    boolean bl2 = false;
                    if (filter.allows("minecraft/" + relPath)) continue;
                    bl = false;
                    break block17;
                }
                bl = true;
            }
        }
        if (!bl) {
            return CopyActionResult.SKIP_SUBTREE;
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(source, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            Long l;
            InputStream ins = (InputStream)closeable;
            boolean bl3 = false;
            Path path = target.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            Object object = path;
            Object object2 = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"createDirectories(...)");
            OpenOption[] openOptionArray2 = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(target, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            object = outputStream;
            object2 = null;
            try {
                Long l2;
                OutputStream out = (OutputStream)object;
                boolean bl4 = false;
                if (StringsKt.equals((String)PathsKt.getExtension((Path)source), (String)"png", (boolean)true)) {
                    PNGMetadataRemover.INSTANCE.remove(ins, out);
                    l2 = Unit.INSTANCE;
                } else {
                    l2 = ins.transferTo(out);
                }
                l = l2;
            }
            catch (Throwable throwable2) {
                object2 = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            Long l3 = l;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return CopyActionResult.CONTINUE;
    }

    private static final boolean extractAssetPacks$lambda$0(List $filters, String path) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$all$iv = $filters;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ResourceFilter it = (ResourceFilter)element$iv;
                    boolean bl2 = false;
                    if (it.allows(path)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final void extractAssetPack$extractDir(Path $namespaceDir, Function1<? super String, Boolean> $fileFilter, String namespace, Path sourceDir, String dirName) {
        Path path = $namespaceDir.resolve(dirName + "/");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        PathsKt.copyToRecursively$default((Path)sourceDir, (Path)path, null, (boolean)false, (arg_0, arg_1, arg_2) -> ExtractTask.extractAssetPack$extractDir$lambda$0(sourceDir, $fileFilter, namespace, dirName, arg_0, arg_1, arg_2), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CopyActionResult extractAssetPack$extractDir$lambda$0(Path $sourceDir, Function1 $fileFilter, String $namespace, String $dirName, CopyActionContext $this$copyToRecursively, Path source, Path target) {
        Intrinsics.checkNotNullParameter((Object)$this$copyToRecursively, (String)"$this$copyToRecursively");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(source, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CopyActionResult.CONTINUE;
        }
        String relPath = PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)source, (Path)$sourceDir));
        if (!((Boolean)$fileFilter.invoke((Object)($namespace + "/" + $dirName + "/" + relPath))).booleanValue()) {
            return CopyActionResult.SKIP_SUBTREE;
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(source, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            Long l;
            InputStream ins = (InputStream)closeable;
            boolean bl = false;
            Path path = target.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            Object object = path;
            Object object2 = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"createDirectories(...)");
            OpenOption[] openOptionArray2 = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(target, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            object = outputStream;
            object2 = null;
            try {
                Long l2;
                OutputStream out = (OutputStream)object;
                boolean bl2 = false;
                if (StringsKt.equals((String)PathsKt.getExtension((Path)source), (String)"png", (boolean)true)) {
                    PNGMetadataRemover.INSTANCE.remove(ins, out);
                    l2 = Unit.INSTANCE;
                } else {
                    l2 = ins.transferTo(out);
                }
                l = l2;
            }
            catch (Throwable throwable2) {
                object2 = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            Long l3 = l;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return CopyActionResult.CONTINUE;
    }
}

