/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.task;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;
import xyz.xenondevs.nova.registry.NovaRegistries;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.resources.ResourceType;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.layout.gui.GuiTextureLayout;
import xyz.xenondevs.nova.resources.builder.task.BuildStage;
import xyz.xenondevs.nova.resources.builder.task.CustomFontContent;
import xyz.xenondevs.nova.resources.builder.task.ExtractTask;
import xyz.xenondevs.nova.resources.builder.task.FontChar;
import xyz.xenondevs.nova.resources.builder.task.FontContent;
import xyz.xenondevs.nova.resources.builder.task.GuiTextureData;
import xyz.xenondevs.nova.resources.builder.task.GuiTextureTaskKt;
import xyz.xenondevs.nova.resources.builder.task.LanguageContent;
import xyz.xenondevs.nova.resources.builder.task.MovedFontContent;
import xyz.xenondevs.nova.resources.builder.task.PackBuildData;
import xyz.xenondevs.nova.resources.builder.task.PackTask;
import xyz.xenondevs.nova.resources.lookup.ResourceLookups;
import xyz.xenondevs.nova.ui.menu.VanillaGuiTextureInjector;
import xyz.xenondevs.nova.ui.overlay.guitexture.GuiTexture;
import xyz.xenondevs.nova.util.data.IOUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lxyz/xenondevs/nova/resources/builder/task/GuiTextureTask;", "Lxyz/xenondevs/nova/resources/builder/task/CustomFontContent;", "Lxyz/xenondevs/nova/resources/builder/task/PackTask;", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "<init>", "(Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;)V", "stage", "Lxyz/xenondevs/nova/resources/builder/task/BuildStage;", "getStage", "()Lxyz/xenondevs/nova/resources/builder/task/BuildStage;", "runsAfter", "", "Lkotlin/reflect/KClass;", "getRunsAfter", "()Ljava/util/Set;", "runsBefore", "getRunsBefore", "run", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "overwriteDefaultContainerTextures", "overwriteInventoryTitle", "loadCustomGuiTextures", "nova"})
@SourceDebugExtension(value={"SMAP\nGuiTextureTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiTextureTask.kt\nxyz/xenondevs/nova/resources/builder/task/GuiTextureTask\n+ 2 ResourcePackBuilder.kt\nxyz/xenondevs/nova/resources/builder/ResourcePackBuilder\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n372#2:127\n373#2,2:130\n372#2:132\n373#2,2:135\n295#3,2:128\n295#3,2:133\n*S KotlinDebug\n*F\n+ 1 GuiTextureTask.kt\nxyz/xenondevs/nova/resources/builder/task/GuiTextureTask\n*L\n94#1:127\n94#1:130,2\n102#1:132\n102#1:135,2\n94#1:128,2\n102#1:133,2\n*E\n"})
public final class GuiTextureTask
extends CustomFontContent
implements PackTask {
    @NotNull
    private final BuildStage stage;
    @NotNull
    private final Set<KClass<? extends PackTask>> runsAfter;
    @NotNull
    private final Set<KClass<? extends PackTask>> runsBefore;

    public GuiTextureTask(@NotNull ResourcePackBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super(builder, "nova:gui_%s", true);
        this.stage = BuildStage.PRE_WORLD;
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(ExtractTask.class), Reflection.getOrCreateKotlinClass(LanguageContent.LoadAll.class)};
        this.runsAfter = SetsKt.setOf((Object[])objectArray);
        objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(MovedFontContent.Write.class), Reflection.getOrCreateKotlinClass(FontContent.Write.class), Reflection.getOrCreateKotlinClass(LanguageContent.Write.class)};
        this.runsBefore = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public BuildStage getStage() {
        return this.stage;
    }

    @Override
    @NotNull
    public Set<KClass<? extends PackTask>> getRunsAfter() {
        return this.runsAfter;
    }

    @Override
    @NotNull
    public Set<KClass<? extends PackTask>> getRunsBefore() {
        return this.runsBefore;
    }

    @Override
    @Nullable
    public Object run(@NotNull Continuation<? super Unit> $completion) {
        this.overwriteDefaultContainerTextures();
        this.overwriteInventoryTitle();
        this.loadCustomGuiTextures();
        return Unit.INSTANCE;
    }

    private final void overwriteDefaultContainerTextures() {
        BufferedImage img = new BufferedImage(256, 256, 2);
        for (String texture : GuiTextureTaskKt.access$getREPLACED_TEXTURES$p()) {
            LinkOption[] linkOptionArray;
            ResourcePath<ResourceType> path = new ResourcePath<ResourceType>(ResourceType.Texture.INSTANCE, "minecraft", "gui/container/" + texture);
            this.getBuilder().writeImage(path, img);
            Path src = this.getBuilder().resolveVanilla(path);
            Path target = this.getBuilder().resolve(new ResourcePath<ResourceType>(ResourceType.Texture.INSTANCE, "nova", "gui/vanilla/" + texture));
            Path path2 = target;
            if (Files.exists(path2, Arrays.copyOf(linkOptionArray = new LinkOption[0], linkOptionArray.length))) continue;
            PathsKt.createParentDirectories((Path)target, (FileAttribute[])new FileAttribute[0]);
            path2 = src;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, target, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
    }

    private final void overwriteInventoryTitle() {
        PackBuildData holder$iv;
        Object v3;
        block8: {
            PackBuildData holder$iv2;
            Object v0;
            Object this_$iv;
            block7: {
                this_$iv = this.getBuilder();
                boolean $i$f$getBuildData = false;
                Iterable $this$firstOrNull$iv$iv = ((ResourcePackBuilder)this_$iv).getData();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    PackBuildData it$iv = (PackBuildData)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof LanguageContent)) continue;
                    v0 = element$iv$iv;
                    break block7;
                }
                v0 = null;
            }
            PackBuildData packBuildData = v0;
            if (packBuildData == null) {
                throw new IllegalArgumentException("No holder of type " + Reflection.getOrCreateKotlinClass(LanguageContent.class).getSimpleName() + " is present");
            }
            PackBuildData packBuildData2 = holder$iv2 = packBuildData;
            if (packBuildData2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type xyz.xenondevs.nova.resources.builder.task.LanguageContent");
            }
            LanguageContent lc = (LanguageContent)((PackBuildData)((LanguageContent)packBuildData2));
            this_$iv = lc.getVanillaLangs().entrySet().iterator();
            while (this_$iv.hasNext()) {
                ResourcePath lang = (ResourcePath)((Map.Entry)this_$iv.next()).getKey();
                String translation = lc.getTranslation(lang, "container.inventory");
                lc.setTranslation(lang, "container.inventory", "");
                lc.setTranslation(lang, "container.nova.inventory", translation);
            }
            ResourcePackBuilder this_$iv2 = this.getBuilder();
            boolean $i$f$getBuildData = false;
            Iterable $this$firstOrNull$iv$iv = this_$iv2.getData();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                PackBuildData it$iv = (PackBuildData)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof MovedFontContent)) continue;
                v3 = element$iv$iv;
                break block8;
            }
            v3 = null;
        }
        PackBuildData packBuildData = v3;
        if (packBuildData == null) {
            throw new IllegalArgumentException("No holder of type " + Reflection.getOrCreateKotlinClass(MovedFontContent.class).getSimpleName() + " is present");
        }
        PackBuildData packBuildData3 = holder$iv = packBuildData;
        if (packBuildData3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type xyz.xenondevs.nova.resources.builder.task.MovedFontContent");
        }
        MovedFontContent mfc = (MovedFontContent)((PackBuildData)((MovedFontContent)packBuildData3));
        mfc.requestMovedFonts(new ResourcePath<ResourceType>(ResourceType.Font.INSTANCE, "minecraft", "default"), (Iterable<Integer>)VanillaGuiTextureInjector.INSTANCE.getRequiredVerticalOffsets());
        mfc.requestMovedFonts(new ResourcePath<ResourceType>(ResourceType.Font.INSTANCE, "minecraft", "uniform"), (Iterable<Integer>)VanillaGuiTextureInjector.INSTANCE.getRequiredVerticalOffsets());
    }

    private final void loadCustomGuiTextures() {
        HashMap guiTextures = new HashMap();
        HashMap guiTexturesByFontChar = new HashMap();
        for (GuiTexture guiTexture : NovaRegistries.GUI_TEXTURE) {
            GuiTextureLayout layout = (GuiTextureLayout)guiTexture.getMakeLayout$nova().invoke((Object)this.getBuilder());
            ResourcePath<ResourceType> texture = layout.getTexture().toType((ResourceType)ResourceType.FontTexture.INSTANCE);
            Dimension dim = IOUtilsKt.readImageDimensions(this.getBuilder().resolve(texture));
            Vector2ic offset = layout.getAlignment().getOffset(dim.width, dim.height);
            FontChar fontChar = this.addEntry(guiTexture.getId().toString(), texture, (Integer)dim.height, -offset.y());
            ((Map)guiTextures).put(guiTexture, new GuiTextureData(fontChar.getFont(), fontChar.getCodePoint(), offset.x(), layout.getHasInventoryLabel()));
            ((Map)guiTexturesByFontChar).put(fontChar, guiTexture);
        }
        ResourceLookups.INSTANCE.setGUI_TEXTURE(guiTextures);
        ResourceLookups.INSTANCE.setGUI_TEXTURE_BY_FONT_CHAR(guiTexturesByFontChar);
    }
}

