/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import net.minecraft.world.level.block.SoundType;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.commons.gson.JsonElementsKt;
import xyz.xenondevs.commons.gson.JsonObjectsKt;
import xyz.xenondevs.nova.registry.NovaRegistries;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.task.BlockModelTask;
import xyz.xenondevs.nova.resources.builder.task.BuildStage;
import xyz.xenondevs.nova.resources.builder.task.PackTask;
import xyz.xenondevs.nova.resources.lookup.ResourceLookups;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.state.model.BackingStateBlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.BlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.DisplayEntityBlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.ModelLessBlockModelProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020!H\u0002J!\u0010#\u001a\u00020!2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%\"\u00020&H\u0002\u00a2\u0006\u0002\u0010'J\u0016\u0010#\u001a\u00020!2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lxyz/xenondevs/nova/resources/builder/task/SoundOverridesTask;", "Lxyz/xenondevs/nova/resources/builder/task/PackTask;", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "<init>", "(Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;)V", "stage", "Lxyz/xenondevs/nova/resources/builder/task/BuildStage;", "getStage", "()Lxyz/xenondevs/nova/resources/builder/task/BuildStage;", "runsAfter", "", "Lkotlin/reflect/KClass;", "Lxyz/xenondevs/nova/resources/builder/task/BlockModelTask;", "getRunsAfter", "()Ljava/util/Set;", "soundEvents", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "useMaterial", "", "material", "Lorg/bukkit/Material;", "addSoundType", "type", "Lnet/minecraft/world/level/block/SoundType;", "run", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findUsedBlockTypes", "write", "createSoundsIndex", "", "Lcom/google/gson/JsonObject;", "obj", "mergeSoundJsons", "files", "", "Ljava/nio/file/Path;", "([Ljava/nio/file/Path;)Lcom/google/gson/JsonObject;", "soundJsons", "", "nova"})
@SourceDebugExtension(value={"SMAP\nSoundOverridesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoundOverridesTask.kt\nxyz/xenondevs/nova/resources/builder/task/SoundOverridesTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 JsonObjects.kt\nxyz/xenondevs/commons/gson/JsonObjectsKt\n*L\n1#1,160:1\n1869#2,2:161\n1267#2,4:165\n1869#2:183\n1869#2:184\n1869#2,2:199\n1870#2:201\n1870#2:202\n216#3,2:163\n11879#4,9:169\n13805#4:178\n13806#4:181\n11888#4:182\n1#5:179\n1#5:180\n41#6,7:185\n41#6,7:192\n*S KotlinDebug\n*F\n+ 1 SoundOverridesTask.kt\nxyz/xenondevs/nova/resources/builder/task/SoundOverridesTask\n*L\n80#1:161,2\n116#1:165,4\n132#1:183\n133#1:184\n152#1:199,2\n133#1:201\n132#1:202\n87#1:163,2\n120#1:169,9\n120#1:178\n120#1:181\n120#1:182\n120#1:180\n136#1:185,7\n150#1:192,7\n*E\n"})
public final class SoundOverridesTask
implements PackTask {
    @NotNull
    private final ResourcePackBuilder builder;
    @NotNull
    private final BuildStage stage;
    @NotNull
    private final Set<KClass<BlockModelTask>> runsAfter;
    @NotNull
    private final HashSet<String> soundEvents;

    public SoundOverridesTask(@NotNull ResourcePackBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.stage = BuildStage.PRE_WORLD;
        this.runsAfter = SetsKt.setOf((Object)Reflection.getOrCreateKotlinClass(BlockModelTask.class));
        this.soundEvents = new HashSet();
    }

    @Override
    @NotNull
    public BuildStage getStage() {
        return this.stage;
    }

    @NotNull
    public Set<KClass<BlockModelTask>> getRunsAfter() {
        return this.runsAfter;
    }

    private final void useMaterial(Material material) {
        SoundType soundType = NMSUtilsKt.getNmsBlock(material).defaultBlockState().getSoundType();
        Intrinsics.checkNotNull((Object)soundType);
        this.addSoundType(soundType);
    }

    private final void addSoundType(SoundType type) {
        ((Collection)this.soundEvents).add(type.breakSound.location().getPath());
        ((Collection)this.soundEvents).add(type.hitSound.location().getPath());
        ((Collection)this.soundEvents).add(type.getStepSound().location().getPath());
        ((Collection)this.soundEvents).add(type.getFallSound().location().getPath());
    }

    @Override
    @Nullable
    public Object run(@NotNull Continuation<? super Unit> $completion) {
        this.findUsedBlockTypes();
        this.write();
        return Unit.INSTANCE;
    }

    private final void findUsedBlockTypes() {
        for (NovaBlock block : NovaRegistries.BLOCK) {
            for (NovaBlockState blockState : block.getBlockStates()) {
                BlockModelProvider modelProvider = blockState.getModelProvider$nova();
                if (modelProvider instanceof DisplayEntityBlockModelProvider) {
                    Material material = ((DisplayEntityBlockModelProvider)modelProvider).getInfo().getHitboxType().getBukkitMaterial();
                    Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getBukkitMaterial(...)");
                    this.useMaterial(material);
                    continue;
                }
                if (modelProvider instanceof BackingStateBlockModelProvider) {
                    Material material = ((BackingStateBlockModelProvider)modelProvider).getInfo().getVanillaBlockState().getBukkitMaterial();
                    Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getBukkitMaterial(...)");
                    this.useMaterial(material);
                    continue;
                }
                if (modelProvider instanceof ModelLessBlockModelProvider) {
                    Material material = ((ModelLessBlockModelProvider)modelProvider).getInfo().getBukkitMaterial();
                    Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getBukkitMaterial(...)");
                    this.useMaterial(material);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void write() {
        try {
            JsonElement jsonElement = JsonElementsKt.parseJson((Path)this.builder.resolveVanilla("assets/minecraft/sounds.json"));
            Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
            Map<String, JsonObject> vanillaIndex = this.createSoundsIndex((JsonObject)jsonElement);
            Path[] pathArray = new Path[]{this.builder.resolveVanilla("assets/minecraft/sounds.json"), this.builder.resolve("assets/minecraft/sounds.json")};
            JsonObject merged = this.mergeSoundJsons(pathArray);
            Map<String, JsonObject> index = this.createSoundsIndex(merged);
            JsonObject novaSoundIndex = new JsonObject();
            Iterable $this$forEach$iv = this.soundEvents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonObject soundEventObj;
                String soundEvent = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)index.get(soundEvent));
                novaSoundIndex.add(soundEvent, (JsonElement)soundEventObj);
            }
            JsonElementsKt.writeToFile((JsonElement)((JsonElement)novaSoundIndex), (Path)this.builder.resolve("assets/nova/sounds.json"));
            JsonObject mcSoundIndex = new JsonObject();
            Map<String, JsonObject> $this$forEach$iv2 = index;
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, JsonObject>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonObject> element$iv;
                Map.Entry<String, JsonObject> entry = element$iv = iterator.next();
                boolean bl = false;
                String soundEvent = entry.getKey();
                JsonObject soundEventObj = entry.getValue();
                if (this.soundEvents.contains(soundEvent)) {
                    soundEventObj.addProperty("replace", Boolean.valueOf(true));
                    soundEventObj.remove("subtitle");
                    soundEventObj.add("sounds", (JsonElement)new JsonArray());
                    mcSoundIndex.add(soundEvent, (JsonElement)soundEventObj);
                    continue;
                }
                if (vanillaIndex.containsKey(soundEvent)) continue;
                mcSoundIndex.add(soundEvent, (JsonElement)soundEventObj);
            }
            JsonElementsKt.writeToFile((JsonElement)((JsonElement)mcSoundIndex), (Path)this.builder.resolve("assets/minecraft/sounds.json"));
            ResourceLookups.INSTANCE.setSOUND_OVERRIDES((Set<String>)this.soundEvents);
        }
        catch (Exception e) {
            this.builder.getLogger().error("Failed to write block sound overrides", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, JsonObject> createSoundsIndex(JsonObject obj) {
        void var3_3;
        void $this$associateTo$iv;
        Set set = obj.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        Iterable iterable = set;
        Map destination$iv = new HashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map map2 = destination$iv;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Object k = it.getKey();
            Object v = it.getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
            Pair pair = TuplesKt.to(k, (Object)((JsonObject)v));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject mergeSoundJsons(Path ... files) {
        void $this$mapNotNullTo$iv$iv;
        Path[] $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        Path[] pathArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            JsonObject it$iv$iv;
            void var17_16;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            void p0 = var17_16 = it;
            boolean $i$f$mergeSoundJsons$lambda$0$exists = false;
            boolean bl3 = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            Object object = Files.exists((Path)p0, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? var17_16 : null;
            Object object2 = object != null ? JsonElementsKt.parseJson(object) : null;
            if ((object2 instanceof JsonObject ? (JsonObject)object2 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List jsonObjects = (List)destination$iv$iv;
        return jsonObjects.size() > 1 ? this.mergeSoundJsons(jsonObjects) : (JsonObject)jsonObjects.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject mergeSoundJsons(List<JsonObject> soundJsons) {
        if (!(soundJsons.size() > 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        JsonObject merged = soundJsons.get(0).deepCopy();
        List<JsonObject> otherJsons = soundJsons.subList(0, soundJsons.size());
        Iterable $this$forEach$iv = otherJsons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonObject mainObj = (JsonObject)element$iv;
            boolean bl = false;
            Set set = mainObj.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
            Iterable $this$forEach$iv2 = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JsonElement jsonElement;
                boolean replace;
                void $this$getOrPut$iv;
                Map.Entry entry = (Map.Entry)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)entry);
                String soundEvent = (String)entry.getKey();
                JsonElement soundEventObj = (JsonElement)entry.getValue();
                Intrinsics.checkNotNull((Object)soundEventObj, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                JsonObject cfr_ignored_0 = (JsonObject)soundEventObj;
                Intrinsics.checkNotNull((Object)merged);
                JsonObject jsonObject = merged;
                Intrinsics.checkNotNull((Object)soundEvent);
                String key$iv = soundEvent;
                boolean $i$f$getOrPut = false;
                JsonElement value$iv = JsonObjectsKt.getOrNull((JsonObject)$this$getOrPut$iv, (String)key$iv);
                if (!(value$iv instanceof JsonObject)) {
                    boolean bl3 = false;
                    value$iv = (JsonElement)new JsonObject();
                    $this$getOrPut$iv.add(key$iv, value$iv);
                }
                JsonObject mergedSoundEventObj = (JsonObject)value$iv;
                String subtitle = JsonObjectsKt.getStringOrNull((JsonObject)((JsonObject)soundEventObj), (String)"subtitle");
                Boolean bl4 = JsonObjectsKt.getBooleanOrNull((JsonObject)((JsonObject)soundEventObj), (String)"replace");
                boolean bl5 = replace = bl4 != null ? bl4 : false;
                if (subtitle != null) {
                    mergedSoundEventObj.addProperty("subtitle", subtitle);
                }
                if (replace) {
                    mergedSoundEventObj.addProperty("replace", Boolean.valueOf(true));
                }
                if (replace) {
                    JsonElement it = value$iv = new JsonArray();
                    boolean bl6 = false;
                    mergedSoundEventObj.add("sounds", it);
                    jsonElement = value$iv;
                } else {
                    void $this$getOrPut$iv2;
                    value$iv = mergedSoundEventObj;
                    String key$iv2 = "sounds";
                    boolean $i$f$getOrPut2 = false;
                    JsonElement value$iv2 = JsonObjectsKt.getOrNull((JsonObject)$this$getOrPut$iv2, (String)key$iv2);
                    if (!(value$iv2 instanceof JsonArray)) {
                        boolean bl7 = false;
                        value$iv2 = (JsonElement)new JsonArray();
                        $this$getOrPut$iv2.add(key$iv2, value$iv2);
                    }
                    jsonElement = (JsonArray)value$iv2;
                }
                JsonElement destSounds = jsonElement;
                JsonArray jsonArray = ((JsonObject)soundEventObj).getAsJsonArray("sounds");
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                Iterable $this$forEach$iv3 = (Iterable)jsonArray;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    JsonElement p0 = (JsonElement)element$iv3;
                    boolean bl8 = false;
                    destSounds.add(p0);
                }
            }
        }
        Intrinsics.checkNotNull((Object)merged);
        return merged;
    }
}

