/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.task;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.integration.customitems.CustomItemServiceManager;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.resources.ResourceType;
import xyz.xenondevs.nova.resources.builder.AssetPack;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.task.BuildStage;
import xyz.xenondevs.nova.resources.builder.task.CustomFontContent;
import xyz.xenondevs.nova.resources.builder.task.FontChar;
import xyz.xenondevs.nova.resources.builder.task.FontContent;
import xyz.xenondevs.nova.resources.builder.task.MovedFontContent;
import xyz.xenondevs.nova.resources.builder.task.PackBuildData;
import xyz.xenondevs.nova.resources.builder.task.PackTask;
import xyz.xenondevs.nova.resources.builder.task.WailaTaskKt;
import xyz.xenondevs.nova.resources.lookup.ResourceLookups;
import xyz.xenondevs.nova.ui.waila.WailaManager;
import xyz.xenondevs.renderer.MinecraftModelRenderer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000eR\u00020\u000f0\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lxyz/xenondevs/nova/resources/builder/task/WailaTask;", "Lxyz/xenondevs/nova/resources/builder/task/CustomFontContent;", "Lxyz/xenondevs/nova/resources/builder/task/PackTask;", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "<init>", "(Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;)V", "stage", "Lxyz/xenondevs/nova/resources/builder/task/BuildStage;", "getStage", "()Lxyz/xenondevs/nova/resources/builder/task/BuildStage;", "runsBefore", "", "Lkotlin/reflect/KClass;", "Lxyz/xenondevs/nova/resources/builder/task/FontContent$Write;", "Lxyz/xenondevs/nova/resources/builder/task/FontContent;", "getRunsBefore", "()Ljava/util/Set;", "run", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renderCustomItemServiceBlocks", "writeHardcodedTextures", "writePackTextures", "pack", "Lxyz/xenondevs/nova/resources/builder/AssetPack;", "nova"})
@SourceDebugExtension(value={"SMAP\nWailaTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WailaTask.kt\nxyz/xenondevs/nova/resources/builder/task/WailaTask\n+ 2 ResourcePackBuilder.kt\nxyz/xenondevs/nova/resources/builder/ResourcePackBuilder\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,336:1\n372#2:337\n373#2,2:340\n295#3,2:338\n1869#3,2:342\n1869#3,2:348\n216#4,2:344\n216#4,2:346\n1321#5:350\n1322#5:352\n1#6:351\n*S KotlinDebug\n*F\n+ 1 WailaTask.kt\nxyz/xenondevs/nova/resources/builder/task/WailaTask\n*L\n255#1:337\n255#1:340,2\n255#1:338,2\n257#1:342,2\n310#1:348,2\n273#1:344,2\n304#1:346,2\n323#1:350\n323#1:352\n*E\n"})
public final class WailaTask
extends CustomFontContent
implements PackTask {
    @NotNull
    private final BuildStage stage;
    @NotNull
    private final Set<KClass<FontContent.Write>> runsBefore;

    public WailaTask(@NotNull ResourcePackBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super(builder, "nova:waila_textures_%s", true);
        this.stage = BuildStage.POST_WORLD;
        this.runsBefore = SetsKt.setOf((Object)Reflection.getOrCreateKotlinClass(FontContent.Write.class));
    }

    @Override
    @NotNull
    public BuildStage getStage() {
        return this.stage;
    }

    @NotNull
    public Set<KClass<FontContent.Write>> getRunsBefore() {
        return this.runsBefore;
    }

    @Override
    @Nullable
    public Object run(@NotNull Continuation<? super Unit> $completion) {
        if (WailaManager.INSTANCE.getENABLED()) {
            PackBuildData holder$iv;
            Object v0;
            block5: {
                ResourcePackBuilder this_$iv = this.getBuilder();
                boolean $i$f$getBuildData = false;
                Iterable $this$firstOrNull$iv$iv = this_$iv.getData();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    PackBuildData it$iv = (PackBuildData)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof MovedFontContent)) continue;
                    v0 = element$iv$iv;
                    break block5;
                }
                v0 = null;
            }
            PackBuildData packBuildData = v0;
            if (packBuildData == null) {
                throw new IllegalArgumentException("No holder of type " + Reflection.getOrCreateKotlinClass(MovedFontContent.class).getSimpleName() + " is present");
            }
            PackBuildData packBuildData2 = holder$iv = packBuildData;
            if (packBuildData2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type xyz.xenondevs.nova.resources.builder.task.MovedFontContent");
            }
            ((MovedFontContent)((PackBuildData)((MovedFontContent)packBuildData2))).requestMovedFonts(new ResourcePath<ResourceType>(ResourceType.Font.INSTANCE, "nova", "waila"), (Iterable)new IntRange(1, 19));
            this.writeHardcodedTextures();
            Iterable $this$forEach$iv = this.getBuilder().getAssetPacks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AssetPack p0 = (AssetPack)element$iv;
                boolean bl = false;
                this.writePackTextures(p0);
            }
            this.renderCustomItemServiceBlocks();
            ResourceLookups.INSTANCE.getWAILA_DATA_LOOKUP().set1((Map<Key, FontChar>)this.getFontCharLookup());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void renderCustomItemServiceBlocks() {
        int count = 0;
        try {
            Object[] objectArray = new Path[]{this.getBuilder().resolveVanilla(""), this.getBuilder().resolve("")};
            MinecraftModelRenderer renderer = new MinecraftModelRenderer(512, 512, 128, 128, CollectionsKt.listOf((Object[])objectArray), true, 0.0, 0.0, 0.0, 0.0, 960, null);
            Map<Key, ResourcePath<ResourceType.Model>> $this$forEach$iv = CustomItemServiceManager.INSTANCE.getBlockItemModelPaths();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Key, ResourcePath<ResourceType.Model>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Key, ResourcePath<ResourceType.Model>> element$iv;
                Map.Entry<Key, ResourcePath<ResourceType.Model>> entry = element$iv = iterator.next();
                boolean bl = false;
                Key id = entry.getKey();
                ResourcePath<ResourceType.Model> path = entry.getValue();
                try {
                    Path path2;
                    Path file = this.getBuilder().resolve("assets/nova/textures/waila_generated/" + id.namespace() + "/" + id.value() + ".png");
                    Intrinsics.checkNotNullExpressionValue((Object)file.getParent(), (String)"getParent(...)");
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                    renderer.renderModelToFile(path.toString(), file);
                    this.addEntry(id, new ResourcePath<ResourceType>(ResourceType.FontTexture.INSTANCE, "nova", "waila_generated/" + id.namespace() + "/" + id.value() + ".png"), (Integer)32, -4);
                    int n = count;
                    count = n + 1;
                }
                catch (Exception e) {
                    this.getBuilder().getLogger().warn("Failed to render " + id + " (" + path + ") ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.getBuilder().getLogger().error("Failed to render WAILA textures for custom item services. (Misconfigured base packs?)", (Throwable)e);
        }
        finally {
            this.getBuilder().getLogger().info("Rendered " + count + " WAILA textures");
        }
    }

    private final void writeHardcodedTextures() {
        Map.Entry element$iv;
        Object $this$forEach$iv = WailaTaskKt.access$getMATERIAL_TEXTURES$p();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String name;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Material material = (Material)entry.getKey();
            String texture = (String)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)material.name().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            ResourcePath path = ResourcePath.Companion.of$default(ResourcePath.Companion, ResourceType.FontTexture.INSTANCE, texture + ".png", null, 4, null);
            Key key = Key.key((String)"minecraft", (String)name);
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
            this.addEntry(key, WailaTask.writeHardcodedTextures$copyMCTexture(this, path), (Integer)32, -4);
        }
        $this$forEach$iv = WailaTaskKt.access$getTEXTURES$p();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            String it = (String)((Object)element$iv);
            boolean bl = false;
            Key key = Key.key((String)"minecraft", (String)it);
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
            this.addEntry(key, WailaTask.writeHardcodedTextures$copyMCTexture(this, new ResourcePath<ResourceType>(ResourceType.Texture.INSTANCE, "minecraft", "block/" + it)), (Integer)32, -4);
        }
    }

    private final void writePackTextures(AssetPack pack) {
        if (!WailaManager.INSTANCE.getENABLED()) {
            return;
        }
        Path wailaDir = this.getBuilder().resolve("assets/" + pack.getNamespace() + "/textures/waila/");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(wailaDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        Sequence $this$forEach$iv = PathsKt.walk((Path)wailaDir, (PathWalkOption[])new PathWalkOption[0]);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Path file = (Path)element$iv;
            boolean bl = false;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) || !StringsKt.equals((String)PathsKt.getExtension((Path)file), (String)"png", (boolean)true)) continue;
            String it = string = pack.getNamespace();
            boolean bl2 = false;
            String string2 = !Intrinsics.areEqual((Object)it, (Object)"nova") ? string : null;
            if (string2 == null) {
                string2 = "minecraft";
            }
            String idNamespace = string2;
            Key key = Key.key((String)idNamespace, (String)PathsKt.getNameWithoutExtension((Path)file));
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
            this.addEntry(key, new ResourcePath<ResourceType>(ResourceType.FontTexture.INSTANCE, pack.getNamespace(), "waila/" + PathsKt.getName((Path)file)), (Integer)32, -4);
        }
    }

    private static final ResourcePath<ResourceType.FontTexture> writeHardcodedTextures$copyMCTexture(WailaTask this$0, ResourcePath<? extends ResourceType.PngFile> from) {
        String name = StringsKt.substringAfterLast$default((String)from.getPath(), (char)'/', null, (int)2, null);
        ResourcePath<ResourceType> to = new ResourcePath<ResourceType>(ResourceType.FontTexture.INSTANCE, "nova", "waila_generated/" + name + ".png");
        Path fromFile = this$0.getBuilder().resolveVanilla(from);
        Path toFile = this$0.getBuilder().resolve(to);
        Path path = toFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        path2 = fromFile;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        CopyOption[] copyOptionArray2 = copyOptionArray;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, toFile, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
        return to;
    }
}

