/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.task.basepack.merger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.gson.JsonElementsKt;
import xyz.xenondevs.commons.gson.JsonObjectsKt;
import xyz.xenondevs.nova.resources.builder.task.basepack.BasePacks;
import xyz.xenondevs.nova.resources.builder.task.basepack.merger.BlockStateFileMergerKt;
import xyz.xenondevs.nova.resources.builder.task.basepack.merger.FileInDirectoryMerger;
import xyz.xenondevs.nova.serialization.json.GsonKt;
import xyz.xenondevs.nova.world.block.state.model.BackingStateConfig;
import xyz.xenondevs.nova.world.block.state.model.BackingStateConfigType;
import xyz.xenondevs.nova.world.block.state.model.DefaultingBackingStateConfigType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00072\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"Lxyz/xenondevs/nova/resources/builder/task/basepack/merger/BlockStateFileMerger;", "Lxyz/xenondevs/nova/resources/builder/task/basepack/merger/FileInDirectoryMerger;", "basePacks", "Lxyz/xenondevs/nova/resources/builder/task/basepack/BasePacks;", "<init>", "(Lxyz/xenondevs/nova/resources/builder/task/basepack/BasePacks;)V", "merge", "", "source", "Ljava/nio/file/Path;", "destination", "getVariants", "Lcom/google/gson/JsonObject;", "file", "convertMultipartToVariants", "array", "Lcom/google/gson/JsonArray;", "processVariants", "configType", "Lxyz/xenondevs/nova/world/block/state/model/BackingStateConfigType;", "obj", "nova"})
@SourceDebugExtension(value={"SMAP\nBlockStateFileMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockStateFileMerger.kt\nxyz/xenondevs/nova/resources/builder/task/basepack/merger/BlockStateFileMerger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,101:1\n295#2,2:102\n1869#2,2:105\n1193#2,2:114\n1267#2,4:116\n1#3:104\n382#4,7:107\n*S KotlinDebug\n*F\n+ 1 BlockStateFileMerger.kt\nxyz/xenondevs/nova/resources/builder/task/basepack/merger/BlockStateFileMerger\n*L\n35#1:102,2\n63#1:105,2\n89#1:114,2\n89#1:116,4\n81#1:107,7\n*E\n"})
public final class BlockStateFileMerger
extends FileInDirectoryMerger {
    public BlockStateFileMerger(@NotNull BasePacks basePacks) {
        Intrinsics.checkNotNullParameter((Object)basePacks, (String)"basePacks");
        super(basePacks, "assets/minecraft/blockstates");
    }

    @Override
    public void merge(@NotNull Path source, @NotNull Path destination) {
        CopyOption[] copyOptionArray;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Iterable $this$firstOrNull$iv = BlockStateFileMergerKt.access$getMERGEABLE_STATE_CONFIGS$p();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DefaultingBackingStateConfigType it = (DefaultingBackingStateConfigType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFileName(), (Object)PathsKt.getNameWithoutExtension((Path)source))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        DefaultingBackingStateConfigType configType = v0;
        if (configType != null) {
            JsonObject variants = this.getVariants(source);
            Path $i$f$firstOrNull = destination;
            copyOptionArray = new LinkOption[0];
            if (Files.exists($i$f$firstOrNull, (LinkOption[])Arrays.copyOf(copyOptionArray, copyOptionArray.length))) {
                JsonObjectsKt.addAll((JsonObject)variants, (JsonObject)this.getVariants(destination));
            }
            this.processVariants(configType, variants);
            JsonObject blockStateObj = new JsonObject();
            blockStateObj.add("variants", (JsonElement)variants);
            String string = GsonKt.getGSON().toJson((JsonElement)blockStateObj);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            PathsKt.writeText$default((Path)destination, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
            return;
        }
        Path path = source;
        copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        CopyOption[] copyOptionArray2 = copyOptionArray;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, destination, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
    }

    private final JsonObject getVariants(Path file) {
        JsonElement jsonElement = JsonElementsKt.parseJson((Path)file);
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
        JsonObject sourceObj = (JsonObject)jsonElement;
        JsonElement jsonElement2 = sourceObj.get("variants");
        JsonObject jsonObject = jsonElement2 instanceof JsonObject ? (JsonObject)jsonElement2 : null;
        if (jsonObject == null) {
            JsonObject jsonObject2;
            JsonElement jsonElement3 = sourceObj.get("multipart");
            JsonArray jsonArray = jsonElement3 instanceof JsonArray ? (JsonArray)jsonElement3 : null;
            if (jsonArray != null) {
                JsonArray p0 = jsonArray;
                boolean bl = false;
                jsonObject2 = this.convertMultipartToVariants(p0);
            } else {
                jsonObject2 = jsonObject = null;
            }
            if (jsonObject2 == null) {
                jsonObject = new JsonObject();
            }
        }
        return jsonObject;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject convertMultipartToVariants(JsonArray array) {
        JsonObject variants = new JsonObject();
        try {
            Iterable $this$forEach$iv = (Iterable)array;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$convertMultipartToVariants_u24lambda_u240_u241;
                JsonObject jsonObject;
                JsonElement jsonElement;
                JsonElement obj = (JsonElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                JsonObject cfr_ignored_0 = (JsonObject)obj;
                JsonElement jsonElement2 = ((JsonObject)obj).get("when");
                Intrinsics.checkNotNull((Object)jsonElement2, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                JsonObject whenObj = (JsonObject)jsonElement2;
                JsonElement apply = ((JsonObject)obj).get("apply");
                if (apply instanceof JsonObject) {
                    jsonElement = ((JsonObject)apply).get("model");
                } else {
                    JsonArray jsonArray = apply.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                    jsonElement = ((JsonElement)CollectionsKt.first((Iterable)((Iterable)jsonArray))).getAsJsonObject().get("model");
                }
                String model = jsonElement.getAsString();
                Set set = whenObj.entrySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
                String variantString = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)",", null, null, (int)0, null, BlockStateFileMerger::convertMultipartToVariants$lambda$0$0, (int)30, null);
                JsonObject jsonObject2 = jsonObject = new JsonObject();
                String string = variantString;
                JsonObject jsonObject3 = variants;
                boolean bl2 = false;
                $this$convertMultipartToVariants_u24lambda_u240_u241.addProperty("model", model);
                Unit unit = Unit.INSTANCE;
                jsonObject3.add(string, (JsonElement)jsonObject);
            }
        }
        catch (Exception e) {
            this.getBasePacks().getBuilder$nova().getLogger().error("Failed to convert multipart to variants, some block states might be missing", (Throwable)e);
        }
        return variants;
    }

    /*
     * WARNING - void declaration
     */
    private final void processVariants(BackingStateConfigType<?> configType, JsonObject obj) {
        try {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = this.getBasePacks().getOccupiedSolidIds$nova();
            BackingStateConfigType<?> key$iv = configType;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                HashSet answer$iv = new HashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            HashSet occupied = (HashSet)object;
            obj.entrySet().removeIf(arg_0 -> BlockStateFileMerger.processVariants$lambda$1(arg_0 -> BlockStateFileMerger.processVariants$lambda$0(occupied, configType, arg_0), arg_0));
            configType.handleMerged$nova(occupied);
        }
        catch (Exception e) {
            this.getBasePacks().getBuilder$nova().getLogger().error("Failed to process variants for " + configType + " in " + obj, (Throwable)e);
        }
    }

    private static final CharSequence convertMultipartToVariants$lambda$0$0(Map.Entry it) {
        return it.getKey() + "=" + ((JsonElement)it.getValue()).getAsString();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean processVariants$lambda$0(HashSet $occupied, BackingStateConfigType $configType, Map.Entry entry) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNull((Object)entry);
        String variant = (String)entry.getKey();
        JsonElement obj = (JsonElement)entry.getValue();
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
        JsonObject cfr_ignored_0 = (JsonObject)obj;
        String model = JsonObjectsKt.getStringOrNull((JsonObject)((JsonObject)obj), (String)"model");
        if (CollectionsKt.contains((Iterable)BlockStateFileMergerKt.access$getIGNORABLE_MODELS$p(), (Object)model)) {
            return true;
        }
        Intrinsics.checkNotNull((Object)variant);
        Object object = new String[]{","};
        object = StringsKt.split$default((CharSequence)variant, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var10_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"="};
            List list = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean bl2 = false;
            String key = (String)list.get(0);
            String value = (String)list.get(1);
            Pair pair = TuplesKt.to((Object)key, (Object)value);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map properties = destination$iv$iv;
        ((Collection)$occupied).add(((BackingStateConfig)$configType.of(properties)).getId());
        return false;
    }

    private static final boolean processVariants$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

