/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.serialization.cbf;

import com.mojang.serialization.DynamicOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import java.util.BitSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.io.ByteReader;
import xyz.xenondevs.cbf.io.ByteWriter;
import xyz.xenondevs.cbf.serializer.VersionedBinarySerializer;
import xyz.xenondevs.invui.inventory.VirtualInventory;
import xyz.xenondevs.nova.serialization.cbf.ItemStackSerializer;
import xyz.xenondevs.nova.util.MathUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/serialization/cbf/VirtualInventoryBinarySerializer;", "Lxyz/xenondevs/cbf/serializer/VersionedBinarySerializer;", "Lxyz/xenondevs/invui/inventory/VirtualInventory;", "<init>", "()V", "readVersioned", "version", "Lkotlin/UByte;", "reader", "Lxyz/xenondevs/cbf/io/ByteReader;", "readVersioned-0ky7B_Q", "(BLxyz/xenondevs/cbf/io/ByteReader;)Lxyz/xenondevs/invui/inventory/VirtualInventory;", "readV2", "readV1", "writeVersioned", "", "obj", "writer", "Lxyz/xenondevs/cbf/io/ByteWriter;", "copyNonNull", "nova"})
@SourceDebugExtension(value={"SMAP\nVirtualInventoryBinarySerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualInventoryBinarySerializer.kt\nxyz/xenondevs/nova/serialization/cbf/VirtualInventoryBinarySerializer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,113:1\n13000#2,2:114\n*S KotlinDebug\n*F\n+ 1 VirtualInventoryBinarySerializer.kt\nxyz/xenondevs/nova/serialization/cbf/VirtualInventoryBinarySerializer\n*L\n99#1:114,2\n*E\n"})
public final class VirtualInventoryBinarySerializer
extends VersionedBinarySerializer<VirtualInventory> {
    @NotNull
    public static final VirtualInventoryBinarySerializer INSTANCE = new VirtualInventoryBinarySerializer();

    private VirtualInventoryBinarySerializer() {
        super((byte)2, null);
    }

    @NotNull
    public VirtualInventory readVersioned-0ky7B_Q(byte by, @NotNull ByteReader reader) {
        VirtualInventory virtualInventory;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        byte by2 = by;
        if (by2 == UByte.constructor-impl((byte)((byte)1))) {
            virtualInventory = this.readV1(reader);
        } else if (by2 == UByte.constructor-impl((byte)((byte)2))) {
            virtualInventory = this.readV2(reader);
        } else {
            throw new UnsupportedOperationException();
        }
        return virtualInventory;
    }

    private final VirtualInventory readV2(ByteReader reader) {
        DataInput dataInput = reader.asDataInput();
        int dataVersion = reader.readVarInt();
        UUID uuid = reader.readUUID();
        int size = reader.readVarInt();
        BitSet itemsMask = BitSet.valueOf(reader.readBytes(MathUtilsKt.ceilDiv(size, 8)));
        ItemStack[] itemStackArray = new ItemStack[size];
        for (int j = 0; j < size; ++j) {
            ItemStack itemStack;
            int n = j;
            if (itemsMask.get(n)) {
                CompoundTag compoundTag = NbtIo.read((DataInput)dataInput);
                Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"read(...)");
                CompoundTag tag = ItemStackSerializer.INSTANCE.tryFix(compoundTag, dataVersion, NMSUtilsKt.getDATA_VERSION());
                ItemStack itemStack2 = ((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.CODEC.parse((DynamicOps)NMSUtilsKt.getREGISTRY_ACCESS().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial().get()).asBukkitMirror();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"asBukkitMirror(...)");
                itemStack = ItemUtilsKt.takeUnlessEmpty(itemStack2);
            } else {
                itemStack = null;
            }
            itemStackArray[n] = itemStack;
        }
        ItemStack[] items = itemStackArray;
        int[] maxStackSizes = null;
        if (reader.readBoolean()) {
            int n = 0;
            int[] nArray = new int[size];
            while (n < size) {
                int n2 = n++;
                nArray[n2] = reader.readVarInt();
            }
            maxStackSizes = nArray;
        } else {
            int n = 0;
            int[] nArray = new int[size];
            while (n < size) {
                int n3 = n++;
                nArray[n3] = 64;
            }
            maxStackSizes = nArray;
        }
        return new VirtualInventory(uuid, size, items, maxStackSizes);
    }

    private final VirtualInventory readV1(ByteReader reader) {
        byte[] data2 = new byte[reader.readVarInt()];
        reader.readBytes(data2);
        VirtualInventory virtualInventory = VirtualInventory.deserialize((byte[])data2);
        Intrinsics.checkNotNullExpressionValue((Object)virtualInventory, (String)"deserialize(...)");
        return virtualInventory;
    }

    /*
     * WARNING - void declaration
     */
    public void writeVersioned(@NotNull VirtualInventory obj, @NotNull ByteWriter writer2) {
        boolean bl;
        block7: {
            void objectArray;
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            DataOutput dataOutput = writer2.asDataOutput();
            UUID uUID = obj.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            UUID uuid = uUID;
            int size = obj.getSize();
            ItemStack[] itemStackArray = obj.getUnsafeItems();
            Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getUnsafeItems(...)");
            ItemStack[] items = itemStackArray;
            int[] nArray = obj.getMaxStackSizes();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getMaxStackSizes(...)");
            int[] maxStackSizes = nArray;
            writer2.writeVarInt(NMSUtilsKt.getDATA_VERSION());
            writer2.writeUUID(uuid);
            writer2.writeVarInt(size);
            BitSet itemsMask = new BitSet(size);
            boolean j = false;
            int n = items.length;
            while (objectArray < n) {
                void slot = objectArray;
                ItemStack itemStack = items[objectArray];
                if (!ItemUtilsKt.isNullOrEmpty(itemStack)) {
                    itemsMask.set((int)slot);
                }
                ++objectArray;
            }
            byte[] byArray = itemsMask.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            byte[] byArray2 = byArray;
            n = MathUtilsKt.ceilDiv(size, 8);
            byte[] byArray3 = Arrays.copyOf(byArray2, n);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
            writer2.writeBytes(byArray3);
            ItemStack[] itemStackArray2 = obj.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)itemStackArray2, (String)"getItems(...)");
            ItemStack[] itemStackArray3 = itemStackArray2;
            int n2 = itemStackArray3.length;
            for (n = 0; n < n2; ++n) {
                ItemStack itemStack2 = itemStackArray3[n];
                if (ItemUtilsKt.isNullOrEmpty(itemStack2)) continue;
                net.minecraft.world.item.ItemStack nmsStack = NMSUtilsKt.unwrap(itemStack2);
                Object t = net.minecraft.world.item.ItemStack.CODEC.encodeStart((DynamicOps)NMSUtilsKt.getREGISTRY_ACCESS().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nmsStack).resultOrPartial().get();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                CompoundTag nbt = (CompoundTag)t;
                NbtIo.write((CompoundTag)nbt, (DataOutput)dataOutput);
            }
            int[] nArray2 = maxStackSizes;
            boolean $i$f$any = false;
            int itemStack2 = nArray2.length;
            for (n2 = 0; n2 < itemStack2; ++n2) {
                int element$iv;
                int it = element$iv = nArray2[n2];
                boolean bl2 = false;
                if (!(it != 64)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            writer2.writeBoolean(true);
            int[] nArray = obj.getMaxStackSizes();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getMaxStackSizes(...)");
            for (int stackSize : nArray) {
                writer2.writeVarInt(stackSize);
            }
        } else {
            writer2.writeBoolean(false);
        }
    }

    @NotNull
    public VirtualInventory copyNonNull(@NotNull VirtualInventory obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return new VirtualInventory(obj);
    }
}

