/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.serialization.kotlinx;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.NMSUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lxyz/xenondevs/nova/serialization/kotlinx/NmsRegistryEntrySerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "registry", "Lnet/minecraft/core/Registry;", "<init>", "(Lnet/minecraft/core/Registry;)V", "getRegistry", "()Lnet/minecraft/core/Registry;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "nova"})
public abstract class NmsRegistryEntrySerializer<T>
implements KSerializer<T> {
    @NotNull
    private final Registry<T> registry;
    @NotNull
    private final SerialDescriptor descriptor;

    public NmsRegistryEntrySerializer(@NotNull Registry<T> registry) {
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        this.registry = registry;
        this.descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"xyz.xenondevs.nova.RegistryEntrySerializer", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }

    @NotNull
    public final Registry<T> getRegistry() {
        return this.registry;
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        ResourceLocation resourceLocation = this.registry.getKey(value);
        if (resourceLocation == null) {
            throw new SerializationException("Value " + value + " is not registered in " + this.registry);
        }
        ResourceLocation id = resourceLocation;
        String string = id.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }

    @NotNull
    public T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        String id = decoder.decodeString();
        T t = NMSUtilsKt.getValue(this.registry, id);
        if (t == null) {
            throw new SerializationException("No entry under " + id + " in " + this.registry);
        }
        return t;
    }
}

