/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.ui.overlay.bossbar.positioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.collections.IterablesKt;
import xyz.xenondevs.nova.ui.overlay.bossbar.BossBarOverlayCompound;
import xyz.xenondevs.nova.ui.overlay.bossbar.positioning.BarMatchInfo;
import xyz.xenondevs.nova.ui.overlay.bossbar.positioning.BarMatcher;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u0000 \u00132\u00020\u0001:\u0003\u0011\u0012\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarPositioning;", "", "info", "Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatchInfo;", "matchAbove", "Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatcher;", "matchBelow", "<init>", "(Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatchInfo;Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatcher;Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatcher;)V", "getInfo", "()Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatchInfo;", "getMatchAbove", "()Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatcher;", "getMatchBelow", "compareTo", "", "other", "Fixed", "Dynamic", "Companion", "nova"})
public abstract class BarPositioning {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BarMatchInfo info;
    @NotNull
    private final BarMatcher matchAbove;
    @NotNull
    private final BarMatcher matchBelow;

    public BarPositioning(@NotNull BarMatchInfo info, @NotNull BarMatcher matchAbove, @NotNull BarMatcher matchBelow) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)matchAbove, (String)"matchAbove");
        Intrinsics.checkNotNullParameter((Object)matchBelow, (String)"matchBelow");
        this.info = info;
        this.matchAbove = matchAbove;
        this.matchBelow = matchBelow;
    }

    @NotNull
    public final BarMatchInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final BarMatcher getMatchAbove() {
        return this.matchAbove;
    }

    @NotNull
    public final BarMatcher getMatchBelow() {
        return this.matchBelow;
    }

    public int compareTo(@NotNull BarPositioning other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BarMatcher matchAbove = this.matchAbove;
        BarMatcher otherMatchAbove = other.matchAbove;
        BarMatcher matchBelow = this.matchBelow;
        BarMatcher otherMatchBelow = other.matchBelow;
        BarMatchInfo info = this.info;
        BarMatchInfo otherInfo = other.info;
        boolean otherAboveThis = matchAbove.test(otherInfo);
        boolean otherBelowThis = matchBelow.test(otherInfo);
        boolean thisAboveOther = otherMatchAbove.test(info);
        boolean thisBelowOther = otherMatchBelow.test(info);
        if (otherAboveThis == thisAboveOther && otherBelowThis == thisBelowOther) {
            return 0;
        }
        if (otherAboveThis && otherBelowThis || thisAboveOther && thisBelowOther) {
            return 0;
        }
        if (otherAboveThis || thisBelowOther) {
            return 1;
        }
        return -1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\b"}, d2={"Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarPositioning$Companion;", "", "<init>", "()V", "sort", "", "Lxyz/xenondevs/nova/ui/overlay/bossbar/BossBarOverlayCompound;", "overlays", "nova"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<BossBarOverlayCompound> sort(@NotNull List<? extends BossBarOverlayCompound> overlays) {
            Intrinsics.checkNotNullParameter(overlays, (String)"overlays");
            List inp = CollectionsKt.toMutableList((Collection)overlays);
            ArrayList<BossBarOverlayCompound> out = new ArrayList<BossBarOverlayCompound>();
            while (!((Collection)inp).isEmpty()) {
                Object object = IterablesKt.poll((Iterable)inp);
                Intrinsics.checkNotNull((Object)object);
                BossBarOverlayCompound newEntry = (BossBarOverlayCompound)object;
                int self = -1;
                for (int i2 = 0; i2 < out.size(); ++i2) {
                    Object e = out.get(i2);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    BossBarOverlayCompound oldEntry = (BossBarOverlayCompound)e;
                    int res = newEntry.getPositioning().compareTo(oldEntry.getPositioning());
                    if (self == -1) {
                        switch (res) {
                            case -1: {
                                out.add(i2, newEntry);
                                self = i2++;
                                break;
                            }
                            case 1: {
                                out.add(i2 + 1, newEntry);
                                self = i2 + 1;
                                ++i2;
                            }
                        }
                        continue;
                    }
                    if (res != 1) continue;
                    out.remove(i2);
                    out.add(self, oldEntry);
                    ++self;
                }
                if (self != -1) continue;
                out.add(newEntry);
            }
            return out;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarPositioning$Dynamic;", "Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarPositioning;", "marginTop", "", "marginBottom", "info", "Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatchInfo;", "matchAbove", "Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatcher;", "matchBelow", "<init>", "(IILxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatchInfo;Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatcher;Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatcher;)V", "getMarginTop", "()I", "getMarginBottom", "nova"})
    public static final class Dynamic
    extends BarPositioning {
        private final int marginTop;
        private final int marginBottom;

        public Dynamic(int marginTop, int marginBottom, @NotNull BarMatchInfo info, @NotNull BarMatcher matchAbove, @NotNull BarMatcher matchBelow) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)matchAbove, (String)"matchAbove");
            Intrinsics.checkNotNullParameter((Object)matchBelow, (String)"matchBelow");
            super(info, matchAbove, matchBelow);
            this.marginTop = marginTop;
            this.marginBottom = marginBottom;
        }

        public final int getMarginTop() {
            return this.marginTop;
        }

        public final int getMarginBottom() {
            return this.marginBottom;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarPositioning$Fixed;", "Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarPositioning;", "offset", "", "info", "Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatchInfo;", "matchAbove", "Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatcher;", "matchBelow", "<init>", "(ILxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatchInfo;Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatcher;Lxyz/xenondevs/nova/ui/overlay/bossbar/positioning/BarMatcher;)V", "getOffset", "()I", "nova"})
    public static final class Fixed
    extends BarPositioning {
        private final int offset;

        public Fixed(int offset, @NotNull BarMatchInfo info, @NotNull BarMatcher matchAbove, @NotNull BarMatcher matchBelow) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)matchAbove, (String)"matchAbove");
            Intrinsics.checkNotNullParameter((Object)matchBelow, (String)"matchBelow");
            super(info, matchAbove, matchBelow);
            this.offset = offset;
        }

        public final int getOffset() {
            return this.offset;
        }
    }
}

