/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.ui.overlay.bossbar.vanilla;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.ARGBLike;
import net.minecraft.world.BossEvent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.resources.CharSizes;
import xyz.xenondevs.nova.ui.overlay.bossbar.BossBarOverlay;
import xyz.xenondevs.nova.ui.overlay.bossbar.vanilla.VanillaBossBarOverlayKt;
import xyz.xenondevs.nova.util.BossBar;
import xyz.xenondevs.nova.util.component.adventure.ComponentUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0013H\u0002J&\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000b\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00132\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lxyz/xenondevs/nova/ui/overlay/bossbar/vanilla/VanillaBossBarOverlay;", "Lxyz/xenondevs/nova/ui/overlay/bossbar/BossBarOverlay;", "player", "Lorg/bukkit/entity/Player;", "bar", "Lxyz/xenondevs/nova/util/BossBar;", "<init>", "(Lorg/bukkit/entity/Player;Lxyz/xenondevs/nova/util/BossBar;)V", "getBar", "()Lxyz/xenondevs/nova/util/BossBar;", "offset", "", "getOffset", "()I", "centerX", "", "getCenterX", "()Ljava/lang/Void;", "component", "Lnet/kyori/adventure/text/Component;", "getComponent", "()Lnet/kyori/adventure/text/Component;", "setComponent", "(Lnet/kyori/adventure/text/Component;)V", "getWidth", "", "locale", "", "getVerticalRange", "Lkotlin/ranges/IntRange;", "update", "", "createComponent", "getProgressComponent", "Lkotlin/Pair;", "progress", "color", "Lnet/kyori/adventure/text/format/TextColor;", "getStyleComponent", "style", "Lnet/minecraft/world/BossEvent$BossBarOverlay;", "toString", "nova"})
public final class VanillaBossBarOverlay
implements BossBarOverlay {
    @NotNull
    private final Player player;
    @NotNull
    private final BossBar bar;
    private final int offset;
    @Nullable
    private final Void centerX;
    @NotNull
    private Component component;

    public VanillaBossBarOverlay(@NotNull Player player, @NotNull BossBar bar) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)bar, (String)"bar");
        this.player = player;
        this.bar = bar;
        this.component = this.createComponent();
    }

    @NotNull
    public final BossBar getBar() {
        return this.bar;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Nullable
    public Void getCenterX() {
        return this.centerX;
    }

    @Override
    @NotNull
    public Component getComponent() {
        return this.component;
    }

    public void setComponent(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"<set-?>");
        this.component = component2;
    }

    @Override
    public float getWidth(@NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return 0.0f;
    }

    @Override
    @NotNull
    public IntRange getVerticalRange(@NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return new IntRange(2, 6);
    }

    public final void update() {
        this.setComponent(this.createComponent());
    }

    private final Component createComponent() {
        boolean barRendered;
        TextComponent.Builder builder = Component.text();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"text(...)");
        TextComponent.Builder builder2 = builder;
        BossEvent.BossBarColor barColor = this.bar.getColor();
        boolean bl = barRendered = !VanillaBossBarOverlayKt.access$getINVISIBLE_COLORS().contains(barColor);
        if (barRendered) {
            Component style;
            Object v = VanillaBossBarOverlayKt.access$getCOLOR_LOOKUP$p().get(this.bar.getColor());
            Intrinsics.checkNotNull(v);
            TextColor color = (TextColor)v;
            TextComponent.Builder builder3 = (TextComponent.Builder)ComponentUtilsKt.move((ComponentBuilder)builder2, -91);
            TextComponent textComponent = Component.text((char)'\uf000');
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
            ComponentBuilder componentBuilder = builder3.append(ComponentUtilsKt.font((Component)textComponent, "nova:bossbar").shadowColor((ARGBLike)ShadowColor.none()));
            Intrinsics.checkNotNullExpressionValue((Object)componentBuilder, (String)"append(...)");
            ComponentUtilsKt.move(componentBuilder, -183);
            Pair<Component, Integer> progress = this.getProgressComponent(this.bar.getProgress(), color);
            if (progress != null) {
                Pair<Component, Integer> pair = progress;
                Component progressComponent = (Component)pair.component1();
                int progressWidth = ((Number)pair.component2()).intValue();
                ComponentBuilder componentBuilder2 = builder2.append(progressComponent.color(color));
                Intrinsics.checkNotNullExpressionValue((Object)componentBuilder2, (String)"append(...)");
                ComponentUtilsKt.move(componentBuilder2, -progressWidth - 1);
            }
            if ((style = this.getStyleComponent(this.bar.getOverlay())) != null) {
                ComponentBuilder componentBuilder3 = builder2.append(style);
                Intrinsics.checkNotNullExpressionValue((Object)componentBuilder3, (String)"append(...)");
                ComponentUtilsKt.move(componentBuilder3, -183);
            }
        }
        Component text = this.bar.getName();
        String string = this.player.getLocale();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocale(...)");
        float textLength = CharSizes.INSTANCE.calculateComponentWidth(text, string);
        float halfTextLength = textLength / (float)2;
        ComponentBuilder componentBuilder = ((TextComponent.Builder)ComponentUtilsKt.move((ComponentBuilder)builder2, Float.valueOf((float)(barRendered ? 91 : 0) - halfTextLength))).append(text);
        Intrinsics.checkNotNullExpressionValue((Object)componentBuilder, (String)"append(...)");
        ComponentUtilsKt.move(componentBuilder, Float.valueOf(-halfTextLength));
        BuildableComponent buildableComponent = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
        return (Component)buildableComponent;
    }

    private final Pair<Component, Integer> getProgressComponent(float progress, TextColor color) {
        if (!(0.0f <= progress ? progress <= 1.0f : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (progress == 0.0f) {
            return null;
        }
        int i2 = MathKt.roundToInt((float)(progress * (float)182));
        String string = String.valueOf((char)(65280 + i2));
        TextComponent textComponent = Component.text((String)string, (Style)Style.style((TextColor)color));
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        Component component2 = ComponentUtilsKt.font((Component)textComponent, "nova:bossbar").shadowColor((ARGBLike)ShadowColor.none());
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"shadowColor(...)");
        Component component3 = component2;
        return TuplesKt.to((Object)component3, (Object)i2);
    }

    private final Component getStyleComponent(BossEvent.BossBarOverlay style) {
        String string = switch (WhenMappings.$EnumSwitchMapping$0[style.ordinal()]) {
            case 1 -> null;
            case 2 -> "\uf001";
            case 3 -> "\uf002";
            case 4 -> "\uf003";
            case 5 -> "\uf004";
            default -> throw new NoWhenBranchMatchedException();
        };
        if (string == null) {
            return null;
        }
        String string2 = string;
        TextComponent textComponent = Component.text((String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        return ComponentUtilsKt.font((Component)textComponent, "nova:bossbar").shadowColor((ARGBLike)ShadowColor.none());
    }

    @NotNull
    public String toString() {
        return "VanillaBossBarOverlay(text=" + ComponentUtilsKt.toPlainText$default(this.bar.getName(), null, 1, null) + ")";
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BossEvent.BossBarOverlay.values().length];
            try {
                nArray[BossEvent.BossBarOverlay.PROGRESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BossEvent.BossBarOverlay.NOTCHED_6.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BossEvent.BossBarOverlay.NOTCHED_10.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BossEvent.BossBarOverlay.NOTCHED_12.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BossEvent.BossBarOverlay.NOTCHED_20.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

