/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018\u00a8\u0006\u001b"}, d2={"Lxyz/xenondevs/nova/util/BlockFaceUtils;", "", "<init>", "()V", "determineBlockFace", "Lorg/bukkit/block/BlockFace;", "block", "Lorg/bukkit/block/Block;", "location", "Lorg/bukkit/Location;", "determineBlockFaceLookingAt", "maxDistance", "", "determineBlockFaceBetween", "from", "Lxyz/xenondevs/nova/world/BlockPos;", "to", "toFace", "axis", "Lorg/bukkit/Axis;", "positive", "", "toCartesianFace", "yaw", "", "pitch", "toAxis", "nova"})
@SourceDebugExtension(value={"SMAP\nBlockFaceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockFaceUtils.kt\nxyz/xenondevs/nova/util/BlockFaceUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,373:1\n1068#2:374\n*S KotlinDebug\n*F\n+ 1 BlockFaceUtils.kt\nxyz/xenondevs/nova/util/BlockFaceUtils\n*L\n226#1:374\n*E\n"})
public final class BlockFaceUtils {
    @NotNull
    public static final BlockFaceUtils INSTANCE = new BlockFaceUtils();

    private BlockFaceUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BlockFace determineBlockFace(@NotNull Block block, @NotNull Location location) {
        void $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Object object = new Pair[]{TuplesKt.to((Object)Axis.X, (Object)(location.getX() - ((double)block.getX() + 0.5))), TuplesKt.to((Object)Axis.Y, (Object)(location.getY() - ((double)block.getY() + 0.5))), TuplesKt.to((Object)Axis.Z, (Object)(location.getZ() - ((double)block.getZ() + 0.5)))};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$sortedByDescending = false;
        Pair result = (Pair)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(Math.abs(((Number)it.getSecond()).doubleValue()));
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(Math.abs(((Number)it.getSecond()).doubleValue())));
            }
        }).get(0);
        return this.toFace((Axis)result.getFirst(), ((Number)result.getSecond()).doubleValue() >= 0.0);
    }

    @Nullable
    public final BlockFace determineBlockFaceLookingAt(@NotNull Location location, double maxDistance) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Vec3 start2 = NMSUtilsKt.getVec3(location);
        Vector vector = location.getDirection();
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"getDirection(...)");
        Vector direction = vector;
        Vec3 end = start2.add(direction.getX() * maxDistance, direction.getY() * maxDistance, direction.getZ() * maxDistance);
        ClipContext ctx = new ClipContext(start2, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty());
        World world = location.getWorld();
        Intrinsics.checkNotNull((Object)world);
        BlockHitResult result = NMSUtilsKt.getServerLevel(world).clip(ctx);
        if (result.getType() == HitResult.Type.BLOCK) {
            Direction direction2 = result.getDirection();
            Intrinsics.checkNotNullExpressionValue((Object)direction2, (String)"getDirection(...)");
            return NMSUtilsKt.getBlockFace(direction2);
        }
        return null;
    }

    public static /* synthetic */ BlockFace determineBlockFaceLookingAt$default(BlockFaceUtils blockFaceUtils, Location location, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 6.0;
        }
        return blockFaceUtils.determineBlockFaceLookingAt(location, d);
    }

    @Nullable
    public final BlockFace determineBlockFaceBetween(@NotNull BlockPos from, @NotNull BlockPos to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        int x = to.getX() - from.getX();
        int y = to.getY() - from.getY();
        int z = to.getZ() - from.getZ();
        return x == 0 && y == 0 && z == -1 ? BlockFace.NORTH : (x == 1 && y == 0 && z == 0 ? BlockFace.EAST : (x == 0 && y == 0 && z == 1 ? BlockFace.SOUTH : (x == -1 && y == 0 && z == 0 ? BlockFace.WEST : (x == 0 && y == 1 && z == 0 ? BlockFace.UP : (x == 0 && y == -1 && z == 0 ? BlockFace.DOWN : (x == 1 && y == 0 && z == -1 ? BlockFace.NORTH_EAST : (x == 1 && y == 0 && z == 1 ? BlockFace.SOUTH_EAST : (x == -1 && y == 0 && z == 1 ? BlockFace.SOUTH_WEST : (x == -1 && y == 0 && z == -1 ? BlockFace.NORTH_WEST : null)))))))));
    }

    @NotNull
    public final BlockFace toFace(@NotNull Axis axis, boolean positive) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1 -> {
                if (positive) {
                    yield BlockFace.EAST;
                }
                yield BlockFace.WEST;
            }
            case 2 -> {
                if (positive) {
                    yield BlockFace.UP;
                }
                yield BlockFace.DOWN;
            }
            case 3 -> {
                if (positive) {
                    yield BlockFace.SOUTH;
                }
                yield BlockFace.NORTH;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ BlockFace toFace$default(BlockFaceUtils blockFaceUtils, Axis axis, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return blockFaceUtils.toFace(axis, bl);
    }

    @NotNull
    public final BlockFace toCartesianFace(float yaw) {
        float f = yaw;
        float f2 = 360.0f;
        float f3 = f % f2;
        float yawMod = !(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f2)) ? f3 + f2 : f3;
        return yawMod >= 315.0f ? BlockFace.SOUTH : (yawMod >= 225.0f ? BlockFace.EAST : (yawMod >= 135.0f ? BlockFace.NORTH : (yawMod >= 45.0f ? BlockFace.WEST : BlockFace.SOUTH)));
    }

    @NotNull
    public final BlockFace toCartesianFace(float yaw, float pitch) {
        float f = yaw;
        float f2 = 360.0f;
        float f3 = f % f2;
        float yawMod = !(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f2)) ? f3 + f2 : f3;
        float pitchMod = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(pitch), (ClosedFloatingPointRange)RangesKt.rangeTo((float)-90.0f, (float)90.0f)))).floatValue();
        return pitchMod < -45.0f ? BlockFace.UP : (pitchMod > 45.0f ? BlockFace.DOWN : (yawMod >= 315.0f ? BlockFace.SOUTH : (yawMod >= 225.0f ? BlockFace.EAST : (yawMod >= 135.0f ? BlockFace.NORTH : (yawMod >= 45.0f ? BlockFace.WEST : BlockFace.SOUTH)))));
    }

    @NotNull
    public final BlockFace toFace(float yaw) {
        float f = yaw;
        float f2 = 360.0f;
        float f3 = f % f2;
        float yawMod = !(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f2)) ? f3 + f2 : f3;
        return (double)yawMod >= 348.75 ? BlockFace.SOUTH : ((double)yawMod >= 326.25 ? BlockFace.SOUTH_SOUTH_EAST : ((double)yawMod >= 303.75 ? BlockFace.SOUTH_EAST : ((double)yawMod >= 281.25 ? BlockFace.EAST_SOUTH_EAST : ((double)yawMod >= 258.75 ? BlockFace.EAST : ((double)yawMod >= 236.25 ? BlockFace.EAST_NORTH_EAST : ((double)yawMod >= 213.75 ? BlockFace.NORTH_EAST : ((double)yawMod >= 191.25 ? BlockFace.NORTH_NORTH_EAST : ((double)yawMod >= 168.75 ? BlockFace.NORTH : ((double)yawMod >= 146.25 ? BlockFace.NORTH_NORTH_WEST : ((double)yawMod >= 123.75 ? BlockFace.NORTH_WEST : ((double)yawMod >= 101.25 ? BlockFace.WEST_NORTH_WEST : ((double)yawMod >= 78.75 ? BlockFace.WEST : ((double)yawMod >= 56.25 ? BlockFace.WEST_SOUTH_WEST : ((double)yawMod >= 33.75 ? BlockFace.SOUTH_WEST : ((double)yawMod >= 11.25 ? BlockFace.SOUTH_SOUTH_WEST : BlockFace.SOUTH)))))))))))))));
    }

    @NotNull
    public final Axis toAxis(float yaw) {
        float f = yaw;
        float f2 = 360.0f;
        float f3 = f % f2;
        float yawMod = !(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f2)) ? f3 + f2 : f3;
        return yawMod >= 315.0f ? Axis.Z : (yawMod >= 225.0f ? Axis.X : (yawMod >= 135.0f ? Axis.Z : (yawMod >= 45.0f ? Axis.X : Axis.Z)));
    }

    @NotNull
    public final Axis toAxis(float yaw, float pitch) {
        float f = yaw;
        float f2 = 360.0f;
        float f3 = f % f2;
        float yawMod = !(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f2)) ? f3 + f2 : f3;
        float pitchMod = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(pitch), (ClosedFloatingPointRange)RangesKt.rangeTo((float)-90.0f, (float)90.0f)))).floatValue();
        return pitchMod < -45.0f ? Axis.Y : (pitchMod > 45.0f ? Axis.Y : (yawMod >= 315.0f ? Axis.Z : (yawMod >= 225.0f ? Axis.X : (yawMod >= 135.0f ? Axis.Z : (yawMod >= 45.0f ? Axis.X : Axis.Z)))));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Axis.values().length];
            try {
                nArray[Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Axis.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Axis.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

