/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Axis;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.xenondevs.nova.util.LocationUtils;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.util.particle.ParticleBuilder;
import xyz.xenondevs.nova.util.particle.ParticleBuilderKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00ce\u0001\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u0011\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\n\u001a\n\u0010\u0018\u001a\u00020\n*\u00020\n\u001a!\u0010\u0019\u001a\u00070\n\u00a2\u0006\u0002\b\u001a*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00022\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a!\u0010\u0019\u001a\u00070\n\u00a2\u0006\u0002\b\u001a*\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a\u001a\u0010 \u001a\u00020\u0017*\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001d\u001a\u0012\u0010\"\u001a\u00020\u001d*\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0012\u0010#\u001a\u00020\n*\u00020\n2\u0006\u0010$\u001a\u00020%\u001a\u0012\u0010&\u001a\u00020\n*\u00020\n2\u0006\u0010$\u001a\u00020%\u001a\u0012\u0010#\u001a\u00020\n*\u00020\n2\u0006\u0010$\u001a\u00020'\u001a\u0012\u0010&\u001a\u00020\n*\u00020\n2\u0006\u0010$\u001a\u00020'\u001a\u0015\u0010(\u001a\n )*\u0004\u0018\u00010\u000f0\u000f*\u00020\nH\u0086\u0002\u001a\r\u0010*\u001a\u00020\u001d*\u00020\nH\u0086\u0002\u001a\r\u0010+\u001a\u00020\u001d*\u00020\nH\u0086\u0002\u001a\r\u0010,\u001a\u00020\u001d*\u00020\nH\u0086\u0002\u001a\r\u0010-\u001a\u00020.*\u00020\nH\u0086\u0002\u001a\r\u0010/\u001a\u00020.*\u00020\nH\u0086\u0002\u001a\u0012\u00100\u001a\u000201*\u00020\n2\u0006\u00102\u001a\u00020\n\u001a\n\u00103\u001a\u000201*\u00020\n\u001a\u001a\u00104\u001a\u000201*\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\n\u001a\u001a\u00107\u001a\u000201*\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\n\u001a\n\u00108\u001a\u000201*\u00020\n\u001a\n\u00109\u001a\u00020:*\u00020;\u001a\n\u0010<\u001a\u00020.*\u00020;\u001a\u0016\u0010=\u001a\u00020;2\u0006\u0010\u0014\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020.\u001a\n\u0010>\u001a\u00020%*\u00020\n\u001a\n\u0010?\u001a\u00020'*\u00020\n\u001a\n\u0010@\u001a\u00020A*\u00020\n\u001a\u0016\u0010B\u001a\u00020\n*\u00020C2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\n\u0010@\u001a\u00020A*\u00020C\u001a\u0016\u0010B\u001a\u00020\n*\u00020D2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\n\u0010@\u001a\u00020A*\u00020D\u001a\n\u0010@\u001a\u00020A*\u00020;\u001a*\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F*\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u0002012\b\b\u0002\u0010K\u001a\u000201\u001a1\u0010L\u001a\b\u0012\u0004\u0012\u00020N0M*\u00020\n2\u0006\u0010O\u001a\u00020\u001d2\u0012\u0010P\u001a\n\u0012\u0006\b\u0001\u0012\u00020N0Q\"\u00020N\u00a2\u0006\u0002\u0010R\u001a&\u0010S\u001a\b\u0012\u0004\u0012\u00020N0F*\b\u0012\u0004\u0012\u00020N0T2\u0006\u0010U\u001a\u00020\n2\u0006\u0010O\u001a\u00020\u001d\u001a4\u0010V\u001a\u00020\u0017*\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010O\u001a\u00020\u001d2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002010XH\u0086\b\u00f8\u0001\u0000\u001a\u001a\u0010Y\u001a\u00020\n*\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010O\u001a\u00020\u001d\u001a&\u0010Z\u001a\u00020\u0017*\u00020\n2\u0006\u0010[\u001a\u0002012\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002010X\u001a\u001c\u0010\\\u001a\u0004\u0018\u00010\n*\u00020\n2\u0006\u0010]\u001a\u0002012\u0006\u0010^\u001a\u000201\u001a \u0010_\u001a\b\u0012\u0004\u0012\u00020\n0F*\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010`\u001a\u00020I\u001a,\u0010a\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0F0b*\u00020\n2\u0006\u0010`\u001a\u00020\n2\u0006\u0010c\u001a\u000201\u001a,\u0010d\u001a\u00020\u0017*\u00020\n2\u0006\u0010`\u001a\u00020\n2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002010XH\u0086\b\u00f8\u0001\u0000\u001a*\u0010e\u001a\b\u0012\u0004\u0012\u00020\n0F*\u00020\n2\u0006\u00102\u001a\u00020\n2\u0006\u0010f\u001a\u0002012\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a\u0018\u0010g\u001a\b\u0012\u0004\u0012\u00020\n0F*\u00020\n2\u0006\u00102\u001a\u00020\n\u001a\u0018\u0010h\u001a\u00020\u0017*\u00020\n2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020j0T\u001a\u0012\u0010k\u001a\u00020\u0017*\u00020\n2\u0006\u0010l\u001a\u00020j\u001a \u0010m\u001a\u00020\u0017*\u00020\u000f2\u0006\u0010U\u001a\u00020\n2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020j0T\u001a\u0012\u0010n\u001a\u00020o*\u00020\n2\u0006\u0010p\u001a\u00020q\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0004\"\u0015\u0010\t\u001a\u00020\n*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006r"}, d2={"CUBE_FACES", "", "Lorg/bukkit/block/BlockFace;", "getCUBE_FACES", "()Ljava/util/Set;", "HORIZONTAL_FACES", "getHORIZONTAL_FACES", "VERTICAL_FACES", "getVERTICAL_FACES", "blockLocation", "Lorg/bukkit/Location;", "getBlockLocation", "(Lorg/bukkit/Location;)Lorg/bukkit/Location;", "Location", "world", "Lorg/bukkit/World;", "x", "", "y", "z", "yaw", "pitch", "removeOrientation", "", "center", "advance", "Lorg/jetbrains/annotations/NotNull;", "blockFace", "stepSize", "", "axis", "Lorg/bukkit/Axis;", "setCoordinate", "coordinate", "getCoordinate", "add", "vec", "Lorg/joml/Vector3d;", "subtract", "Lorg/joml/Vector3f;", "component1", "kotlin.jvm.PlatformType", "component2", "component3", "component4", "component5", "", "component6", "positionEquals", "", "other", "isBlockLocation", "isBetween", "min", "max", "isBetweenXZ", "isInsideWorldRestrictions", "calculateYawPitch", "", "Lorg/bukkit/util/Vector;", "calculateYaw", "Vector", "toVector3d", "toVector3f", "toVec3", "Lnet/minecraft/world/phys/Vec3;", "toLocation", "Lorg/joml/Vector3dc;", "Lorg/joml/Vector3fc;", "getSurroundingChunks", "", "Lorg/bukkit/Chunk;", "range", "", "includeCurrent", "ignoreUnloaded", "getPlayersNearby", "Lkotlin/sequences/Sequence;", "Lorg/bukkit/entity/Player;", "maxDistance", "excluded", "", "(Lorg/bukkit/Location;D[Lorg/bukkit/entity/Player;)Lkotlin/sequences/Sequence;", "filterInRange", "", "location", "castRay", "run", "Lkotlin/Function1;", "getTargetLocation", "untilHeightLimit", "includeThis", "getNextBlockBelow", "countSelf", "requiresSolid", "getStraightLine", "to", "getRectangle", "", "omitCorners", "fullCuboidTo", "getBoxOutline", "correct", "getFullCuboid", "dropItems", "items", "Lorg/bukkit/inventory/ItemStack;", "dropItem", "item", "dropItemsNaturally", "createColoredParticle", "Lnet/minecraft/network/protocol/game/ClientboundLevelParticlesPacket;", "color", "Ljava/awt/Color;", "nova"})
@SourceDebugExtension(value={"SMAP\nLocationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationUtils.kt\nxyz/xenondevs/nova/util/LocationUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Sets.kt\nxyz/xenondevs/commons/collections/SetsKt\n*L\n1#1,444:1\n230#1,8:448\n774#2:445\n865#2,2:446\n1563#2:457\n1634#2,3:458\n1869#2,2:461\n1869#2,2:463\n1869#2,2:465\n1869#2,2:467\n1#3:456\n1#3:471\n1#3:474\n1#3:477\n22#4:469\n20#4:470\n22#4:472\n20#4:473\n22#4:475\n20#4:476\n*S KotlinDebug\n*F\n+ 1 LocationUtils.kt\nxyz/xenondevs/nova/util/LocationUtilsKt\n*L\n242#1:448,8\n221#1:445\n221#1:446,2\n283#1:457\n283#1:458,3\n301#1:461,2\n309#1:463,2\n394#1:465,2\n402#1:467,2\n31#1:471\n32#1:474\n33#1:477\n31#1:469\n31#1:470\n32#1:472\n32#1:473\n33#1:475\n33#1:476\n*E\n"})
public final class LocationUtilsKt {
    @NotNull
    private static final Set<BlockFace> CUBE_FACES;
    @NotNull
    private static final Set<BlockFace> HORIZONTAL_FACES;
    @NotNull
    private static final Set<BlockFace> VERTICAL_FACES;

    @NotNull
    public static final Set<BlockFace> getCUBE_FACES() {
        return CUBE_FACES;
    }

    @NotNull
    public static final Set<BlockFace> getHORIZONTAL_FACES() {
        return HORIZONTAL_FACES;
    }

    @NotNull
    public static final Set<BlockFace> getVERTICAL_FACES() {
        return VERTICAL_FACES;
    }

    @NotNull
    public static final Location getBlockLocation(@NotNull Location $this$blockLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$blockLocation, (String)"<this>");
        return new Location($this$blockLocation.getWorld(), (double)$this$blockLocation.getBlockX(), (double)$this$blockLocation.getBlockY(), (double)$this$blockLocation.getBlockZ());
    }

    @NotNull
    public static final Location Location(@Nullable World world, @NotNull Number x, @NotNull Number y, @NotNull Number z, @NotNull Number yaw, @NotNull Number pitch) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Intrinsics.checkNotNullParameter((Object)yaw, (String)"yaw");
        Intrinsics.checkNotNullParameter((Object)pitch, (String)"pitch");
        return new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue(), yaw.floatValue(), pitch.floatValue());
    }

    public static /* synthetic */ Location Location$default(World world, Number number, Number number2, Number number3, Number number4, Number number5, int n, Object object) {
        if ((n & 0x10) != 0) {
            number4 = 0;
        }
        if ((n & 0x20) != 0) {
            number5 = 0;
        }
        return LocationUtilsKt.Location(world, number, number2, number3, number4, number5);
    }

    public static final void removeOrientation(@NotNull Location $this$removeOrientation) {
        Intrinsics.checkNotNullParameter((Object)$this$removeOrientation, (String)"<this>");
        $this$removeOrientation.setYaw(0.0f);
        $this$removeOrientation.setPitch(0.0f);
    }

    @NotNull
    public static final Location center(@NotNull Location $this$center) {
        Intrinsics.checkNotNullParameter((Object)$this$center, (String)"<this>");
        Location location = $this$center.add(0.5, 0.0, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        return location;
    }

    @NotNull
    public static final Location advance(@NotNull Location $this$advance, @NotNull BlockFace blockFace, double stepSize) {
        Intrinsics.checkNotNullParameter((Object)$this$advance, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)blockFace, (String)"blockFace");
        Location location = $this$advance.add((double)blockFace.getModX() * stepSize, (double)blockFace.getModY() * stepSize, (double)blockFace.getModZ() * stepSize);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        return location;
    }

    public static /* synthetic */ Location advance$default(Location location, BlockFace blockFace, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        return LocationUtilsKt.advance(location, blockFace, d);
    }

    @NotNull
    public static final Location advance(@NotNull Location $this$advance, @NotNull Axis axis, double stepSize) {
        Intrinsics.checkNotNullParameter((Object)$this$advance, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Location location = switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1 -> $this$advance.add(stepSize, 0.0, 0.0);
            case 2 -> $this$advance.add(0.0, stepSize, 0.0);
            case 3 -> $this$advance.add(0.0, 0.0, stepSize);
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)location);
        return location;
    }

    public static /* synthetic */ Location advance$default(Location location, Axis axis, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        return LocationUtilsKt.advance(location, axis, d);
    }

    public static final void setCoordinate(@NotNull Location $this$setCoordinate, @NotNull Axis axis, double coordinate) {
        Intrinsics.checkNotNullParameter((Object)$this$setCoordinate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1: {
                $this$setCoordinate.setX(coordinate);
                break;
            }
            case 2: {
                $this$setCoordinate.setY(coordinate);
                break;
            }
            case 3: {
                $this$setCoordinate.setZ(coordinate);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static final double getCoordinate(@NotNull Location $this$getCoordinate, @NotNull Axis axis) {
        Intrinsics.checkNotNullParameter((Object)$this$getCoordinate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1 -> $this$getCoordinate.getX();
            case 2 -> $this$getCoordinate.getY();
            case 3 -> $this$getCoordinate.getZ();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final Location add(@NotNull Location $this$add, @NotNull Vector3d vec) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        $this$add.setX($this$add.getX() + vec.x);
        $this$add.setY($this$add.getY() + vec.y);
        $this$add.setZ($this$add.getZ() + vec.z);
        return $this$add;
    }

    @NotNull
    public static final Location subtract(@NotNull Location $this$subtract, @NotNull Vector3d vec) {
        Intrinsics.checkNotNullParameter((Object)$this$subtract, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        $this$subtract.setX($this$subtract.getX() - vec.x);
        $this$subtract.setY($this$subtract.getY() - vec.y);
        $this$subtract.setZ($this$subtract.getZ() - vec.z);
        return $this$subtract;
    }

    @NotNull
    public static final Location add(@NotNull Location $this$add, @NotNull Vector3f vec) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        $this$add.setX($this$add.getX() + (double)vec.x);
        $this$add.setY($this$add.getY() + (double)vec.y);
        $this$add.setZ($this$add.getZ() + (double)vec.z);
        return $this$add;
    }

    @NotNull
    public static final Location subtract(@NotNull Location $this$subtract, @NotNull Vector3f vec) {
        Intrinsics.checkNotNullParameter((Object)$this$subtract, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        $this$subtract.setX($this$subtract.getX() - (double)vec.x);
        $this$subtract.setY($this$subtract.getY() - (double)vec.y);
        $this$subtract.setZ($this$subtract.getZ() - (double)vec.z);
        return $this$subtract;
    }

    public static final World component1(@NotNull Location $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.getWorld();
    }

    public static final double component2(@NotNull Location $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.getX();
    }

    public static final double component3(@NotNull Location $this$component3) {
        Intrinsics.checkNotNullParameter((Object)$this$component3, (String)"<this>");
        return $this$component3.getY();
    }

    public static final double component4(@NotNull Location $this$component4) {
        Intrinsics.checkNotNullParameter((Object)$this$component4, (String)"<this>");
        return $this$component4.getZ();
    }

    public static final float component5(@NotNull Location $this$component5) {
        Intrinsics.checkNotNullParameter((Object)$this$component5, (String)"<this>");
        return $this$component5.getYaw();
    }

    public static final float component6(@NotNull Location $this$component6) {
        Intrinsics.checkNotNullParameter((Object)$this$component6, (String)"<this>");
        return $this$component6.getPitch();
    }

    public static final boolean positionEquals(@NotNull Location $this$positionEquals, @NotNull Location other) {
        Intrinsics.checkNotNullParameter((Object)$this$positionEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$positionEquals.getWorld(), (Object)other.getWorld()) && $this$positionEquals.getX() == other.getX() && $this$positionEquals.getY() == other.getY() && $this$positionEquals.getZ() == other.getZ();
    }

    public static final boolean isBlockLocation(@NotNull Location $this$isBlockLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$isBlockLocation, (String)"<this>");
        return (double)((int)$this$isBlockLocation.getX()) - $this$isBlockLocation.getX() == 0.0 && (double)((int)$this$isBlockLocation.getY()) - $this$isBlockLocation.getY() == 0.0 && (double)((int)$this$isBlockLocation.getZ()) - $this$isBlockLocation.getZ() == 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBetween(@NotNull Location $this$isBetween, @NotNull Location min, @NotNull Location max) {
        Intrinsics.checkNotNullParameter((Object)$this$isBetween, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        double d = min.getX();
        double d2 = max.getX();
        double d3 = $this$isBetween.getX();
        if (!(d <= d3)) return false;
        if (!(d3 <= d2)) return false;
        boolean bl = true;
        if (!bl) return false;
        d = min.getY();
        d2 = max.getY();
        d3 = $this$isBetween.getY();
        if (!(d <= d3)) return false;
        if (!(d3 <= d2)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        d = min.getZ();
        d2 = max.getZ();
        d3 = $this$isBetween.getZ();
        if (!(d <= d3)) return false;
        if (!(d3 <= d2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBetweenXZ(@NotNull Location $this$isBetweenXZ, @NotNull Location min, @NotNull Location max) {
        Intrinsics.checkNotNullParameter((Object)$this$isBetweenXZ, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        double d = min.getX();
        double d2 = max.getX();
        double d3 = $this$isBetweenXZ.getX();
        if (!(d <= d3)) return false;
        if (!(d3 <= d2)) return false;
        boolean bl = true;
        if (!bl) return false;
        d = min.getZ();
        d2 = max.getZ();
        d3 = $this$isBetweenXZ.getZ();
        if (!(d <= d3)) return false;
        if (!(d3 <= d2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideWorldRestrictions(@NotNull Location $this$isInsideWorldRestrictions) {
        Intrinsics.checkNotNullParameter((Object)$this$isInsideWorldRestrictions, (String)"<this>");
        World world = $this$isInsideWorldRestrictions.getWorld();
        Intrinsics.checkNotNull((Object)world);
        World world2 = world;
        if (!world2.getWorldBorder().isInside($this$isInsideWorldRestrictions)) return false;
        int n = world2.getMinHeight();
        int n2 = world2.getMaxHeight();
        int n3 = $this$isInsideWorldRestrictions.getBlockY();
        if (n > n3) return false;
        if (n3 >= n2) return false;
        return true;
    }

    @NotNull
    public static final float[] calculateYawPitch(@NotNull Vector $this$calculateYawPitch) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateYawPitch, (String)"<this>");
        double yaw = Math.atan2(-$this$calculateYawPitch.getX(), $this$calculateYawPitch.getZ());
        double h = -$this$calculateYawPitch.getX() / Math.sin(yaw);
        double pitch = Math.atan2($this$calculateYawPitch.getY(), h);
        float[] fArray = new float[]{(float)Math.toDegrees(yaw), -((float)Math.toDegrees(pitch))};
        return fArray;
    }

    public static final float calculateYaw(@NotNull Vector $this$calculateYaw) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateYaw, (String)"<this>");
        return (float)Math.toDegrees(Math.atan2(-$this$calculateYaw.getX(), $this$calculateYaw.getZ()));
    }

    @NotNull
    public static final Vector Vector(float yaw, float pitch) {
        double pitchRadians = Math.toRadians(-((double)pitch));
        double yawRadians = Math.toRadians(yaw);
        double xy = Math.cos(pitchRadians);
        double x = Math.cos(yawRadians) * xy;
        double y = Math.sin(yawRadians) * xy;
        double z = Math.sin(pitchRadians);
        return new Vector(-y, z, x);
    }

    @NotNull
    public static final Vector3d toVector3d(@NotNull Location $this$toVector3d) {
        Intrinsics.checkNotNullParameter((Object)$this$toVector3d, (String)"<this>");
        return new Vector3d($this$toVector3d.getX(), $this$toVector3d.getY(), $this$toVector3d.getZ());
    }

    @NotNull
    public static final Vector3f toVector3f(@NotNull Location $this$toVector3f) {
        Intrinsics.checkNotNullParameter((Object)$this$toVector3f, (String)"<this>");
        return new Vector3f((float)$this$toVector3f.getX(), (float)$this$toVector3f.getY(), (float)$this$toVector3f.getZ());
    }

    @NotNull
    public static final Vec3 toVec3(@NotNull Location $this$toVec3) {
        Intrinsics.checkNotNullParameter((Object)$this$toVec3, (String)"<this>");
        return new Vec3($this$toVec3.getX(), $this$toVec3.getY(), $this$toVec3.getZ());
    }

    @NotNull
    public static final Location toLocation(@NotNull Vector3dc $this$toLocation, @Nullable World world) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocation, (String)"<this>");
        return new Location(world, $this$toLocation.x(), $this$toLocation.y(), $this$toLocation.z());
    }

    public static /* synthetic */ Location toLocation$default(Vector3dc vector3dc, World world, int n, Object object) {
        if ((n & 1) != 0) {
            world = null;
        }
        return LocationUtilsKt.toLocation(vector3dc, world);
    }

    @NotNull
    public static final Vec3 toVec3(@NotNull Vector3dc $this$toVec3) {
        Intrinsics.checkNotNullParameter((Object)$this$toVec3, (String)"<this>");
        return new Vec3($this$toVec3.x(), $this$toVec3.y(), $this$toVec3.z());
    }

    @NotNull
    public static final Location toLocation(@NotNull Vector3fc $this$toLocation, @Nullable World world) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocation, (String)"<this>");
        return new Location(world, (double)$this$toLocation.x(), (double)$this$toLocation.y(), (double)$this$toLocation.z());
    }

    public static /* synthetic */ Location toLocation$default(Vector3fc vector3fc, World world, int n, Object object) {
        if ((n & 1) != 0) {
            world = null;
        }
        return LocationUtilsKt.toLocation(vector3fc, world);
    }

    @NotNull
    public static final Vec3 toVec3(@NotNull Vector3fc $this$toVec3) {
        Intrinsics.checkNotNullParameter((Object)$this$toVec3, (String)"<this>");
        return new Vec3((double)$this$toVec3.x(), (double)$this$toVec3.y(), (double)$this$toVec3.z());
    }

    @NotNull
    public static final Vec3 toVec3(@NotNull Vector $this$toVec3) {
        Intrinsics.checkNotNullParameter((Object)$this$toVec3, (String)"<this>");
        return new Vec3($this$toVec3.getX(), $this$toVec3.getY(), $this$toVec3.getZ());
    }

    @NotNull
    public static final List<Chunk> getSurroundingChunks(@NotNull Chunk $this$getSurroundingChunks, int range, boolean includeCurrent, boolean ignoreUnloaded) {
        Intrinsics.checkNotNullParameter((Object)$this$getSurroundingChunks, (String)"<this>");
        ArrayList chunks = new ArrayList();
        World world = $this$getSurroundingChunks.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        World world2 = world;
        int chunkX = $this$getSurroundingChunks.getX() - range;
        int n = $this$getSurroundingChunks.getX() + range;
        if (chunkX <= n) {
            while (true) {
                int n2;
                int chunkZ;
                if ((chunkZ = $this$getSurroundingChunks.getZ() - range) <= (n2 = $this$getSurroundingChunks.getZ() + range)) {
                    while (true) {
                        if (!ignoreUnloaded || world2.isChunkLoaded(chunkX, chunkZ)) {
                            Chunk chunk;
                            Intrinsics.checkNotNullExpressionValue((Object)world2.getChunkAt(chunkX, chunkZ), (String)"getChunkAt(...)");
                            if (!Intrinsics.areEqual((Object)chunk, (Object)$this$getSurroundingChunks) || includeCurrent) {
                                ((Collection)chunks).add(world2.getChunkAt(chunkX, chunkZ));
                            }
                        }
                        if (chunkZ == n2) break;
                        ++chunkZ;
                    }
                }
                if (chunkX == n) break;
                ++chunkX;
            }
        }
        return chunks;
    }

    public static /* synthetic */ List getSurroundingChunks$default(Chunk chunk, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        return LocationUtilsKt.getSurroundingChunks(chunk, n, bl, bl2);
    }

    @NotNull
    public static final Sequence<Player> getPlayersNearby(@NotNull Location $this$getPlayersNearby, double maxDistance, Player ... excluded) {
        Intrinsics.checkNotNullParameter((Object)$this$getPlayersNearby, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)excluded, (String)"excluded");
        double maxDistanceSquared = maxDistance * maxDistance;
        World world = $this$getPlayersNearby.getWorld();
        Intrinsics.checkNotNull((Object)world);
        List list = world.getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        return SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> LocationUtilsKt.getPlayersNearby$lambda$0(excluded, arg_0)), arg_0 -> LocationUtilsKt.getPlayersNearby$lambda$1($this$getPlayersNearby, maxDistanceSquared, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Player> filterInRange(@NotNull Iterable<? extends Player> $this$filterInRange, @NotNull Location location, double maxDistance) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        double maxDistanceSquared = maxDistance * maxDistance;
        Iterable<? extends Player> $this$filter$iv = $this$filterInRange;
        boolean $i$f$filter = false;
        Iterable<? extends Player> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location otherLocation;
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getLocation(), (String)"getLocation(...)");
            if (!(Intrinsics.areEqual((Object)location.getWorld(), (Object)otherLocation.getWorld()) && location.distanceSquared(otherLocation) <= maxDistanceSquared)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final void castRay(@NotNull Location $this$castRay, double stepSize, double maxDistance, @NotNull Function1<? super Location, Boolean> run2) {
        Intrinsics.checkNotNullParameter((Object)$this$castRay, (String)"<this>");
        Intrinsics.checkNotNullParameter(run2, (String)"run");
        boolean $i$f$castRay = false;
        Vector vector = $this$castRay.getDirection().multiply(stepSize);
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"multiply(...)");
        Vector vector2 = vector;
        Location location = $this$castRay.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        Location location2 = location;
        for (double distance = 0.0; ((Boolean)run2.invoke((Object)location2)).booleanValue() && distance <= maxDistance; distance += stepSize) {
            location2.add(vector2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Location getTargetLocation(@NotNull Location $this$getTargetLocation, double stepSize, double maxDistance) {
        void stepSize$iv;
        void $this$castRay$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getTargetLocation, (String)"<this>");
        Location location = null;
        location = $this$getTargetLocation;
        Location location2 = $this$getTargetLocation;
        double d = stepSize;
        double maxDistance$iv = maxDistance;
        boolean $i$f$castRay = false;
        Vector vector = $this$castRay$iv.getDirection().multiply((double)stepSize$iv);
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"multiply(...)");
        Vector vector$iv = vector;
        Location location3 = $this$castRay$iv.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"clone(...)");
        Location location$iv = location3;
        double distance$iv = 0.0;
        while (true) {
            boolean bl;
            Block block;
            Location rayLocation = location$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)rayLocation.getBlock(), (String)"getBlock(...)");
            Material material = block.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
            if (MaterialUtilsKt.isTraversable(material) && !block.getBoundingBox().contains(rayLocation.getX(), rayLocation.getY(), rayLocation.getZ())) {
                Intrinsics.checkNotNullExpressionValue((Object)rayLocation.clone(), (String)"clone(...)");
                bl = true;
            } else {
                bl = false;
            }
            if (!bl || !(distance$iv <= maxDistance$iv)) break;
            location$iv.add(vector$iv);
            distance$iv += stepSize$iv;
        }
        return location;
    }

    public static final void untilHeightLimit(@NotNull Location $this$untilHeightLimit, boolean includeThis, @NotNull Function1<? super Location, Boolean> run2) {
        Location location;
        Intrinsics.checkNotNullParameter((Object)$this$untilHeightLimit, (String)"<this>");
        Intrinsics.checkNotNullParameter(run2, (String)"run");
        World world = $this$untilHeightLimit.getWorld();
        Intrinsics.checkNotNull((Object)world);
        int heightLimit = world.getMaxHeight();
        Location $this$untilHeightLimit_u24lambda_u240 = location = $this$untilHeightLimit.clone();
        boolean bl = false;
        if (!includeThis) {
            $this$untilHeightLimit_u24lambda_u240.add(0.0, 1.0, 0.0);
        }
        Location location2 = location;
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"apply(...)");
        Location location3 = location2;
        while (location3.getY() < (double)heightLimit && ((Boolean)run2.invoke((Object)location3)).booleanValue()) {
            location3.add(0.0, 1.0, 0.0);
        }
    }

    @Nullable
    public static final Location getNextBlockBelow(@NotNull Location $this$getNextBlockBelow, boolean countSelf, boolean requiresSolid) {
        Intrinsics.checkNotNullParameter((Object)$this$getNextBlockBelow, (String)"<this>");
        Location location = $this$getNextBlockBelow.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        Location location2 = location;
        if (!countSelf) {
            location2.setY(location2.getY() - 1.0);
        }
        while (true) {
            Material type;
            double d = location2.getY();
            World world = $this$getNextBlockBelow.getWorld();
            int n = world != null ? world.getMinHeight() : -64;
            if (!(d >= (double)n)) break;
            Intrinsics.checkNotNullExpressionValue((Object)location2.getBlock().getType(), (String)"getType(...)");
            if (!(type.isAir() || requiresSolid && !type.isSolid())) {
                return location2;
            }
            location2.setY(location2.getY() - 1.0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Location> getStraightLine(@NotNull Location $this$getStraightLine, @NotNull Axis axis, int to) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getStraightLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        int min = Math.min((int)LocationUtilsKt.getCoordinate($this$getStraightLine, axis), to);
        int max = Math.max((int)LocationUtilsKt.getCoordinate($this$getStraightLine, axis), to);
        Iterable $this$map$iv = (Iterable)new IntRange(min, max);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void coordinate;
            Location location;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Location $this$getStraightLine_u24lambda_u240_u240 = location = $this$getStraightLine.clone();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)$this$getStraightLine_u24lambda_u240_u240);
            LocationUtilsKt.setCoordinate($this$getStraightLine_u24lambda_u240_u240, axis, (double)coordinate);
            collection.add(location);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Map<Axis, List<Location>> getRectangle(@NotNull Location $this$getRectangle, @NotNull Location to, boolean omitCorners) {
        Location location;
        Collection collection;
        Location location2;
        Iterable $this$forEach$iv;
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)$this$getRectangle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        HashMap rectangle = new HashMap();
        ArrayList it = arrayList = new ArrayList();
        boolean bl = false;
        ((Map)rectangle).put(Axis.X, it);
        ArrayList listX = arrayList;
        ArrayList it2 = it = new ArrayList();
        boolean bl2 = false;
        ((Map)rectangle).put(Axis.Z, it2);
        ArrayList listZ = it;
        int modifier = omitCorners ? 1 : 0;
        int minX = Math.min($this$getRectangle.getBlockX(), to.getBlockX());
        int minZ = Math.min($this$getRectangle.getBlockZ(), to.getBlockZ());
        int maxX = Math.max($this$getRectangle.getBlockX(), to.getBlockX());
        int maxZ = Math.max($this$getRectangle.getBlockZ(), to.getBlockZ());
        Location location3 = $this$getRectangle.clone();
        Location $this$getRectangle_u24lambda_u242 = location3;
        boolean bl3 = false;
        $this$getRectangle_u24lambda_u242.setX((double)(minX + modifier));
        Location location4 = location3;
        Intrinsics.checkNotNullExpressionValue((Object)location4, (String)"apply(...)");
        Iterable iterable = LocationUtilsKt.getStraightLine(location4, Axis.X, maxX - modifier);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            location2 = (Location)element$iv;
            boolean bl4 = false;
            collection = listX;
            Location $this$getRectangle_u24lambda_u243_u240 = location = location2.clone();
            boolean bl5 = false;
            $this$getRectangle_u24lambda_u243_u240.setZ((double)minZ);
            collection.add(location);
            collection = listX;
            Location $this$getRectangle_u24lambda_u243_u241 = location = location2.clone();
            boolean bl6 = false;
            $this$getRectangle_u24lambda_u243_u241.setZ((double)maxZ);
            collection.add(location);
        }
        Location $this$getRectangle_u24lambda_u244 = $i$f$forEach = $this$getRectangle.clone();
        boolean bl7 = false;
        $this$getRectangle_u24lambda_u244.setZ((double)(minZ + modifier));
        Location location5 = $i$f$forEach;
        Intrinsics.checkNotNullExpressionValue((Object)location5, (String)"apply(...)");
        $this$forEach$iv = LocationUtilsKt.getStraightLine(location5, Axis.Z, maxZ - modifier);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            location2 = (Location)element$iv;
            boolean bl8 = false;
            collection = listZ;
            Location $this$getRectangle_u24lambda_u245_u240 = location = location2.clone();
            boolean bl9 = false;
            $this$getRectangle_u24lambda_u245_u240.setX((double)minX);
            collection.add(location);
            collection = listZ;
            Location $this$getRectangle_u24lambda_u245_u241 = location = location2.clone();
            boolean bl10 = false;
            $this$getRectangle_u24lambda_u245_u241.setX((double)maxX);
            collection.add(location);
        }
        return rectangle;
    }

    public static final void fullCuboidTo(@NotNull Location $this$fullCuboidTo, @NotNull Location to, @NotNull Function1<? super Location, Boolean> run2) {
        Intrinsics.checkNotNullParameter((Object)$this$fullCuboidTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(run2, (String)"run");
        boolean $i$f$fullCuboidTo = false;
        Preconditions.checkArgument(($this$fullCuboidTo.getWorld() != null && Intrinsics.areEqual((Object)to.getWorld(), (Object)$this$fullCuboidTo.getWorld()) ? 1 : 0) != 0);
        Pair<Location, Location> pair = LocationUtils.INSTANCE.sort($this$fullCuboidTo, to);
        Location min = (Location)pair.component1();
        Location max = (Location)pair.component2();
        int x = min.getBlockX();
        int n = max.getBlockX();
        if (x <= n) {
            while (true) {
                int n2;
                int y;
                if ((y = min.getBlockY()) <= (n2 = max.getBlockY())) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = min.getBlockZ()) <= (n3 = max.getBlockZ())) {
                            while (true) {
                                Location location;
                                if (!((Boolean)run2.invoke((Object)(location = new Location($this$fullCuboidTo.getWorld(), (double)x, (double)y, (double)z)))).booleanValue()) {
                                    return;
                                }
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
    }

    @NotNull
    public static final List<Location> getBoxOutline(@NotNull Location $this$getBoxOutline, @NotNull Location other, boolean correct, double stepSize) {
        Intrinsics.checkNotNullParameter((Object)$this$getBoxOutline, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ArrayList<Location> locations = new ArrayList<Location>();
        double minX = Math.min($this$getBoxOutline.getX(), other.getX());
        double minY = Math.min($this$getBoxOutline.getY(), other.getY());
        double minZ = Math.min($this$getBoxOutline.getZ(), other.getZ());
        double maxX = Math.max($this$getBoxOutline.getX(), other.getX()) + (double)(correct ? 1 : 0);
        double maxY = Math.max($this$getBoxOutline.getY(), other.getY()) + (double)(correct ? 1 : 0);
        double maxZ = Math.max($this$getBoxOutline.getZ(), other.getZ()) + (double)(correct ? 1 : 0);
        double x = minX;
        while (x < maxX) {
            locations.add(new Location($this$getBoxOutline.getWorld(), x += stepSize, minY, minZ));
            locations.add(new Location($this$getBoxOutline.getWorld(), x, maxY, minZ));
            locations.add(new Location($this$getBoxOutline.getWorld(), x, minY, maxZ));
            locations.add(new Location($this$getBoxOutline.getWorld(), x, maxY, maxZ));
        }
        double z = minZ;
        while (z < maxZ) {
            locations.add(new Location($this$getBoxOutline.getWorld(), minX, minY, z += stepSize));
            locations.add(new Location($this$getBoxOutline.getWorld(), maxX, minY, z));
            locations.add(new Location($this$getBoxOutline.getWorld(), minX, maxY, z));
            locations.add(new Location($this$getBoxOutline.getWorld(), maxX, maxY, z));
        }
        double y = minY;
        while (y < maxY) {
            locations.add(new Location($this$getBoxOutline.getWorld(), minX, y += stepSize, minZ));
            locations.add(new Location($this$getBoxOutline.getWorld(), maxX, y, minZ));
            locations.add(new Location($this$getBoxOutline.getWorld(), minX, y, maxZ));
            locations.add(new Location($this$getBoxOutline.getWorld(), maxX, y, maxZ));
        }
        return locations;
    }

    public static /* synthetic */ List getBoxOutline$default(Location location, Location location2, boolean bl, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 0.5;
        }
        return LocationUtilsKt.getBoxOutline(location, location2, bl, d);
    }

    @NotNull
    public static final List<Location> getFullCuboid(@NotNull Location $this$getFullCuboid, @NotNull Location other) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullCuboid, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Preconditions.checkArgument(($this$getFullCuboid.getWorld() != null && Intrinsics.areEqual((Object)other.getWorld(), (Object)$this$getFullCuboid.getWorld()) ? 1 : 0) != 0);
        ArrayList list = new ArrayList();
        Pair<Location, Location> pair = LocationUtils.INSTANCE.sort($this$getFullCuboid, other);
        Location min = (Location)pair.component1();
        Location max = (Location)pair.component2();
        int x = min.getBlockX();
        int n = max.getBlockX();
        if (x <= n) {
            while (true) {
                int n2;
                int y;
                if ((y = min.getBlockY()) <= (n2 = max.getBlockY())) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = min.getBlockZ()) <= (n3 = max.getBlockZ())) {
                            while (true) {
                                ((Collection)list).add(new Location($this$getFullCuboid.getWorld(), (double)x, (double)y, (double)z));
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        return list;
    }

    public static final void dropItems(@NotNull Location $this$dropItems, @NotNull Iterable<? extends ItemStack> items) {
        Intrinsics.checkNotNullParameter((Object)$this$dropItems, (String)"<this>");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        World world = $this$dropItems.getWorld();
        Intrinsics.checkNotNull((Object)world);
        World world2 = world;
        Iterable<? extends ItemStack> $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        Iterator<? extends ItemStack> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            ItemStack element$iv;
            ItemStack it = element$iv = iterator.next();
            boolean bl = false;
            world2.dropItemNaturally($this$dropItems, it);
        }
    }

    public static final void dropItem(@NotNull Location $this$dropItem, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)$this$dropItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        World world = $this$dropItem.getWorld();
        Intrinsics.checkNotNull((Object)world);
        world.dropItemNaturally($this$dropItem, item);
    }

    public static final void dropItemsNaturally(@NotNull World $this$dropItemsNaturally, @NotNull Location location, @NotNull Iterable<? extends ItemStack> items) {
        Intrinsics.checkNotNullParameter((Object)$this$dropItemsNaturally, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable<? extends ItemStack> $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        Iterator<? extends ItemStack> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            ItemStack element$iv;
            ItemStack it = element$iv = iterator.next();
            boolean bl = false;
            $this$dropItemsNaturally.dropItemNaturally(location, it);
        }
    }

    @NotNull
    public static final ClientboundLevelParticlesPacket createColoredParticle(@NotNull Location $this$createColoredParticle, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)$this$createColoredParticle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        ParticleType particleType = ParticleTypes.DUST;
        Intrinsics.checkNotNullExpressionValue((Object)particleType, (String)"DUST");
        return ParticleBuilderKt.color(new ParticleBuilder<DustParticleOptions>(particleType, $this$createColoredParticle), color).build();
    }

    private static final boolean getPlayersNearby$lambda$0(Player[] $excluded, Player it) {
        return !ArraysKt.contains((Object[])$excluded, (Object)it);
    }

    private static final boolean getPlayersNearby$lambda$1(Location $this_getPlayersNearby, double $maxDistanceSquared, Player it) {
        return $this_getPlayersNearby.distanceSquared(it.getLocation()) <= $maxDistanceSquared;
    }

    static {
        BlockFace[] blockFaceArray = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};
        Object[] elements$iv = (Enum[])blockFaceArray;
        boolean $i$f$enumSetOf = false;
        boolean $i$f$enumSet = false;
        EnumSet<BlockFace> enumSet = EnumSet.noneOf(BlockFace.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        EnumSet<BlockFace> $this$enumSetOf_u24lambda_u243$iv = $i$f$enumSet = enumSet;
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$enumSetOf_u24lambda_u243$iv, (Object[])elements$iv);
        CUBE_FACES = $i$f$enumSet;
        elements$iv = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
        elements$iv = (Enum[])elements$iv;
        $i$f$enumSetOf = false;
        $i$f$enumSet2 = false;
        EnumSet<BlockFace> enumSet2 = EnumSet.noneOf(BlockFace.class);
        Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
        EnumSet<BlockFace> $i$f$enumSet2 = enumSet2;
        $this$enumSetOf_u24lambda_u243$iv = $i$f$enumSet2;
        bl = false;
        CollectionsKt.addAll((Collection)$this$enumSetOf_u24lambda_u243$iv, (Object[])elements$iv);
        HORIZONTAL_FACES = $i$f$enumSet2;
        elements$iv = new BlockFace[]{BlockFace.UP, BlockFace.DOWN};
        elements$iv = (Enum[])elements$iv;
        $i$f$enumSetOf = false;
        $i$f$enumSet = false;
        EnumSet<BlockFace> enumSet3 = EnumSet.noneOf(BlockFace.class);
        Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"noneOf(...)");
        EnumSet<BlockFace> enumSet4 = enumSet3;
        $this$enumSetOf_u24lambda_u243$iv = enumSet4;
        bl = false;
        CollectionsKt.addAll((Collection)$this$enumSetOf_u24lambda_u243$iv, (Object[])elements$iv);
        VERTICAL_FACES = enumSet4;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Axis.values().length];
            try {
                nArray[Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Axis.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Axis.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

