/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4dc;
import xyz.xenondevs.nova.resources.builder.model.Model;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\u0007*\u00020\u0006H\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0000\u001a\f\u0010\f\u001a\u00020\u000b*\u00020\nH\u0000\u001a\u0014\u0010\r\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\r\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0001H\u0000\u001a0\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00100\u0014H\u0080\b\u00f8\u0001\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0000\u001a\f\u0010\u001d\u001a\u00020\u0002*\u00020\u001eH\u0000\u001a\u001c\u0010\u001f\u001a\u00020\u0018*\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007H\u0000\u001a\u001c\u0010#\u001a\u00020\u0018*\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u0007H\u0000\u001a\u0014\u0010%\u001a\u00020\u0007*\u00020&2\u0006\u0010 \u001a\u00020!H\u0000\u001a\u000e\u0010'\u001a\u0004\u0018\u00010!*\u00020&H\u0000\u001a\r\u0010(\u001a\u00020\u0007*\u00020)H\u0080\u0002\u001a\r\u0010*\u001a\u00020\u0007*\u00020)H\u0080\u0002\u001a\r\u0010+\u001a\u00020\u0007*\u00020)H\u0080\u0002\u001a\r\u0010,\u001a\u00020\u0007*\u00020)H\u0080\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006-"}, d2={"intValue", "", "", "getIntValue", "(Z)I", "toFixedPoint", "", "", "fromFixedPoint", "toPackedByte", "", "", "fromPackedByte", "roundToDecimalPlaces", "n", "sumOfNoOverflow", "", "T", "", "selector", "Lkotlin/Function1;", "ceilDiv", "other", "round", "Lorg/joml/Vector3d;", "decimalPlaces", "max", "a", "b", "decrementIfGreaterThanZero", "Ljava/util/concurrent/atomic/AtomicInteger;", "rotate", "axis", "Lxyz/xenondevs/nova/resources/builder/model/Model$Axis;", "angleRad", "set", "value", "get", "Lorg/joml/Vector3dc;", "firstNonZeroAxis", "component1", "Lorg/joml/Vector4dc;", "component2", "component3", "component4", "nova"})
@SourceDebugExtension(value={"SMAP\nMathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathUtils.kt\nxyz/xenondevs/nova/util/MathUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n295#2,2:211\n*S KotlinDebug\n*F\n+ 1 MathUtils.kt\nxyz/xenondevs/nova/util/MathUtilsKt\n*L\n100#1:211,2\n*E\n"})
public final class MathUtilsKt {
    public static final int getIntValue(boolean $this$intValue) {
        return $this$intValue ? 1 : 0;
    }

    public static final short toFixedPoint(double $this$toFixedPoint) {
        return (short)($this$toFixedPoint * (double)4069);
    }

    public static final double fromFixedPoint(short $this$fromFixedPoint) {
        return (double)$this$fromFixedPoint / 4096.0;
    }

    public static final byte toPackedByte(float $this$toPackedByte) {
        return (byte)($this$toPackedByte * 256.0f / 360.0f);
    }

    public static final float fromPackedByte(byte $this$fromPackedByte) {
        return (float)$this$fromPackedByte * 360.0f / 256.0f;
    }

    public static final float roundToDecimalPlaces(float $this$roundToDecimalPlaces, int n) {
        double multiplier = Math.pow(10.0, n);
        return (float)(Math.rint((double)$this$roundToDecimalPlaces * multiplier) / multiplier);
    }

    public static final double roundToDecimalPlaces(double $this$roundToDecimalPlaces, int n) {
        double multiplier = Math.pow(10.0, n);
        return Math.rint($this$roundToDecimalPlaces * multiplier) / multiplier;
    }

    public static final <T> long sumOfNoOverflow(@NotNull Iterable<? extends T> $this$sumOfNoOverflow, @NotNull Function1<? super T, Long> selector) {
        Intrinsics.checkNotNullParameter($this$sumOfNoOverflow, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        boolean $i$f$sumOfNoOverflow = false;
        long sum = 0L;
        for (T element : $this$sumOfNoOverflow) {
            long element2 = ((Number)selector.invoke(element)).longValue();
            long result = sum + element2;
            if (((sum ^ result) & (element2 ^ result)) < 0L) {
                return Long.MAX_VALUE;
            }
            sum = result;
        }
        return sum;
    }

    public static final int ceilDiv(int $this$ceilDiv, int other) {
        return ($this$ceilDiv + other - 1) / other;
    }

    @NotNull
    public static final Vector3d round(@NotNull Vector3d $this$round, int decimalPlaces) {
        Intrinsics.checkNotNullParameter((Object)$this$round, (String)"<this>");
        double multiplier = Math.pow(10.0, decimalPlaces);
        $this$round.mul(multiplier);
        $this$round.round();
        $this$round.div(multiplier);
        return $this$round;
    }

    @NotNull
    public static final Vector3d max(@NotNull Vector3d a, @NotNull Vector3d b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return new Vector3d(Math.max(a.x, b.x), Math.max(a.y, b.y), Math.max(a.z, b.z));
    }

    public static final boolean decrementIfGreaterThanZero(@NotNull AtomicInteger $this$decrementIfGreaterThanZero) {
        int current;
        Intrinsics.checkNotNullParameter((Object)$this$decrementIfGreaterThanZero, (String)"<this>");
        do {
            if ((current = $this$decrementIfGreaterThanZero.get()) > 0) continue;
            return false;
        } while (!$this$decrementIfGreaterThanZero.compareAndSet(current, current - 1));
        return true;
    }

    @NotNull
    public static final Vector3d rotate(@NotNull Vector3d $this$rotate, @NotNull Model.Axis axis, double angleRad) {
        Vector3d vector3d;
        Intrinsics.checkNotNullParameter((Object)$this$rotate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1: {
                Vector3d vector3d2 = $this$rotate.rotateX(angleRad);
                vector3d = vector3d2;
                Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"rotateX(...)");
                break;
            }
            case 2: {
                Vector3d vector3d3 = $this$rotate.rotateY(angleRad);
                vector3d = vector3d3;
                Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"rotateY(...)");
                break;
            }
            case 3: {
                Vector3d vector3d4 = $this$rotate.rotateZ(angleRad);
                vector3d = vector3d4;
                Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"rotateZ(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return vector3d;
    }

    @NotNull
    public static final Vector3d set(@NotNull Vector3d $this$set, @NotNull Model.Axis axis, double value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        Vector3d vector3d = $this$set.setComponent(axis.ordinal(), value);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"setComponent(...)");
        return vector3d;
    }

    public static final double get(@NotNull Vector3dc $this$get, @NotNull Model.Axis axis) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        return $this$get.get(axis.ordinal());
    }

    @Nullable
    public static final Model.Axis firstNonZeroAxis(@NotNull Vector3dc $this$firstNonZeroAxis) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$firstNonZeroAxis, (String)"<this>");
            Iterable $this$firstOrNull$iv = (Iterable)Model.Axis.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Model.Axis axis = (Model.Axis)((Object)element$iv);
                boolean bl = false;
                if (!(Math.abs(MathUtilsKt.get($this$firstNonZeroAxis, axis)) > 1.0E-6)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static final double component1(@NotNull Vector4dc $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.x();
    }

    public static final double component2(@NotNull Vector4dc $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.y();
    }

    public static final double component3(@NotNull Vector4dc $this$component3) {
        Intrinsics.checkNotNullParameter((Object)$this$component3, (String)"<this>");
        return $this$component3.z();
    }

    public static final double component4(@NotNull Vector4dc $this$component4) {
        Intrinsics.checkNotNullParameter((Object)$this$component4, (String)"<this>");
        return $this$component4.w();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Model.Axis.values().length];
            try {
                nArray[Model.Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Model.Axis.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Model.Axis.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

