/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util.advancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.component.predicates.CustomDataPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.addon.Addon;
import xyz.xenondevs.nova.addon.AddonKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.component.adventure.ComponentUtilsKt;
import xyz.xenondevs.nova.world.item.NovaItem;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a/\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n\u001a*\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a@\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u0019\u001a\u00020\t*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u00a8\u0006\u001d"}, d2={"advancement", "Lnet/minecraft/advancements/AdvancementHolder;", "addon", "Lxyz/xenondevs/nova/addon/Addon;", "name", "", "init", "Lkotlin/Function1;", "Lnet/minecraft/advancements/Advancement$Builder;", "", "Lkotlin/ExtensionFunctionType;", "obtainNovaItemAdvancement", "parent", "item", "Lxyz/xenondevs/nova/world/item/NovaItem;", "frameType", "Lnet/minecraft/advancements/AdvancementType;", "obtainNovaItemsAdvancement", "items", "", "requireAll", "", "createObtainNovaItemCriterion", "Lnet/minecraft/advancements/Criterion;", "Lnet/minecraft/advancements/critereon/InventoryChangeTrigger$TriggerInstance;", "awardAdvancement", "Lorg/bukkit/entity/Player;", "key", "Lorg/bukkit/NamespacedKey;", "nova"})
@SourceDebugExtension(value={"SMAP\nAdvancementUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancementUtils.kt\nxyz/xenondevs/nova/util/advancement/AdvancementUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1#2:119\n1740#3,3:120\n1869#3,2:123\n*S KotlinDebug\n*F\n+ 1 AdvancementUtils.kt\nxyz/xenondevs/nova/util/advancement/AdvancementUtilsKt\n*L\n66#1:120,3\n116#1:123,2\n*E\n"})
public final class AdvancementUtilsKt {
    @NotNull
    public static final AdvancementHolder advancement(@NotNull Addon addon, @NotNull String name, @NotNull Function1<? super Advancement.Builder, Unit> init2) {
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        Advancement.Builder builder = new Advancement.Builder();
        init2.invoke((Object)builder);
        AdvancementHolder advancementHolder = builder.build(ResourceLocation.fromNamespaceAndPath((String)AddonKt.getId(addon), (String)name));
        Intrinsics.checkNotNullExpressionValue((Object)advancementHolder, (String)"build(...)");
        return advancementHolder;
    }

    @NotNull
    public static final AdvancementHolder obtainNovaItemAdvancement(@NotNull Addon addon, @Nullable AdvancementHolder parent, @NotNull NovaItem item, @NotNull AdvancementType frameType) {
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)frameType, (String)"frameType");
        if (!Intrinsics.areEqual((Object)AddonKt.getId(addon), (Object)item.getId().namespace())) {
            boolean bl = false;
            String string = "The specified item is from a different addon";
            throw new IllegalArgumentException(string.toString());
        }
        Key id = item.getId();
        return AdvancementUtilsKt.advancement(addon, "obtain_" + id.value(), (Function1<? super Advancement.Builder, Unit>)((Function1)arg_0 -> AdvancementUtilsKt.obtainNovaItemAdvancement$lambda$1(parent, item, id, frameType, arg_0)));
    }

    public static /* synthetic */ AdvancementHolder obtainNovaItemAdvancement$default(Addon addon, AdvancementHolder advancementHolder, NovaItem novaItem, AdvancementType advancementType, int n, Object object) {
        if ((n & 8) != 0) {
            advancementType = AdvancementType.TASK;
        }
        return AdvancementUtilsKt.obtainNovaItemAdvancement(addon, advancementHolder, novaItem, advancementType);
    }

    @NotNull
    public static final AdvancementHolder obtainNovaItemsAdvancement(@NotNull Addon addon, @NotNull String name, @Nullable AdvancementHolder parent, @NotNull List<NovaItem> items, boolean requireAll, @NotNull AdvancementType frameType) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            Intrinsics.checkNotNullParameter((Object)frameType, (String)"frameType");
            Iterable $this$all$iv = items;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    NovaItem it = (NovaItem)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getId().namespace(), (Object)AddonKt.getId(addon))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "At least one of the specified items is from a different addon";
            throw new IllegalArgumentException(string.toString());
        }
        String namespace = AddonKt.getId(addon);
        return AdvancementUtilsKt.advancement(addon, name, (Function1<? super Advancement.Builder, Unit>)((Function1)arg_0 -> AdvancementUtilsKt.obtainNovaItemsAdvancement$lambda$2(parent, items, namespace, name, frameType, requireAll, arg_0)));
    }

    public static /* synthetic */ AdvancementHolder obtainNovaItemsAdvancement$default(Addon addon, String string, AdvancementHolder advancementHolder, List list, boolean bl, AdvancementType advancementType, int n, Object object) {
        if ((n & 0x20) != 0) {
            advancementType = AdvancementType.TASK;
        }
        return AdvancementUtilsKt.obtainNovaItemsAdvancement(addon, string, advancementHolder, list, bl, advancementType);
    }

    /*
     * WARNING - void declaration
     */
    private static final Criterion<InventoryChangeTrigger.TriggerInstance> createObtainNovaItemCriterion(NovaItem item) {
        void $this$createObtainNovaItemCriterion_u24lambda_u240_u240;
        CompoundTag compoundTag;
        CompoundTag compoundTag2;
        CompoundTag $this$createObtainNovaItemCriterion_u24lambda_u240 = compoundTag2 = new CompoundTag();
        boolean bl = false;
        CompoundTag compoundTag3 = compoundTag = new CompoundTag();
        String string = "nova";
        CompoundTag compoundTag4 = $this$createObtainNovaItemCriterion_u24lambda_u240;
        boolean bl2 = false;
        $this$createObtainNovaItemCriterion_u24lambda_u240_u240.putString("id", item.getId().toString());
        Unit unit = Unit.INSTANCE;
        compoundTag4.put(string, (Tag)compoundTag);
        CompoundTag expectedCustomData = compoundTag2;
        ItemPredicate.Builder[] builderArray = new ItemPredicate.Builder[]{ItemPredicate.Builder.item().withComponents(DataComponentMatchers.Builder.components().partial(DataComponentPredicates.CUSTOM_DATA, (DataComponentPredicate)new CustomDataPredicate(new NbtPredicate(expectedCustomData))).build())};
        Criterion criterion = InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])builderArray);
        Intrinsics.checkNotNullExpressionValue((Object)criterion, (String)"hasItems(...)");
        return criterion;
    }

    public static final void awardAdvancement(@NotNull Player $this$awardAdvancement, @NotNull NamespacedKey key) {
        Intrinsics.checkNotNullParameter((Object)$this$awardAdvancement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Advancement advancement = Bukkit.getAdvancement((NamespacedKey)key);
        if (advancement != null) {
            AdvancementProgress advancementProgress = $this$awardAdvancement.getAdvancementProgress(advancement);
            Intrinsics.checkNotNullExpressionValue((Object)advancementProgress, (String)"getAdvancementProgress(...)");
            AdvancementProgress progress = advancementProgress;
            Collection collection = advancement.getCriteria();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getCriteria(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                progress.awardCriteria(it);
            }
        }
    }

    private static final Unit obtainNovaItemAdvancement$lambda$1(AdvancementHolder $parent, NovaItem $item, Key $id, AdvancementType $frameType, Advancement.Builder $this$advancement) {
        Intrinsics.checkNotNullParameter((Object)$this$advancement, (String)"$this$advancement");
        if ($parent != null) {
            $this$advancement.parent($parent);
        }
        ItemStack itemStack = NMSUtilsKt.unwrap($item.getClientsideProvider().get()).copy();
        TranslatableComponent translatableComponent = net.kyori.adventure.text.Component.translatable((String)("advancement." + $id.namespace() + "." + $id.value() + ".title"));
        Intrinsics.checkNotNullExpressionValue((Object)translatableComponent, (String)"translatable(...)");
        Component component2 = ComponentUtilsKt.toNMSComponent((net.kyori.adventure.text.Component)translatableComponent);
        TranslatableComponent translatableComponent2 = net.kyori.adventure.text.Component.translatable((String)("advancement." + $id.namespace() + "." + $id.value() + ".description"));
        Intrinsics.checkNotNullExpressionValue((Object)translatableComponent2, (String)"translatable(...)");
        $this$advancement.display(new DisplayInfo(itemStack, component2, ComponentUtilsKt.toNMSComponent((net.kyori.adventure.text.Component)translatableComponent2), Optional.empty(), $frameType, true, true, false));
        $this$advancement.addCriterion("obtain_" + $id.value(), AdvancementUtilsKt.createObtainNovaItemCriterion($item));
        return Unit.INSTANCE;
    }

    private static final Unit obtainNovaItemsAdvancement$lambda$2(AdvancementHolder $parent, List $items, String $namespace, String $name, AdvancementType $frameType, boolean $requireAll, Advancement.Builder $this$advancement) {
        Intrinsics.checkNotNullParameter((Object)$this$advancement, (String)"$this$advancement");
        if ($parent != null) {
            $this$advancement.parent($parent);
        }
        ItemStack itemStack = NMSUtilsKt.unwrap(((NovaItem)$items.get(0)).getClientsideProvider().get()).copy();
        TranslatableComponent translatableComponent = net.kyori.adventure.text.Component.translatable((String)("advancement." + $namespace + "." + $name + ".title"));
        Intrinsics.checkNotNullExpressionValue((Object)translatableComponent, (String)"translatable(...)");
        Component component2 = ComponentUtilsKt.toNMSComponent((net.kyori.adventure.text.Component)translatableComponent);
        TranslatableComponent translatableComponent2 = net.kyori.adventure.text.Component.translatable((String)("advancement." + $namespace + "." + $name + ".description"));
        Intrinsics.checkNotNullExpressionValue((Object)translatableComponent2, (String)"translatable(...)");
        $this$advancement.display(new DisplayInfo(itemStack, component2, ComponentUtilsKt.toNMSComponent((net.kyori.adventure.text.Component)translatableComponent2), Optional.empty(), $frameType, true, true, false));
        ArrayList criteriaNames = new ArrayList();
        for (NovaItem item : $items) {
            String criterionName = "obtain_" + item.getId().value();
            $this$advancement.addCriterion(criterionName, AdvancementUtilsKt.createObtainNovaItemCriterion(item));
            ((Collection)criteriaNames).add(criterionName);
        }
        Advancement.Builder builder = $requireAll ? $this$advancement.requirements(AdvancementRequirements.allOf((Collection)criteriaNames)) : $this$advancement.requirements(AdvancementRequirements.anyOf((Collection)criteriaNames));
        return Unit.INSTANCE;
    }
}

