/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.behavior;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.util.BlockFaceUtils;
import xyz.xenondevs.nova.util.BlockUtils;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.DefaultBlocks;
import xyz.xenondevs.nova.world.block.behavior.BlockBehavior;
import xyz.xenondevs.nova.world.block.behavior.TripwireBehaviorKt;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.state.property.DefaultBlockStateProperties;
import xyz.xenondevs.nova.world.block.state.property.impl.BooleanProperty;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J(\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013H\u0016\u00a8\u0006\u0019"}, d2={"Lxyz/xenondevs/nova/world/block/behavior/TripwireBehavior;", "Lxyz/xenondevs/nova/world/block/behavior/BlockBehavior;", "<init>", "()V", "updateShape", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "state", "neighborPos", "handleEntityInside", "", "entity", "Lorg/bukkit/entity/Entity;", "handleScheduledTick", "getDrops", "", "Lorg/bukkit/inventory/ItemStack;", "ctx", "Lxyz/xenondevs/nova/context/Context;", "Lxyz/xenondevs/nova/context/intention/DefaultContextIntentions$BlockBreak;", "checkPressed", "updateSource", "vanillaBlockStateOf", "Lnet/minecraft/world/level/block/state/BlockState;", "nova", "pickBlockCreative", "Lxyz/xenondevs/nova/context/intention/DefaultContextIntentions$BlockInteract;"})
@SourceDebugExtension(value={"SMAP\nTripwireBehavior.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TripwireBehavior.kt\nxyz/xenondevs/nova/world/block/behavior/TripwireBehavior\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1761#2,3:149\n1761#2,2:152\n1763#2:155\n1#3:154\n*S KotlinDebug\n*F\n+ 1 TripwireBehavior.kt\nxyz/xenondevs/nova/world/block/behavior/TripwireBehavior\n*L\n83#1:149,3\n87#1:152,2\n87#1:155\n*E\n"})
public final class TripwireBehavior
implements BlockBehavior {
    @NotNull
    public static final TripwireBehavior INSTANCE = new TripwireBehavior();

    private TripwireBehavior() {
    }

    @Override
    @NotNull
    public NovaBlockState updateShape(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        BooleanProperty booleanProperty = (BooleanProperty)TripwireBehaviorKt.access$getFACE_PROPERTIES$p().get(BlockFaceUtils.INSTANCE.determineBlockFaceBetween(pos, neighborPos));
        if (booleanProperty == null) {
            return state;
        }
        BooleanProperty property = booleanProperty;
        NovaBlockState novaNeighbor = neighborPos.getNovaBlockState();
        BlockState nmsNeighbor = neighborPos.getNmsBlockState();
        NovaBlockState novaBlockState = novaNeighbor;
        return state.with(property, Intrinsics.areEqual((Object)(novaBlockState != null ? novaBlockState.getBlock() : null), (Object)DefaultBlocks.INSTANCE.getTRIPWIRE()) || Intrinsics.areEqual((Object)nmsNeighbor, (Object)Blocks.TRIPWIRE_HOOK));
    }

    @Override
    public void handleEntityInside(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (new EntityInsideBlockEvent(entity, pos.getBlock()).callEvent() && !((Boolean)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getPOWERED())).booleanValue()) {
            this.checkPressed(pos, state);
        }
    }

    @Override
    public void handleScheduledTick(@NotNull BlockPos pos, @NotNull NovaBlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getPOWERED())).booleanValue()) {
            this.checkPressed(pos, state);
        }
    }

    @Override
    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull Context<DefaultContextIntentions.BlockBreak> ctx) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        if (!ctx.get(DefaultContextParamTypes.INSTANCE.getBLOCK_DROPS()).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)ItemStack.of((Material)Material.STRING));
    }

    private final void checkPressed(BlockPos pos, NovaBlockState state) {
        boolean shouldBePowered;
        boolean isPowered;
        Collection entities;
        block12: {
            Collection collection = pos.getWorld().getNearbyEntities(pos.getBlock().getBoundingBox());
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNearbyEntities(...)");
            entities = collection;
            isPowered = (Boolean)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getPOWERED());
            Iterable $this$any$iv = entities;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(!NMSUtilsKt.getNmsEntity(it).isIgnoringBlockTriggers())) continue;
                    v1 = true;
                    break block12;
                }
                v1 = shouldBePowered = false;
            }
        }
        if (isPowered != shouldBePowered && ((Boolean)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getTRIPWIRE_ATTACHED$nova())).booleanValue() && !entities.isEmpty()) {
            boolean allowed;
            block13: {
                Iterable $this$any$iv = entities;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PlayerInteractEvent event;
                        PlayerInteractEvent playerInteractEvent;
                        Entity entity = (Entity)element$iv;
                        boolean bl = false;
                        if (entity instanceof org.bukkit.entity.Player) {
                            playerInteractEvent = CraftEventFactory.callPlayerInteractEvent((Player)((Player)NMSUtilsKt.getServerPlayer((org.bukkit.entity.Player)entity)), (Action)Action.PHYSICAL, (net.minecraft.core.BlockPos)pos.getNmsPos(), null, null, null);
                        } else {
                            EntityInteractEvent entityInteractEvent = new EntityInteractEvent(entity, pos.getBlock());
                            Event p0 = (Event)entityInteractEvent;
                            boolean bl2 = false;
                            EventUtilsKt.callEvent(p0);
                            playerInteractEvent = entityInteractEvent;
                        }
                        if (!(!((Cancellable)(event = playerInteractEvent)).isCancelled())) continue;
                        v2 = true;
                        break block13;
                    }
                    v2 = allowed = false;
                }
            }
            if (!allowed) {
                return;
            }
        }
        if (isPowered != shouldBePowered) {
            NovaBlockState newState = state.with(DefaultBlockStateProperties.INSTANCE.getPOWERED(), shouldBePowered);
            WorldDataManager.INSTANCE.setBlockState(pos, newState);
            BlockUtils.INSTANCE.broadcastBlockUpdate$nova(pos);
            this.updateSource(pos, newState);
        }
        if (shouldBePowered) {
            NMSUtilsKt.getServerLevel(pos.getWorld()).scheduleTick(pos.getNmsPos(), Blocks.TRIPWIRE, 10);
        }
    }

    private final void updateSource(BlockPos pos, NovaBlockState state) {
        BlockFace[] blockFaceArray = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST};
        block0: for (BlockFace face : blockFaceArray) {
            for (int length = 1; length < 42; ++length) {
                BlockState vanillaStateThere;
                NovaBlockState novaStateThere;
                BlockPos posThere = pos.advance(face, length);
                NovaBlockState novaBlockState = novaStateThere = WorldDataManager.INSTANCE.getBlockState(posThere);
                if (Intrinsics.areEqual((Object)(novaBlockState != null ? novaBlockState.getBlock() : null), (Object)DefaultBlocks.INSTANCE.getTRIPWIRE()) || !Intrinsics.areEqual((Object)(vanillaStateThere = posThere.getNmsBlockState()).getBlock(), (Object)Blocks.TRIPWIRE_HOOK)) continue;
                Comparable comparable = vanillaStateThere.getValue((Property)TripWireHookBlock.FACING);
                BlockFace blockFace = face.getOppositeFace();
                Intrinsics.checkNotNullExpressionValue((Object)blockFace, (String)"getOppositeFace(...)");
                if (comparable != NMSUtilsKt.getNmsDirection(blockFace)) continue;
                TripWireHookBlock.calculateState((Level)((Level)NMSUtilsKt.getServerLevel(posThere.getWorld())), (net.minecraft.core.BlockPos)posThere.getNmsPos(), (BlockState)vanillaStateThere, (boolean)false, (boolean)true, (int)length, (BlockState)this.vanillaBlockStateOf(state));
                continue block0;
            }
        }
    }

    @NotNull
    public final BlockState vanillaBlockStateOf(@NotNull NovaBlockState nova) {
        Intrinsics.checkNotNullParameter((Object)nova, (String)"nova");
        Object object = ((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.TRIPWIRE.defaultBlockState().setValue((Property)TripWireBlock.NORTH, (Comparable)nova.getOrThrow(DefaultBlockStateProperties.INSTANCE.getTRIPWIRE_NORTH$nova()))).setValue((Property)TripWireBlock.EAST, (Comparable)nova.getOrThrow(DefaultBlockStateProperties.INSTANCE.getTRIPWIRE_EAST$nova()))).setValue((Property)TripWireBlock.SOUTH, (Comparable)nova.getOrThrow(DefaultBlockStateProperties.INSTANCE.getTRIPWIRE_SOUTH$nova()))).setValue((Property)TripWireBlock.WEST, (Comparable)nova.getOrThrow(DefaultBlockStateProperties.INSTANCE.getTRIPWIRE_WEST$nova()))).setValue((Property)TripWireBlock.DISARMED, (Comparable)nova.getOrThrow(DefaultBlockStateProperties.INSTANCE.getTRIPWIRE_DISARMED$nova()))).setValue((Property)TripWireBlock.ATTACHED, (Comparable)nova.getOrThrow(DefaultBlockStateProperties.INSTANCE.getTRIPWIRE_ATTACHED$nova()))).setValue((Property)TripWireBlock.POWERED, (Comparable)nova.getOrThrow(DefaultBlockStateProperties.INSTANCE.getPOWERED()));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @Override
    @Nullable
    public ItemStack pickBlockCreative(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull Context<DefaultContextIntentions.BlockInteract> ctx) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        return ItemStack.of((Material)Material.STRING);
    }
}

