/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.hitbox;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.hitbox.VirtualHitbox;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u001a&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0012H\u0002*l\b\u0002\u0010\u0000\"2\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00060\u000122\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00060\u0001\u00a8\u0006\u0013"}, d2={"HitboxQualifier", "Lkotlin/Function2;", "Lorg/bukkit/entity/Player;", "Lkotlin/ParameterName;", "name", "player", "", "isLeftClick", "VirtualHitbox", "Lxyz/xenondevs/nova/world/block/hitbox/VirtualHitbox;", "from", "Lorg/bukkit/Location;", "to", "getBlocksBetween", "", "Lxyz/xenondevs/nova/world/BlockPos;", "world", "Lorg/bukkit/World;", "Lorg/joml/Vector3fc;", "nova"})
@SourceDebugExtension(value={"SMAP\nVirtualHitbox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualHitbox.kt\nxyz/xenondevs/nova/world/block/hitbox/VirtualHitboxKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class VirtualHitboxKt {
    @NotNull
    public static final VirtualHitbox VirtualHitbox(@NotNull Location from, @NotNull Location to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (!(from.getWorld() != null && Intrinsics.areEqual((Object)from.getWorld(), (Object)to.getWorld()))) {
            boolean $i$a$-require-VirtualHitboxKt$VirtualHitbox$52 = false;
            String $i$a$-require-VirtualHitboxKt$VirtualHitbox$52 = "from and to must be in the same world";
            throw new IllegalArgumentException($i$a$-require-VirtualHitboxKt$VirtualHitbox$52.toString());
        }
        if (!(from.getX() < to.getX())) {
            boolean $i$a$-require-VirtualHitboxKt$VirtualHitbox$62 = false;
            String $i$a$-require-VirtualHitboxKt$VirtualHitbox$62 = "from.x must be smaller than to.x";
            throw new IllegalArgumentException($i$a$-require-VirtualHitboxKt$VirtualHitbox$62.toString());
        }
        if (!(from.getY() < to.getY())) {
            boolean $i$a$-require-VirtualHitboxKt$VirtualHitbox$72 = false;
            String $i$a$-require-VirtualHitboxKt$VirtualHitbox$72 = "from.y must be smaller than to.y";
            throw new IllegalArgumentException($i$a$-require-VirtualHitboxKt$VirtualHitbox$72.toString());
        }
        if (!(from.getZ() < to.getZ())) {
            boolean $i$a$-require-VirtualHitboxKt$VirtualHitbox$82 = false;
            String $i$a$-require-VirtualHitboxKt$VirtualHitbox$82 = "from.z must be smaller than to.z";
            throw new IllegalArgumentException($i$a$-require-VirtualHitboxKt$VirtualHitbox$82.toString());
        }
        Vector3f fromVec = LocationUtilsKt.toVector3f(from);
        Vector3f toVec = LocationUtilsKt.toVector3f(to);
        float xWidth = toVec.x - fromVec.x;
        float zWidth = toVec.z - fromVec.z;
        float height = toVec.y - fromVec.y;
        Vector3f baseCenter = new Vector3f(fromVec.x + xWidth / 2.0f, fromVec.y, fromVec.z + zWidth / 2.0f);
        Vector3f center = new Vector3f(fromVec.x + xWidth / 2.0f, fromVec.y + height / 2.0f, fromVec.z + zWidth / 2.0f);
        World world = from.getWorld();
        Intrinsics.checkNotNull((Object)world);
        return new VirtualHitbox(world, (Vector3fc)baseCenter, (Vector3fc)center, (Vector3fc)fromVec, (Vector3fc)toVec, xWidth, zWidth, height);
    }

    private static final Set<BlockPos> getBlocksBetween(World world, Vector3fc from, Vector3fc to) {
        HashSet blocks = new HashSet();
        int minX = (int)Math.floor(from.x());
        int minY = (int)Math.floor(from.y());
        int minZ = (int)Math.floor(from.z());
        int maxX = (int)Math.floor(to.x());
        int maxY = (int)Math.floor(to.y());
        int maxZ = (int)Math.floor(to.z());
        int x = minX;
        if (x <= maxX) {
            while (true) {
                int y;
                if ((y = minY) <= maxY) {
                    while (true) {
                        int z;
                        if ((z = minZ) <= maxZ) {
                            while (true) {
                                ((Collection)blocks).add(new BlockPos(world, x, y, z));
                                if (z == maxZ) break;
                                ++z;
                            }
                        }
                        if (y == maxY) break;
                        ++y;
                    }
                }
                if (x == maxX) break;
                ++x;
            }
        }
        return blocks;
    }

    public static final /* synthetic */ Set access$getBlocksBetween(World world, Vector3fc from, Vector3fc to) {
        return VirtualHitboxKt.getBlocksBetween(world, from, to);
    }
}

