/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.logic.place;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Dispenser;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.ContextIntention;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.util.BlockUtils;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.state.model.BackingStateBlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.BlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.DisplayEntityBlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.ModelLessBlockModelProvider;
import xyz.xenondevs.nova.world.format.WorldDataManager;
import xyz.xenondevs.nova.world.item.NovaItem;
import xyz.xenondevs.nova.world.player.EventlessHandSwingingKt;
import xyz.xenondevs.nova.world.player.WrappedPlayerInteractEvent;

@InternalInit(stage=InternalInitStage.POST_WORLD, dependsOn={WorldDataManager.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000eH\u0003J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0010H\u0003J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0012H\u0003J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0017H\u0002J(\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0002\u00a8\u0006\""}, d2={"Lxyz/xenondevs/nova/world/block/logic/place/BlockPlacing;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "init", "", "handleBlockPlace", "", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "handleFluidPlace", "event", "Lorg/bukkit/event/player/PlayerBucketEmptyEvent;", "handleFluidRemove", "Lorg/bukkit/event/player/PlayerBucketFillEvent;", "handleFallingBlockLand", "Lorg/bukkit/event/entity/EntityChangeBlockEvent;", "handleBlockDispense", "Lorg/bukkit/event/block/BlockDispenseEvent;", "handleInteract", "wrappedEvent", "Lxyz/xenondevs/nova/world/player/WrappedPlayerInteractEvent;", "placeNovaBlock", "Lorg/bukkit/event/player/PlayerInteractEvent;", "novaBlock", "Lxyz/xenondevs/nova/world/block/NovaBlock;", "placeVanillaBlock", "canPlace", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "block", "placedOn", "nova"})
@SourceDebugExtension(value={"SMAP\nBlockPlacing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockPlacing.kt\nxyz/xenondevs/nova/world/block/logic/place/BlockPlacing\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
public final class BlockPlacing
implements Listener {
    @NotNull
    public static final BlockPlacing INSTANCE = new BlockPlacing();

    private BlockPlacing() {
    }

    @InitFun
    private final void init() {
        EventUtilsKt.registerEvents(this);
    }

    public final boolean handleBlockPlace(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        NovaBlockState blockState = WorldDataManager.INSTANCE.getBlockState(pos);
        return blockState == null || Intrinsics.areEqual((Object)blockState.getBlock().getId().namespace(), (Object)"nova");
    }

    @EventHandler(ignoreCancelled=true)
    private final void handleFluidPlace(PlayerBucketEmptyEvent event) {
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        NovaBlockState blockState = WorldDataManager.INSTANCE.getBlockState(BlockPosKt.getPos(block));
        event.setCancelled(blockState != null && !Intrinsics.areEqual((Object)blockState.getBlock().getId().namespace(), (Object)"nova"));
    }

    @EventHandler(ignoreCancelled=true)
    private final void handleFluidRemove(PlayerBucketFillEvent event) {
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        NovaBlockState blockState = WorldDataManager.INSTANCE.getBlockState(BlockPosKt.getPos(block));
        event.setCancelled(blockState != null && !Intrinsics.areEqual((Object)blockState.getBlock().getId().namespace(), (Object)"nova"));
    }

    @EventHandler(ignoreCancelled=true)
    private final void handleFallingBlockLand(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        Entity entity2 = entity;
        if (entity2 instanceof FallingBlock) {
            Block block = event.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            BlockPos pos = BlockPosKt.getPos(block);
            NovaBlockState blockState = WorldDataManager.INSTANCE.getBlockState(pos);
            if (blockState != null) {
                event.setCancelled(true);
                Location location = event.getBlock().getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                LocationUtilsKt.dropItem(location, new ItemStack(((FallingBlock)entity2).getBlockData().getMaterial()));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private final void handleBlockDispense(BlockDispenseEvent event) {
        Material material = event.getItem().getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        if (MaterialUtilsKt.isBucket(material)) {
            Block block = event.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            BlockPos blockPos = BlockPosKt.getPos(block);
            BlockData blockData = event.getBlock().getBlockData();
            Intrinsics.checkNotNull((Object)blockData, (String)"null cannot be cast to non-null type org.bukkit.block.data.type.Dispenser");
            BlockFace blockFace = ((Dispenser)blockData).getFacing();
            Intrinsics.checkNotNullExpressionValue((Object)blockFace, (String)"getFacing(...)");
            BlockPos targetPos = BlockPos.advance$default(blockPos, blockFace, 0, 2, null);
            if (WorldDataManager.INSTANCE.getBlockStateOrNullIfUnloaded$nova(targetPos) != null) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    private final void handleInteract(WrappedPlayerInteractEvent wrappedEvent) {
        block8: {
            NovaBlock novaBlock;
            NovaItem novaItem;
            NovaBlockState novaBlockState;
            Block block;
            ItemStack handItem;
            PlayerInteractEvent event;
            block9: {
                if (wrappedEvent.getActionPerformed()) {
                    return;
                }
                event = wrappedEvent.getEvent();
                Action action = event.getAction();
                Intrinsics.checkNotNullExpressionValue((Object)action, (String)"getAction(...)");
                Action action2 = action;
                Player player = event.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                Player player2 = player;
                if (action2 != Action.RIGHT_CLICK_BLOCK) break block8;
                handItem = event.getItem();
                Block block2 = event.getClickedBlock();
                Intrinsics.checkNotNull((Object)block2);
                block = block2;
                novaBlockState = WorldDataManager.INSTANCE.getBlockState(BlockPosKt.getPos(block));
                if (novaBlockState != null) break block9;
                Material material = block.getType();
                Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
                if (MaterialUtilsKt.isActuallyInteractable(material) && !player2.isSneaking()) break block8;
            }
            ItemStack itemStack = handItem;
            NovaItem novaItem2 = novaItem = itemStack != null ? ItemUtilsKt.getNovaItem(itemStack) : null;
            NovaBlock novaBlock2 = novaBlock = novaItem2 != null ? novaItem2.getBlock() : null;
            if (novaBlock != null) {
                event.setCancelled(true);
                wrappedEvent.setActionPerformed(true);
                this.placeNovaBlock(event, novaBlock);
            } else if (novaBlockState != null && Tag.REPLACEABLE.isTagged((Keyed)block.getType()) && novaItem == null) {
                ItemStack itemStack2 = handItem;
                boolean bl = itemStack2 != null && (itemStack2 = itemStack2.getType()) != null ? itemStack2.isBlock() : false;
                if (bl) {
                    event.setCancelled(true);
                    wrappedEvent.setActionPerformed(true);
                    this.placeVanillaBlock(event);
                }
            }
        }
    }

    private final void placeNovaBlock(PlayerInteractEvent event, NovaBlock novaBlock) {
        BlockData blockData;
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = event.getItem();
        Intrinsics.checkNotNull((Object)itemStack);
        ItemStack handItem = itemStack;
        Block block = event.getClickedBlock();
        Intrinsics.checkNotNull((Object)block);
        Block clickedBlock = block;
        Ref.ObjectRef pos = new Ref.ObjectRef();
        Location location = clickedBlock.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        pos.element = BlockPosKt.getPos(location);
        if (!Tag.REPLACEABLE.isTagged((Keyed)clickedBlock.getType()) || WorldDataManager.INSTANCE.getBlockState((BlockPos)pos.element) != null) {
            BlockPos blockPos = (BlockPos)pos.element;
            BlockFace blockFace = event.getBlockFace();
            Intrinsics.checkNotNullExpressionValue((Object)blockFace, (String)"getBlockFace(...)");
            pos.element = BlockPos.advance$default(blockPos, blockFace, 0, 2, null);
        }
        Context.Builder<ContextIntention> ctxBuilder = Context.Companion.intention((ContextIntention)DefaultContextIntentions.BlockPlace.INSTANCE).param(DefaultContextParamTypes.INSTANCE.getBLOCK_POS(), pos.element).param(DefaultContextParamTypes.INSTANCE.getBLOCK_ITEM_STACK(), handItem).param(DefaultContextParamTypes.INSTANCE.getSOURCE_ENTITY(), player2).param(DefaultContextParamTypes.INSTANCE.getCLICKED_BLOCK_FACE(), event.getBlockFace());
        NovaBlockState newState = novaBlock.chooseBlockState(ctxBuilder.build());
        ctxBuilder.param(DefaultContextParamTypes.INSTANCE.getBLOCK_STATE_NOVA(), newState);
        Context<ContextIntention> ctx = ctxBuilder.build();
        BlockModelProvider modelProvider = newState.getModelProvider$nova();
        if (modelProvider instanceof BackingStateBlockModelProvider) {
            blockData = NMSUtilsKt.getBukkitBlockData(((BackingStateBlockModelProvider)modelProvider).getInfo().getVanillaBlockState());
        } else if (modelProvider instanceof DisplayEntityBlockModelProvider) {
            blockData = NMSUtilsKt.getBukkitBlockData(((DisplayEntityBlockModelProvider)modelProvider).getInfo().getHitboxType());
        } else if (modelProvider instanceof ModelLessBlockModelProvider) {
            blockData = NMSUtilsKt.getBukkitBlockData(((ModelLessBlockModelProvider)modelProvider).getInfo());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        BlockData vanillaState = blockData;
        if (LocationUtilsKt.isInsideWorldRestrictions(((BlockPos)pos.element).getLocation()) && BlockUtils.INSTANCE.isUnobstructed$nova((BlockPos)pos.element, (Entity)player2, vanillaState) && ProtectionManager.INSTANCE.canPlace(player2, handItem, (BlockPos)pos.element)) {
            BlockPos blockPos = (BlockPos)pos.element;
            Location location2 = ((BlockPos)pos.element).getLocation();
            BlockFace blockFace = event.getBlockFace().getOppositeFace();
            Intrinsics.checkNotNullExpressionValue((Object)blockFace, (String)"getOppositeFace(...)");
            if (this.canPlace(player2, handItem, blockPos, BlockPosKt.getPos(LocationUtilsKt.advance$default(location2, blockFace, 0.0, 2, null))) && ((Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(novaBlock, (Ref.ObjectRef<BlockPos>)pos, newState, ctx, null){
                int label;
                final /* synthetic */ NovaBlock $novaBlock;
                final /* synthetic */ Ref.ObjectRef<BlockPos> $pos;
                final /* synthetic */ NovaBlockState $newState;
                final /* synthetic */ Context<DefaultContextIntentions.BlockPlace> $ctx;
                {
                    this.$novaBlock = $novaBlock;
                    this.$pos = $pos;
                    this.$newState = $newState;
                    this.$ctx = $ctx;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$novaBlock.canPlace((BlockPos)this.$pos.element, this.$newState, this.$ctx, (Continuation<? super Boolean>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null)).booleanValue()) {
                if (player2.getGameMode() != GameMode.CREATIVE) {
                    int n = handItem.getAmount();
                    handItem.setAmount(n + -1);
                }
                BlockUtils.INSTANCE.placeNovaBlock$nova((BlockPos)pos.element, newState, ctx);
                EquipmentSlot equipmentSlot = event.getHand();
                Intrinsics.checkNotNull((Object)equipmentSlot);
                EventlessHandSwingingKt.swingHandEventless(player2, equipmentSlot);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void placeVanillaBlock(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = event.getItem();
        Intrinsics.checkNotNull((Object)itemStack);
        ItemStack handItem = itemStack;
        Block block = event.getClickedBlock();
        Intrinsics.checkNotNull((Object)block);
        BlockPos placedOn = BlockPosKt.getPos(block);
        Block block2 = event.getClickedBlock();
        Intrinsics.checkNotNull((Object)block2);
        Location location = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        BlockFace blockFace = event.getBlockFace();
        Intrinsics.checkNotNullExpressionValue((Object)blockFace, (String)"getBlockFace(...)");
        BlockPos pos = BlockPosKt.getPos(LocationUtilsKt.advance$default(location, blockFace, 0.0, 2, null));
        if (ProtectionManager.INSTANCE.canPlace(player2, handItem, pos) && this.canPlace(player2, handItem, pos, placedOn)) {
            BlockFace blockFace2 = event.getBlockFace();
            Intrinsics.checkNotNullExpressionValue((Object)blockFace2, (String)"getBlockFace(...)");
            boolean placed = BlockUtils.INSTANCE.placeVanillaBlock$nova(pos, blockFace2, NMSUtilsKt.getServerPlayer(player2), handItem, true);
            if (placed && player2.getGameMode() != GameMode.CREATIVE) {
                void $this$placeVanillaBlock_u24lambda_u240;
                ItemStack itemStack2;
                PlayerInventory playerInventory = player2.getInventory();
                EquipmentSlot equipmentSlot = event.getHand();
                Intrinsics.checkNotNull((Object)equipmentSlot);
                ItemStack itemStack3 = itemStack2 = handItem;
                EquipmentSlot equipmentSlot2 = equipmentSlot;
                PlayerInventory playerInventory2 = playerInventory;
                boolean bl = false;
                $this$placeVanillaBlock_u24lambda_u240.setAmount($this$placeVanillaBlock_u24lambda_u240.getAmount() - 1);
                Unit unit = Unit.INSTANCE;
                playerInventory2.setItem(equipmentSlot2, itemStack2);
            }
        }
    }

    private final boolean canPlace(Player player, ItemStack item, BlockPos block, BlockPos placedOn) {
        if (player.getGameMode() == GameMode.SPECTATOR || !LocationUtilsKt.isInsideWorldRestrictions(block.getLocation()) || !Tag.REPLACEABLE.isTagged((Keyed)block.getBlock().getType()) || WorldDataManager.INSTANCE.getBlockState(block) != null) {
            return false;
        }
        if (player.getGameMode() == GameMode.ADVENTURE) {
            AdventureModePredicate canPlaceOn = (AdventureModePredicate)NMSUtilsKt.unwrap(item).get(DataComponents.CAN_PLACE_ON);
            BlockInWorld blockInWorld = new BlockInWorld((LevelReader)NMSUtilsKt.getServerLevel(placedOn.getWorld()), placedOn.getNmsPos(), false);
            AdventureModePredicate adventureModePredicate = canPlaceOn;
            return adventureModePredicate != null ? adventureModePredicate.test(blockInWorld) : false;
        }
        return true;
    }
}

