/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.logic.sound;

import com.mojang.datafixers.util.Either;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.bukkit.Sound;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.network.event.PacketHandler;
import xyz.xenondevs.nova.network.event.PacketListener;
import xyz.xenondevs.nova.network.event.PacketListenerKt;
import xyz.xenondevs.nova.network.event.clientbound.ClientboundSoundEntityPacketEvent;
import xyz.xenondevs.nova.network.event.clientbound.ClientboundSoundPacketEvent;
import xyz.xenondevs.nova.resources.lookup.ResourceLookups;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@InternalInit(stage=InternalInitStage.POST_WORLD, dependsOn={WorldDataManager.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bJ0\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007JX\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0003J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020!H\u0003J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\nH\u0002\u00a8\u0006&"}, d2={"Lxyz/xenondevs/nova/world/block/logic/sound/SoundEngine;", "Lorg/bukkit/event/Listener;", "Lxyz/xenondevs/nova/network/event/PacketListener;", "<init>", "()V", "init", "", "overridesSound", "", "sound", "", "Lorg/bukkit/Sound;", "broadcast", "entity", "Lnet/minecraft/world/entity/Entity;", "oldSound", "newSound", "volume", "", "pitch", "broadcastIfOverridden", "level", "Lnet/minecraft/world/level/Level;", "x", "", "y", "z", "radius", "source", "Lnet/minecraft/sounds/SoundSource;", "handleSoundPacket", "event", "Lxyz/xenondevs/nova/network/event/clientbound/ClientboundSoundPacketEvent;", "Lxyz/xenondevs/nova/network/event/clientbound/ClientboundSoundEntityPacketEvent;", "getNovaSound", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/sounds/SoundEvent;", "path", "nova"})
public final class SoundEngine
implements Listener,
PacketListener {
    @NotNull
    public static final SoundEngine INSTANCE = new SoundEngine();

    private SoundEngine() {
    }

    @InitFun
    private final void init() {
        EventUtilsKt.registerEvents(this);
        PacketListenerKt.registerPacketListener(this);
    }

    public final boolean overridesSound(@NotNull String sound) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        return ResourceLookups.INSTANCE.getSOUND_OVERRIDES().contains(StringsKt.removePrefix((String)sound, (CharSequence)"minecraft:"));
    }

    public final boolean overridesSound(@NotNull Sound sound) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        String string = sound.getKey().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.overridesSound(string);
    }

    @JvmStatic
    public static final void broadcast(@NotNull Entity entity, @NotNull String oldSound, @NotNull String newSound, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)oldSound, (String)"oldSound");
        Intrinsics.checkNotNullParameter((Object)newSound, (String)"newSound");
        Level level = entity.level();
        Player player = INSTANCE.overridesSound(oldSound) ? null : (entity instanceof Player ? (Player)entity : null);
        NMSUtilsKt.getMINECRAFT_SERVER().getPlayerList().broadcast(player, entity.getX(), entity.getY(), entity.getZ(), 16.0, level.dimension(), (Packet)new ClientboundSoundPacket(Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)newSound))), entity.getSoundSource(), entity.getX(), entity.getY(), entity.getZ(), volume, pitch, level.random.nextLong()));
    }

    @JvmStatic
    public static final void broadcastIfOverridden(@NotNull Level level, double x, double y, double z, double radius, @NotNull String oldSound, @NotNull String newSound, float volume, float pitch, @NotNull SoundSource source) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)oldSound, (String)"oldSound");
        Intrinsics.checkNotNullParameter((Object)newSound, (String)"newSound");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!INSTANCE.overridesSound(oldSound)) {
            return;
        }
        NMSUtilsKt.getMINECRAFT_SERVER().getPlayerList().broadcast(null, x, y, z, radius, level.dimension(), (Packet)new ClientboundSoundPacket(Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)newSound))), source, x, y, z, volume, pitch, Random.Default.nextLong()));
    }

    @PacketHandler
    private final void handleSoundPacket(ClientboundSoundPacketEvent event) {
        Either either = event.getSound().unwrap().mapBoth(arg_0 -> SoundEngine.handleSoundPacket$lambda$1(SoundEngine::handleSoundPacket$lambda$0, arg_0), arg_0 -> SoundEngine.handleSoundPacket$lambda$3(SoundEngine::handleSoundPacket$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"mapBoth(...)");
        ResourceLocation location = (ResourceLocation)NMSUtilsKt.take(either);
        if (Intrinsics.areEqual((Object)location.getNamespace(), (Object)"minecraft") && ResourceLookups.INSTANCE.getSOUND_OVERRIDES().contains(location.getPath())) {
            String string = location.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            event.setSound(this.getNovaSound(string));
        }
    }

    @PacketHandler
    private final void handleSoundPacket(ClientboundSoundEntityPacketEvent event) {
        Either either = event.getSound().unwrap().mapBoth(arg_0 -> SoundEngine.handleSoundPacket$lambda$5(SoundEngine::handleSoundPacket$lambda$4, arg_0), arg_0 -> SoundEngine.handleSoundPacket$lambda$7(SoundEngine::handleSoundPacket$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"mapBoth(...)");
        ResourceLocation location = (ResourceLocation)NMSUtilsKt.take(either);
        if (Intrinsics.areEqual((Object)location.getNamespace(), (Object)"minecraft") && ResourceLookups.INSTANCE.getSOUND_OVERRIDES().contains(location.getPath())) {
            String string = location.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            event.setSound(this.getNovaSound(string));
        }
    }

    private final Holder<SoundEvent> getNovaSound(String path) {
        Holder holder2 = Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nova", (String)path)));
        Intrinsics.checkNotNullExpressionValue((Object)holder2, (String)"direct(...)");
        return holder2;
    }

    private static final ResourceLocation handleSoundPacket$lambda$0(ResourceKey it) {
        return it.location();
    }

    private static final ResourceLocation handleSoundPacket$lambda$1(Function1 $tmp0, Object p0) {
        return (ResourceLocation)$tmp0.invoke(p0);
    }

    private static final ResourceLocation handleSoundPacket$lambda$2(SoundEvent it) {
        return it.location();
    }

    private static final ResourceLocation handleSoundPacket$lambda$3(Function1 $tmp0, Object p0) {
        return (ResourceLocation)$tmp0.invoke(p0);
    }

    private static final ResourceLocation handleSoundPacket$lambda$4(ResourceKey it) {
        return it.location();
    }

    private static final ResourceLocation handleSoundPacket$lambda$5(Function1 $tmp0, Object p0) {
        return (ResourceLocation)$tmp0.invoke(p0);
    }

    private static final ResourceLocation handleSoundPacket$lambda$6(SoundEvent it) {
        return it.location();
    }

    private static final ResourceLocation handleSoundPacket$lambda$7(Function1 $tmp0, Object p0) {
        return (ResourceLocation)$tmp0.invoke(p0);
    }
}

