/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.tileentity.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.world.block.tileentity.network.NetworkCluster;
import xyz.xenondevs.nova.world.block.tileentity.network.ProtoNetwork;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0086\u0002J\u001b\u0010\u0017\u001a\u00020\u00182\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001H\u0086\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0000H\u0086\u0002J\u0015\u0010\u001b\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0086\u0002J\u0015\u0010\u001c\u001a\u00020\u00122\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0086\u0002J\u0018\u0010\u001d\u001a\u0011\u0012\r\u0012\u000b\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0002\b\u001f0\u001eH\u0096\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/network/ProtoNetworkCluster;", "", "Lxyz/xenondevs/nova/world/block/tileentity/network/ProtoNetwork;", "<init>", "()V", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "networks", "Ljava/util/HashSet;", "cluster", "Lxyz/xenondevs/nova/world/block/tileentity/network/NetworkCluster;", "getCluster", "()Lxyz/xenondevs/nova/world/block/tileentity/network/NetworkCluster;", "setCluster", "(Lxyz/xenondevs/nova/world/block/tileentity/network/NetworkCluster;)V", "dirty", "", "getDirty", "()Z", "setDirty", "(Z)V", "plusAssign", "", "network", "other", "minusAssign", "contains", "iterator", "", "Lkotlin/jvm/internal/EnhancedNullability;", "nova"})
public final class ProtoNetworkCluster
implements Iterable<ProtoNetwork<?>>,
KMappedMarker {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final HashSet<ProtoNetwork<?>> networks;
    public NetworkCluster cluster;
    private boolean dirty;

    public ProtoNetworkCluster() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uuid = uUID;
        this.networks = new HashSet();
        this.dirty = true;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final NetworkCluster getCluster() {
        NetworkCluster networkCluster = this.cluster;
        if (networkCluster != null) {
            return networkCluster;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cluster");
        return null;
    }

    public final void setCluster(@NotNull NetworkCluster networkCluster) {
        Intrinsics.checkNotNullParameter((Object)networkCluster, (String)"<set-?>");
        this.cluster = networkCluster;
    }

    public final boolean getDirty() {
        return this.dirty;
    }

    public final void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public final void plusAssign(@NotNull ProtoNetwork<?> network) {
        Intrinsics.checkNotNullParameter(network, (String)"network");
        if (this.networks.add(network)) {
            this.dirty = true;
        }
    }

    public final void plusAssign(@NotNull Iterable<? extends ProtoNetwork<?>> networks) {
        Intrinsics.checkNotNullParameter(networks, (String)"networks");
        if (CollectionsKt.addAll((Collection)this.networks, networks)) {
            this.dirty = true;
        }
    }

    public final void plusAssign(@Nullable ProtoNetworkCluster other) {
        if (other == null) {
            return;
        }
        if (this.networks.addAll((Collection)other.networks)) {
            this.dirty = true;
        }
    }

    public final void minusAssign(@NotNull ProtoNetwork<?> network) {
        Intrinsics.checkNotNullParameter(network, (String)"network");
        if (this.networks.remove(network)) {
            this.dirty = true;
        }
    }

    public final boolean contains(@NotNull ProtoNetwork<?> network) {
        Intrinsics.checkNotNullParameter(network, (String)"network");
        return this.networks.contains(network);
    }

    @Override
    @NotNull
    public Iterator<ProtoNetwork<?>> iterator() {
        Iterator<ProtoNetwork<?>> iterator = this.networks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        return iterator;
    }
}

