/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.entity.variant;

import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.ClosedRange;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.MoonBrightnessCheck;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.entity.variant.StructureCheck;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.registry.RegistryElementBuilderDsl;
import xyz.xenondevs.nova.util.NMSUtilsKt;

@RegistryElementBuilderDsl
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015JA\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u001e\u0010\u0019\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u001a\"\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u001cJ;\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00172\u001a\u0010\u001e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u001a\"\u0006\u0012\u0002\b\u00030\u0017\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001cJ\u001c\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\r\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u000b0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\f\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lxyz/xenondevs/nova/world/entity/variant/SpawnConditionsBuilder;", "", "lookup", "Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;", "<init>", "(Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;)V", "biomeRegistry", "Lnet/minecraft/core/HolderGetter;", "Lnet/minecraft/world/level/biome/Biome;", "kotlin.jvm.PlatformType", "structureRegistry", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "conditions", "Ljava/util/ArrayList;", "Lnet/minecraft/world/entity/variant/PriorityProvider$Selector;", "Lnet/minecraft/world/entity/variant/SpawnContext;", "Lnet/minecraft/world/entity/variant/SpawnCondition;", "Lkotlin/collections/ArrayList;", "always", "", "priority", "", "biome", "Lio/papermc/paper/registry/TypedKey;", "Lorg/bukkit/block/Biome;", "biomes", "", "(ILio/papermc/paper/registry/TypedKey;[Lio/papermc/paper/registry/TypedKey;)V", "Lio/papermc/paper/registry/tag/TagKey;", "structure", "structures", "moonBrightness", "range", "Lkotlin/ranges/ClosedRange;", "", "build", "Lnet/minecraft/world/entity/variant/SpawnPrioritySelectors;", "build$nova", "nova"})
public final class SpawnConditionsBuilder {
    @NotNull
    private final HolderGetter<net.minecraft.world.level.biome.Biome> biomeRegistry;
    @NotNull
    private final HolderGetter<Structure> structureRegistry;
    @NotNull
    private final ArrayList<PriorityProvider.Selector<SpawnContext, SpawnCondition>> conditions;

    public SpawnConditionsBuilder(@NotNull RegistryOps.RegistryInfoLookup lookup2) {
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        ResourceKey resourceKey = Registries.BIOME;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"BIOME");
        this.biomeRegistry = NMSUtilsKt.lookupGetterOrThrow(lookup2, resourceKey);
        ResourceKey resourceKey2 = Registries.STRUCTURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey2, (String)"STRUCTURE");
        this.structureRegistry = NMSUtilsKt.lookupGetterOrThrow(lookup2, resourceKey2);
        this.conditions = new ArrayList();
    }

    public final void always(int priority) {
        ((Collection)this.conditions).add(new PriorityProvider.Selector(priority));
    }

    public final void biome(int priority, @NotNull TypedKey<Biome> biome2, TypedKey<Biome> ... biomes) {
        Intrinsics.checkNotNullParameter(biome2, (String)"biome");
        Intrinsics.checkNotNullParameter(biomes, (String)"biomes");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add(biome2);
        spreadBuilder.addSpread(biomes);
        Iterable iterable = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new TypedKey[spreadBuilder.size()]));
        ResourceKey resourceKey = Registries.BIOME;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"BIOME");
        HolderSet<net.minecraft.world.level.biome.Biome> holderSet = NMSUtilsKt.toHolderSet(iterable, resourceKey, this.biomeRegistry);
        ((Collection)this.conditions).add(new PriorityProvider.Selector((PriorityProvider.SelectorCondition)new BiomeCheck(holderSet), priority));
    }

    public final void biome(int priority, @NotNull TagKey<Biome> biome2) {
        Intrinsics.checkNotNullParameter(biome2, (String)"biome");
        ResourceKey resourceKey = Registries.BIOME;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"BIOME");
        HolderSet.Named holderSet = this.biomeRegistry.getOrThrow(NMSUtilsKt.toNmsTagKey(biome2, resourceKey));
        ((Collection)this.conditions).add(new PriorityProvider.Selector((PriorityProvider.SelectorCondition)new BiomeCheck((HolderSet)holderSet), priority));
    }

    public final void structure(int priority, @NotNull TypedKey<?> structure, TypedKey<?> ... structures) {
        Intrinsics.checkNotNullParameter(structure, (String)"structure");
        Intrinsics.checkNotNullParameter(structures, (String)"structures");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add(structure);
        spreadBuilder.addSpread(structures);
        Iterable iterable = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new TypedKey[spreadBuilder.size()]));
        ResourceKey resourceKey = Registries.STRUCTURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"STRUCTURE");
        HolderSet<Structure> holderSet = NMSUtilsKt.toHolderSet(iterable, resourceKey, this.structureRegistry);
        ((Collection)this.conditions).add(new PriorityProvider.Selector((PriorityProvider.SelectorCondition)new StructureCheck(holderSet), priority));
    }

    public final void structure(int priority, @NotNull TagKey<?> structure) {
        Intrinsics.checkNotNullParameter(structure, (String)"structure");
        ResourceKey resourceKey = Registries.STRUCTURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"STRUCTURE");
        HolderSet.Named holderSet = this.structureRegistry.getOrThrow(NMSUtilsKt.toNmsTagKey(structure, resourceKey));
        ((Collection)this.conditions).add(new PriorityProvider.Selector((PriorityProvider.SelectorCondition)new StructureCheck((HolderSet)holderSet), priority));
    }

    public final void moonBrightness(int priority, @NotNull ClosedRange<Double> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        ((Collection)this.conditions).add(new PriorityProvider.Selector((PriorityProvider.SelectorCondition)new MoonBrightnessCheck(MinMaxBounds.Doubles.between((double)((Number)((Object)range.getStart())).doubleValue(), (double)((Number)((Object)range.getEndInclusive())).doubleValue())), priority));
    }

    @NotNull
    public final SpawnPrioritySelectors build$nova() {
        return new SpawnPrioritySelectors((List)this.conditions);
    }
}

