/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.entity.variant;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.config.PermanentStorage;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.registry.RegistryEventManagerKt;
import xyz.xenondevs.nova.resources.ResourceGeneration;
import xyz.xenondevs.nova.serialization.kotlinx.ResourceKeySerializer;
import xyz.xenondevs.nova.util.NMSUtilsKt;

@InternalInit(stage=InternalInitStage.PRE_WORLD, dependsOn={ResourceGeneration.PreWorld.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0003J\u0012\u0010\u000b\u001a\u00020\n2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0006R&\u0010\u0004\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/world/entity/variant/UnknownEntityVariants;", "", "<init>", "()V", "customVariantKeys", "Ljava/util/HashSet;", "Lnet/minecraft/resources/ResourceKey;", "Lkotlin/collections/HashSet;", "registeredIds", "addUnknownEntityVariants", "", "rememberEntityVariantKey", "id", "nova"})
public final class UnknownEntityVariants {
    @NotNull
    public static final UnknownEntityVariants INSTANCE;
    @NotNull
    private static final HashSet<ResourceKey<?>> customVariantKeys;
    @NotNull
    private static final HashSet<ResourceKey<?>> registeredIds;

    private UnknownEntityVariants() {
    }

    @InitFun
    private final void addUnknownEntityVariants() {
        PermanentStorage.INSTANCE.store("custom_entity_variant_keys", (SerializationStrategy)BuiltinSerializersKt.SetSerializer((KSerializer)ResourceKeySerializer.INSTANCE), customVariantKeys);
        Set unregisteredIds = SetsKt.minus((Set)customVariantKeys, (Iterable)registeredIds);
        for (ResourceKey key : unregisteredIds) {
            ResourceKey registryKey = key.registryKey();
            ResourceLocation id = key.location();
            ResourceKey resourceKey = registryKey;
            if (Intrinsics.areEqual((Object)resourceKey, (Object)Registries.CHICKEN_VARIANT)) {
                ResourceKey resourceKey2 = Registries.CHICKEN_VARIANT;
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey2, (String)"CHICKEN_VARIANT");
                RegistryEventManagerKt.preFreeze(resourceKey2, (arg_0, arg_1) -> UnknownEntityVariants.addUnknownEntityVariants$lambda$0(id, arg_0, arg_1));
                continue;
            }
            if (Intrinsics.areEqual((Object)resourceKey, (Object)Registries.COW_VARIANT)) {
                ResourceKey resourceKey3 = Registries.COW_VARIANT;
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey3, (String)"COW_VARIANT");
                RegistryEventManagerKt.preFreeze(resourceKey3, (arg_0, arg_1) -> UnknownEntityVariants.addUnknownEntityVariants$lambda$1(id, arg_0, arg_1));
                continue;
            }
            if (Intrinsics.areEqual((Object)resourceKey, (Object)Registries.FROG_VARIANT)) {
                ResourceKey resourceKey4 = Registries.FROG_VARIANT;
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey4, (String)"FROG_VARIANT");
                RegistryEventManagerKt.preFreeze(resourceKey4, (arg_0, arg_1) -> UnknownEntityVariants.addUnknownEntityVariants$lambda$2(id, arg_0, arg_1));
                continue;
            }
            if (Intrinsics.areEqual((Object)resourceKey, (Object)Registries.PIG_VARIANT)) {
                ResourceKey resourceKey5 = Registries.PIG_VARIANT;
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey5, (String)"PIG_VARIANT");
                RegistryEventManagerKt.preFreeze(resourceKey5, (arg_0, arg_1) -> UnknownEntityVariants.addUnknownEntityVariants$lambda$3(id, arg_0, arg_1));
                continue;
            }
            if (Intrinsics.areEqual((Object)resourceKey, (Object)Registries.WOLF_VARIANT)) {
                ResourceKey resourceKey6 = Registries.WOLF_VARIANT;
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey6, (String)"WOLF_VARIANT");
                RegistryEventManagerKt.preFreeze(resourceKey6, (arg_0, arg_1) -> UnknownEntityVariants.addUnknownEntityVariants$lambda$4(id, arg_0, arg_1));
                continue;
            }
            NovaBootstrapperKt.getLOGGER().error("Unknown entity variant has unhandled entity type: " + key);
        }
    }

    public final void rememberEntityVariantKey(@NotNull ResourceKey<?> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        ((Collection)customVariantKeys).add(id);
        ((Collection)registeredIds).add(id);
    }

    private static final Unit addUnknownEntityVariants$lambda$0(ResourceLocation $id, WritableRegistry registry, RegistryOps.RegistryInfoLookup registryInfoLookup) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)registryInfoLookup, (String)"<unused var>");
        Intrinsics.checkNotNull((Object)$id);
        NMSUtilsKt.set(registry, $id, new ChickenVariant(new ModelAndTexture((Object)ChickenVariant.ModelType.NORMAL, $id), SpawnPrioritySelectors.EMPTY));
        return Unit.INSTANCE;
    }

    private static final Unit addUnknownEntityVariants$lambda$1(ResourceLocation $id, WritableRegistry registry, RegistryOps.RegistryInfoLookup registryInfoLookup) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)registryInfoLookup, (String)"<unused var>");
        Intrinsics.checkNotNull((Object)$id);
        NMSUtilsKt.set(registry, $id, new CowVariant(new ModelAndTexture((Object)CowVariant.ModelType.NORMAL, $id), SpawnPrioritySelectors.EMPTY));
        return Unit.INSTANCE;
    }

    private static final Unit addUnknownEntityVariants$lambda$2(ResourceLocation $id, WritableRegistry registry, RegistryOps.RegistryInfoLookup registryInfoLookup) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)registryInfoLookup, (String)"<unused var>");
        Intrinsics.checkNotNull((Object)$id);
        NMSUtilsKt.set(registry, $id, new FrogVariant(new ClientAsset.ResourceTexture($id), SpawnPrioritySelectors.EMPTY));
        return Unit.INSTANCE;
    }

    private static final Unit addUnknownEntityVariants$lambda$3(ResourceLocation $id, WritableRegistry registry, RegistryOps.RegistryInfoLookup registryInfoLookup) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)registryInfoLookup, (String)"<unused var>");
        Intrinsics.checkNotNull((Object)$id);
        NMSUtilsKt.set(registry, $id, new PigVariant(new ModelAndTexture((Object)PigVariant.ModelType.NORMAL, $id), SpawnPrioritySelectors.EMPTY));
        return Unit.INSTANCE;
    }

    private static final Unit addUnknownEntityVariants$lambda$4(ResourceLocation $id, WritableRegistry registry, RegistryOps.RegistryInfoLookup registryInfoLookup) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)registryInfoLookup, (String)"<unused var>");
        Intrinsics.checkNotNull((Object)$id);
        NMSUtilsKt.set(registry, $id, new WolfVariant(new WolfVariant.AssetInfo(new ClientAsset.ResourceTexture($id), new ClientAsset.ResourceTexture($id), new ClientAsset.ResourceTexture($id)), SpawnPrioritySelectors.EMPTY));
        return Unit.INSTANCE;
    }

    static {
        HashSet hashSet;
        INSTANCE = new UnknownEntityVariants();
        Set set = (Set)PermanentStorage.INSTANCE.retrieve("custom_entity_variant_keys", (DeserializationStrategy)BuiltinSerializersKt.SetSerializer((KSerializer)ResourceKeySerializer.INSTANCE));
        customVariantKeys = set != null && (hashSet = CollectionsKt.toHashSet((Iterable)set)) != null ? hashSet : new HashSet();
        registeredIds = new HashSet();
    }
}

