/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.behavior;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.commons.provider.Providers;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.item.NovaItem;
import xyz.xenondevs.nova.world.item.behavior.ItemBehavior;
import xyz.xenondevs.nova.world.item.vanilla.VanillaMaterialProperty;
import xyz.xenondevs.nova.world.player.WrappedPlayerInteractEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b\u0017R \u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lxyz/xenondevs/nova/world/item/behavior/Dyeable;", "Lxyz/xenondevs/nova/world/item/behavior/ItemBehavior;", "<init>", "()V", "vanillaMaterialProperties", "Lxyz/xenondevs/commons/provider/Provider;", "", "Lxyz/xenondevs/nova/world/item/vanilla/VanillaMaterialProperty;", "getVanillaMaterialProperties", "()Lxyz/xenondevs/commons/provider/Provider;", "handleInteract", "", "player", "Lorg/bukkit/entity/Player;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "action", "Lorg/bukkit/event/block/Action;", "wrappedEvent", "Lxyz/xenondevs/nova/world/player/WrappedPlayerInteractEvent;", "isDyeable", "", "Lnet/minecraft/world/item/ItemStack;", "isDyeable$nova", "nova"})
@SourceDebugExtension(value={"SMAP\nDyeable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dyeable.kt\nxyz/xenondevs/nova/world/item/behavior/Dyeable\n+ 2 NovaItem.kt\nxyz/xenondevs/nova/world/item/NovaItem\n*L\n1#1,59:1\n180#2:60\n*S KotlinDebug\n*F\n+ 1 Dyeable.kt\nxyz/xenondevs/nova/world/item/behavior/Dyeable\n*L\n56#1:60\n*E\n"})
public final class Dyeable
implements ItemBehavior {
    @NotNull
    public static final Dyeable INSTANCE = new Dyeable();
    @NotNull
    private static final Provider<List<VanillaMaterialProperty>> vanillaMaterialProperties = Providers.provider((Object)CollectionsKt.listOf((Object)((Object)VanillaMaterialProperty.DYEABLE)));

    private Dyeable() {
    }

    @Override
    @NotNull
    public Provider<List<VanillaMaterialProperty>> getVanillaMaterialProperties() {
        return vanillaMaterialProperties;
    }

    @Override
    public void handleInteract(@NotNull Player player, @NotNull ItemStack itemStack, @NotNull Action action, @NotNull WrappedPlayerInteractEvent wrappedEvent) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)((Object)wrappedEvent), (String)"wrappedEvent");
        PlayerInteractEvent event = wrappedEvent.getEvent();
        Block clickedBlock = event.getClickedBlock();
        if (action == Action.RIGHT_CLICK_BLOCK) {
            Block block = clickedBlock;
            if ((block != null ? block.getType() : null) == Material.WATER_CAULDRON && NMSUtilsKt.unwrap(itemStack).has(DataComponents.DYED_COLOR)) {
                BlockState blockState = NMSUtilsKt.getNmsState(clickedBlock);
                World world = clickedBlock.getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
                if (LayeredCauldronBlock.lowerFillLevel((BlockState)blockState, (Level)((Level)NMSUtilsKt.getServerLevel(world)), (BlockPos)BlockPosKt.getPos(clickedBlock).getNmsPos(), (Entity)((Entity)NMSUtilsKt.getServerPlayer(player)), (CauldronLevelChangeEvent.ChangeReason)CauldronLevelChangeEvent.ChangeReason.ARMOR_WASH)) {
                    NMSUtilsKt.unwrap(itemStack).remove(DataComponents.DYED_COLOR);
                    NMSUtilsKt.getServerPlayer(player).awardStat(Stats.CLEAN_ARMOR);
                    wrappedEvent.setActionPerformed(true);
                }
            }
        }
    }

    @JvmStatic
    public static final boolean isDyeable$nova(@NotNull net.minecraft.world.item.ItemStack itemStack) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        NovaItem novaItem = ItemUtilsKt.getNovaItem(itemStack);
        if (novaItem != null) {
            NovaItem this_$iv = novaItem;
            boolean $i$f$hasBehavior = false;
            bl = this_$iv.hasBehavior(Reflection.getOrCreateKotlinClass(Dyeable.class));
        } else {
            bl = itemStack.is(ItemTags.DYEABLE);
        }
        return bl;
    }
}

